/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.permission;

import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.permission.CasePermissionException;
import oracle.bpm.casemgmt.permission.IAuthenticationStoreManager;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.security.jps.config.ExtendedProperty;
import oracle.security.jps.service.policystore.ApplicationPolicy;
import oracle.security.jps.service.policystore.ApplicationRoleAttributes;
import oracle.security.jps.service.policystore.info.InfoFactory;
import oracle.security.jps.service.policystore.info.PermissionEntry;
import oracle.security.jps.service.policystore.info.PrincipalEntry;
import oracle.tip.pc.services.common.ServiceFactory;
import oracle.tip.pc.services.identity.BPMProvider;
import oracle.tip.pc.services.identity.config.BPMIdentityConfigService;
import oracle.tip.pc.services.identity.config.ProviderCfg;
import oracle.tip.pc.services.identity.jps.JpsProvider;

public class AuthenticationStoreManager
implements IAuthenticationStoreManager {
    private static BPMProvider mProvider = null;
    private static final String BPM_SYSTEM_ROLE_SCOPE = "BPM-SYSTEM-ROLE";

    @Override
    public void createAppRole(final String appCtx, final String appRoleName, final String displayName, final String description) throws CasePermissionException {
        String METHOD = "createAppRole";
        this.debugLog("createAppRole", "appRoleName : " + appRoleName + ", appCtx : " + appCtx + ", description : " + description);
        try {
            PrincipalEntry pEntry = this.lookupAppRole(appCtx, appRoleName);
            if (pEntry != null) {
                this.debugLog("createAppRole", "appRoleName : " + appRoleName + ", appCtx : " + appCtx + " already exists in policy store.");
                return;
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ApplicationPolicy appPolicy = AuthenticationStoreManager.this.getApplicationPolicy(appCtx);
                    String attribute = ApplicationRoleAttributes.SCOPE.name();
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(AuthenticationStoreManager.BPM_SYSTEM_ROLE_SCOPE);
                    ExtendedProperty extProp = new ExtendedProperty();
                    extProp.setProperty(attribute, values);
                    appPolicy.createAppRole(appRoleName, displayName, description, extProp);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new CasePermissionException(74800, new String[]{appRoleName, appCtx, description}, e);
        }
    }

    @Override
    public void grantPermissionToAppRole(final String appCtx, String appRoleName, final String permissionTargetName, final String permissionClass, final String actions) throws CasePermissionException {
        String METHOD = "grantPermissionToAppRole";
        final PrincipalEntry principalEntry = this.lookupAppRole(appCtx, appRoleName);
        this.debugLog("grantPermissionToAppRole", "permissionTargetName : " + permissionTargetName + ", permissionClass : " + permissionClass + ", actions : " + actions);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ApplicationPolicy applicationPolicy = AuthenticationStoreManager.this.getApplicationPolicy(appCtx);
                    ArrayList<PrincipalEntry> principalList = new ArrayList<PrincipalEntry>();
                    principalList.add(principalEntry);
                    String displayName = permissionTargetName;
                    String description = permissionTargetName;
                    PermissionEntry permissionEntry = InfoFactory.newPermissionEntry((String)displayName, (String)description, (String)permissionClass, (String)permissionTargetName, (String)actions);
                    ArrayList<PermissionEntry> permEntryList = new ArrayList<PermissionEntry>();
                    permEntryList.add(permissionEntry);
                    applicationPolicy.grant(principalList, null, permEntryList);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new CasePermissionException(74801, new String[]{permissionTargetName, permissionClass, actions}, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationPolicy getApplicationPolicy(String appCtx) throws Exception {
        if (mProvider == null) {
            AuthenticationStoreManager authenticationStoreManager = this;
            synchronized (authenticationStoreManager) {
                if (mProvider == null) {
                    BPMIdentityConfigService service = ServiceFactory.getIdentityConfigServiceInstance();
                    String realmName = service.getDefaultRealmName();
                    ProviderCfg conf = service.getConfiguration(realmName).getProviderCfg("Authorization");
                    mProvider = JpsProvider.getInstance((ProviderCfg)conf);
                }
            }
        }
        return ((JpsProvider)mProvider).getPolicyStore().getApplicationPolicy(appCtx);
    }

    private PrincipalEntry lookupAppRole(final String appCtx, final String appRoleName) throws CasePermissionException {
        String METHOD = "lookupAppRole";
        this.debugLog("lookupAppRole", "appRoleName : " + appRoleName + ", appCtx : " + appCtx);
        PrincipalEntry pEntry = null;
        try {
            pEntry = (PrincipalEntry)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ApplicationPolicy appPolicy = AuthenticationStoreManager.this.getApplicationPolicy(appCtx);
                    List list = appPolicy.searchAppRoles(appRoleName);
                    if (list != null && list.size() != 0) {
                        return (PrincipalEntry)list.get(0);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new CasePermissionException(74802, new String[]{appRoleName, appCtx, null}, e);
        }
        return pEntry;
    }

    private void debugLog(String method, String msg) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_PERMISSION, (Severity)Severity.DEBUG, (String)("AuthenticationStoreManager." + method + "() : " + msg));
    }
}

