/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseInstanceService;
import oracle.bpm.casemgmt.annotations.ValidateUserCaseAccess;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.interceptors.AbstractAnnotationAdvice;
import oracle.bpm.casemgmt.interceptors.CaseAnnotationInterceptorContext;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseObjectUtil;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolder;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;

public class ValidateUserCaseAccessAdvice
extends AbstractAnnotationAdvice {
    private static ValidateUserCaseAccessAdvice thisAdvice = new ValidateUserCaseAccessAdvice();

    private ValidateUserCaseAccessAdvice() {
    }

    public static void validateUserCaseAccess(ICaseInstanceService caseInstanceService, ICaseIdentityService caseIdentityService, IBPMContext ctx, CaseIdentifier caseIdentifier) throws CaseServiceException {
        Case caseInstance;
        if (ctx instanceof InternalBPMContext || caseIdentityService.isAdminContext(ctx)) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("ValidateUserCaseAccessAdvice.validateUserCaseAccess: validated : Administrator " + ctx + " access to " + caseIdentifier));
            return;
        }
        boolean isUserAStakeholder = false;
        try {
            caseInstance = ServicesLocator.getCaseInstancePersistence().findCaseByCaseId(caseIdentifier.getCaseId());
            CaseObjectUtil.populateCaseStakeHolders((Case)caseInstance);
            CaseServiceUtil.populateIsUserInRole(ctx, caseInstance.getCaseStakeHolders());
        }
        catch (CasePersistenceException e) {
            throw new CaseServiceException(74600, new Object[]{caseIdentifier.getCaseId()});
        }
        List stakeholders = caseInstance.getCaseStakeHolders();
        for (CaseStakeHolder caseStakeholder : stakeholders) {
            if (!caseStakeholder.getIsContextUserInRole()) continue;
            isUserAStakeholder = true;
            break;
        }
        if (!isUserAStakeholder) {
            throw new CaseServiceException(73422, new Object[]{ctx.getUser(), caseIdentifier.getCaseId()});
        }
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("ValidateUserCaseAccessAdvice.validateUserCaseAccess: validated: " + ctx + " access to " + caseIdentifier));
    }

    public static ValidateUserCaseAccessAdvice getInstance() {
        return thisAdvice;
    }

    @Override
    public void process(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        ValidateUserCaseAccess validateUserCaseAccessAnnotation = (ValidateUserCaseAccess)annotation;
        ValidateUserCaseAccessAdvice.validateUserCaseAccess(context.mCaseInstanceService, context.mCaseIdentityService, context.getBPMContext(), context.getCaseIdentifier());
    }

    @Override
    public void processResult(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
    }

    @Override
    public boolean ignoreForInternalWorkflow(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        return true;
    }
}

