/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.interceptors.AbstractAnnotationAdvice;
import oracle.bpm.casemgmt.interceptors.CaseAnnotationInterceptorContext;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;

public class ValidateContextWithDefaultAdvice
extends AbstractAnnotationAdvice {
    private static ValidateContextWithDefaultAdvice thisAdvice = new ValidateContextWithDefaultAdvice();

    private ValidateContextWithDefaultAdvice() {
    }

    public static IBPMContext validateContext(ICaseIdentityService caseIdentityService, IBPMContext context) throws BPMException, WorkflowException {
        IBPMContext newContext = null;
        newContext = context == null ? caseIdentityService.getBPMContextForAuthenticatedUser() : caseIdentityService.validateContext(context);
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("ValidateContextWithDefaultAdvice.validateContext: Context validated for user: " + newContext.getUser()));
        return newContext;
    }

    public static ValidateContextWithDefaultAdvice getInstance() {
        return thisAdvice;
    }

    @Override
    public void process(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        try {
            IBPMContext incomingCtx = context.getBPMContext();
            boolean nullContext = incomingCtx == null;
            IBPMContext ctx = null;
            try {
                ctx = ValidateContextWithDefaultAdvice.validateContext(context.mCaseIdentityService, incomingCtx);
            }
            catch (Exception e) {
                if (nullContext) {
                    ctx = InternalBPMContext.getInternalBPMContext();
                }
                throw e;
            }
            context.mMethodArgs[0] = ctx;
            if ("workflowsystem".equals(ctx.getUser())) {
                context.setAsInternalContext();
            }
        }
        catch (Exception e) {
            throw new CaseServiceException(74806, null, (Throwable)e);
        }
    }

    @Override
    public void processResult(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
    }
}

