/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.annotations.ValidateContext;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.interceptors.AbstractAnnotationAdvice;
import oracle.bpm.casemgmt.interceptors.CaseAnnotationInterceptorContext;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class ValidateContextAdvice
extends AbstractAnnotationAdvice {
    private static ValidateContextAdvice thisAdvice = new ValidateContextAdvice();

    private ValidateContextAdvice() {
    }

    public static IBPMContext validateContext(ICaseIdentityService caseIdentityService, IBPMContext context) throws BPMException, WorkflowException, Exception {
        IBPMContext newContext = null;
        if (context == null) {
            newContext = caseIdentityService.getBPMContextForAuthenticatedUser();
            if (newContext == null) {
                throw new Exception("Null subject");
            }
        } else {
            newContext = caseIdentityService.validateContext(context);
        }
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("ValidateContextAdvice.validateContext: Context validated for user: " + newContext.getUser()));
        return newContext;
    }

    public static ValidateContextAdvice getInstance() {
        return thisAdvice;
    }

    @Override
    public void process(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        try {
            ValidateContext validateContextAnnotation = (ValidateContext)annotation;
            IBPMContext ctx = ValidateContextAdvice.validateContext(context.mCaseIdentityService, context.getBPMContext());
            context.mMethodArgs[0] = ctx;
            if ("workflowsystem".equals(ctx.getUser())) {
                context.setAsInternalContext();
            }
        }
        catch (Exception e) {
            throw new CaseServiceException(74806, null, (Throwable)e);
        }
    }

    @Override
    public void processResult(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
    }
}

