/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseInstanceService;
import oracle.bpm.casemgmt.annotations.ValidateCaseIdentifier;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.interceptors.AbstractAnnotationAdvice;
import oracle.bpm.casemgmt.interceptors.CaseAnnotationInterceptorContext;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class ValidateCaseIdentifierAdvice
extends AbstractAnnotationAdvice {
    private static ValidateCaseIdentifierAdvice thisAdvice = new ValidateCaseIdentifierAdvice();

    private ValidateCaseIdentifierAdvice() {
    }

    public static void validateCaseIdentifier(IBPMContext ctx, ICaseInstanceService caseInstanceService, CaseIdentifier caseIdentifier) throws CaseServiceException {
        try {
            Case caseInstance = null;
            String caseIdentifierValue = null;
            if (caseIdentifier.getCaseIdentifierType() == null) {
                caseIdentifierValue = "CaseIdentifier:" + caseIdentifier;
            } else if (CaseIdentifier.CaseIdentifierType.CASEID == caseIdentifier.getCaseIdentifierType()) {
                caseIdentifierValue = "CaseId:" + caseIdentifier.getCaseId();
                caseInstance = ServicesLocator.getCaseInstancePersistence().findCaseByCaseId(caseIdentifier.getCaseId());
            } else if (CaseIdentifier.CaseIdentifierType.CASENUMBER == caseIdentifier.getCaseIdentifierType()) {
                caseIdentifierValue = "CaseNumber:" + caseIdentifier.getCaseNumber();
                caseInstance = ServicesLocator.getCaseInstancePersistence().findCaseByCaseNumber(caseIdentifier.getCaseNumber());
            } else if (CaseIdentifier.CaseIdentifierType.IDENTIFICATIONKEY == caseIdentifier.getCaseIdentifierType()) {
                caseIdentifierValue = "IdentificationKey:" + caseIdentifier.getCaseIdentifierType();
                caseInstance = ServicesLocator.getCaseInstancePersistence().findCaseByIdentificationKey(caseIdentifier.getIdentificationKey());
            }
            if (caseInstance == null) {
                CaseServiceException cse = new CaseServiceException(73403, new Object[]{caseIdentifierValue});
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)ValidateCaseIdentifierAdvice.class.getName(), (String)"validateCaseIdentifier", (Throwable)cse);
                throw cse;
            }
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("ValidateCaseIdentifierAdvice.validateCaseIdentifier: caseIdentifier validated: " + caseIdentifier));
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73403, new Object[]{caseIdentifier.toString()}, (Throwable)e);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)ValidateCaseIdentifierAdvice.class.getName(), (String)"validateCaseIdentifier", (Throwable)cse);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(ctx, null));
            throw cse;
        }
    }

    public static ValidateCaseIdentifierAdvice getInstance() {
        return thisAdvice;
    }

    @Override
    public void process(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        ValidateCaseIdentifier validateCaseIdentifierAnnotation = (ValidateCaseIdentifier)annotation;
        ValidateCaseIdentifierAdvice.validateCaseIdentifier(context.getBPMContext(), context.mCaseInstanceService, context.getCaseIdentifier());
    }

    @Override
    public void processResult(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
    }
}

