/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.annotations.ValidateAdminContext;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.interceptors.AbstractAnnotationAdvice;
import oracle.bpm.casemgmt.interceptors.CaseAnnotationInterceptorContext;
import oracle.bpm.casemgmt.interceptors.ValidateContextAdvice;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class ValidateAdminContextAdvice
extends AbstractAnnotationAdvice {
    private static ValidateAdminContextAdvice thisAdvice = new ValidateAdminContextAdvice();

    private ValidateAdminContextAdvice() {
    }

    public static ValidateAdminContextAdvice getInstance() {
        return thisAdvice;
    }

    public static IBPMContext validateAdminContext(ICaseIdentityService caseIdentityService, IBPMContext context) throws BPMException, WorkflowException, Exception {
        IBPMContext adminCtx = ValidateContextAdvice.validateContext(caseIdentityService, context);
        if ("workflowsystem".equals(adminCtx.getUser())) {
            return adminCtx;
        }
        if (!caseIdentityService.isAdminContext(adminCtx)) {
            throw new IllegalArgumentException("Not an admin context");
        }
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("ValidateAdminContextAdvice.validateAdminContext: Admin context validated for user: " + adminCtx.getUser()));
        return adminCtx;
    }

    @Override
    public void process(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        try {
            ValidateAdminContext validateAdminContextAnnotation = (ValidateAdminContext)annotation;
            IBPMContext adminCtx = ValidateAdminContextAdvice.validateAdminContext(context.mCaseIdentityService, context.getBPMContext());
            context.mMethodArgs[0] = adminCtx;
            if ("workflowsystem".equals(adminCtx.getUser())) {
                context.setAsInternalContext();
            }
        }
        catch (Exception e) {
            throw new CaseServiceException(74806, null, (Throwable)e);
        }
    }

    @Override
    public void processResult(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
    }
}

