/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.IInternalCaseService;
import oracle.bpm.casemgmt.annotations.ValidateAction;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityAttrib;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityAttribPK;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityDefinition;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.interceptors.AbstractAnnotationAdvice;
import oracle.bpm.casemgmt.interceptors.CaseAnnotationInterceptorContext;
import oracle.bpm.casemgmt.interceptors.SetCaseObjectDefaultValuesAdvice;
import oracle.bpm.casemgmt.permission.CasePermissionException;
import oracle.bpm.casemgmt.permission.ICasePermissionServiceInternal;
import oracle.bpm.casemgmt.permission.PermissionUtil;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;

public class ValidateActionAdvice
extends AbstractAnnotationAdvice {
    private static ValidateActionAdvice thisAdvice = new ValidateActionAdvice();

    private ValidateActionAdvice() {
    }

    public static ValidateActionAdvice getInstance() {
        return thisAdvice;
    }

    public void validateAction(ICaseIdentityService caseIdentityService, ICasePermissionServiceInternal casePermissionServiceInternal, IBPMContext ctx, CaseIdentifier caseIdentifier, SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder caseDefinitionIdHolder, ICaseConstants.CaseObjectType annotCaseObjType, ICaseConstants.CaseObjectPermissionType annotAction, String newTagFromCaseObj, String oldTagFromPersCaseObj) throws CaseServiceException {
        String METHOD = "validateAction";
        ValidateActionAdvice.debugLog("validateAction", "ValidateActionAdvice.validateAction: Validating {" + annotAction + "} on " + annotCaseObjType + " for " + ctx.getUser());
        if (ctx instanceof InternalBPMContext || caseIdentityService.isAdminContext(ctx)) {
            return;
        }
        boolean hasStakeholderPermission = false;
        CasePermissionException cpe = null;
        try {
            Set<ICaseConstants.CaseObjectPermissionType> actions = casePermissionServiceInternal.getActionsUserCanPerform(ctx, caseIdentifier, null, annotCaseObjType);
            hasStakeholderPermission = actions.contains(annotAction);
        }
        catch (CasePermissionException _cpe) {
            cpe = _cpe;
        }
        if (!hasStakeholderPermission) {
            throw ValidateActionAdvice.logAndLocalizeException(ctx, "validateAction", new CaseServiceException(74812, new Object[]{ctx.getUser(), annotAction, annotCaseObjType, caseIdentifier}, (Throwable)((Object)cpe)));
        }
        if (newTagFromCaseObj != null && !newTagFromCaseObj.trim().equals("")) {
            this.validateActionOnCaseObjectWithTag(casePermissionServiceInternal, ctx, caseIdentifier, newTagFromCaseObj, annotAction, annotCaseObjType);
        }
        if (!(oldTagFromPersCaseObj == null || oldTagFromPersCaseObj.trim().equals("") || newTagFromCaseObj != null && newTagFromCaseObj.equals(oldTagFromPersCaseObj))) {
            this.validateActionOnCaseObjectWithTag(casePermissionServiceInternal, ctx, caseIdentifier, oldTagFromPersCaseObj, annotAction, annotCaseObjType);
        }
    }

    @Override
    public void process(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        ValidateAction validateActionAnnotation = (ValidateAction)annotation;
        ICaseConstants.CaseObjectPermissionType annotAction = Enum.valueOf(ICaseConstants.CaseObjectPermissionType.class, validateActionAnnotation.action());
        ICaseConstants.CaseObjectType annotCaseObjType = this.getAnnotatedCaseObjectType(validateActionAnnotation.caseObjectType(), context.getCaseObject());
        String newTagFromCaseObj = this.getCaseObjectPermissionTag(annotCaseObjType, context.getCaseObject());
        String oldTagFromPersCaseObj = this.getExistingPermissionTag(context, context.getBPMContext(), context.getCaseIdentifier(), annotCaseObjType, context.getCaseObject());
        SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder caseDefinitionIdHolder = (SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder)context.mLocalCache.get(SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder.class.getSimpleName());
        if (caseDefinitionIdHolder == null) {
            caseDefinitionIdHolder = new SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder();
        }
        this.validateAction(context.mCaseIdentityService, context.mCasePermissionServiceInternal, context.getBPMContext(), context.getCaseIdentifier(), caseDefinitionIdHolder, annotCaseObjType, annotAction, newTagFromCaseObj, oldTagFromPersCaseObj);
    }

    @Override
    public void processResult(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
    }

    @Override
    public boolean ignoreForInternalWorkflow(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        return true;
    }

    private static CaseServiceException logAndLocalizeException(IBPMContext ctx, String method, CaseServiceException cse) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)"ValidateActionAdvice", (String)method, (Throwable)cse);
        new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(ctx, null));
        return cse;
    }

    private static void debugLog(String method, String msg) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("ValidateActionAdvice." + method + "() : " + msg));
    }

    private String getCaseObjectPermissionTag(ICaseConstants.CaseObjectType annotCaseObjType, CaseObject pCaseObject) {
        if (pCaseObject == null) {
            return null;
        }
        if (annotCaseObjType.equals((Object)ICaseConstants.CaseObjectType.ACTIVITY) || annotCaseObjType.equals((Object)ICaseConstants.CaseObjectType.CASE)) {
            return null;
        }
        if (!annotCaseObjType.equals((Object)PermissionUtil.getObjectType(pCaseObject))) {
            return null;
        }
        return pCaseObject.getPermissionTag();
    }

    private String getExistingPermissionTag(CaseAnnotationInterceptorContext interceptorContext, IBPMContext ctx, CaseIdentifier caseIdentifier, ICaseConstants.CaseObjectType annotCaseObjType, CaseObject caseObject) throws CaseServiceException {
        String METHOD = "getExistingPermissionTag";
        if (annotCaseObjType.equals((Object)ICaseConstants.CaseObjectType.ACTIVITY)) {
            String caseActivityDefinitionId = interceptorContext.getCaseActivityDefinitionId();
            if (caseActivityDefinitionId == null || "".equals(caseActivityDefinitionId)) {
                return null;
            }
            String caseId = caseIdentifier.getCaseId();
            if (caseId == null) {
                // empty if block
            }
            try {
                String permTag = null;
                IInternalCaseService service = ServicesLocator.getInternalCaseService();
                CaseActivityAttribPK attribPK = new CaseActivityAttribPK(caseActivityDefinitionId, caseId);
                CaseActivityAttrib oldAttrib = ServicesLocator.getCasePersistence().find(CaseActivityAttrib.class, attribPK);
                if (oldAttrib != null) {
                    permTag = oldAttrib.getPermissionTag();
                }
                if (permTag == null || "".equals(permTag.trim())) {
                    CaseActivityDefinition activityDefn = service.getCaseActivityDefinition(caseActivityDefinitionId);
                    permTag = activityDefn.getPermissionTag();
                }
                ValidateActionAdvice.debugLog("getExistingPermissionTag", "PermTag : " + permTag);
                return permTag;
            }
            catch (CasePersistenceException cpe) {
                throw ValidateActionAdvice.logAndLocalizeException(ctx, "getExistingPermissionTag", new CaseServiceException(74001, new Object[]{caseActivityDefinitionId}, (Throwable)((Object)cpe)));
            }
        }
        if (annotCaseObjType.equals((Object)ICaseConstants.CaseObjectType.CASE)) {
            return null;
        }
        if (caseObject == null) {
            return null;
        }
        if (!annotCaseObjType.equals((Object)PermissionUtil.getObjectType(caseObject))) {
            return null;
        }
        try {
            return CaseServiceUtil.getPermissionTag(ctx, caseIdentifier, caseObject);
        }
        catch (CasePermissionException cpe) {
            throw ValidateActionAdvice.logAndLocalizeException(ctx, "getExistingPermissionTag", new CaseServiceException(73416, new Object[0], (Throwable)((Object)cpe)));
        }
    }

    private ICaseConstants.CaseObjectType getAnnotatedCaseObjectType(String annotCaseObjTypeStr, CaseObject pCaseObject) {
        if (annotCaseObjTypeStr.equals("NA")) {
            return PermissionUtil.getObjectType(pCaseObject);
        }
        return Enum.valueOf(ICaseConstants.CaseObjectType.class, annotCaseObjTypeStr);
    }

    private void validateActionOnCaseObjectWithTag(ICasePermissionServiceInternal casePermissionServiceInternal, IBPMContext ctx, CaseIdentifier caseIdentifier, String permissionTag, ICaseConstants.CaseObjectPermissionType annotAction, ICaseConstants.CaseObjectType annotCaseObjType) throws CaseServiceException {
        String METHOD = "validateActionOnCaseObjectWithTag";
        CasePermissionException cpe = null;
        boolean canPerformAction = false;
        try {
            canPerformAction = casePermissionServiceInternal.checkCaseTagPermission(ctx, caseIdentifier, permissionTag, annotAction, annotCaseObjType);
        }
        catch (CasePermissionException _cpe) {
            cpe = _cpe;
        }
        if (!canPerformAction) {
            throw ValidateActionAdvice.logAndLocalizeException(ctx, "validateActionOnCaseObjectWithTag", new CaseServiceException(74813, new Object[]{ctx.getUser(), annotAction, permissionTag, annotCaseObjType, caseIdentifier}, (Throwable)((Object)cpe)));
        }
    }
}

