/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Locale;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseDocumentObject;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseList;
import oracle.bpm.casemgmt.CaseObjectsList;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseInstanceService;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.annotations.SetReturnDisplayName;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityDefinition;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.event.CaseEventUtil;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.interceptors.AbstractAnnotationAdvice;
import oracle.bpm.casemgmt.interceptors.CaseAnnotationInterceptorContext;
import oracle.bpm.casemgmt.interceptors.SetCaseObjectDefaultValuesAdvice;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.model.CaseHeader;
import oracle.bpm.casemgmt.persistence.model.CaseMilestone;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolder;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.resource.Casei18nUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class SetReturnDisplayNameAdvice
extends AbstractAnnotationAdvice {
    private static SetReturnDisplayNameAdvice thisAdvice = new SetReturnDisplayNameAdvice();

    private SetReturnDisplayNameAdvice() {
    }

    public static void setDisplayNames(ICaseIdentityService identityService, ICaseMetadataService caseMetadataService, ICaseInstanceService caseInstanceService, IBPMContext ctx, Object returnValue) throws CaseServiceException {
        if (returnValue == null) {
            return;
        }
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("SetReturnDisplayNameAdvice.setDisplayNames(): Input is " + returnValue));
        Locale locale = CaseServiceUtil.getLocale(ctx, null);
        Locale defaultLocale = Locale.getDefault();
        if (returnValue instanceof Case) {
            Case caseInstance = (Case)returnValue;
            String caseId = caseInstance.getCaseHeader().getCaseId();
            CaseIdentifier caseIdentifier = CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseId);
            String caseDefinitionName = caseInstance.getCaseHeader().getCaseDefinitionName();
            String caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
            SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder caseDefinitionIdHolder = new SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder();
            caseDefinitionIdHolder.caseDefinitionId = caseDefinitionId;
            caseDefinitionIdHolder.caseDefinitionName = caseDefinitionName;
            SetReturnDisplayNameAdvice.setCaseHeaderDisplayNames(identityService, caseMetadataService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, caseInstance.getCaseHeader(), locale);
            List milestones = caseInstance.getCaseMilestones();
            for (CaseMilestone milestone : milestones) {
                SetReturnDisplayNameAdvice.setCaseObjectDisplayNames(identityService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, (CaseObject)milestone, locale);
            }
            List stakeholders = caseInstance.getCaseStakeHolders();
            for (CaseStakeHolder stakeholder : stakeholders) {
                SetReturnDisplayNameAdvice.setCaseObjectDisplayNames(identityService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, (CaseObject)stakeholder, locale);
            }
            List caseDatas = caseInstance.getCaseData();
            for (CaseData caseData : caseDatas) {
                SetReturnDisplayNameAdvice.setCaseObjectDisplayNames(identityService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, (CaseObject)caseData, locale);
            }
            List comments = caseInstance.getComments();
            for (Comment comment : comments) {
                SetReturnDisplayNameAdvice.setCaseObjectDisplayNames(identityService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, (CaseObject)comment, locale);
            }
        } else if (returnValue instanceof CaseObject) {
            CaseObject caseObject = (CaseObject)returnValue;
            String caseId = caseObject.getCaseId();
            CaseIdentifier caseIdentifier = CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseId);
            SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder caseDefinitionIdHolder = new SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder();
            SetReturnDisplayNameAdvice.setCaseObjectDisplayNames(identityService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, caseObject, locale);
        } else if (returnValue instanceof CaseActivityDefinition) {
            CaseActivityDefinition activity = (CaseActivityDefinition)returnValue;
            String caseId = activity.getCaseId();
            CaseIdentifier caseIdentifier = CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseId);
            SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder caseDefinitionIdHolder = new SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder();
            SetReturnDisplayNameAdvice.setActivityDisplayName(identityService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, activity, locale);
        } else if (returnValue instanceof List) {
            List inList = (List)returnValue;
            if (inList != null) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("SetReturnDisplayNameAdvice.setDisplayNames: got list of size " + inList.size()));
            } else {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"SetReturnDisplayNameAdvice.setDisplayNames: got NULL list");
            }
            if (inList != null && inList.size() > 0) {
                Object anyOneObject = inList.get(0);
                if (!(anyOneObject instanceof CaseObject) && !(anyOneObject instanceof CaseActivityDefinition)) {
                    throw new IllegalArgumentException("Expected CaseObject or CaseActivityDefinition but found " + anyOneObject.getClass().getName());
                }
                if (anyOneObject instanceof CaseObject) {
                    CaseObject anyOneCaseObject = (CaseObject)anyOneObject;
                    String caseId = anyOneCaseObject.getCaseId();
                    CaseIdentifier caseIdentifier = CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseId);
                    SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder caseDefinitionIdHolder = new SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder();
                    for (Object obj : inList) {
                        SetReturnDisplayNameAdvice.setCaseObjectDisplayNames(identityService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, (CaseObject)obj, locale);
                    }
                } else if (anyOneObject instanceof CaseActivityDefinition) {
                    CaseActivityDefinition anyOneCaseActivity = (CaseActivityDefinition)anyOneObject;
                    String caseId = anyOneCaseActivity.getCaseId();
                    CaseIdentifier caseIdentifier = CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseId);
                    SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder caseDefinitionIdHolder = new SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder();
                    for (Object obj : inList) {
                        SetReturnDisplayNameAdvice.setActivityDisplayName(identityService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, (CaseActivityDefinition)obj, locale);
                    }
                }
            }
        } else if (returnValue instanceof CaseList) {
            List cases = ((CaseList)returnValue).getCases();
            for (Case caseInstance : cases) {
                SetReturnDisplayNameAdvice.setDisplayNames(identityService, caseMetadataService, caseInstanceService, ctx, caseInstance);
            }
        } else if (returnValue instanceof CaseObjectsList) {
            SetReturnDisplayNameAdvice.setDisplayNames(identityService, caseMetadataService, caseInstanceService, ctx, ((CaseObjectsList)returnValue).getCaseObjects());
        } else {
            throw new IllegalArgumentException("Unknown type: " + returnValue.getClass().getName());
        }
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("SetReturnDisplayNameAdvice.setDisplayNames(): Output is " + returnValue));
    }

    public static void setCaseObjectDisplayNames(ICaseIdentityService identityService, ICaseInstanceService caseInstanceService, IBPMContext ctx, CaseIdentifier caseIdentifier, SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder caseDefinitionIdHolder, CaseObject caseObject, Locale locale) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("SetReturnDisplayNameAdvice.setCaseObjectDisplayNames(): Input is " + caseObject));
        if (caseObject == null) {
            return;
        }
        caseObject.setObjectDisplayName(SetReturnDisplayNameAdvice.getObjectDisplayName(caseInstanceService, ctx, caseObject, caseIdentifier, caseDefinitionIdHolder, caseObject.getObjectName(), locale));
        String permissionTag = caseObject.getPermissionTag();
        if (permissionTag != null && !permissionTag.isEmpty()) {
            String permissionTagDisplayName = Casei18nUtil.getValue(ctx, caseDefinitionIdHolder.caseDefinitionId, CaseServiceUtil.getLocale(ctx, null), permissionTag, null);
            if (permissionTagDisplayName == null || permissionTagDisplayName.isEmpty()) {
                permissionTagDisplayName = permissionTag;
            }
            caseObject.setPermissionTagDisplayName(permissionTagDisplayName);
        }
        if (caseObject.getUpdatedBy().equals("workflowsystem")) {
            String updatedByDisplayName = Casei18nUtil.getValue(ctx, caseDefinitionIdHolder.caseDefinitionId, CaseServiceUtil.getLocale(ctx, null), "workflowsystem", null);
            if (updatedByDisplayName == null) {
                updatedByDisplayName = caseObject.getUpdatedBy();
            }
            caseObject.setUpdatedByDisplayName(updatedByDisplayName);
        } else {
            caseObject.setUpdatedByDisplayName(identityService.getUserDisplayName(locale, caseObject.getUpdatedBy()));
        }
        Comment comment = SetReturnDisplayNameAdvice.getComment(caseObject);
        if (comment != null) {
            SetReturnDisplayNameAdvice.setCaseObjectDisplayNames(identityService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, (CaseObject)comment, locale);
        }
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"SetReturnDisplayNameAdvice.setCaseObjectDisplayNames: case object defaulted");
    }

    public static Comment getComment(CaseObject caseObject) {
        if (caseObject instanceof CaseHeader) {
            return null;
        }
        if (caseObject instanceof Comment) {
            return null;
        }
        if (caseObject instanceof CaseMilestone) {
            return ((CaseMilestone)caseObject).getComment();
        }
        if (caseObject instanceof CaseStakeHolder) {
            return ((CaseStakeHolder)caseObject).getComment();
        }
        if (caseObject instanceof CaseData) {
            return ((CaseData)caseObject).getComment();
        }
        if (caseObject instanceof CaseDocumentObject) {
            return null;
        }
        if (caseObject instanceof CaseEvent) {
            return ((CaseEvent)caseObject).getComment();
        }
        throw new IllegalArgumentException("Unknown type: " + caseObject.getClass().getName());
    }

    public static void setActivityDisplayName(ICaseIdentityService identityService, ICaseInstanceService caseInstanceService, IBPMContext ctx, CaseIdentifier caseIdentifier, SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder caseDefinitionIdHolder, CaseActivityDefinition activity, Locale locale) throws CaseServiceException {
        if (activity == null) {
            return;
        }
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("SetReturnDisplayNameAdvice.setActivityDisplayName(): Input is " + activity.getName()));
        activity.setDisplayName(SetReturnDisplayNameAdvice.getActivityDisplayName(caseInstanceService, ctx, activity, caseIdentifier, caseDefinitionIdHolder, activity.getName(), locale));
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("SetReturnDisplayNameAdvice.setActivityDisplayName() is completed for: " + activity.getName()));
    }

    public static SetReturnDisplayNameAdvice getInstance() {
        return thisAdvice;
    }

    public static String getDisplayName(IBPMContext ctx, String caseDefinitionId, Locale locale, String key) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("SetReturnDisplayNameAdvice.getDisplayName: Looking for " + key + " for case " + caseDefinitionId));
        try {
            String value = Casei18nUtil.getValue(ctx, caseDefinitionId, locale, key, null);
            if (value == null) {
                return key;
            }
            return value;
        }
        catch (CaseServiceException e) {}
        finally {
            return key;
        }
    }

    @Override
    public void process(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
    }

    @Override
    public void processResult(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        SetReturnDisplayName setReturnDisplayNameAnnotation = (SetReturnDisplayName)annotation;
        Locale locale = CaseServiceUtil.getLocale(context.getBPMContext(), null);
        Locale defaultLocale = Locale.getDefault();
        if (locale != null && defaultLocale != null && defaultLocale.equals(locale)) {
            return;
        }
        SetReturnDisplayNameAdvice.setDisplayNames(context.mCaseIdentityService, context.mCaseMetadataService, context.mCaseInstanceService, context.getBPMContext(), context.getReturnArg());
    }

    @Override
    public boolean ignoreForInternalWorkflow(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        return true;
    }

    private static void setCaseHeaderDisplayNames(ICaseIdentityService identityService, ICaseMetadataService caseMetadataService, ICaseInstanceService caseInstanceService, IBPMContext ctx, CaseIdentifier caseIdentifier, SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder caseDefinitionIdHolder, CaseHeader caseHeader, Locale locale) {
        caseHeader.setObjectDisplayName(SetReturnDisplayNameAdvice.getDisplayName(ctx, caseHeader.getCaseDefinitionId(), locale, caseHeader.getObjectName()));
        caseHeader.setCategoryDisplayName(SetReturnDisplayNameAdvice.getDisplayName(ctx, caseHeader.getCaseDefinitionId(), locale, caseHeader.getCategory()));
        caseHeader.setOutcomeDisplayName(SetReturnDisplayNameAdvice.getDisplayName(ctx, caseHeader.getCaseDefinitionId(), locale, caseHeader.getOutcome()));
        caseHeader.setStateDisplayName(CaseServiceUtil.getTranslatedValue(locale, caseHeader.getState()));
        if (identityService.isValidUser(caseHeader.getCreatedBy())) {
            caseHeader.setCreatedByDisplayName(identityService.getUserDisplayName(locale, caseHeader.getCreatedBy()));
        }
    }

    private static String getObjectDisplayName(ICaseInstanceService caseInstanceService, IBPMContext ctx, CaseObject caseObject, CaseIdentifier caseIdentifier, SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder caseDefinitionIdHolder, String objectName, Locale locale) throws CaseServiceException {
        if (caseObject instanceof CaseHeader) {
            return objectName;
        }
        if (caseObject instanceof Comment) {
            return objectName;
        }
        if (caseObject instanceof CaseDocumentObject) {
            return objectName;
        }
        if (caseObject instanceof CaseEvent) {
            String ceDisplayName = CaseEventUtil.getEventDisplayName(ctx, (CaseEvent)caseObject);
            return ceDisplayName;
        }
        if (caseObject instanceof CaseMilestone || caseObject instanceof CaseStakeHolder || caseObject instanceof CaseData) {
            SetCaseObjectDefaultValuesAdvice.getCaseDefinitionId(ctx, caseInstanceService, caseDefinitionIdHolder, caseIdentifier);
            return SetReturnDisplayNameAdvice.getDisplayName(ctx, caseDefinitionIdHolder.caseDefinitionId, locale, objectName);
        }
        throw new IllegalArgumentException("Unknown type: " + caseObject.getClass().getName());
    }

    private static String getActivityDisplayName(ICaseInstanceService caseInstanceService, IBPMContext ctx, CaseActivityDefinition activity, CaseIdentifier caseIdentifier, SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder caseDefinitionIdHolder, String activityName, Locale locale) throws CaseServiceException {
        SetCaseObjectDefaultValuesAdvice.getCaseDefinitionId(ctx, caseInstanceService, caseDefinitionIdHolder, caseIdentifier);
        return SetReturnDisplayNameAdvice.getDisplayName(ctx, caseDefinitionIdHolder.caseDefinitionId, locale, activityName);
    }
}

