/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.casemgmt.CaseDocumentObject;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseInstanceService;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.annotations.SetCaseObjectDefaultValues;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.event.CaseEventUtil;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.interceptors.AbstractAnnotationAdvice;
import oracle.bpm.casemgmt.interceptors.CaseAnnotationInterceptorContext;
import oracle.bpm.casemgmt.metadata.common.model.TResourceIdentityType;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.model.CaseHeader;
import oracle.bpm.casemgmt.persistence.model.CaseMilestone;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolder;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolderMember;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.persistence.model.DatabaseDocument;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.casemgmt.resource.Casei18nUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;

public class SetCaseObjectDefaultValuesAdvice
extends AbstractAnnotationAdvice {
    private static SetCaseObjectDefaultValuesAdvice thisAdvice = new SetCaseObjectDefaultValuesAdvice();

    private SetCaseObjectDefaultValuesAdvice() {
    }

    public static CaseDefinitionIdHolder setCaseObjectDefaultValues(ICaseIdentityService caseIdentityService, ICaseMetadataService caseMetadataService, ICaseInstanceService caseInstanceService, IBPMContext ctx, CaseIdentifier caseIdentifier, CaseObject caseObject) throws CaseServiceException {
        return SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues(caseIdentityService, caseMetadataService, caseInstanceService, ctx, caseIdentifier, caseObject, CaseServiceUtil.getCalendarInstance(ctx));
    }

    public static CaseDefinitionIdHolder setCaseObjectDefaultValues(ICaseIdentityService caseIdentityService, ICaseMetadataService caseMetadataService, ICaseInstanceService caseInstanceService, IBPMContext ctx, CaseIdentifier caseIdentifier, CaseObject caseObject, Calendar currentTime) throws CaseServiceException {
        CaseDefinitionIdHolder caseDefinitionIdHolder = new CaseDefinitionIdHolder();
        try {
            SetCaseObjectDefaultValuesAdvice.getCaseDefinitionId(ctx, caseInstanceService, caseDefinitionIdHolder, caseIdentifier);
        }
        catch (CaseServiceException e) {
            throw new IllegalArgumentException("Invalid CaseDefinitionId");
        }
        SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues(caseIdentityService, caseMetadataService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, caseObject, currentTime);
        return caseDefinitionIdHolder;
    }

    public static CaseDefinitionIdHolder setCaseObjectDefaultValues(ICaseIdentityService caseIdentityService, ICaseMetadataService caseMetadataService, ICaseInstanceService caseInstanceService, IBPMContext ctx, Case caseInstance) throws CaseServiceException {
        Calendar currentTime = CaseServiceUtil.getCalendarInstance(ctx);
        caseInstance.setCaseId(CaseServiceUtil.getGUID());
        CaseIdentifier caseIdentifier = CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseInstance.getCaseId());
        String caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
        if (caseDefinitionId == null) {
            throw new IllegalArgumentException("Null caseDefinitionId in Case object");
        }
        String caseDefinitionName = caseInstance.getCaseHeader().getCaseDefinitionName();
        CaseDefinitionIdHolder caseDefinitionIdHolder = new CaseDefinitionIdHolder();
        caseDefinitionIdHolder.caseDefinitionId = caseDefinitionId;
        caseDefinitionIdHolder.caseDefinitionName = caseDefinitionName;
        SetCaseObjectDefaultValuesAdvice.setCaseHeaderDefaultValues(caseIdentityService, caseMetadataService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, caseInstance, caseInstance.getCaseHeader(), currentTime);
        if (caseInstance.getCaseMilestones() != null) {
            for (CaseMilestone caseMilestone : caseInstance.getCaseMilestones()) {
                SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues(caseIdentityService, caseMetadataService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, caseInstance, (CaseObject)caseMilestone, currentTime);
            }
        }
        if (caseInstance.getCaseStakeHolders() != null) {
            for (CaseStakeHolder caseStakeHolder : caseInstance.getCaseStakeHolders()) {
                SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues(caseIdentityService, caseMetadataService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, caseInstance, (CaseObject)caseStakeHolder, currentTime);
            }
        }
        if (caseInstance.getCaseData() != null) {
            for (CaseData caseData : caseInstance.getCaseData()) {
                SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues(caseIdentityService, caseMetadataService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, caseInstance, (CaseObject)caseData, currentTime);
            }
        }
        if (caseInstance.getComments() != null) {
            for (Comment comment : caseInstance.getComments()) {
                SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues(caseIdentityService, caseMetadataService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, caseInstance, (CaseObject)comment, currentTime);
            }
        }
        return caseDefinitionIdHolder;
    }

    public static void setCaseObjectDefaultValues(ICaseIdentityService caseIdentityService, ICaseMetadataService caseMetadataService, ICaseInstanceService caseInstanceService, IBPMContext ctx, CaseIdentifier caseIdentifier, CaseDefinitionIdHolder caseDefinitionIdHolder, CaseObject caseObject) throws CaseServiceException {
        SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues(caseIdentityService, caseMetadataService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, caseObject, CaseServiceUtil.getCalendarInstance(ctx));
    }

    public static void setCaseObjectDefaultValues(ICaseIdentityService caseIdentityService, ICaseMetadataService caseMetadataService, ICaseInstanceService caseInstanceService, IBPMContext ctx, CaseIdentifier caseIdentifier, CaseDefinitionIdHolder caseDefinitionIdHolder, CaseObject caseObject, Calendar currentTime) throws CaseServiceException {
        SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues(caseIdentityService, caseMetadataService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, null, caseObject, currentTime);
    }

    public static void setCaseObjectDefaultValues(ICaseIdentityService caseIdentityService, ICaseMetadataService caseMetadataService, ICaseInstanceService caseInstanceService, IBPMContext ctx, CaseIdentifier caseIdentifier, CaseDefinitionIdHolder caseDefinitionIdHolder, Case caseInstance, CaseObject caseObject, Calendar currentTime) throws CaseServiceException {
        if (caseObject == null) {
            return;
        }
        if (caseInstance == null) {
            caseInstance = SetCaseObjectDefaultValuesAdvice.getCase(ctx, caseIdentifier);
        }
        caseObject.setCase(caseInstance);
        caseObject.setCaseId(caseInstance.getCaseId());
        if (CaseServiceUtil.isNullOrEmpty(caseObject.getId())) {
            caseObject.setId(CaseServiceUtil.getGUID());
        }
        if (ctx != null) {
            caseObject.setUpdatedBy(ctx.getUser());
            String userName = ctx.getUser();
            if (userName.equals("workflowsystem")) {
                String updatedByDisplayName = Casei18nUtil.getValue(ctx, caseDefinitionIdHolder.caseDefinitionId, Locale.getDefault(), "workflowsystem", null);
                if (updatedByDisplayName == null) {
                    updatedByDisplayName = userName;
                }
                caseObject.setUpdatedByDisplayName(updatedByDisplayName);
            } else {
                caseObject.setUpdatedByDisplayName(caseIdentityService.getContextUserDisplayNameInDefaultLocale(ctx));
            }
        }
        caseObject.setUpdatedDate(currentTime);
        String objectType = SetCaseObjectDefaultValuesAdvice.getObjectType(caseObject).name();
        caseObject.setObjectType(objectType);
        caseObject.setObjectDisplayName(SetCaseObjectDefaultValuesAdvice.getObjectDisplayName(caseMetadataService, caseInstanceService, ctx, caseObject, caseIdentifier, caseDefinitionIdHolder, caseObject.getObjectName()));
        Comment comment = SetCaseObjectDefaultValuesAdvice.getComment(caseObject);
        if (comment != null) {
            comment.setCaseObjectId(caseObject.getId());
            comment.setIsSystemComment("F");
            comment.setCaseObjectType(objectType);
            SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues(caseIdentityService, caseMetadataService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, caseInstance, (CaseObject)comment, currentTime);
        } else if (caseObject instanceof Comment) {
            comment = (Comment)caseObject;
            comment.setCaseObjectId(caseObject.getId());
            comment.setIsSystemComment("F");
            comment.setCaseObjectType(objectType);
        }
        if (caseObject instanceof CaseStakeHolder) {
            CaseStakeHolder caseStakeHolder = (CaseStakeHolder)caseObject;
            List caseStakeHolderMembers = caseStakeHolder.getCaseStakeHolderMembers();
            if (caseStakeHolderMembers != null && caseStakeHolderMembers.size() > 0) {
                for (CaseStakeHolderMember caseStakeHolderMember : caseStakeHolderMembers) {
                    if (caseStakeHolderMember == null) continue;
                    if (caseStakeHolderMember.getId() == null || caseStakeHolderMember.getId().trim().length() == 0) {
                        caseStakeHolderMember.setId(CaseServiceUtil.getGUID());
                    }
                    caseStakeHolderMember.setCaseStakeHolder(caseStakeHolder);
                    if (caseStakeHolderMember.getStakeHolderType().equals(TResourceIdentityType.APPLICATION_ROLE.name())) {
                        caseStakeHolderMember.setStakeHolderDisplayName(caseIdentityService.getApplicationRoleDisplayName(Locale.getDefault(), caseStakeHolderMember.getStakeHolder()));
                        continue;
                    }
                    if (caseStakeHolderMember.getStakeHolderType().equals(TResourceIdentityType.USER.name())) {
                        caseStakeHolderMember.setStakeHolderDisplayName(caseIdentityService.getUserDisplayName(Locale.getDefault(), caseStakeHolderMember.getStakeHolder()));
                        continue;
                    }
                    if (!caseStakeHolderMember.getStakeHolderType().equals(TResourceIdentityType.GROUP.name())) continue;
                    caseStakeHolderMember.setStakeHolderDisplayName(caseIdentityService.getGroupDisplayName(Locale.getDefault(), caseStakeHolderMember.getStakeHolder()));
                }
            }
        } else if (caseObject instanceof CaseEvent) {
            CaseEvent ce = (CaseEvent)caseObject;
            CaseHeader caseHeader = caseInstance.getCaseHeader();
            ce.setIdentificationKey(caseHeader.getIdentificationKey());
            ce.setCaseName(caseHeader.getObjectName());
        }
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues: case object defaulted");
    }

    public static ICaseConstants.CaseObjectType getObjectType(CaseObject caseObject) {
        if (caseObject instanceof CaseHeader) {
            return ICaseConstants.CaseObjectType.CASE;
        }
        if (caseObject instanceof Comment) {
            return ICaseConstants.CaseObjectType.COMMENT;
        }
        if (caseObject instanceof CaseMilestone) {
            return ICaseConstants.CaseObjectType.MILESTONE;
        }
        if (caseObject instanceof CaseStakeHolder) {
            return ICaseConstants.CaseObjectType.STAKEHOLDER;
        }
        if (caseObject instanceof CaseData) {
            return ICaseConstants.CaseObjectType.DATA;
        }
        if (caseObject instanceof CaseDocumentObject) {
            return ICaseConstants.CaseObjectType.DOCUMENT;
        }
        if (caseObject instanceof DatabaseDocument) {
            return ICaseConstants.CaseObjectType.DATABASE_ECM_DOCUMENT;
        }
        if (caseObject instanceof CaseEvent) {
            return ICaseConstants.CaseObjectType.EVENT;
        }
        throw new IllegalArgumentException("Unknown type: " + caseObject.getClass().getName());
    }

    public static Comment getComment(CaseObject caseObject) {
        if (caseObject instanceof CaseHeader) {
            return null;
        }
        if (caseObject instanceof Comment) {
            return null;
        }
        if (caseObject instanceof CaseMilestone) {
            return ((CaseMilestone)caseObject).getComment();
        }
        if (caseObject instanceof CaseStakeHolder) {
            return ((CaseStakeHolder)caseObject).getComment();
        }
        if (caseObject instanceof CaseData) {
            return ((CaseData)caseObject).getComment();
        }
        if (caseObject instanceof CaseDocumentObject) {
            return null;
        }
        if (caseObject instanceof CaseEvent) {
            return ((CaseEvent)caseObject).getComment();
        }
        throw new IllegalArgumentException("Unknown type: " + caseObject.getClass().getName());
    }

    public static void getCaseDefinitionId(IBPMContext ctx, ICaseInstanceService caseInstanceService, CaseDefinitionIdHolder caseDefinitionIdHolder, CaseIdentifier caseIdentifier) throws CaseServiceException {
        try {
            if (caseDefinitionIdHolder.caseDefinitionId == null) {
                Case caseInstance = SetCaseObjectDefaultValuesAdvice.getCase(ctx, caseIdentifier);
                String caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
                String caseDefinitionName = caseInstance.getCaseHeader().getCaseDefinitionName();
                if (caseDefinitionId == null) {
                    throw new IllegalArgumentException("No caseDefinitionId for case identifier " + caseIdentifier.toString());
                }
                caseDefinitionIdHolder.caseDefinitionId = caseDefinitionId;
                caseDefinitionIdHolder.caseDefinitionName = caseDefinitionName;
            }
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73403, new Object[]{caseIdentifier.toString()}, (Throwable)e);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)SetCaseObjectDefaultValuesAdvice.class.getName(), (String)"getCaseMetadata", (Throwable)cse);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(ctx, null));
            throw cse;
        }
    }

    public static SetCaseObjectDefaultValuesAdvice getInstance() {
        return thisAdvice;
    }

    @Override
    public void process(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        SetCaseObjectDefaultValues setCaseObjectDefaultValuesAnnotation = (SetCaseObjectDefaultValues)annotation;
        CaseDefinitionIdHolder caseDefinitionIdHolder = null;
        String caseObjectType = setCaseObjectDefaultValuesAnnotation.caseObjectType();
        if ("caseObject".equals(caseObjectType)) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"^^^CaseServiceAdvice.invoke: Must set default values on caseObject");
            caseDefinitionIdHolder = SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues(context.mCaseIdentityService, context.mCaseMetadataService, context.mCaseInstanceService, context.getBPMContext(), context.getCaseIdentifier(), context.getCaseObject());
        } else if ("case".equals(caseObjectType)) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"^^^CaseServiceAdvice.invoke: Must set default values on case");
            caseDefinitionIdHolder = SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues(context.mCaseIdentityService, context.mCaseMetadataService, context.mCaseInstanceService, context.getBPMContext(), context.getCase());
        }
        context.mLocalCache.put(CaseDefinitionIdHolder.class.getSimpleName(), caseDefinitionIdHolder);
    }

    @Override
    public void processResult(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
    }

    private static Case getCase(IBPMContext ctx, CaseIdentifier caseIdentifier) throws CaseServiceException {
        return ServicesLocator.getInternalCaseService().getCase(ctx, caseIdentifier, null);
    }

    private static void setCaseHeaderDefaultValues(ICaseIdentityService caseIdentityService, ICaseMetadataService caseMetadataService, ICaseInstanceService caseInstanceService, IBPMContext ctx, CaseIdentifier caseIdentifier, CaseDefinitionIdHolder caseDefinitionIdHolder, Case caseInstance, CaseHeader caseHeader, Calendar currentTime) throws CaseServiceException {
        caseHeader.setCaseId(caseInstance.getCaseId());
        caseHeader.setCase(caseInstance);
        caseHeader.setId(caseInstance.getCaseId());
        caseHeader.setCreatedDate(currentTime);
        if (!caseIdentityService.isValidUser(caseHeader.getCreatedBy())) {
            caseHeader.setCreatedBy(null);
            String subjectUser = null;
            try {
                subjectUser = VerificationService.getUserName();
            }
            catch (WorkflowException e) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)SetCaseObjectDefaultValuesAdvice.class.getName(), (String)"getCaseMetadata", (Throwable)e);
                subjectUser = null;
            }
            if (ctx != null) {
                if (ctx instanceof InternalBPMContext) {
                    if (subjectUser != null) {
                        caseHeader.setCreatedBy(subjectUser);
                    } else {
                        caseHeader.setCreatedBy(ctx.getUser());
                    }
                } else {
                    caseHeader.setCreatedBy(ctx.getUser());
                }
            } else if (subjectUser != null) {
                caseHeader.setCreatedBy(subjectUser);
            }
        }
        if (caseHeader.getCreatedBy() != null) {
            String createdByDisplayName = null;
            createdByDisplayName = caseHeader.getCreatedBy().equals("workflowsystem") ? Casei18nUtil.getValue(ctx, caseDefinitionIdHolder.caseDefinitionId, CaseServiceUtil.getLocale(ctx, null), "workflowsystem", null) : caseIdentityService.getUserDisplayName(Locale.getDefault(), caseHeader.getCreatedBy());
            caseHeader.setCreatedByDisplayName(createdByDisplayName);
        }
        String category = caseHeader.getCategory();
        String outcome = caseHeader.getOutcome();
        try {
            caseHeader.setCategoryDisplayName(CaseServiceUtil.lookupMetadataResourceBundle(ctx, caseDefinitionIdHolder.caseDefinitionId, category));
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)SetCaseObjectDefaultValuesAdvice.class.getName(), (String)"getCaseMetadata", (Throwable)e);
            caseHeader.setCategoryDisplayName(category);
        }
        try {
            caseHeader.setOutcomeDisplayName(CaseServiceUtil.lookupMetadataResourceBundle(ctx, caseDefinitionIdHolder.caseDefinitionId, outcome));
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)SetCaseObjectDefaultValuesAdvice.class.getName(), (String)"getCaseMetadata", (Throwable)e);
            caseHeader.setOutcomeDisplayName(outcome);
        }
        SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues(caseIdentityService, caseMetadataService, caseInstanceService, ctx, caseIdentifier, caseDefinitionIdHolder, caseInstance, (CaseObject)caseHeader, currentTime);
    }

    private static String getObjectDisplayName(ICaseMetadataService caseMetadataService, ICaseInstanceService caseInstanceService, IBPMContext ctx, CaseObject caseObject, CaseIdentifier caseIdentifier, CaseDefinitionIdHolder caseDefinitionIdHolder, String objectName) throws CaseServiceException {
        if (caseObject instanceof CaseHeader) {
            return objectName;
        }
        if (caseObject instanceof Comment) {
            return objectName;
        }
        if (caseObject instanceof CaseDocumentObject) {
            return objectName;
        }
        if (caseObject instanceof CaseEvent) {
            IBPMContext defaultLocaleCtx = null;
            CaseEvent caseEvent = (CaseEvent)caseObject;
            String ceDisplayName = CaseEventUtil.getEventDisplayName(defaultLocaleCtx, caseEvent);
            caseEvent.setObjectDisplayName(ceDisplayName);
            if (caseEvent.getObjectName() == null) {
                caseEvent.setObjectName(ceDisplayName);
            }
            return ceDisplayName;
        }
        if (caseObject instanceof CaseMilestone || caseObject instanceof CaseStakeHolder || caseObject instanceof CaseData) {
            try {
                SetCaseObjectDefaultValuesAdvice.getCaseDefinitionId(ctx, caseInstanceService, caseDefinitionIdHolder, caseIdentifier);
            }
            catch (CaseServiceException e) {
                throw new IllegalArgumentException("Invalid CaseDefinitionId");
            }
            try {
                return CaseServiceUtil.lookupMetadataResourceBundle(ctx, caseDefinitionIdHolder.caseDefinitionId, objectName);
            }
            catch (Exception e) {
                return objectName;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + caseObject.getClass().getName());
    }

    public static class CaseDefinitionIdHolder {
        public String caseDefinitionId = null;
        public String caseDefinitionName = null;
    }
}

