/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseList;
import oracle.bpm.casemgmt.CaseObjectsList;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.annotations.SetCaseObjectAction;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.interceptors.AbstractAnnotationAdvice;
import oracle.bpm.casemgmt.interceptors.ActionsUtil;
import oracle.bpm.casemgmt.interceptors.CaseAnnotationInterceptorContext;
import oracle.bpm.casemgmt.interceptors.PermissionsUtil;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.permission.CasePermissionException;
import oracle.bpm.casemgmt.permission.ICasePermissionServiceInternal;
import oracle.bpm.casemgmt.persistence.model.ActionUserCanPerform;
import oracle.bpm.casemgmt.persistence.model.ActionsPermittedForCaseObject;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.model.CaseMilestone;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.CaseObjectPermission;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolder;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.casemgmt.persistence.model.UserActions;
import oracle.bpm.casemgmt.persistence.model.UserPermissions;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class SetCaseObjectActionAdvice
extends AbstractAnnotationAdvice {
    private static SetCaseObjectActionAdvice thisAdvice = new SetCaseObjectActionAdvice();

    private SetCaseObjectActionAdvice() {
    }

    public static SetCaseObjectActionAdvice getInstance() {
        return thisAdvice;
    }

    public static void setCaseObjectAction(ICaseIdentityService identityService, ICasePermissionServiceInternal permissionServiceInternal, ICaseMetadataService metadataService, IBPMContext ctx, Object returnValue) {
        if (returnValue instanceof Case) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"SetCaseObjectActionAdvice:setCaseObjectAction: setting action on Case");
            Case caseInstance = (Case)returnValue;
            SetCaseObjectActionAdvice.populateUserPermissions(ctx, caseInstance, permissionServiceInternal);
            SetCaseObjectActionAdvice.setCasePermittedActions(ctx, identityService, permissionServiceInternal, caseInstance);
            ArrayList<CaseObject> caseObjects = new ArrayList<CaseObject>();
            HashMap<CaseObject, List> references = new HashMap<CaseObject, List>();
            List milestones = caseInstance.getCaseMilestones();
            caseObjects.addAll(milestones);
            for (CaseMilestone milestone : milestones) {
                references.put((CaseObject)milestone, milestones);
            }
            List stakeholders = caseInstance.getCaseStakeHolders();
            caseObjects.addAll(stakeholders);
            for (CaseStakeHolder stakeholder : stakeholders) {
                references.put((CaseObject)stakeholder, stakeholders);
            }
            List caseData = caseInstance.getCaseData();
            caseObjects.addAll(caseData);
            for (CaseData oneCaseData : caseData) {
                references.put((CaseObject)oneCaseData, caseData);
            }
            List comments = caseInstance.getComments();
            caseObjects.addAll(comments);
            for (Comment comment : comments) {
                references.put((CaseObject)comment, comments);
            }
            SetCaseObjectActionAdvice.setCaseObjectPermittedActions(ctx, identityService, permissionServiceInternal, metadataService, caseInstance.getCaseHeader().getCaseId(), caseInstance, caseObjects, references);
        } else if (returnValue instanceof List) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"SetCaseObjectActionAdvice:setCaseObjectAction: setting action on List");
            List inList = (List)returnValue;
            if (inList == null || inList.isEmpty()) {
                return;
            }
            if (!(inList.get(0) instanceof CaseObject)) {
                throw new IllegalArgumentException("Expected CaseObject but found " + inList.get(0).getClass().getName());
            }
            CaseObject anyOneCaseObj = (CaseObject)inList.get(0);
            ArrayList<CaseObject> caseObjects = new ArrayList<CaseObject>();
            HashMap<CaseObject, List> references = new HashMap<CaseObject, List>();
            for (Object obj : inList) {
                CaseObject caseObj = (CaseObject)obj;
                caseObjects.add(caseObj);
                references.put(caseObj, inList);
            }
            SetCaseObjectActionAdvice.setCaseObjectPermittedActions(ctx, identityService, permissionServiceInternal, metadataService, anyOneCaseObj.getCaseId(), null, caseObjects, references);
            if (anyOneCaseObj instanceof CaseEvent) {
                SetCaseObjectActionAdvice.removeCommentsUserCanNotRead(ctx, inList, permissionServiceInternal);
            }
        } else if (returnValue instanceof CaseList) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"SetCaseObjectActionAdvice:setCaseObjectAction: setting action on CaseList");
            List cases = ((CaseList)returnValue).getCases();
            for (Case caseInstance : cases) {
                SetCaseObjectActionAdvice.setCasePermittedActions(ctx, identityService, permissionServiceInternal, caseInstance);
            }
        } else if (returnValue instanceof CaseObjectsList) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"SetCaseObjectActionAdvice:setCaseObjectAction: setting action on CaseObjectList");
            SetCaseObjectActionAdvice.setCaseObjectAction(identityService, permissionServiceInternal, metadataService, ctx, ((CaseObjectsList)returnValue).getCaseObjects());
        }
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"SetCaseObjectActionAdvice.setCaseObjectAction: actions set");
    }

    @Override
    public void process(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
    }

    @Override
    public void processResult(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        SetCaseObjectAction setCaseObjectActionAnnotation = (SetCaseObjectAction)annotation;
        SetCaseObjectActionAdvice.setCaseObjectAction(context.mCaseIdentityService, context.mCasePermissionServiceInternal, context.mCaseMetadataService, context.getBPMContext(), context.getReturnArg());
    }

    @Override
    public boolean ignoreForInternalWorkflow(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        return true;
    }

    private static void removeUnreadableCaseObjects(List<CaseObject> caseObjects, Map<CaseObject, List> references, Map<CaseObject, Set<ICaseConstants.CaseObjectPermissionType>> permissionMap) {
        if (caseObjects == null || caseObjects.size() == 0) {
            return;
        }
        CaseIdentifier caseIdentifier = new CaseIdentifier(caseObjects.get(0).getCaseId(), null, null);
        for (CaseObject obj : caseObjects) {
            if (obj == null) continue;
            SetCaseObjectActionAdvice.debugLog("removeUnreadableCaseObjects", "Case Object '" + obj.getObjectType() + "' (" + obj.getObjectName() + ") actions are " + obj.getActions());
            boolean isRemove = false;
            Set<ICaseConstants.CaseObjectPermissionType> actions = permissionMap.get(obj);
            try {
                isRemove = actions == null || actions.size() == 0 ? true : (actions.contains(ICaseConstants.CaseObjectPermissionType.INVOKE) ? false : !actions.contains(ICaseConstants.CaseObjectPermissionType.READ));
            }
            catch (Exception e) {
                isRemove = true;
            }
            if (!isRemove) continue;
            SetCaseObjectActionAdvice.debugLog("removeUnreadableCaseObjects", "removing " + obj.getObjectName());
            List list = references.get(obj);
            list.remove(obj);
        }
    }

    private static void setCasePermittedActions(IBPMContext ctx, ICaseIdentityService identityService, ICasePermissionServiceInternal permissionServiceInternal, Case caseInstance) {
        try {
            caseInstance.setActions(new ArrayList());
            CaseIdentifier caseIdentifier = new CaseIdentifier(caseInstance.getCaseHeader().getCaseId(), caseInstance.getCaseHeader().getCaseNumber(), caseInstance.getCaseHeader().getIdentificationKey());
            Set<ICaseConstants.CaseObjectPermissionType> permissionSet = permissionServiceInternal.getActionsUserCanPerform(ctx, caseIdentifier, caseInstance, ICaseConstants.CaseObjectType.CASE);
            Set<ICaseConstants.CaseObjectPermissionType> permissionsOnHeader = permissionServiceInternal.getActionsUserCanPerform(ctx, caseIdentifier, caseInstance, ICaseConstants.CaseObjectType.HEADER);
            boolean hasUpdateOnHeader = permissionsOnHeader.contains(ICaseConstants.CaseObjectPermissionType.UPDATE);
            ArrayList<String> actions = new ArrayList<String>();
            actions.addAll(ActionsUtil.getPermittedActionsForCase(permissionSet, caseInstance, hasUpdateOnHeader));
            caseInstance.getActions().addAll(actions);
            SetCaseObjectActionAdvice.populateUserActions(ctx, caseInstance, permissionServiceInternal, permissionSet, hasUpdateOnHeader);
            SetCaseObjectActionAdvice.debugLog("setCasePermittedActions ", "Case Actions : " + caseInstance.getActions());
        }
        catch (Throwable cpe) {
            cpe.printStackTrace();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)("SetCaseObjectActionAdvice:setCasePermittedActions : Failed to get CASE actions due to error : " + cpe.getMessage()));
        }
    }

    private static void setCaseObjectPermittedActions(IBPMContext ctx, ICaseIdentityService identityService, ICasePermissionServiceInternal permissionServiceInternal, ICaseMetadataService metadataService, String caseId, Case caseInstance, List<CaseObject> caseObjects, Map<CaseObject, List> references) {
        SetCaseObjectActionAdvice.debugLog("setCaseObjectPermittedActions", "CaseID : " + caseId);
        try {
            if (caseObjects == null || caseObjects.size() == 0) {
                return;
            }
            CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
            HashMap<CaseObject, Set<ICaseConstants.CaseObjectPermissionType>> permissionMap = new HashMap<CaseObject, Set<ICaseConstants.CaseObjectPermissionType>>();
            for (CaseObject caseObj : caseObjects) {
                if (caseObj == null) continue;
                caseObj.setActions(new ArrayList());
                Set<ICaseConstants.CaseObjectPermissionType> permissionSet = permissionServiceInternal.getActionsUserCanPerformOnCaseObject(ctx, caseIdentifier, caseInstance, caseObj);
                if (caseInstance == null) {
                    ArrayList<ICaseConstants.CaseInfo> CASE_INFO_STAKEHOLDER = new ArrayList<ICaseConstants.CaseInfo>();
                    CASE_INFO_STAKEHOLDER.add(ICaseConstants.CaseInfo.STAKEHOLDER);
                    caseInstance = ServicesLocator.getInternalCaseService().getCase(ctx, caseIdentifier, CASE_INFO_STAKEHOLDER);
                }
                Set<ICaseConstants.CaseObjectPermissionType> permissionsOnHeader = permissionServiceInternal.getActionsUserCanPerform(ctx, caseIdentifier, caseInstance, ICaseConstants.CaseObjectType.HEADER);
                boolean hasUpdateOnHeader = permissionsOnHeader.contains(ICaseConstants.CaseObjectPermissionType.UPDATE);
                CaseMetadata caseMetadata = metadataService.getCaseMetadata(ctx, caseInstance.getCaseHeader().getCaseDefinitionId());
                ArrayList<String> actions = new ArrayList<String>();
                actions.addAll(ActionsUtil.getPermittedActionsForCaseObject(ctx, caseMetadata, permissionSet, hasUpdateOnHeader, caseObj, caseObj.getObjectType()));
                caseObj.getActions().addAll(actions);
                permissionMap.put(caseObj, permissionSet);
                SetCaseObjectActionAdvice.debugLog("setCaseObjectPermittedActions", "Case Object '" + caseObj.getObjectType() + "' (" + caseObj.getObjectName() + ") Actions : " + caseObj.getActions());
            }
            SetCaseObjectActionAdvice.removeUnreadableCaseObjects(caseObjects, references, permissionMap);
        }
        catch (Throwable cpe) {
            cpe.printStackTrace();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)("SetCaseObjectActionAdvice:setCaseObjectPermittedActions: Failed to get CASE Object actions due to error : " + cpe.getMessage()));
        }
    }

    private static void debugLog(String method, String msg) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("SetCaseObjectActionAdvice." + method + " () : " + msg));
    }

    private static void removeCommentsUserCanNotRead(IBPMContext ctx, List caseEvents, ICasePermissionServiceInternal permissionServiceInternal) {
        try {
            if (caseEvents == null || caseEvents.size() == 0) {
                return;
            }
            CaseObject anyOneCaseObj = (CaseObject)caseEvents.get(0);
            CaseIdentifier caseId = new CaseIdentifier(anyOneCaseObj.getCaseId(), null, null);
            for (Object obj : caseEvents) {
                Set<ICaseConstants.CaseObjectPermissionType> actions;
                CaseEvent caseEvent = (CaseEvent)obj;
                Comment comment = caseEvent.getComment();
                if (comment == null || (actions = permissionServiceInternal.getActionsUserCanPerformOnCaseObject(ctx, caseId, null, (CaseObject)comment)).contains(ICaseConstants.CaseObjectPermissionType.READ)) continue;
                caseEvent.setComment(null);
            }
        }
        catch (CasePermissionException cpe) {
            SetCaseObjectActionAdvice.debugLog("getCommentsUserCanNotRead", "Exception occured while looking up allowed actions by user :" + ctx.getUser() + ". Detailed Exception message :" + cpe.getMessage());
        }
    }

    private static void populateUserPermissions(IBPMContext ctx, Case caseInstance, ICasePermissionServiceInternal permissionServiceInternal) {
        try {
            String caseHeaderUser;
            String loggedInUser;
            if (caseInstance.getCaseHeader().getUserPermissions() != null && (loggedInUser = ctx.getUser()).equals(caseHeaderUser = caseInstance.getCaseHeader().getUserPermissions().getUserId())) {
                return;
            }
            UserPermissions userPermissions = permissionServiceInternal.getPermissionsForUser(ctx, caseInstance);
            caseInstance.getCaseHeader().setUserPermissions(userPermissions);
            SetCaseObjectActionAdvice.filterPermissionsBasedOnCaseState(caseInstance);
        }
        catch (Exception cpe) {
            cpe.printStackTrace();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)("SetCaseObjectActionAdvice:populateUserPermissions : Failed to set UserPermissions in case header due to error : " + cpe.getMessage()));
        }
    }

    private static void filterPermissionsBasedOnCaseState(Case caseInstance) {
        boolean isStateNonUpdatable = false;
        for (ICaseConstants.NonUpdatableCaseState state : ICaseConstants.NonUpdatableCaseState.values()) {
            if (!state.toString().equals(caseInstance.getCaseHeader().getState())) continue;
            isStateNonUpdatable = true;
            break;
        }
        if (isStateNonUpdatable) {
            UserPermissions updatedUserPermissions = new UserPermissions();
            UserPermissions userPermissions = caseInstance.getCaseHeader().getUserPermissions();
            updatedUserPermissions.setUserId(userPermissions.getUserId());
            HashSet updatedCaseObjectPermissionSet = new HashSet();
            for (CaseObjectPermission caseObjectPermission : userPermissions.getCaseObjectPermission()) {
                CaseObjectPermission updatedCaseObjectPermission = new CaseObjectPermission();
                updatedCaseObjectPermission.setCaseObject(caseObjectPermission.getCaseObject());
                HashSet<ActionUserCanPerform> updatedActionUserCanPerform = new HashSet<ActionUserCanPerform>();
                for (ActionUserCanPerform actionUserCanPerform : caseObjectPermission.getActionUserCanPerform()) {
                    if (!actionUserCanPerform.getAction().equals(ICaseConstants.CaseObjectPermissionType.READ.toString())) continue;
                    updatedActionUserCanPerform.add(actionUserCanPerform);
                }
                updatedCaseObjectPermission.setActionUserCanPerform(updatedActionUserCanPerform);
            }
            updatedUserPermissions.setCaseObjectPermission(updatedCaseObjectPermissionSet);
            caseInstance.getCaseHeader().setUserPermissions(updatedUserPermissions);
        }
    }

    private static void populateUserActions(IBPMContext ctx, Case caseInstance, ICasePermissionServiceInternal permissionServiceInternal, Set<ICaseConstants.CaseObjectPermissionType> permissionSet, boolean hasUpdateOnHeader) throws Exception {
        UserActions userActions = new UserActions();
        HashSet<ActionsPermittedForCaseObject> actionsPermittedForCaseObjects = new HashSet<ActionsPermittedForCaseObject>();
        HashSet<String> alreadyPopulatedCaseObj = new HashSet<String>();
        for (ICaseConstants.CaseObjectType caseObjectType : ICaseConstants.CaseObjectType.values()) {
            ICaseConstants.CaseObjectType baseCaseObjectType = PermissionsUtil.convertStringToCaseObjectType(caseObjectType.toString());
            if (baseCaseObjectType.equals((Object)ICaseConstants.CaseObjectType.HEADER) || alreadyPopulatedCaseObj.contains(baseCaseObjectType.toString())) continue;
            alreadyPopulatedCaseObj.add(baseCaseObjectType.toString());
            ActionsPermittedForCaseObject actionsForCaseObject = new ActionsPermittedForCaseObject();
            actionsForCaseObject.setCaseObjectType(baseCaseObjectType.toString());
            Set<Object> actions = new HashSet();
            if (baseCaseObjectType.equals((Object)ICaseConstants.CaseObjectType.CASE)) {
                actions = ActionsUtil.getPermittedActionsForCase(permissionSet, caseInstance, hasUpdateOnHeader);
            } else {
                CaseIdentifier caseIdentifier = new CaseIdentifier(caseInstance.getCaseHeader().getCaseId(), caseInstance.getCaseHeader().getCaseNumber(), caseInstance.getCaseHeader().getIdentificationKey());
                permissionSet = permissionServiceInternal.getActionsUserCanPerform(ctx, caseIdentifier, caseInstance, baseCaseObjectType);
                actions = ActionsUtil.getPermittedActionsForCaseObject(permissionSet, hasUpdateOnHeader, baseCaseObjectType.toString());
            }
            actionsForCaseObject.setPermittedAction(actions);
            actionsPermittedForCaseObjects.add(actionsForCaseObject);
        }
        userActions.setActionsPermittedForCaseObject(actionsPermittedForCaseObjects);
        caseInstance.getCaseHeader().setUserActions(userActions);
    }
}

