/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.annotations.SetCaseActivityAction;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityAttrib;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityAttribPK;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityDefinition;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.interceptors.AbstractAnnotationAdvice;
import oracle.bpm.casemgmt.interceptors.CaseAnnotationInterceptorContext;
import oracle.bpm.casemgmt.permission.CasePermissionException;
import oracle.bpm.casemgmt.permission.ICasePermissionServiceInternal;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;

public class SetCaseActivityActionAdvice
extends AbstractAnnotationAdvice {
    private static SetCaseActivityActionAdvice thisAdvice = new SetCaseActivityActionAdvice();

    private SetCaseActivityActionAdvice() {
    }

    public static SetCaseActivityActionAdvice getInstance() {
        return thisAdvice;
    }

    public void setCaseActivityAction(ICaseIdentityService caseIdentityService, ICasePermissionServiceInternal permissionServiceInternal, IBPMContext ctx, CaseIdentifier caseIdentifier, Object returnValue) throws CaseServiceException {
        if (returnValue == null) {
            return;
        }
        if (ctx instanceof InternalBPMContext || caseIdentityService.isAdminContext(ctx)) {
            return;
        }
        List caseActivityList = (List)returnValue;
        ArrayList<CaseActivityDefinition> nonInvokcableList = new ArrayList<CaseActivityDefinition>();
        boolean userHasStakeHolderPermission = this.userHasStakeHolderPermission(permissionServiceInternal, ctx, caseIdentifier);
        HashMap<String, Boolean> activityPermissionTagMap = new HashMap<String, Boolean>();
        for (CaseActivityDefinition activityDfn : caseActivityList) {
            if (!userHasStakeHolderPermission) {
                nonInvokcableList.add(activityDfn);
                continue;
            }
            String permissionTag = this.getExistingPermssionTag(ctx, activityDfn, caseIdentifier);
            Boolean userHasTagPermission = (Boolean)activityPermissionTagMap.get(permissionTag);
            if (userHasTagPermission == null) {
                boolean canInvoke = this.userHasTagPermission(permissionServiceInternal, ctx, caseIdentifier, permissionTag);
                userHasTagPermission = new Boolean(canInvoke);
                activityPermissionTagMap.put(permissionTag, userHasTagPermission);
            }
            if (!userHasTagPermission.equals(Boolean.FALSE)) continue;
            nonInvokcableList.add(activityDfn);
        }
        this.removeNonInvokableCaseActivities(caseActivityList, nonInvokcableList);
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"SetCaseActivityActionAdvice.setCaseActivityAction: actions set");
    }

    @Override
    public void process(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
    }

    @Override
    public void processResult(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        SetCaseActivityAction setCaseActivityActionAnnotation = (SetCaseActivityAction)annotation;
        this.setCaseActivityAction(context.mCaseIdentityService, context.mCasePermissionServiceInternal, context.getBPMContext(), context.getCaseIdentifier(), context.getReturnArg());
    }

    private static CaseServiceException logAndLocalizeException(IBPMContext ctx, String method, CaseServiceException cse) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)"ValidateActionAdvice", (String)method, (Throwable)cse);
        new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(ctx, null));
        return cse;
    }

    private boolean userHasStakeHolderPermission(ICasePermissionServiceInternal permissionServiceInternal, IBPMContext ctx, CaseIdentifier caseIdentifier) {
        boolean hasStakeHolderPermission;
        block3: {
            String METHOD = "userHasStakeHolderPermission";
            hasStakeHolderPermission = false;
            try {
                Set<ICaseConstants.CaseObjectPermissionType> actions = permissionServiceInternal.getActionsUserCanPerform(ctx, caseIdentifier, null, ICaseConstants.CaseObjectType.ACTIVITY);
                if (actions == null || actions.size() <= 0) break block3;
                for (ICaseConstants.CaseObjectPermissionType taction : actions) {
                    if (!taction.equals((Object)ICaseConstants.CaseObjectPermissionType.INVOKE)) continue;
                    hasStakeHolderPermission = true;
                    break;
                }
            }
            catch (CasePermissionException cpe) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"userHasStakeHolderPermission", (Throwable)((Object)cpe));
            }
        }
        this.debugLog("userHasStakeHolderPermission", ctx.getUser() + ", hasStakeHolderPermission : " + hasStakeHolderPermission);
        return hasStakeHolderPermission;
    }

    private boolean userHasTagPermission(ICasePermissionServiceInternal permissionServiceInternal, IBPMContext ctx, CaseIdentifier caseIdentifier, String permissionTag) {
        String METHOD = "userHasTagPermission";
        boolean hasTagPermission = false;
        try {
            hasTagPermission = permissionTag != null && !"".equals(permissionTag) ? permissionServiceInternal.checkCaseTagPermission(ctx, caseIdentifier, permissionTag, ICaseConstants.CaseObjectPermissionType.INVOKE, ICaseConstants.CaseObjectType.ACTIVITY) : true;
        }
        catch (CasePermissionException cpe) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"userHasTagPermission", (Throwable)((Object)cpe));
        }
        this.debugLog("userHasTagPermission", ctx.getUser() + ", userHasTagPermission for " + permissionTag + " : " + hasTagPermission);
        return hasTagPermission;
    }

    private void removeNonInvokableCaseActivities(List<CaseActivityDefinition> returnValue, List<CaseActivityDefinition> rmCaseActivityDefnList) {
        for (CaseActivityDefinition rmActivity : rmCaseActivityDefnList) {
            returnValue.remove(rmActivity);
        }
    }

    private void debugLog(String method, String msg) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("SetCaseActivityActionAdvice." + method + " () : " + msg));
    }

    private String getExistingPermssionTag(IBPMContext ctx, CaseActivityDefinition activityDfn, CaseIdentifier caseIdentifier) throws CaseServiceException {
        String caseId = caseIdentifier.getCaseId();
        String caseActivityDefinitionId = activityDfn.getDefinitionId();
        try {
            String permissionTag = null;
            CaseActivityAttribPK attribPK = new CaseActivityAttribPK(caseActivityDefinitionId, caseId);
            CaseActivityAttrib oldAttrib = ServicesLocator.getCasePersistence().find(CaseActivityAttrib.class, attribPK);
            if (oldAttrib != null) {
                permissionTag = oldAttrib.getPermissionTag();
            }
            if (permissionTag == null || "".equals(permissionTag.trim())) {
                permissionTag = activityDfn.getPermissionTag();
            }
            return permissionTag;
        }
        catch (CasePersistenceException cpe) {
            throw SetCaseActivityActionAdvice.logAndLocalizeException(ctx, "setCaseActivityAction", new CaseServiceException(74001, new Object[]{caseActivityDefinitionId}, (Throwable)((Object)cpe)));
        }
    }
}

