/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseDocumentObject;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.annotations.RaiseEvent;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.interceptors.AbstractAnnotationAdvice;
import oracle.bpm.casemgmt.interceptors.CaseAnnotationInterceptorContext;
import oracle.bpm.casemgmt.metadata.event.model.TDocumentEvent;
import oracle.bpm.casemgmt.metadata.event.model.TEventType;
import oracle.bpm.casemgmt.metadata.event.model.TLifecycleEvent;
import oracle.bpm.casemgmt.metadata.event.model.TMilestoneEvent;
import oracle.bpm.casemgmt.persistence.factory.CaseEventFactory;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.model.CaseMilestone;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class RaiseEventAdvice
extends AbstractAnnotationAdvice {
    private static RaiseEventAdvice thisAdvice = new RaiseEventAdvice();

    private RaiseEventAdvice() {
    }

    public static RaiseEventAdvice getInstance() {
        return thisAdvice;
    }

    @Override
    public void process(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        RaiseEvent raiseEventAnnotation = (RaiseEvent)annotation;
    }

    @Override
    public void processResult(Annotation annotation, CaseAnnotationInterceptorContext context) throws CaseServiceException {
        RaiseEvent raiseEventAnnotation = (RaiseEvent)annotation;
        RaiseEventAdvice.raiseEvent(context, raiseEventAnnotation);
    }

    private static void raiseEvent(CaseAnnotationInterceptorContext context, RaiseEvent raiseEventAnnotation) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"RaiseEventAdvice.raiseEvent: event raised");
        IBPMContext ctx = context.getBPMContext();
        Case caseInstance = null;
        Comment comment = null;
        CaseObject caseObject = context.getCaseObject();
        if (caseObject != null) {
            comment = context.getComment(caseObject);
        } else {
            caseInstance = context.getCase();
            if (caseInstance != null && caseInstance.getComments() != null && caseInstance.getComments().size() > 0) {
                comment = (Comment)caseInstance.getComments().get(0);
            }
        }
        CaseIdentifier caseIdentifier = context.getCaseIdentifier();
        String eventType = raiseEventAnnotation.eventType();
        String lifecycleEventType = raiseEventAnnotation.lifecycleEventType();
        String documentEventType = raiseEventAnnotation.documentEventType();
        String milestoneEventType = raiseEventAnnotation.milestoneEventType();
        CaseEvent ce = null;
        if (TEventType.LIFECYCLE_EVENT.name().equals(eventType)) {
            TLifecycleEvent lce = TLifecycleEvent.fromValue((String)lifecycleEventType);
            ce = CaseEventFactory.createCaseLifecycleEvent((TLifecycleEvent)lce, null, (Comment)comment);
        } else if (TEventType.DOCUMENT_EVENT.name().equals(eventType)) {
            if (!(caseObject instanceof CaseDocumentObject)) {
                throw new IllegalArgumentException("Expected document type, but got: " + caseObject.getClass().getName());
            }
            String documentName = caseObject.getObjectName();
            String documentVersion = null;
            String documentId = caseObject.getId();
            TDocumentEvent de = TDocumentEvent.fromValue((String)documentEventType);
            ce = CaseEventFactory.createCaseDocumentEvent((TDocumentEvent)de, (String)documentName, documentVersion, (String)documentId, null, (Comment)comment);
        } else if (TEventType.MILESTONE_EVENT.name().equals(eventType)) {
            if (!(caseObject instanceof CaseMilestone)) {
                throw new IllegalArgumentException("Expected milestone type, but got: " + caseObject.getClass().getName());
            }
            String milestoneName = caseObject.getObjectName();
            TMilestoneEvent me = TMilestoneEvent.fromValue((String)milestoneEventType);
            ce = CaseEventFactory.createCaseMilestoneEvent((Comment)comment, null, (TMilestoneEvent)me, (String)milestoneName);
        } else if (TEventType.COMMENT_EVENT.name().equals(eventType)) {
            if (!(caseObject instanceof Comment)) {
                throw new IllegalArgumentException("Expected comment type, but got: " + caseObject.getClass().getName());
            }
            ce = CaseEventFactory.createCaseCommentEvent((Comment)((Comment)caseObject), null);
        } else if (TEventType.DATA_UPLOAD_EVENT.name().equals(eventType)) {
            if (!(caseObject instanceof CaseData)) {
                throw new IllegalArgumentException("Expected CaseData type, but got: " + caseObject.getClass().getName());
            }
            ce = CaseEventFactory.createCaseDataEvent((Comment)comment, null, (String)caseObject.getObjectName());
        } else {
            throw new IllegalArgumentException("Unknown event type: " + eventType);
        }
        if (caseObject != null) {
            ce.setPermissionTag(caseObject.getPermissionTag());
        }
        context.mCaseEventService.raiseCaseEvent(ctx, caseIdentifier, ce);
    }

    private boolean isStartCaseEvent(RaiseEvent raiseEventAnnotation) {
        String eventType = raiseEventAnnotation.eventType();
        String lifecycleEventType = raiseEventAnnotation.lifecycleEventType();
        return TEventType.LIFECYCLE_EVENT.name().equals(eventType) && "STARTED".equals(lifecycleEventType);
    }
}

