/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import oracle.bpm.casemgmt.annotations.MethodPermissionMap;
import oracle.bpm.casemgmt.interceptors.ActionsUtil;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;

public class PermissionsUtil {
    private static final String permissionAnnotation = "@oracle.bpm.casemgmt.annotations.MethodPermissionMap";
    private static Hashtable<String, Set<String>> actionPermissionMap = new Hashtable();
    private static Map<String, String> documentStreamPermissionMap = new HashMap<String, String>();
    private static boolean documentStreamActionsUpdateStatus = false;

    public static Set<String> filterActionsBasedOnPermissions(Set<ICaseConstants.CaseObjectPermissionType> permissionSet, ICaseConstants.CaseObjectType caseObjectType) {
        HashSet<String> actionsToBeRemmoved = new HashSet<String>();
        switch (caseObjectType) {
            case CASE: 
            case DATA: 
            case DOCUMENT: 
            case MILESTONE: 
            case STAKEHOLDER: 
            case COMMENT: {
                for (ICaseConstants.CaseObjectPermissionType caseObjectPermissionType : ICaseConstants.CaseObjectPermissionType.values()) {
                    if (caseObjectPermissionType.equals((Object)ICaseConstants.CaseObjectPermissionType.INVOKE) || permissionSet.contains(caseObjectPermissionType)) continue;
                    actionsToBeRemmoved.addAll((Collection<String>)actionPermissionMap.get(caseObjectPermissionType.toString()));
                }
                break;
            }
            case ACTIVITY: 
            case EVENT: {
                if (permissionSet.contains(ICaseConstants.CaseObjectPermissionType.INVOKE)) break;
                actionsToBeRemmoved.addAll((Collection<String>)actionPermissionMap.get(ICaseConstants.CaseObjectPermissionType.INVOKE.toString()));
            }
        }
        return actionsToBeRemmoved;
    }

    public static ICaseConstants.CaseObjectType convertStringToCaseObjectType(String caseObjectType) {
        if (caseObjectType.equals(ICaseConstants.CaseObjectType.DATABASE_ECM_DOCUMENT.toString())) {
            return ICaseConstants.CaseObjectType.DOCUMENT;
        }
        return ICaseConstants.CaseObjectType.valueOf((String)caseObjectType);
    }

    public static void populateMethodPermissionMap(String methodName, Annotation[] annotations) {
        for (Annotation a : annotations) {
            String str = ((Object)a).toString();
            int ind = str.indexOf(40);
            if (!(str = str.substring(0, ind)).equals(permissionAnnotation)) continue;
            MethodPermissionMap methodPermissionMap = (MethodPermissionMap)a;
            String permissionForApi = methodPermissionMap.permission();
            String permissionCaseObjectType = methodPermissionMap.permissionCaseObjectType();
            String caseObjectType = methodPermissionMap.caseObjectType();
            for (ICaseConstants.CaseObjectPermissionType caseObjectPermissionType : ICaseConstants.CaseObjectPermissionType.values()) {
                if (!permissionForApi.equals(caseObjectPermissionType.toString())) continue;
                Set<String> actions = actionPermissionMap.get(permissionForApi);
                if (actions == null) {
                    actions = new HashSet<String>();
                }
                actions.add(methodName);
                actionPermissionMap.put(caseObjectPermissionType.toString(), actions);
                break;
            }
            ActionsUtil.populateActions(methodName, permissionCaseObjectType);
            if (!caseObjectType.isEmpty()) {
                ActionsUtil.populateActions(methodName, caseObjectType);
            }
            if (documentStreamActionsUpdateStatus) continue;
            PermissionsUtil.populateDocumentStreamActions();
        }
    }

    private static void populateDocumentStreamActions() {
        for (Map.Entry<String, String> entry : documentStreamPermissionMap.entrySet()) {
            Set<String> existingActions = actionPermissionMap.get(entry.getValue());
            if (existingActions == null) {
                existingActions = new HashSet<String>();
            }
            existingActions.add(entry.getKey());
            actionPermissionMap.put(entry.getValue(), existingActions);
            ActionsUtil.populateActions(entry.getKey(), ICaseConstants.CaseObjectType.DOCUMENT.toString());
        }
        documentStreamActionsUpdateStatus = true;
    }

    static {
        documentStreamPermissionMap.put(ICaseConstants.CaseDocumentStreamActions.uploadDocument.toString(), ICaseConstants.CaseObjectPermissionType.UPDATE.toString());
        documentStreamPermissionMap.put(ICaseConstants.CaseDocumentStreamActions.downloadDocument.toString(), ICaseConstants.CaseObjectPermissionType.UPDATE.toString());
    }
}

