/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.ICaseStreamService;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.impl.CaseActivityServiceImpl;
import oracle.bpm.casemgmt.impl.CaseDocumentServiceImpl;
import oracle.bpm.casemgmt.impl.CaseEventServiceImpl;
import oracle.bpm.casemgmt.impl.CaseInstanceServiceImpl;
import oracle.bpm.casemgmt.impl.CaseMetadataServiceImpl;
import oracle.bpm.casemgmt.impl.CasePermissionServiceImpl;
import oracle.bpm.casemgmt.impl.CaseRuleServiceImpl;
import oracle.bpm.casemgmt.interceptors.CaseAnnotationComparator;
import oracle.bpm.casemgmt.interceptors.PermissionsUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class InterceptorUtil {
    private static Class[] sClassesWithAnnotations = new Class[]{CasePermissionServiceImpl.class, CaseRuleServiceImpl.class, CaseDocumentServiceImpl.class, CaseActivityServiceImpl.class, CaseInstanceServiceImpl.class, CaseEventServiceImpl.class, CaseMetadataServiceImpl.class};
    private static Class[] sServiceInterfaces = new Class[]{ICaseService.class, ICaseStreamService.class};
    private static Map<String, Annotation[]> sAnnotations = new HashMap<String, Annotation[]>();
    private static Map<String, Boolean> sInterfaceMethods = new HashMap<String, Boolean>();

    public static Annotation[] getAnnotations(String methodName) {
        return sAnnotations.get(methodName);
    }

    private static void buildCache() {
        try {
            Method[] methods;
            for (Class classObj : sServiceInterfaces) {
                for (Method m : methods = classObj.getMethods()) {
                    if (sInterfaceMethods.get(m.getName()) != null) {
                        throw new RuntimeException("InterceptorUtil: duplicate method name in class " + classObj.getName() + "." + m.getName());
                    }
                    Class<?>[] params = m.getParameterTypes();
                    if (!"oracle.bpel.services.bpm.common.IBPMContext".equals(params[0].getName())) {
                        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("%%%" + classObj.getName() + "." + m.getName() + " doesn't have context as first param"));
                        throw new RuntimeException("InterceptorUtil: " + classObj.getName() + "." + m.getName() + " doesn't have context as first param");
                    }
                    sInterfaceMethods.put(m.getName(), true);
                }
            }
            for (Class classObj : sClassesWithAnnotations) {
                for (Method m : methods = classObj.getDeclaredMethods()) {
                    Annotation[] annotations;
                    if (sInterfaceMethods.get(m.getName()) == null || (annotations = m.getAnnotations()) == null | annotations.length == 0) continue;
                    if (sAnnotations.get(m.getName()) != null) {
                        throw new RuntimeException("InterceptorUtil: duplicate method name in class " + classObj.getName() + "." + m.getName());
                    }
                    sAnnotations.put(m.getName(), InterceptorUtil.sortAnnotations(annotations));
                    PermissionsUtil.populateMethodPermissionMap(m.getName(), annotations);
                }
            }
        }
        catch (Throwable t) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)InterceptorUtil.class.getName(), (String)"buildCache", (Throwable)t);
        }
    }

    private static Annotation[] sortAnnotations(Annotation[] annotations) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("Sort annotations: Incoming\n" + InterceptorUtil.printAnnotations(annotations)));
        CaseAnnotationComparator comparator = new CaseAnnotationComparator();
        Arrays.sort(annotations, comparator);
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("Sort annotations: Outgoing\n" + InterceptorUtil.printAnnotations(annotations)));
        return annotations;
    }

    private static String printAnnotations(Annotation[] annotations) {
        if (annotations == null) {
            return "NONE";
        }
        StringBuffer sb = new StringBuffer();
        for (Annotation a : annotations) {
            sb.append("\n\t" + a);
        }
        return sb.toString();
    }

    static {
        InterceptorUtil.buildCache();
        Iterator<String> interfaceMethodsIter = sInterfaceMethods.keySet().iterator();
        Iterator<String> annotationsIter = sAnnotations.keySet().iterator();
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"Advice methods");
        while (interfaceMethodsIter.hasNext()) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)interfaceMethodsIter.next());
        }
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"Annotations");
        while (annotationsIter.hasNext()) {
            String name = annotationsIter.next();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)name);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)InterceptorUtil.printAnnotations(sAnnotations.get(name)));
        }
    }
}

