/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import oracle.bpm.casemgmt.ICaseEventService;
import oracle.bpm.casemgmt.ICaseInstanceService;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.identity.CaseIdentityService;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.impl.CaseEventServiceImpl;
import oracle.bpm.casemgmt.impl.CaseInstanceServiceImpl;
import oracle.bpm.casemgmt.impl.CaseMetadataServiceImpl;
import oracle.bpm.casemgmt.interceptors.AbstractAnnotationAdvice;
import oracle.bpm.casemgmt.interceptors.CaseAnnotationInterceptorContext;
import oracle.bpm.casemgmt.interceptors.CaseAnnotationInterceptorFactory;
import oracle.bpm.casemgmt.interceptors.InterceptorUtil;
import oracle.bpm.casemgmt.permission.ICasePermissionServiceInternal;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class CaseServiceAdvice
implements MethodInterceptor {
    private ICaseEventService mCaseEventService = null;
    private ICaseIdentityService mCaseIdentityService = null;
    private ICaseInstanceService mCaseInstanceService = null;
    private ICaseMetadataService mCaseMetadataService = null;
    private ICasePermissionServiceInternal mCasePermissionServiceInternal = null;

    public ICaseInstanceService getCaseInstanceService() {
        if (this.mCaseInstanceService == null) {
            this.mCaseInstanceService = new CaseInstanceServiceImpl();
        }
        return this.mCaseInstanceService;
    }

    public void setCaseInstanceService(ICaseInstanceService newCaseInstanceService) {
        this.mCaseInstanceService = newCaseInstanceService;
    }

    public ICaseEventService getCaseEventService() {
        if (this.mCaseEventService == null) {
            this.mCaseEventService = new CaseEventServiceImpl();
        }
        return this.mCaseEventService;
    }

    public void setCaseEventService(ICaseEventService newCaseEventService) {
        this.mCaseEventService = newCaseEventService;
    }

    public ICaseMetadataService getCaseMetadataService() {
        if (this.mCaseMetadataService == null) {
            this.mCaseMetadataService = new CaseMetadataServiceImpl();
        }
        return this.mCaseMetadataService;
    }

    public void setCaseMetadataService(ICaseMetadataService newCaseMetadataService) {
        this.mCaseMetadataService = newCaseMetadataService;
    }

    public ICaseIdentityService getCaseIdentityService() {
        if (this.mCaseIdentityService == null) {
            this.mCaseIdentityService = new CaseIdentityService();
        }
        return this.mCaseIdentityService;
    }

    public void setCaseIdentityService(ICaseIdentityService newCaseIdentityService) {
        this.mCaseIdentityService = newCaseIdentityService;
    }

    public ICasePermissionServiceInternal getCasePermissionServiceInternal() {
        if (this.mCasePermissionServiceInternal == null) {
            this.mCasePermissionServiceInternal = ServicesLocator.getCasePermissionServiceInternal();
        }
        return this.mCasePermissionServiceInternal;
    }

    public void setCasePermissionServiceInternal(ICasePermissionServiceInternal casePermissionServiceInternal) {
        this.mCasePermissionServiceInternal = casePermissionServiceInternal;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("^^^CaseServiceAdvice.invoke: Intercepting method " + methodInvocation.getMethod().getName() + ". Method arguments : " + Arrays.toString(methodInvocation.getArguments())));
        String methodName = methodInvocation.getMethod().getName();
        Annotation[] annotations = InterceptorUtil.getAnnotations(methodName);
        CaseAnnotationInterceptorContext interceptorContext = new CaseAnnotationInterceptorContext(this.getCaseEventService(), this.getCaseIdentityService(), this.getCasePermissionServiceInternal(), this.getCaseInstanceService(), this.getCaseMetadataService(), methodInvocation, annotations);
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("Created context " + interceptorContext));
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (interceptorContext.shouldIgnoreAllAnnotations()) break;
                AbstractAnnotationAdvice advice = CaseAnnotationInterceptorFactory.getAnnotationAdvice(annotation);
                if (advice == null && ((Object)annotation).toString().indexOf("@oracle.bpm.casemgmt.annotations.MethodPermissionMap") > -1) continue;
                if (interceptorContext.isInternalContext() && advice.ignoreForInternalWorkflow(annotation, interceptorContext)) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("Ignoring : " + annotation));
                    continue;
                }
                advice.process(annotation, interceptorContext);
            }
        }
        Object result = methodInvocation.proceed();
        interceptorContext.setReturnArg(result);
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (interceptorContext.shouldIgnoreAllAnnotations()) break;
                AbstractAnnotationAdvice advice = CaseAnnotationInterceptorFactory.getAnnotationAdvice(annotation);
                if (advice == null && ((Object)annotation).toString().indexOf("@oracle.bpm.casemgmt.annotations.MethodPermissionMap") > -1) continue;
                if (interceptorContext.isInternalContext() && advice.ignoreForInternalWorkflow(annotation, interceptorContext)) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("Ignoring : " + annotation));
                    continue;
                }
                advice.processResult(annotation, interceptorContext);
            }
        }
        return result;
    }
}

