/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.casemgmt.interceptors.AbstractAnnotationAdvice;
import oracle.bpm.casemgmt.interceptors.IgnoreFirstOfMultipleAdvice;
import oracle.bpm.casemgmt.interceptors.RaiseEventAdvice;
import oracle.bpm.casemgmt.interceptors.SetCaseActivityActionAdvice;
import oracle.bpm.casemgmt.interceptors.SetCaseObjectActionAdvice;
import oracle.bpm.casemgmt.interceptors.SetCaseObjectDefaultValuesAdvice;
import oracle.bpm.casemgmt.interceptors.SetReturnDisplayNameAdvice;
import oracle.bpm.casemgmt.interceptors.ValidateActionAdvice;
import oracle.bpm.casemgmt.interceptors.ValidateAdminContextAdvice;
import oracle.bpm.casemgmt.interceptors.ValidateCaseIdentifierAdvice;
import oracle.bpm.casemgmt.interceptors.ValidateContextAdvice;
import oracle.bpm.casemgmt.interceptors.ValidateContextWithDefaultAdvice;
import oracle.bpm.casemgmt.interceptors.ValidateUserCaseAccessAdvice;

public class CaseAnnotationInterceptorFactory {
    private static Map<String, AbstractAnnotationAdvice> sAdvices = new HashMap<String, AbstractAnnotationAdvice>();

    public static AbstractAnnotationAdvice getAnnotationAdvice(Annotation annotation) {
        String str = ((Object)annotation).toString();
        int ind = str.indexOf(40);
        return sAdvices.get(str.substring(0, ind));
    }

    static {
        sAdvices.put("@oracle.bpm.casemgmt.annotations.ValidateContext", ValidateContextAdvice.getInstance());
        sAdvices.put("@oracle.bpm.casemgmt.annotations.ValidateContextWithDefault", ValidateContextWithDefaultAdvice.getInstance());
        sAdvices.put("@oracle.bpm.casemgmt.annotations.IgnoreFirstOfMultiple", IgnoreFirstOfMultipleAdvice.getInstance());
        sAdvices.put("@oracle.bpm.casemgmt.annotations.ValidateAdminContext", ValidateAdminContextAdvice.getInstance());
        sAdvices.put("@oracle.bpm.casemgmt.annotations.ValidateCaseIdentifier", ValidateCaseIdentifierAdvice.getInstance());
        sAdvices.put("@oracle.bpm.casemgmt.annotations.ValidateAction", ValidateActionAdvice.getInstance());
        sAdvices.put("@oracle.bpm.casemgmt.annotations.ValidateUserCaseAccess", ValidateUserCaseAccessAdvice.getInstance());
        sAdvices.put("@oracle.bpm.casemgmt.annotations.SetCaseObjectDefaultValues", SetCaseObjectDefaultValuesAdvice.getInstance());
        sAdvices.put("@oracle.bpm.casemgmt.annotations.RaiseEvent", RaiseEventAdvice.getInstance());
        sAdvices.put("@oracle.bpm.casemgmt.annotations.SetCaseObjectAction", SetCaseObjectActionAdvice.getInstance());
        sAdvices.put("@oracle.bpm.casemgmt.annotations.SetReturnDisplayName", SetReturnDisplayNameAdvice.getInstance());
        sAdvices.put("@oracle.bpm.casemgmt.annotations.SetCaseActivityAction", SetCaseActivityActionAdvice.getInstance());
    }
}

