/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseDocumentObject;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.ICaseEventService;
import oracle.bpm.casemgmt.ICaseInstanceService;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.permission.ICasePermissionServiceInternal;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.model.CaseHeader;
import oracle.bpm.casemgmt.persistence.model.CaseMilestone;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolder;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import org.aopalliance.intercept.MethodInvocation;

public class CaseAnnotationInterceptorContext {
    protected Annotation[] mAnnotations = null;
    protected ICaseEventService mCaseEventService = null;
    protected ICaseIdentityService mCaseIdentityService = null;
    protected ICaseInstanceService mCaseInstanceService = null;
    protected ICaseMetadataService mCaseMetadataService = null;
    protected ICasePermissionServiceInternal mCasePermissionServiceInternal = null;
    protected boolean mIgnoreAllAnnotations = false;
    protected boolean mIsInternalContext = false;
    protected Map<String, Object> mLocalCache = new HashMap<String, Object>();
    protected Object[] mMethodArgs = null;
    protected MethodInvocation mMethodInvocation = null;
    protected String mMethodName = null;
    protected Object mReturnArg = null;

    public CaseAnnotationInterceptorContext(ICaseEventService caseEventService, ICaseIdentityService caseIdentityService, ICasePermissionServiceInternal casePermissionServiceInternal, ICaseInstanceService caseInstanceService, ICaseMetadataService caseMetadataService, MethodInvocation methodInvocation, Annotation[] annotations) {
        this.mCaseEventService = caseEventService;
        this.mCaseIdentityService = caseIdentityService;
        this.mCasePermissionServiceInternal = casePermissionServiceInternal;
        this.mCaseInstanceService = caseInstanceService;
        this.mCaseMetadataService = caseMetadataService;
        this.mMethodInvocation = methodInvocation;
        this.mMethodName = methodInvocation.getMethod().getName();
        this.mMethodArgs = methodInvocation.getArguments();
        this.mAnnotations = annotations;
    }

    public void setReturnArg(Object returnArg) {
        this.mReturnArg = returnArg;
    }

    public boolean shouldIgnoreAllAnnotations() {
        return this.mIgnoreAllAnnotations;
    }

    public void ignoreAllAnnotations() {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("Ignoring all annotations for context " + this));
        this.mIgnoreAllAnnotations = true;
    }

    public boolean isInternalContext() {
        return this.mIsInternalContext;
    }

    public void setAsInternalContext() {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"Setting as internal workflow context");
        this.mIsInternalContext = true;
    }

    protected IBPMContext getBPMContext() {
        IBPMContext obj = null;
        for (Object arg : this.mMethodArgs) {
            if (!(arg instanceof IBPMContext)) continue;
            obj = (IBPMContext)arg;
        }
        return obj;
    }

    protected CaseIdentifier getCaseIdentifier() {
        Case caseInstance;
        CaseObject caseObject;
        CaseIdentifier obj = null;
        for (Object arg : this.mMethodArgs) {
            if (!(arg instanceof CaseIdentifier)) continue;
            obj = (CaseIdentifier)arg;
        }
        if (obj == null && (caseObject = this.getCaseObject()) != null && caseObject.getCaseId() != null) {
            obj = CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseObject.getCaseId());
        }
        if (obj == null && (caseInstance = this.getCase()) != null && caseInstance.getCaseId() != null) {
            obj = CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseInstance.getCaseId());
        }
        return obj;
    }

    protected CaseObject getCaseObject() {
        CaseObject obj = null;
        for (Object arg : this.mMethodArgs) {
            if (!(arg instanceof CaseObject)) continue;
            obj = (CaseObject)arg;
            return obj;
        }
        return obj;
    }

    protected String getCaseActivityDefinitionId() {
        String str = null;
        for (Object arg : this.mMethodArgs) {
            if (!(arg instanceof String)) continue;
            return (String)arg;
        }
        return str;
    }

    protected Case getCase() {
        Case obj = null;
        for (Object arg : this.mMethodArgs) {
            if (!(arg instanceof Case)) continue;
            obj = (Case)arg;
        }
        return obj;
    }

    protected String getMethodName() {
        return this.mMethodName;
    }

    protected Object getReturnArg() {
        return this.mReturnArg;
    }

    protected Comment getComment() {
        Comment obj = null;
        for (Object arg : this.mMethodArgs) {
            if (!(arg instanceof Comment)) continue;
            obj = (Comment)arg;
        }
        return obj;
    }

    protected Comment getComment(CaseObject caseObject) {
        Comment commentArg = this.getComment();
        if (commentArg != null && commentArg.getCaseObjectComment() != null) {
            return commentArg;
        }
        if (caseObject instanceof CaseHeader) {
            return null;
        }
        if (caseObject instanceof Comment) {
            return null;
        }
        if (caseObject instanceof CaseMilestone) {
            return ((CaseMilestone)caseObject).getComment();
        }
        if (caseObject instanceof CaseStakeHolder) {
            return ((CaseStakeHolder)caseObject).getComment();
        }
        if (caseObject instanceof CaseData) {
            return ((CaseData)caseObject).getComment();
        }
        if (caseObject instanceof CaseDocumentObject) {
            return null;
        }
        if (caseObject instanceof CaseEvent) {
            return ((CaseEvent)caseObject).getComment();
        }
        throw new IllegalArgumentException("Unknown type: " + caseObject.getClass().getName());
    }
}

