/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.interceptors;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.interceptors.PermissionsUtil;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseData;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TData;
import oracle.bpm.casemgmt.metadata.Case.model.TMilestone;
import oracle.bpm.casemgmt.metadata.Case.model.TMilestones;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseMilestone;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;

public class ActionsUtil {
    private static Hashtable<String, Set<String>> caseObjectActions = new Hashtable();
    private static Hashtable<String, Set<String>> caseStateExclusionTable = new Hashtable();
    private static Hashtable<String, Set<String>> caseMilestoneStateExclusionTable = new Hashtable();

    public static Set<String> getPermittedActionsForCase(Set<ICaseConstants.CaseObjectPermissionType> permissionSet, Case caseInstance, boolean hasUpdateOnHeader) throws CaseServiceException {
        HashSet actionsfromMap = (HashSet)caseObjectActions.get(ICaseConstants.CaseObjectType.CASE.toString());
        HashSet actionsValidForCaseObj = (HashSet)actionsfromMap.clone();
        Set<String> actionsWithSpecialPermisisons = ActionsUtil.filterActionsWithSpecialPermissions(actionsValidForCaseObj);
        if (actionsWithSpecialPermisisons.size() != 0 && !hasUpdateOnHeader) {
            actionsValidForCaseObj.removeAll(actionsWithSpecialPermisisons);
        }
        actionsValidForCaseObj.removeAll(PermissionsUtil.filterActionsBasedOnPermissions(permissionSet, ICaseConstants.CaseObjectType.CASE));
        actionsValidForCaseObj.removeAll(ActionsUtil.filterActionsBasedOnState(ICaseConstants.CaseObjectType.CASE, caseInstance, null));
        return actionsValidForCaseObj;
    }

    public static Set<String> getPermittedActionsForCaseObject(Set<ICaseConstants.CaseObjectPermissionType> permissionSet, boolean hasUpdateOnHeader, String caseObjectType) throws CaseServiceException {
        return ActionsUtil.getPermittedActionsForCaseObject(null, null, permissionSet, hasUpdateOnHeader, null, caseObjectType);
    }

    public static Set<String> getPermittedActionsForCaseObject(IBPMContext ctx, CaseMetadata caseMetadata, Set<ICaseConstants.CaseObjectPermissionType> permissionSet, boolean hasUpdateOnHeader, CaseObject caseObj, String baseCaseObjectType) throws CaseServiceException {
        ICaseConstants.CaseObjectType caseObjectType = PermissionsUtil.convertStringToCaseObjectType(baseCaseObjectType);
        HashSet actionsfromMap = (HashSet)caseObjectActions.get(caseObjectType.toString());
        HashSet actionsValidForCaseObj = (HashSet)actionsfromMap.clone();
        Set<String> actionsWithSpecialPermisisons = ActionsUtil.filterActionsWithSpecialPermissions(actionsValidForCaseObj);
        if (actionsWithSpecialPermisisons.size() != 0 && !hasUpdateOnHeader) {
            actionsValidForCaseObj.removeAll(actionsWithSpecialPermisisons);
        }
        actionsValidForCaseObj.removeAll(PermissionsUtil.filterActionsBasedOnPermissions(permissionSet, caseObjectType));
        if (!hasUpdateOnHeader) {
            actionsValidForCaseObj.removeAll((Collection)caseObjectActions.get(ICaseConstants.CaseObjectType.HEADER.toString()));
        }
        if (caseObj != null) {
            actionsValidForCaseObj.removeAll(ActionsUtil.filterActionsBasedOnState(caseObjectType, null, caseObj));
            actionsValidForCaseObj.removeAll(ActionsUtil.filterActionsBasedOnCaseObject(ctx, caseMetadata, caseObjectType, caseObj));
        }
        return actionsValidForCaseObj;
    }

    public static void populateActions(String methodName, String caseObjectType) {
        Set<String> actions = caseObjectActions.get(caseObjectType);
        if (actions == null) {
            actions = new HashSet<String>();
        }
        actions.add(methodName);
        caseObjectActions.put(caseObjectType, actions);
    }

    private static Set<String> filterActionsWithSpecialPermissions(Set<String> actionsForCaseObject) {
        HashSet<String> actionsWithSpecialPermissions = new HashSet<String>();
        Set<String> actionsThatNeedHeaderPermissions = caseObjectActions.get(ICaseConstants.CaseObjectType.HEADER.toString());
        for (String action : actionsThatNeedHeaderPermissions) {
            if (!actionsForCaseObject.contains(action)) continue;
            actionsWithSpecialPermissions.add(action);
        }
        return actionsWithSpecialPermissions;
    }

    private static Set<String> filterActionsBasedOnState(ICaseConstants.CaseObjectType caseObjectType, Case caseInstance, CaseObject caseObj) throws CaseServiceException {
        HashSet<String> invalidStates = new HashSet<String>();
        String state = "";
        if (caseObjectType.equals((Object)ICaseConstants.CaseObjectType.CASE)) {
            state = caseInstance.getCaseHeader().getState();
            if (caseStateExclusionTable.containsKey(state)) {
                invalidStates.addAll((Collection<String>)caseStateExclusionTable.get(state));
                return invalidStates;
            }
            throw new CaseServiceException(74814, new Object[]{state, caseObjectType.toString()});
        }
        if (caseObjectType.equals((Object)ICaseConstants.CaseObjectType.MILESTONE)) {
            CaseMilestone caseMilestone = (CaseMilestone)caseObj;
            state = caseMilestone.getState();
            if (caseMilestoneStateExclusionTable.containsKey(state)) {
                invalidStates.addAll((Collection<String>)caseMilestoneStateExclusionTable.get(state));
                return invalidStates;
            }
            throw new CaseServiceException(74814, new Object[]{state, caseObjectType.toString()});
        }
        return invalidStates;
    }

    private static Set<String> filterActionsBasedOnCaseObject(IBPMContext ctx, CaseMetadata caseMetadata, ICaseConstants.CaseObjectType caseObjectType, CaseObject caseObj) {
        if (caseObjectType.equals((Object)ICaseConstants.CaseObjectType.MILESTONE)) {
            return ActionsUtil.filterMilestoneActions(ctx, caseMetadata, (CaseMilestone)caseObj);
        }
        if (caseObjectType.equals((Object)ICaseConstants.CaseObjectType.DATA)) {
            return ActionsUtil.filterCaseDataActions(caseMetadata, (CaseData)caseObj);
        }
        return new HashSet<String>();
    }

    private static Set<String> filterMilestoneActions(IBPMContext ctx, CaseMetadata caseMetadata, CaseMilestone caseMilestone) {
        List milestonesList;
        TMilestones milestones;
        HashSet<String> invalidStates = new HashSet<String>();
        if (caseMilestone.getState().equals(ICaseConstants.CaseMilestoneState.ATTAINED.toString()) && (milestones = ((TCaseMetadata)caseMetadata.getValue()).getMilestones()) != null && (milestonesList = milestones.getMilestone()) != null && !milestonesList.isEmpty()) {
            for (TMilestone milestone : milestonesList) {
                boolean isSoft;
                if (!caseMilestone.getObjectName().equals(milestone.getName()) || (isSoft = milestone.isIsSoft())) continue;
                invalidStates.add(ICaseConstants.CaseMilestoneActions.revokeMilestone.toString());
            }
        }
        return invalidStates;
    }

    private static Set<String> filterCaseDataActions(CaseMetadata caseMetadata, CaseData caseData) {
        List caseDataListFromMetadata;
        HashSet<String> invalidStates = new HashSet<String>();
        List caseDataWrapperListFromMetadata = ((TCaseMetadata)caseMetadata.getValue()).getCaseData();
        TCaseData caseDataWrapperFromMetadata = null;
        if (caseDataWrapperListFromMetadata != null && !caseDataWrapperListFromMetadata.isEmpty()) {
            caseDataWrapperFromMetadata = (TCaseData)caseDataWrapperListFromMetadata.get(0);
        }
        if ((caseDataListFromMetadata = caseDataWrapperFromMetadata.getData()) != null && !caseDataListFromMetadata.isEmpty()) {
            for (TData caseDataFromMetadata : caseDataListFromMetadata) {
                if (!caseData.getObjectName().equals(caseDataFromMetadata.getName()) || caseDataFromMetadata.isUpdatable()) continue;
                invalidStates.add(ICaseConstants.CaseDataActions.uploadCaseData.toString());
            }
        }
        return invalidStates;
    }

    static {
        HashSet<String> activeCaseExclusion = new HashSet<String>();
        activeCaseExclusion.add(ICaseConstants.CaseActions.resumeCase.toString());
        activeCaseExclusion.add(ICaseConstants.CaseActions.reopenCase.toString());
        activeCaseExclusion.add(ICaseConstants.CaseActions.startCase.toString());
        HashSet<String> suspendedCaseExclusion = new HashSet<String>();
        suspendedCaseExclusion.add(ICaseConstants.CaseActions.reopenCase.toString());
        suspendedCaseExclusion.add(ICaseConstants.CaseActions.suspendCase.toString());
        suspendedCaseExclusion.add(ICaseConstants.CaseActions.startCase.toString());
        HashSet<String> closeCaseExclusion = new HashSet<String>();
        closeCaseExclusion.add(ICaseConstants.CaseActions.closeCase.toString());
        closeCaseExclusion.add(ICaseConstants.CaseActions.resumeCase.toString());
        closeCaseExclusion.add(ICaseConstants.CaseActions.suspendCase.toString());
        closeCaseExclusion.add(ICaseConstants.CaseActions.startCase.toString());
        HashSet<String> staleCaseExclusion = new HashSet<String>();
        staleCaseExclusion.add(ICaseConstants.CaseActions.closeCase.toString());
        staleCaseExclusion.add(ICaseConstants.CaseActions.resumeCase.toString());
        staleCaseExclusion.add(ICaseConstants.CaseActions.suspendCase.toString());
        staleCaseExclusion.add(ICaseConstants.CaseActions.startCase.toString());
        staleCaseExclusion.add(ICaseConstants.CaseActions.reopenCase.toString());
        staleCaseExclusion.add(ICaseConstants.CaseActions.updateCaseHeader.toString());
        staleCaseExclusion.add(ICaseConstants.CaseActions.abortCase.toString());
        caseStateExclusionTable.put(ICaseConstants.CaseState.ACTIVE.toString(), activeCaseExclusion);
        caseStateExclusionTable.put(ICaseConstants.CaseState.SUSPENDED.toString(), suspendedCaseExclusion);
        caseStateExclusionTable.put(ICaseConstants.CaseState.CLOSED.toString(), closeCaseExclusion);
        caseStateExclusionTable.put(ICaseConstants.CaseState.EXPIRED.toString(), staleCaseExclusion);
        caseStateExclusionTable.put(ICaseConstants.CaseState.ERRORED.toString(), staleCaseExclusion);
        caseStateExclusionTable.put(ICaseConstants.CaseState.STALE.toString(), staleCaseExclusion);
        caseStateExclusionTable.put(ICaseConstants.CaseState.ABORTED.toString(), staleCaseExclusion);
        HashSet<String> notAttainedMilestoneExclusion = new HashSet<String>();
        notAttainedMilestoneExclusion.add(ICaseConstants.CaseMilestoneActions.revokeMilestone.toString());
        HashSet<String> attainedMilestoneExclusion = new HashSet<String>();
        attainedMilestoneExclusion.add(ICaseConstants.CaseMilestoneActions.attainMilestone.toString());
        HashSet<String> revokedMilestoneExclusion = new HashSet<String>();
        revokedMilestoneExclusion.add(ICaseConstants.CaseMilestoneActions.revokeMilestone.toString());
        caseMilestoneStateExclusionTable.put(ICaseConstants.CaseMilestoneState.NOT_ATTAINED.toString(), notAttainedMilestoneExclusion);
        caseMilestoneStateExclusionTable.put(ICaseConstants.CaseMilestoneState.ATTAINED.toString(), attainedMilestoneExclusion);
        caseMilestoneStateExclusionTable.put(ICaseConstants.CaseMilestoneState.REVOKED.toString(), revokedMilestoneExclusion);
    }
}

