/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.task.ITaskAndCaseManagmentBridgeService;
import oracle.bpel.services.workflow.task.model.AttachmentType;
import oracle.bpel.services.workflow.task.model.CommentType;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.casemgmt.CaseDocumentObject;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseDocumentStreamService;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseHeader;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolder;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;

public class TaskAndCaseManagmentBridgeService
implements ITaskAndCaseManagmentBridgeService {
    ICaseDocumentStreamService caseDocumentStreamService = ServicesLocator.getCaseDocumentStreamService();
    ICaseService caseService = BPMServiceClientFactory.getInstance((String)"REMOTE", null, null).getCaseManagementServiceClient().getCaseService();
    ObjectFactory objectFactory = new ObjectFactory();
    private static final List<ICaseConstants.CaseInfo> CASE_INFO_MILESTONE = new ArrayList<ICaseConstants.CaseInfo>();
    private static final List<ICaseConstants.CaseInfo> CASE_INFO_CASEDATA = new ArrayList<ICaseConstants.CaseInfo>();
    private static final List<ICaseConstants.CaseInfo> CASE_INFO_STAKEHOLDER = new ArrayList<ICaseConstants.CaseInfo>();
    private static final List<ICaseConstants.CaseInfo> CASE_INFO_COMMENT = new ArrayList<ICaseConstants.CaseInfo>();

    public List<AttachmentType> getAttachments(IWorkflowContext context, String caseId, String taskId) throws WorkflowException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[getAttachments] caseId:" + caseId + " taskId:" + taskId));
        if (CaseServiceUtil.isNullOrEmpty(caseId)) {
            return new ArrayList<AttachmentType>();
        }
        try {
            IBPMContext bpmContext = null;
            boolean isUserStakeHolder = false;
            if (context != null) {
                bpmContext = (IBPMContext)context;
                isUserStakeHolder = this.isUserStakeHolder((IWorkflowContext)bpmContext, caseId);
                if (!isUserStakeHolder) {
                    bpmContext = InternalBPMContext.getInternalBPMContext();
                }
            } else {
                bpmContext = InternalBPMContext.getInternalBPMContext();
            }
            CaseIdentifier caseIdentifier = CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseId);
            List caseDocumentObjectList = this.caseService.listDocuments(bpmContext, caseIdentifier);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[getAttachments] Retrieved " + caseDocumentObjectList.size() + " documents."));
            if (!isUserStakeHolder && !CaseServiceUtil.isNullOrEmpty(caseDocumentObjectList)) {
                ArrayList<CaseDocumentObject> caseDocumentObjectListToBeRemoved = new ArrayList<CaseDocumentObject>();
                for (CaseDocumentObject caseDocumentObject : caseDocumentObjectList) {
                    if (caseDocumentObject == null || caseDocumentObject.getPermissionTag() == null || caseDocumentObject.getPermissionTag().isEmpty()) continue;
                    caseDocumentObjectListToBeRemoved.add(caseDocumentObject);
                }
                if (caseDocumentObjectListToBeRemoved.size() > 0) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[getAttachments] Removed " + caseDocumentObjectListToBeRemoved.size() + " documents."));
                    caseDocumentObjectList.removeAll(caseDocumentObjectListToBeRemoved);
                }
            }
            return this.convertCaseDocumentsToTaskAttachments(caseDocumentObjectList, taskId);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public AttachmentType getAttachment(IWorkflowContext context, String caseId, String taskId, String attachmentName) throws WorkflowException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[getAttachment] caseId:" + caseId + " taskId:" + taskId + " attachmentName:" + attachmentName));
        if (CaseServiceUtil.isNullOrEmpty(caseId)) {
            return null;
        }
        try {
            IBPMContext bpmContext = null;
            boolean isUserStakeHolder = false;
            if (context != null) {
                bpmContext = (IBPMContext)context;
                isUserStakeHolder = this.isUserStakeHolder((IWorkflowContext)bpmContext, caseId);
                if (!isUserStakeHolder) {
                    bpmContext = InternalBPMContext.getInternalBPMContext();
                }
            } else {
                bpmContext = InternalBPMContext.getInternalBPMContext();
            }
            CaseIdentifier caseIdentifier = CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseId);
            List caseDocumentObjectList = this.caseService.listDocuments(bpmContext, caseIdentifier);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[getAttachment] Retrieved " + caseDocumentObjectList.size() + " documents."));
            for (CaseDocumentObject caseDocument : caseDocumentObjectList) {
                if (!caseDocument.getObjectName().equals(attachmentName)) continue;
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[getAttachment] Attachment found: " + caseDocument));
                AttachmentType attachment = this.convertCaseDocumentToTaskAttachment(caseDocument, taskId);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[getAttachment] Fetching the contents for: " + attachmentName));
                InputStream inputStream = this.caseDocumentStreamService.downloadDocument(bpmContext, caseIdentifier, attachmentName);
                attachment.setInputStream(inputStream);
                return attachment;
            }
            return null;
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public List<CommentType> getComments(IWorkflowContext context, String caseId, String taskId) throws WorkflowException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[getComments] caseId:" + caseId + " taskId:" + taskId));
        if (CaseServiceUtil.isNullOrEmpty(caseId)) {
            return new ArrayList<CommentType>();
        }
        try {
            IBPMContext bpmContext = null;
            boolean isUserStakeHolder = false;
            if (context != null) {
                bpmContext = (IBPMContext)context;
                isUserStakeHolder = this.isUserStakeHolder((IWorkflowContext)bpmContext, caseId);
                if (!isUserStakeHolder) {
                    bpmContext = InternalBPMContext.getInternalBPMContext();
                }
            } else {
                bpmContext = InternalBPMContext.getInternalBPMContext();
            }
            CaseHeader caseHeader = new CaseHeader();
            caseHeader.setCaseId(caseId);
            caseHeader.setId(caseId);
            List commentList = this.caseService.getComments(bpmContext, (CaseObject)caseHeader);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[getComments] Retrieved " + commentList.size() + " comments."));
            if (!isUserStakeHolder && !CaseServiceUtil.isNullOrEmpty(commentList)) {
                ArrayList<Comment> commentListToBeRemoved = new ArrayList<Comment>();
                for (Comment comment : commentList) {
                    if (comment == null || comment.getPermissionTag() == null || comment.getPermissionTag().isEmpty()) continue;
                    commentListToBeRemoved.add(comment);
                }
                if (commentListToBeRemoved.size() > 0) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[getComments] Removed " + commentListToBeRemoved.size() + " comments."));
                    commentList.removeAll(commentListToBeRemoved);
                }
            }
            return this.convertCaseCommentsToTaskComments(commentList, taskId);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public AttachmentType addAttachment(IWorkflowContext context, AttachmentType attachment, String caseId) throws WorkflowException {
        if (attachment == null) {
            return null;
        }
        attachment.setAttachmentScope("CASE");
        CaseDocumentObject caseDocumentObject = this.convertTaskAttachmentToCaseDocument(attachment, caseId);
        InputStream inputStream = attachment.getInputStream();
        if (inputStream == null) {
            String content = attachment.getContent();
            if (CaseServiceUtil.isNullOrEmpty(content)) {
                String uri = attachment.getURI();
                inputStream = new ByteArrayInputStream(uri.getBytes());
            } else {
                inputStream = new ByteArrayInputStream(content.getBytes());
            }
        }
        try {
            CaseIdentifier caseIdentifier;
            boolean added;
            IBPMContext bpmContext = null;
            boolean isUserStakeHolder = false;
            if (context != null) {
                bpmContext = (IBPMContext)context;
                isUserStakeHolder = this.isUserStakeHolder((IWorkflowContext)bpmContext, caseId);
                if (!isUserStakeHolder) {
                    bpmContext = InternalBPMContext.getInternalBPMContext();
                }
            } else {
                bpmContext = InternalBPMContext.getInternalBPMContext();
            }
            if (added = this.caseDocumentStreamService.uploadDocument(bpmContext, caseIdentifier = new CaseIdentifier(caseId, null, null), caseDocumentObject.getObjectName(), attachment.getMimeType(), inputStream, null, null)) {
                List caseDocumentObjectList = this.caseService.listDocuments(bpmContext, CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseId));
                for (CaseDocumentObject caseDocument : caseDocumentObjectList) {
                    if (!caseDocument.getObjectName().equals(caseDocumentObject.getObjectName())) continue;
                    attachment.setId(caseDocument.getId());
                    return attachment;
                }
            }
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
        return null;
    }

    public CommentType addComment(IWorkflowContext context, CommentType comment, String caseId) throws WorkflowException {
        boolean added;
        if (comment == null) {
            return null;
        }
        Comment caseComment = this.convertTaskCommentToCaseComment(comment, caseId);
        try {
            IBPMContext bpmContext = null;
            boolean isUserStakeHolder = false;
            if (context != null) {
                bpmContext = (IBPMContext)context;
                isUserStakeHolder = this.isUserStakeHolder((IWorkflowContext)bpmContext, caseId);
                if (!isUserStakeHolder) {
                    bpmContext = InternalBPMContext.getInternalBPMContext();
                }
            } else {
                bpmContext = InternalBPMContext.getInternalBPMContext();
            }
            CaseIdentifier caseIdentifier = CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseId);
            caseComment.setId(CaseServiceUtil.getGUID());
            added = this.caseService.addComment(bpmContext, caseIdentifier, caseComment);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
        if (added) {
            comment.setId(caseComment.getId());
            comment.setCommentScope("CASE");
            return comment;
        }
        return null;
    }

    public void removeAttachment(IWorkflowContext context, AttachmentType attachment, String caseId) throws WorkflowException {
        CaseIdentifier caseIdentifier = CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseId);
        CaseDocumentObject caseDocumentObject = this.convertTaskAttachmentToCaseDocument(attachment, caseId);
        try {
            IBPMContext bpmContext = null;
            bpmContext = context != null ? (IBPMContext)context : InternalBPMContext.getInternalBPMContext();
            this.caseService.deleteDocument(bpmContext, caseIdentifier, caseDocumentObject, true);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    private boolean isUserStakeHolder(IWorkflowContext context, String caseId) throws BPMException, CaseServiceException {
        IBPMContext bpmContext = null;
        bpmContext = context != null ? (IBPMContext)context : InternalBPMContext.getInternalBPMContext();
        Case caseInstance = this.caseService.getCase(InternalBPMContext.getInternalBPMContext(), CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseId), CASE_INFO_STAKEHOLDER);
        CaseServiceUtil.populateIsUserInRole(bpmContext, caseInstance.getCaseStakeHolders());
        for (CaseStakeHolder caseStakeHolder : caseInstance.getCaseStakeHolders()) {
            if (caseStakeHolder == null || !caseStakeHolder.getIsContextUserInRole()) continue;
            return true;
        }
        return false;
    }

    private Comment convertTaskCommentToCaseComment(CommentType comment, String caseId) {
        if (comment == null) {
            return null;
        }
        Comment caseComment = new Comment();
        caseComment.setId(comment.getId());
        caseComment.setCaseObjectComment(comment.getComment());
        caseComment.setIsSystemComment(this.convertBooleanToString(comment.isIsSystemComment()));
        caseComment.setCaseId(caseId);
        if (comment.getUpdatedBy() != null) {
            caseComment.setUpdatedBy(comment.getUpdatedBy().getId());
        }
        if (comment.getUpdatedDate() != null) {
            caseComment.setUpdatedDate(CaseServiceUtil.getCalendarInstance(null, comment.getUpdatedDate().getTimeInMillis()));
        }
        caseComment.setCaseObjectId(caseId);
        caseComment.setCaseObjectType(ICaseConstants.CommentObjectType.CASE.name());
        caseComment.setObjectType(ICaseConstants.CaseObjectType.COMMENT.name());
        return caseComment;
    }

    private List<AttachmentType> convertCaseDocumentsToTaskAttachments(List<CaseDocumentObject> caseDocumentObjectList, String taskId) {
        ArrayList<AttachmentType> attachmentList = new ArrayList<AttachmentType>();
        if (CaseServiceUtil.isNullOrEmpty(caseDocumentObjectList)) {
            return attachmentList;
        }
        for (CaseDocumentObject caseDocumentObject : caseDocumentObjectList) {
            AttachmentType attachment = this.convertCaseDocumentToTaskAttachment(caseDocumentObject, taskId);
            attachmentList.add(attachment);
        }
        return attachmentList;
    }

    private AttachmentType convertCaseDocumentToTaskAttachment(CaseDocumentObject caseDocumentObject, String taskId) {
        if (caseDocumentObject == null) {
            return null;
        }
        AttachmentType attachment = this.objectFactory.createAttachmentType();
        attachment.setId(caseDocumentObject.getId());
        attachment.setAttachmentScope("CASE");
        attachment.setDoesBelongToParent(false);
        attachment.setTaskId(taskId);
        attachment.setName(caseDocumentObject.getObjectName());
        attachment.setUpdatedBy(caseDocumentObject.getUpdatedBy());
        if (caseDocumentObject.getUpdatedDate() != null) {
            Calendar updatedDate = Calendar.getInstance();
            updatedDate.setTime(caseDocumentObject.getUpdatedDate().getTime());
            attachment.setUpdatedDate(updatedDate);
        }
        return attachment;
    }

    private CaseDocumentObject convertTaskAttachmentToCaseDocument(AttachmentType attachment, String caseId) {
        if (attachment == null) {
            return null;
        }
        CaseDocumentObject caseDocumentObject = new CaseDocumentObject();
        caseDocumentObject.setId(attachment.getId());
        caseDocumentObject.setCaseId(caseId);
        caseDocumentObject.setObjectName(attachment.getName());
        caseDocumentObject.setUpdatedBy(attachment.getUpdatedBy());
        if (attachment.getUpdatedDate() != null) {
            caseDocumentObject.setUpdatedDate(CaseServiceUtil.getCalendarInstance(null, attachment.getUpdatedDate().getTimeInMillis()));
        }
        return caseDocumentObject;
    }

    private List<CommentType> convertCaseCommentsToTaskComments(List<Comment> caseCommentList, String taskId) {
        ArrayList<CommentType> commentList = new ArrayList<CommentType>();
        if (CaseServiceUtil.isNullOrEmpty(caseCommentList)) {
            return commentList;
        }
        for (Comment caseComment : caseCommentList) {
            CommentType comment = this.convertCaseCommentToTaskComment(caseComment, taskId);
            commentList.add(comment);
        }
        return commentList;
    }

    private CommentType convertCaseCommentToTaskComment(Comment caseComment, String taskId) {
        if (caseComment == null) {
            return null;
        }
        CommentType comment = this.objectFactory.createCommentType();
        comment.setId(caseComment.getId());
        comment.setComment(caseComment.getCaseObjectComment());
        comment.setCommentScope("CASE");
        comment.setDoesBelongToParent(false);
        comment.setIsSystemComment(this.convertStringToBoolean(caseComment.getIsSystemComment()));
        comment.setTaskId(taskId);
        if (caseComment.getUpdatedBy() != null) {
            IdentityType identityType = new ObjectFactory().createIdentityType();
            identityType.setId(caseComment.getUpdatedBy());
            comment.setUpdatedBy(identityType);
        }
        if (caseComment.getUpdatedDate() != null) {
            Calendar updatedDate = Calendar.getInstance();
            updatedDate.setTime(caseComment.getUpdatedDate().getTime());
            comment.setUpdatedDate(updatedDate);
        }
        return comment;
    }

    private boolean convertStringToBoolean(String isSystemComment) {
        if (CaseServiceUtil.isNullOrEmpty(isSystemComment)) {
            return false;
        }
        return "T".equalsIgnoreCase(isSystemComment) || "TRUE".equalsIgnoreCase(isSystemComment);
    }

    private String convertBooleanToString(boolean isSystemComment) {
        if (isSystemComment) {
            return "T";
        }
        return "F";
    }

    static {
        CASE_INFO_MILESTONE.add(ICaseConstants.CaseInfo.MILESTONE);
        CASE_INFO_CASEDATA.add(ICaseConstants.CaseInfo.DATA);
        CASE_INFO_STAKEHOLDER.add(ICaseConstants.CaseInfo.STAKEHOLDER);
        CASE_INFO_COMMENT.add(ICaseConstants.CaseInfo.COMMENT);
    }
}

