/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.impl;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.util.MOXyUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.xml.parser.v2.XMLNodeList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CaseXPathVariableResolver
implements XPathVariableResolver {
    private Case caseInstance = null;
    private static MOXyUtil caseMoxyUtil = new MOXyUtil("moxy/caseinstance/eclipselink-oxm.xml", "oracle.bpm.casemgmt.persistence.model", Case.class);

    public CaseXPathVariableResolver(Case caseInstance) {
        this.caseInstance = caseInstance;
    }

    @Override
    public Object resolveVariable(QName variableName) {
        String dataObjectName = variableName.getLocalPart();
        try {
            if (this.caseInstance != null && dataObjectName != null) {
                if ("".equals(dataObjectName = dataObjectName.trim()) || "case".equalsIgnoreCase(dataObjectName)) {
                    String caseXml = caseMoxyUtil.marshal((Object)this.caseInstance);
                    Document caseDocument = XMLUtil.parseDocumentFromXMLString((String)caseXml);
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("Case XML Document " + XMLUtil.toString((Node)caseDocument)));
                    return caseDocument.getChildNodes();
                }
                if (this.caseInstance.getCaseData() != null && this.caseInstance.getCaseData().size() > 0) {
                    for (CaseData caseData : this.caseInstance.getCaseData()) {
                        if (!dataObjectName.equals(caseData.getObjectName())) continue;
                        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("CaseData for " + dataObjectName + ":" + caseData.getData()));
                        Document caseDataDocument = caseData.fetchDataAsDOM();
                        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("CaseDataDocument XML string:" + XMLUtil.toString((Node)caseDataDocument)));
                        return caseDataDocument;
                    }
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)("CaseData with name:" + dataObjectName + ", does not exist in case - " + this.caseInstance));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while trying to resolve: " + variableName, e);
        }
        return new XMLNodeList();
    }
}

