/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.impl;

import java.io.StringWriter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFunctionResolver;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.fabric.WorkflowServiceEngine;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpm.casemgmt.Case.model.CaseTranslation;
import oracle.bpm.casemgmt.Case.model.CaseTranslationPK;
import oracle.bpm.casemgmt.CaseDataFetchException;
import oracle.bpm.casemgmt.CaseDocumentObject;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.IExternalCaseDataCallback;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.common.resources.i18n.CaseManagementResourceBundle;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.impl.CaseXPathVariableResolver;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TNamespacePrefix;
import oracle.bpm.casemgmt.permission.CasePermissionException;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolder;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolderMember;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.casemgmt.resource.Casei18nUtil;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.fabric.common.xml.xpath.SimpleNamespaceContext;
import oracle.tip.pc.services.identity.BPMIdentity;
import oracle.xml.xpath.JXPathFactory;
import org.w3c.dom.Node;

public class CaseServiceUtil {
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-mm-yyyy hh:mm aa");

    public static final void setTranslatedTitle(String locale, Case caseInstance) throws CasePersistenceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"*** setTranslatedTitle");
        CaseTranslationPK caseTranslationPK = new CaseTranslationPK(caseInstance.getCaseId(), locale.toString());
        CaseTranslation caseTranslation = ServicesLocator.getCasePersistence().find(CaseTranslation.class, caseTranslationPK);
        if (caseTranslation == null) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("*** Title translation for locale:" + locale.toString() + " is not found"));
        } else {
            String translatedTitle = caseTranslation.getTitle();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("*** translatedTitle:" + translatedTitle));
            caseInstance.getCaseHeader().setTitle(translatedTitle);
        }
    }

    public static Calendar getCalendarInstance(IBPMContext ctx) {
        return Calendar.getInstance(CaseServiceUtil.getLocale(ctx, null));
    }

    public static Calendar getCalendarInstance(IBPMContext ctx, long millis) {
        Calendar calendar = Calendar.getInstance(CaseServiceUtil.getLocale(ctx, null));
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    public static Locale getLocale(IBPMContext ctx, Locale locale) {
        if (locale == null && ctx != null) {
            locale = ctx.getDisplayNameLocale();
        }
        if (locale == null && ctx != null) {
            locale = ctx.getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static String evaluateXPath(IBPMContext ctx, Case caseInstance, String xpathExpr) throws CaseServiceException {
        try {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("xpathExpr:" + xpathExpr));
            if (CaseServiceUtil.isNullOrEmpty(xpathExpr)) {
                return "";
            }
            ICaseMetadataService caseMetadataService = ServicesLocator.getCaseMetadataService();
            CaseMetadata caseMetadata = caseMetadataService.getCaseMetadata(ctx, caseInstance.getCaseHeader().getCaseDefinitionId());
            if (caseMetadata == null) {
                return "";
            }
            JXPathFactory xpfac = new JXPathFactory();
            XPath xpath = xpfac.newXPath();
            HashMap<String, String> namespaces = new HashMap<String, String>();
            List tNamespacePrefixList = ((TCaseMetadata)caseMetadata.getValue()).getNamespacePrefixes().getNamespacePrefix();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("tNamespacePrefixList:" + tNamespacePrefixList));
            for (TNamespacePrefix namespacePrefix : tNamespacePrefixList) {
                namespaces.put(namespacePrefix.getPrefix(), namespacePrefix.getNamespace());
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)(namespacePrefix.getPrefix() + "=" + namespacePrefix.getNamespace()));
            }
            SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext(namespaces);
            xpath.setNamespaceContext((NamespaceContext)namespaceContext);
            WorkflowServiceEngine wfse = WorkflowServiceEngine.getInstance();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("WorkflowServiceEngine:" + wfse));
            if (wfse != null) {
                XPathFunctionResolver functionResolver = wfse.getXPathFunctionResolver();
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("XPathFunctionResolver:" + functionResolver));
                if (functionResolver != null) {
                    xpath.setXPathFunctionResolver(functionResolver);
                }
            }
            xpath.setXPathVariableResolver(new CaseXPathVariableResolver(caseInstance));
            String result = (String)xpath.evaluate(xpathExpr, XMLUtil.getDocumentBuilder().newDocument(), XPathConstants.STRING);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("XPath evaluation result:" + result));
            return result;
        }
        catch (Exception e) {
            throw new CaseServiceException(73402, new Object[]{xpathExpr}, (Throwable)e);
        }
    }

    public static void populateIsUserInRole(IBPMContext bpmContext, List<CaseStakeHolder> caseStakeholders) {
        if (caseStakeholders == null || caseStakeholders.size() == 0) {
            return;
        }
        String userName = null;
        if (bpmContext != null) {
            userName = bpmContext.getUser();
        }
        ICaseIdentityService identityService = ServicesLocator.getCaseIdentityService();
        List<BPMIdentity> userAppRoleList = identityService.getApplicationRoles(bpmContext);
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("User's Approles:" + userAppRoleList));
        List<BPMIdentity> userGroupList = identityService.getGroups(bpmContext);
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("User's Groups:" + userGroupList));
        CaseServiceUtil.populateIsUserInRole(userName, userAppRoleList, userGroupList, caseStakeholders);
    }

    public static void populateIsUserInRole(String userName, List<BPMIdentity> userAppRoleList, List<BPMIdentity> userGroupList, List<CaseStakeHolder> caseStakeholders) {
        if (caseStakeholders == null || caseStakeholders.size() == 0) {
            return;
        }
        ArrayList<String> appRoles = new ArrayList<String>();
        ArrayList<String> groups = new ArrayList<String>();
        if (userAppRoleList != null && userAppRoleList.size() > 0) {
            for (BPMIdentity appRole : userAppRoleList) {
                appRoles.add(appRole.getName());
            }
        }
        if (userGroupList != null && userGroupList.size() > 0) {
            for (BPMIdentity group : userGroupList) {
                groups.add(group.getName());
            }
        }
        if (caseStakeholders != null && caseStakeholders.size() > 0) {
            for (CaseStakeHolder caseStakeHolder : caseStakeholders) {
                List caseStakeHolderMembers;
                if (caseStakeHolder == null || (caseStakeHolderMembers = caseStakeHolder.getCaseStakeHolderMembers()) == null || caseStakeHolderMembers.isEmpty()) continue;
                for (CaseStakeHolderMember caseStakeHolderMember : caseStakeHolderMembers) {
                    if (ICaseConstants.IdentityType.USER.name().equals(caseStakeHolderMember.getStakeHolderType())) {
                        if (!caseStakeHolderMember.getStakeHolder().equals(userName)) continue;
                        caseStakeHolderMember.setIsContextUserInRole(true);
                        caseStakeHolder.setIsContextUserInRole(true);
                        continue;
                    }
                    if (ICaseConstants.IdentityType.APPLICATION_ROLE.name().equals(caseStakeHolderMember.getStakeHolderType())) {
                        if (!appRoles.contains(caseStakeHolderMember.getStakeHolder())) continue;
                        caseStakeHolderMember.setIsContextUserInRole(true);
                        caseStakeHolder.setIsContextUserInRole(true);
                        continue;
                    }
                    if (!ICaseConstants.IdentityType.GROUP.name().equals(caseStakeHolderMember.getStakeHolderType()) || !groups.contains(caseStakeHolderMember.getStakeHolder())) continue;
                    caseStakeHolderMember.setIsContextUserInRole(true);
                    caseStakeHolder.setIsContextUserInRole(true);
                }
            }
        }
    }

    public static final void populateExternalCaseData(IBPMContext context, Case caseClone) throws CaseServiceException {
        CaseServiceUtil.populateExternalCaseData(context, caseClone.getCaseData(), caseClone);
    }

    public static final void populateExternalCaseData(IBPMContext context, List<CaseData> caseDataList, Case caseClone) throws CaseServiceException {
        if (caseDataList == null || caseDataList.isEmpty()) {
            return;
        }
        for (CaseData caseData : caseDataList) {
            if (caseData == null || !CaseServiceUtil.isNullOrEmpty(caseData.getData())) continue;
            CaseServiceUtil.populateExternalCaseData(context, caseData, caseClone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void populateExternalCaseData(IBPMContext context, CaseData caseData, Case caseClone) throws CaseServiceException {
        if (caseData == null) {
            return;
        }
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"*** populateExternalCaseData invoked");
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("*** Name: " + caseData.getObjectName()));
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("*** CaseData:" + caseData.getData()));
        ClassLoader originalClassloader = null;
        try {
            if (CaseServiceUtil.isNullOrEmpty(caseData.getData())) {
                caseData.setExternal(true);
                CaseData caseDataFromCaseClone = null;
                for (CaseData caseDataInCaseClone : caseClone.getCaseData()) {
                    if (caseDataInCaseClone == null || !caseDataInCaseClone.getObjectName().equals(caseData.getObjectName())) continue;
                    caseDataFromCaseClone = caseDataInCaseClone;
                }
                if (caseDataFromCaseClone == null) {
                    return;
                }
                caseDataFromCaseClone.setExternal(true);
                originalClassloader = ServicesLocator.getCaseSE().setCompositeClassLoaderAsThreadContextLoader("COMPOSITE_CLASSLOADER", caseClone.getCaseHeader().getCaseDefinitionId());
                Iterator<IExternalCaseDataCallback> externalCallbacks = ServiceLoader.load(IExternalCaseDataCallback.class).iterator();
                boolean fetched = CaseServiceUtil.populateExternalCaseData(context, caseData, caseClone, externalCallbacks, caseDataFromCaseClone);
                if (!fetched) {
                    if (originalClassloader != null) {
                        Thread.currentThread().setContextClassLoader(originalClassloader);
                        originalClassloader = null;
                    }
                    externalCallbacks = ServiceLoader.load(IExternalCaseDataCallback.class).iterator();
                    fetched = CaseServiceUtil.populateExternalCaseData(context, caseData, caseClone, externalCallbacks, caseDataFromCaseClone);
                }
                if (!fetched) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("*** fetched:" + fetched));
                    caseDataFromCaseClone.setData(null);
                    caseDataFromCaseClone.setState(ICaseConstants.CaseDataState.NOT_AVAILABLE);
                }
            }
        }
        finally {
            if (originalClassloader != null) {
                Thread.currentThread().setContextClassLoader(originalClassloader);
            }
        }
    }

    public static String getGUID() {
        return UUID.randomUUID().toString();
    }

    public static String getTranslatedValue(Locale locale, String key) {
        String value = null;
        try {
            value = Casei18nUtil.getValue(null, null, locale, key, CaseManagementResourceBundle.class.getName());
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)CaseServiceUtil.class.getClass().getName(), (String)"getTranslatedValue", (Throwable)e);
        }
        return value;
    }

    public static boolean isCaseInstall() {
        try {
            return WorkflowUtil.isBPMInstall();
        }
        catch (WorkflowException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)"CaseServiceUtil", (String)"isCaseInstall", (Throwable)e);
            return false;
        }
    }

    public static boolean isNotNullAndEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static boolean isNullOrEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public static String lookupMetadataResourceBundle(IBPMContext ctx, String caseDefinitionId, String objectName) throws CaseServiceException {
        if (CaseServiceUtil.isNullOrEmpty(objectName)) {
            return objectName;
        }
        String value = Casei18nUtil.getValue(ctx, caseDefinitionId, Locale.getDefault(), objectName, null);
        if (value == null) {
            return objectName;
        }
        return value;
    }

    public static String getPermissionTag(IBPMContext context, CaseIdentifier caseIdentifier, String docName) throws CasePermissionException, CaseServiceException, BPMException {
        String METHOD = "getPermissionTag";
        String permissionTag = null;
        CaseDocumentObject caseDocument = null;
        List docList = null;
        docList = ServicesLocator.getCaseService().listDocuments(InternalBPMContext.getInternalBPMContext(), caseIdentifier);
        for (CaseDocumentObject caseDoc : docList) {
            if (!docName.trim().equals(caseDoc.getObjectName().trim())) continue;
            caseDocument = caseDoc;
            break;
        }
        if (caseDocument == null) {
            throw new CasePermissionException(73416, new Object[0]);
        }
        permissionTag = caseDocument.getPermissionTag();
        return permissionTag;
    }

    public static String getPermissionTag(IBPMContext context, CaseIdentifier caseIdentifier, CaseObject caseObject) throws CasePermissionException, CaseServiceException {
        String permissionTag = null;
        try {
            if (caseObject instanceof CaseDocumentObject) {
                permissionTag = CaseServiceUtil.getPermissionTag(context, caseIdentifier, caseObject.getObjectName());
            } else {
                List caseObjects = ServicesLocator.getCasePersistence().findWithNamedQuery("CaseObject.findById", "id", caseObject.getId());
                if (caseObjects != null && caseObjects.size() > 0) {
                    permissionTag = ((CaseObject)caseObjects.get(0)).getPermissionTag();
                }
            }
        }
        catch (CasePersistenceException e) {
            throw new CasePermissionException(73416, new Object[0], (Throwable)((Object)e));
        }
        catch (BPMException e) {
            throw new CasePermissionException(73416, new Object[0], e);
        }
        return permissionTag;
    }

    public static String formatDate(Timestamp timestamp) {
        if (timestamp != null) {
            return simpleDateFormat.format(timestamp);
        }
        return "";
    }

    public static String formatDate(Calendar calendar) {
        if (calendar != null) {
            return simpleDateFormat.format(calendar.getTime());
        }
        return "";
    }

    static IBPMContext validateContext(IBPMContext context) throws CasePermissionException {
        String METHOD = "validateContext";
        ICaseIdentityService caseIdentityService = ServicesLocator.getCaseIdentityService();
        try {
            if (context != null) {
                return caseIdentityService.validateContext(context);
            }
            IBPMContext newContext = caseIdentityService.getBPMContextForAuthenticatedUser();
            if (newContext == null) {
                throw new Exception("Null subject");
            }
            return newContext;
        }
        catch (Exception e) {
            throw new CasePermissionException(74806, null, e);
        }
    }

    static void validateAction(IBPMContext context, CaseIdentifier caseIdentifier, ICaseConstants.CaseObjectPermissionType action, ICaseConstants.CaseObjectType caseObjType, String permissionTag) throws CasePermissionException, CaseServiceException {
        String METHOD = "validateAction";
        CaseServiceUtil.debugLog("validateAction", "User : " + context.getUser() + " Action : " + action + " caseObjType : " + caseObjType + " permissionTag : " + permissionTag);
        ICaseIdentityService caseIdentityService = ServicesLocator.getCaseIdentityService();
        if (context instanceof InternalBPMContext || caseIdentityService.isAdminContext(context)) {
            return;
        }
        ICaseService casePermSvc = ServicesLocator.getCaseService();
        Set actions = casePermSvc.getActionsUserCanPerform(context, caseIdentifier, caseObjType);
        boolean hasStakeHolderPerm = actions.contains(action);
        if (!hasStakeHolderPerm) {
            throw new CasePermissionException(74812, new Object[]{context.getUser(), action.name(), caseObjType.name(), caseIdentifier.toString()});
        }
        if (permissionTag == null || permissionTag.trim().equals("")) {
            return;
        }
        boolean hasTagPerm = casePermSvc.checkCaseTagPermission(context, caseIdentifier, permissionTag, action, caseObjType);
        if (!hasTagPerm) {
            throw new CasePermissionException(74813, new Object[]{context.getUser(), action.name(), permissionTag, caseObjType.name(), caseIdentifier.toString()});
        }
    }

    private static boolean populateExternalCaseData(IBPMContext context, CaseData caseData, Case caseClone, Iterator<IExternalCaseDataCallback> externalCallbacks, CaseData caseDataFromCaseClone) {
        boolean fetched = false;
        while (externalCallbacks.hasNext()) {
            IExternalCaseDataCallback externalCallback = externalCallbacks.next();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("*** externalCallback:" + externalCallback.getClass().getName()));
            IExternalCaseDataCallback.FetchStatus fetchStatus = null;
            try {
                fetchStatus = externalCallback.setCaseData(context, caseData, caseClone);
            }
            catch (CaseDataFetchException caseDataFetchException) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)("*** caseDataFetchException:" + (Object)((Object)caseDataFetchException)));
                caseDataFromCaseClone.setData(null);
                caseDataFromCaseClone.setState(ICaseConstants.CaseDataState.ERRORED);
                fetched = true;
                break;
            }
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("*** fetchStatus:" + fetchStatus));
            if (fetchStatus != IExternalCaseDataCallback.FetchStatus.FETCHED) continue;
            fetched = true;
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("*** CaseData:" + caseData.getData()));
            caseDataFromCaseClone.setData(caseData.getData());
            caseDataFromCaseClone.setState(ICaseConstants.CaseDataState.FETCHED);
            break;
        }
        return fetched;
    }

    private static String toString(Node node) {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(node);
            trans.transform(source, result);
            String xmlString = sw.toString();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)xmlString);
            return xmlString;
        }
        catch (TransformerException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)"CaseServiceUtil", (String)"toString(Node)", (String)"Node serialization error", (Throwable)e);
            return null;
        }
    }

    private static void debugLog(String method, String msg) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)"CaseServiceUtil", (String)method, (String)msg);
    }
}

