/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseRuleService;
import oracle.bpm.casemgmt.ICaseRuleStreamService;
import oracle.bpm.casemgmt.annotations.ValidateContext;
import oracle.bpm.casemgmt.caserule.model.CaseRule;
import oracle.bpm.casemgmt.caserule.model.CaseRuleEdit;
import oracle.bpm.casemgmt.caserule.model.CaseRuleEditPK;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.util.CaseUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseRuleServiceImpl
implements ICaseRuleService,
ICaseRuleStreamService {
    private static final String ACTIVE = "T";
    private static final String INACTIVE = "F";
    private static final String CLASS_NAME = "oracle.bpm.casemgmt.impl.CaseRuleServiceImpl";

    @ValidateContext
    public InputStream getDictionaryFromSandbox(IBPMContext ctx, String namespace) throws Exception {
        byte[] dictionary = null;
        try {
            CaseRuleEdit caseRule = this.getUserDictionaryInternal(ctx, namespace);
            dictionary = caseRule.getDictionary();
        }
        catch (Exception e) {
            throw new CaseServiceException(73603, new Object[]{ctx.getUser(), namespace}, (Throwable)e);
        }
        return new ByteArrayInputStream(dictionary);
    }

    @ValidateContext
    public InputStream getActiveDictionary(IBPMContext ctx, String namespace) throws CaseServiceException {
        byte[] dictionary = null;
        try {
            CaseRule caseRule = this.getActiveDictionaryInternal(ctx, namespace);
            dictionary = caseRule.getDictionary();
        }
        catch (Exception e) {
            throw new CaseServiceException(73604, new Object[]{namespace}, (Throwable)e);
        }
        return new ByteArrayInputStream(dictionary);
    }

    @ValidateContext
    public void saveDictionaryToSandbox(IBPMContext ctx, String namespace, InputStream dictionary, String comments) throws CaseServiceException {
        try {
            CaseRuleEdit userDict = this.getUserDictionaryInternal(ctx, namespace);
            byte[] userDictBytes = CaseUtil.convertInputStreamToByteArray(dictionary);
            if (userDict != null) {
                userDict.setDictionary(userDictBytes);
                userDict.setComments(comments);
                ServicesLocator.getInternalCaseService().updateCaseRuleDictionary(userDict);
            } else {
                CaseRule rule = this.getActiveDictionaryInternal(ctx, namespace);
                userDict = new CaseRuleEdit(comments, ctx.getUser(), rule, "tenantId");
                userDict.setDictionary(userDictBytes);
                userDict.setCaseRule(rule);
                ServicesLocator.getInternalCaseService().persistCaseRuleDictionary(userDict);
            }
        }
        catch (Exception e) {
            throw new CaseServiceException(73601, new Object[]{namespace}, (Throwable)e);
        }
        finally {
            try {
                dictionary.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @ValidateContext
    public void commitDictionary(IBPMContext ctx, String namespace, InputStream dictionary, String comments, boolean forceUpdate) throws CaseServiceException {
        try {
            if (dictionary == null) {
                return;
            }
            Calendar todaysDateAndTime = Calendar.getInstance();
            long version = 1L;
            CaseRuleEdit userDict = this.getUserDictionaryInternal(ctx, namespace);
            CaseRule activeDict = this.getActiveDictionaryInternal(ctx, namespace);
            if (userDict != null && activeDict != null && userDict.getVersion().intValue() < activeDict.getVersion().intValue() && !forceUpdate) {
                throw new Exception();
            }
            if (activeDict != null) {
                version = activeDict.getVersion() + 1L;
                activeDict.setIsActive(INACTIVE);
                activeDict.setLastUpdatedBy(ctx.getUser());
                activeDict.setLastUdpatedIdctx(ctx.getIdentityContext());
                activeDict.setLastUpdatedDate(todaysDateAndTime);
                ServicesLocator.getInternalCaseService().updateCaseRuleDictionary(activeDict);
            }
            CaseRule caseRule = new CaseRule(comments, ctx.getUser(), ctx.getIdentityContext(), todaysDateAndTime, ACTIVE, ctx.getIdentityContext(), ctx.getUser(), todaysDateAndTime, namespace, "tenantId", new Long(version));
            caseRule.setDictionary(CaseUtil.convertInputStreamToByteArray(dictionary));
            ServicesLocator.getInternalCaseService().persistCaseRuleDictionary(caseRule);
            ServicesLocator.getECARuleProcessor().invalidateClassloader(ctx, namespace, String.valueOf(version));
            ServicesLocator.getECARuleProcessor().invalidateRuleSessionPool(ctx, namespace);
        }
        catch (Exception e) {
            throw new CaseServiceException(73602, new Object[]{namespace}, (Throwable)e);
        }
        finally {
            try {
                dictionary.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @ValidateContext
    public void deleteUserDictionary(IBPMContext ctx, String namespace) throws CaseServiceException {
        this.deleteUserDictionaryInternal(ctx, namespace);
    }

    private CaseRuleEdit getUserDictionaryInternal(IBPMContext ctx, String namespace) throws CasePersistenceException {
        return ServicesLocator.getInternalCaseService().getUserDictionaryInternal(ctx, namespace);
    }

    private CaseRule getActiveDictionaryInternal(IBPMContext ctx, String namespace) throws CasePersistenceException {
        return ServicesLocator.getInternalCaseService().getActiveDictionaryInternal(ctx, namespace);
    }

    private void deleteUserDictionaryInternal(IBPMContext ctx, String namespace) throws CaseServiceException {
        try {
            CaseRuleEdit userDict = this.getUserDictionaryInternal(ctx, namespace);
            if (userDict != null) {
                ServicesLocator.getCaseRulePersistance().delete(CaseRuleEdit.class, new CaseRuleEditPK(userDict.getLockedBy(), userDict.getNamespace(), userDict.getVersion()));
            }
        }
        catch (Exception e) {
            throw new CaseServiceException(73605, new Object[]{namespace}, (Throwable)e);
        }
    }

    private void logException(Throwable t, String methodName) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.FATAL, (String)CLASS_NAME, (String)methodName, (Throwable)t);
    }

    private void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)methodName, (String)message);
    }
}

