/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.impl;

import java.util.List;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseDocumentObject;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICasePermissionService;
import oracle.bpm.casemgmt.annotations.ValidateAction;
import oracle.bpm.casemgmt.annotations.ValidateCaseIdentifier;
import oracle.bpm.casemgmt.annotations.ValidateContext;
import oracle.bpm.casemgmt.annotations.ValidateUserCaseAccess;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityAttrib;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityAttribPK;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseDocumentServiceImpl;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.permission.CasePermissionException;
import oracle.bpm.casemgmt.permission.ICasePermissionServiceInternal;
import oracle.bpm.casemgmt.permission.PermissionUtil;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.ICasePersistence;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;

public class CasePermissionServiceImpl
implements ICasePermissionService {
    private static final String CLASS = "CasePermissionServiceImpl";

    @ValidateContext
    @ValidateUserCaseAccess
    public Set<String> getPermissionTags(IBPMContext ctx, CaseIdentifier caseIdentifier) throws CaseServiceException {
        String METHOD = "getPermissionTags";
        try {
            ICasePermissionServiceInternal permSvcIntl = ServicesLocator.getCasePermissionServiceInternal();
            return permSvcIntl.getPermissionTags(ctx, caseIdentifier);
        }
        catch (CasePermissionException cpe) {
            throw CasePermissionServiceImpl.logAndLocalizeException(ctx, "getPermissionTags", new CaseServiceException(74807, new Object[]{caseIdentifier}, (Throwable)((Object)cpe)));
        }
    }

    @ValidateContext
    @ValidateUserCaseAccess
    public Set<String> getPermissionTagsUserCanUse(IBPMContext ctx, CaseIdentifier caseIdentifier, ICaseConstants.CaseObjectPermissionType action, ICaseConstants.CaseObjectType caseObjectType) throws CaseServiceException {
        String METHOD = "getPermissionTagsUserCanUse";
        try {
            ICasePermissionServiceInternal permSvcIntl = ServicesLocator.getCasePermissionServiceInternal();
            return permSvcIntl.getPermissionTagsUserCanUse(ctx, caseIdentifier, action, caseObjectType);
        }
        catch (CasePermissionException cpe) {
            throw CasePermissionServiceImpl.logAndLocalizeException(ctx, "getPermissionTagsUserCanUse", new CaseServiceException(74808, new Object[]{action, caseObjectType, caseIdentifier}, (Throwable)((Object)cpe)));
        }
    }

    @ValidateContext
    @ValidateUserCaseAccess
    public Set<ICaseConstants.CaseObjectPermissionType> getActionsUserCanPerform(IBPMContext ctx, CaseIdentifier caseIdentifier, ICaseConstants.CaseObjectType caseObjectType) throws CaseServiceException {
        String METHOD = "getActionsUserCanPerform";
        try {
            ICasePermissionServiceInternal permSvcIntl = ServicesLocator.getCasePermissionServiceInternal();
            return permSvcIntl.getActionsUserCanPerform(ctx, caseIdentifier, null, caseObjectType);
        }
        catch (CasePermissionException cpe) {
            throw CasePermissionServiceImpl.logAndLocalizeException(ctx, "getActionsUserCanPerform", new CaseServiceException(74809, new Object[]{caseObjectType, caseIdentifier}, (Throwable)((Object)cpe)));
        }
    }

    @ValidateContext
    @ValidateUserCaseAccess
    public Set<ICaseConstants.CaseObjectPermissionType> getActionsUserCanPerformOnCaseObject(IBPMContext ctx, CaseIdentifier caseIdentifier, CaseObject caseObj) throws CaseServiceException {
        String METHOD = "getActionsUserCanPerformOnCaseObject";
        try {
            ICasePermissionServiceInternal permSvcIntl = ServicesLocator.getCasePermissionServiceInternal();
            return permSvcIntl.getActionsUserCanPerformOnCaseObject(ctx, caseIdentifier, null, caseObj);
        }
        catch (CasePermissionException cpe) {
            ICaseConstants.CaseObjectType caseObjectType = PermissionUtil.getObjectType(caseObj);
            throw CasePermissionServiceImpl.logAndLocalizeException(ctx, "getActionsUserCanPerformOnCaseObject", new CaseServiceException(74809, new Object[]{caseObjectType, caseIdentifier}, (Throwable)((Object)cpe)));
        }
    }

    @ValidateContext
    @ValidateUserCaseAccess
    public boolean checkCaseTagPermission(IBPMContext ctx, CaseIdentifier caseIdentifier, String permissionTag, ICaseConstants.CaseObjectPermissionType action, ICaseConstants.CaseObjectType caseObjectType) throws CaseServiceException {
        String METHOD = "checkCaseTagPermission";
        try {
            ICasePermissionServiceInternal permSvcIntl = ServicesLocator.getCasePermissionServiceInternal();
            return permSvcIntl.checkCaseTagPermission(ctx, caseIdentifier, permissionTag, action, caseObjectType);
        }
        catch (CasePermissionException cpe) {
            throw CasePermissionServiceImpl.logAndLocalizeException(ctx, "checkCaseTagPermission", new CaseServiceException(74810, new Object[]{action, permissionTag, caseObjectType, caseIdentifier}, (Throwable)((Object)cpe)));
        }
    }

    @ValidateAction(caseObjectType="NA", action="UPDATE")
    @ValidateCaseIdentifier
    @ValidateContext
    @ValidateUserCaseAccess
    public boolean setPermissionTag(IBPMContext context, CaseIdentifier caseIdentifier, CaseObject caseObject, String permissionTag) throws CaseServiceException {
        String METHOD = "setPermissionTag";
        try {
            ICasePermissionServiceInternal permSvcIntl;
            boolean canUpdateCaseObjWithTag;
            this.validatePermissionTag(context, caseIdentifier, permissionTag);
            ICaseConstants.CaseObjectType caseObjType = PermissionUtil.getObjectType(caseObject);
            if (caseObjType.equals((Object)ICaseConstants.CaseObjectType.EVENT)) {
                caseObjType = ICaseConstants.CaseObjectType.HEADER;
            }
            if (!(canUpdateCaseObjWithTag = (permSvcIntl = ServicesLocator.getCasePermissionServiceInternal()).checkCaseTagPermission(context, caseIdentifier, permissionTag, ICaseConstants.CaseObjectPermissionType.UPDATE, caseObjType))) {
                this.debugLog("setPermissionTag", "User " + context + " does not have permission to set permission tag " + permissionTag + " on " + caseObjType);
                throw CasePermissionServiceImpl.logAndLocalizeException(context, "setPermissionTag", new CaseServiceException(74811, new Object[]{context.getUser(), permissionTag, caseObjType, caseIdentifier}));
            }
            if (caseObject.getObjectType().toUpperCase().contains("DOCUMENT")) {
                CaseDocumentServiceImpl.setPermissionTag(context, caseIdentifier, (CaseDocumentObject)caseObject, permissionTag);
            } else {
                List caseObjects = ServicesLocator.getCasePersistence().findWithNamedQuery("CaseObject.findById", "id", caseObject.getId());
                if (caseObjects != null && caseObjects.size() > 0) {
                    CaseObject updatedCaseObject = (CaseObject)caseObjects.get(0);
                    updatedCaseObject.setPermissionTag(permissionTag);
                    ServicesLocator.getCasePersistence().update(updatedCaseObject);
                }
            }
        }
        catch (CaseServiceException cse) {
            throw cse;
        }
        catch (Exception e) {
            throw CasePermissionServiceImpl.logAndLocalizeException(context, "setPermissionTag", new CaseServiceException(73425, new Object[]{permissionTag, caseIdentifier}, (Throwable)e));
        }
        return true;
    }

    @ValidateAction(caseObjectType="HEADER", action="UPDATE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean setCaseActivityPermissionTag(IBPMContext context, CaseIdentifier caseIdentifier, String caseActivityDefinitionId, String permissionTag) throws CaseServiceException {
        String METHOD = "setCaseActivityPermissionTag";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        String caseId = caseIdentifier.getCaseId();
        CaseActivityAttribPK attribPK = new CaseActivityAttribPK(caseActivityDefinitionId, caseId);
        try {
            ICasePermissionServiceInternal permSvcIntl = ServicesLocator.getCasePermissionServiceInternal();
            boolean canUsePermissionTag = permSvcIntl.checkCaseTagPermission(context, caseIdentifier, permissionTag, ICaseConstants.CaseObjectPermissionType.UPDATE, ICaseConstants.CaseObjectType.HEADER);
            if (!canUsePermissionTag) {
                throw CasePermissionServiceImpl.logAndLocalizeException(context, "setCaseActivityPermissionTag", new CaseServiceException(74811, new Object[]{context.getUser(), permissionTag, ICaseConstants.CaseObjectType.HEADER, caseIdentifier}));
            }
            this.validatePermissionTag(context, caseIdentifier, permissionTag);
            CaseActivityAttrib oldAttrib = persistence.find(CaseActivityAttrib.class, attribPK);
            if (oldAttrib != null) {
                if (oldAttrib.getPermissionTag() == null || oldAttrib.getPermissionTag() != permissionTag) {
                    boolean canUpdatePermissionTag = permSvcIntl.checkCaseTagPermission(context, caseIdentifier, oldAttrib.getPermissionTag(), ICaseConstants.CaseObjectPermissionType.UPDATE, ICaseConstants.CaseObjectType.HEADER);
                    if (!canUpdatePermissionTag) {
                        throw CasePermissionServiceImpl.logAndLocalizeException(context, "setCaseActivityPermissionTag", new CaseServiceException(74811, new Object[]{context.getUser(), oldAttrib.getPermissionTag(), ICaseConstants.CaseObjectType.HEADER, caseIdentifier}));
                    }
                    oldAttrib.setPermissionTag(permissionTag);
                    persistence.update(oldAttrib);
                }
            } else {
                CaseActivityAttrib newAttrib = new CaseActivityAttrib();
                newAttrib.setCaseId(caseId);
                newAttrib.setActivityDefinitionId(caseActivityDefinitionId);
                newAttrib.setPermissionTag(permissionTag);
                persistence.persist(newAttrib);
            }
        }
        catch (CasePersistenceException e) {
            throw CasePermissionServiceImpl.logAndLocalizeException(context, "setCaseActivityPermissionTag", new CaseServiceException(74021, new Object[]{caseActivityDefinitionId, permissionTag, caseId}, (Throwable)((Object)e)));
        }
        catch (CasePermissionException e) {
            throw CasePermissionServiceImpl.logAndLocalizeException(context, "setCaseActivityPermissionTag", new CaseServiceException(74021, new Object[]{caseActivityDefinitionId, permissionTag, caseId}, (Throwable)((Object)e)));
        }
        return true;
    }

    private static CaseServiceException logAndLocalizeException(IBPMContext ctx, String method, CaseServiceException cse) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_PERMISSION, (Severity)Severity.ERRORS, (String)CLASS, (String)method, (Throwable)cse);
        new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(ctx, null));
        return cse;
    }

    private void validatePermissionTag(IBPMContext context, CaseIdentifier caseIdentifier, String permissionTag) throws CaseServiceException {
        String METHOD = "validatePermissionTag";
        IBPMContext internalBPMCtx = null;
        if (permissionTag == null || "".equals(permissionTag.trim())) {
            return;
        }
        try {
            internalBPMCtx = InternalBPMContext.getInternalBPMContext();
        }
        catch (BPMException bpme) {
            this.debugLog("validatePermissionTag", "Failed while getting internalBPMContext. Detailed exception :" + bpme.getMessage());
            internalBPMCtx = context;
        }
        try {
            ICasePermissionServiceInternal permSvcIntl = ServicesLocator.getCasePermissionServiceInternal();
            Set<String> usableTags = permSvcIntl.getPermissionTags(internalBPMCtx, caseIdentifier);
            for (String usableTag : usableTags) {
                if (usableTag == null || !usableTag.equalsIgnoreCase(permissionTag.trim())) continue;
                return;
            }
        }
        catch (CasePermissionException cpe1) {
            throw CasePermissionServiceImpl.logAndLocalizeException(context, "validatePermissionTag", new CaseServiceException(73426, new Object[]{permissionTag, caseIdentifier.toString()}, (Throwable)((Object)cpe1)));
        }
        throw CasePermissionServiceImpl.logAndLocalizeException(context, "validatePermissionTag", new CaseServiceException(73426, new Object[]{permissionTag, caseIdentifier.toString()}));
    }

    private void debugLog(String method, String msg) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_PERMISSION, (Severity)Severity.DEBUG, (String)CLASS, (String)method, (String)msg);
    }
}

