/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.annotations.ValidateContext;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityDefinition;
import oracle.bpm.casemgmt.casemetadata.model.CaseDefinition;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseActivityMetadataCache;
import oracle.bpm.casemgmt.impl.CaseMetadataCache;
import oracle.bpm.casemgmt.impl.CaseMetadataException;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TMilestone;
import oracle.bpm.casemgmt.metadata.Case.model.TMilestones;
import oracle.bpm.casemgmt.metadata.Case.model.TOutcome;
import oracle.bpm.casemgmt.metadata.Case.model.TOutcomes;
import oracle.bpm.casemgmt.metadata.Case.model.TPermissionTag;
import oracle.bpm.casemgmt.metadata.Case.model.TPermissionTags;
import oracle.bpm.casemgmt.metadata.Case.model.TStakeHolder;
import oracle.bpm.casemgmt.metadata.Case.model.TStakeHolders;
import oracle.bpm.casemgmt.metadata.Case.model.TUserDefinedEvent;
import oracle.bpm.casemgmt.metadata.activity.model.CaseActivity;
import oracle.bpm.casemgmt.metadata.casedisplay.model.TCaseDisplayInfo;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.ICasePersistence;
import oracle.bpm.casemgmt.util.CaseDisplayUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseMetadataServiceImpl
implements ICaseMetadataService {
    @ValidateContext
    public CaseMetadata getCaseMetadata(IBPMContext ctx, String caseDefinitionId) throws CaseServiceException {
        this.validateContext(ctx);
        Locale locale = Locale.getDefault();
        CaseMetadata caseMetadata = null;
        CaseMetadataCache metadataCache = CaseMetadataCache.getInstance();
        try {
            caseMetadata = (CaseMetadata)metadataCache.getMetadata(caseDefinitionId);
        }
        catch (CaseMetadataException e) {
            CaseServiceException se = new CaseServiceException(72800, new Object[]{caseDefinitionId}, (Throwable)((Object)e));
            throw se;
        }
        return caseMetadata;
    }

    @ValidateContext
    public Map<String, String> getCaseMetadataDisplayValues(IBPMContext ctx, String caseDefinitionId, ICaseMetadataService.TRANSLATABLES_ENUM translatableEnum, Locale locale) throws CaseServiceException {
        this.debugLog("getCaseMetadataDisplayValues", "Input:\n CaseDefnId:" + caseDefinitionId + "\n Translatables Enum:" + translatableEnum.toString() + "\n Locale:" + locale);
        this.validateContext(ctx);
        CaseMetadata caseMetadata = this.getCaseMetadata(ctx, caseDefinitionId);
        HashMap<String, String> translationMappings = new HashMap<String, String>();
        if (caseMetadata == null) {
            return Collections.EMPTY_MAP;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        CaseMetadataCache cache = CaseMetadataCache.getInstance();
        if (ICaseMetadataService.TRANSLATABLES_ENUM.ALL.equals((Object)translatableEnum)) {
            if (((TCaseMetadata)caseMetadata.getValue()).getName() != null) {
                String displayName = cache.getDisplayValue(caseDefinitionId, ((TCaseMetadata)caseMetadata.getValue()).getName(), locale);
                translationMappings.put(((TCaseMetadata)caseMetadata.getValue()).getName(), displayName);
            }
            translationMappings.putAll(this.getCaseMilestonesDisplayValue(caseMetadata, locale));
            translationMappings.putAll(this.getCaseOutcomesDisplayValue(caseMetadata, locale));
            translationMappings.putAll(this.getCaseStakeholdersDisplayValue(caseMetadata, locale));
            translationMappings.putAll(this.getCasePermissionsDisplayValue(caseMetadata, locale));
            translationMappings.putAll(this.getCaseUserDefinedEventsDisplayValue(caseMetadata, locale));
        } else if (ICaseMetadataService.TRANSLATABLES_ENUM.MILESTONE.equals((Object)translatableEnum)) {
            translationMappings = this.getCaseMilestonesDisplayValue(caseMetadata, locale);
        } else if (ICaseMetadataService.TRANSLATABLES_ENUM.OUTCOME.equals((Object)translatableEnum)) {
            translationMappings = this.getCaseOutcomesDisplayValue(caseMetadata, locale);
        } else if (ICaseMetadataService.TRANSLATABLES_ENUM.STAKEHOLDER.equals((Object)translatableEnum)) {
            translationMappings = this.getCaseStakeholdersDisplayValue(caseMetadata, locale);
        } else if (ICaseMetadataService.TRANSLATABLES_ENUM.PERMISSION.equals((Object)translatableEnum)) {
            translationMappings = this.getCasePermissionsDisplayValue(caseMetadata, locale);
        } else if (ICaseMetadataService.TRANSLATABLES_ENUM.USER_DEFINED_EVENTS.equals((Object)translatableEnum)) {
            translationMappings = this.getCaseUserDefinedEventsDisplayValue(caseMetadata, locale);
        }
        this.debugLog("getCaseMetadataDisplayValues", "Translation mappings returned for translationEnum: " + translatableEnum.toString() + " is " + translationMappings);
        return translationMappings;
    }

    @ValidateContext
    public List<CaseDefinition> listCaseDefinition(IBPMContext ctx, ICaseMetadataService.SEARCH_TYPE_ENUM searchByEnum, List values) throws CaseServiceException {
        this.validateContext(ctx);
        Locale locale = Locale.getDefault();
        List<Object> caseDefinitionList = new ArrayList<CaseDefinition>();
        if (searchByEnum == null || values == null || values.size() == 0) {
            this.debugLog("listCaseDefinition", "One of the input parameters is null");
            return caseDefinitionList;
        }
        this.debugLog("listCaseDefinition", "Searching case definitions with search criteria:" + searchByEnum.toString() + " matching values:" + values);
        ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
        try {
            HashMap<String, Object> parameters;
            if (ICaseMetadataService.SEARCH_TYPE_ENUM.ALL.equals((Object)searchByEnum)) {
                caseDefinitionList = casePersistence.findWithNamedQuery("CaseDefinition.findAll");
            } else if (ICaseMetadataService.SEARCH_TYPE_ENUM.CASE_DEFINITION_ID.equals((Object)searchByEnum)) {
                parameters = new HashMap<String, Object>();
                parameters.put("definitionId", values);
                caseDefinitionList = casePersistence.findWithNamedQuery("CaseDefinition.findById", parameters);
            } else if (ICaseMetadataService.SEARCH_TYPE_ENUM.CATEGORY.equals((Object)searchByEnum)) {
                parameters = new HashMap();
                parameters.put("categoryName", values);
                caseDefinitionList = casePersistence.findWithNamedQuery("CaseDefinition.findByCategory", parameters);
            } else if (ICaseMetadataService.SEARCH_TYPE_ENUM.NAME.equals((Object)searchByEnum)) {
                parameters = new HashMap();
                parameters.put("name", values);
                caseDefinitionList = casePersistence.findWithNamedQuery("CaseDefinition.findByName", parameters);
            } else if (ICaseMetadataService.SEARCH_TYPE_ENUM.NAMESPACE.equals((Object)searchByEnum)) {
                parameters = new HashMap();
                parameters.put("namespace", values);
                caseDefinitionList = casePersistence.findWithNamedQuery("CaseDefinition.findByNamespace", parameters);
            } else {
                String searchByEnumString = searchByEnum != null ? searchByEnum.toString() : null;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(ICaseMetadataService.SEARCH_TYPE_ENUM.ALL.toString());
                arrayList.add(ICaseMetadataService.SEARCH_TYPE_ENUM.NAME.toString());
                arrayList.add(ICaseMetadataService.SEARCH_TYPE_ENUM.NAMESPACE.toString());
                arrayList.add(ICaseMetadataService.SEARCH_TYPE_ENUM.CATEGORY.toString());
                arrayList.add(ICaseMetadataService.SEARCH_TYPE_ENUM.CASE_DEFINITION_ID.toString());
                throw new CaseServiceException(72803, new Object[]{searchByEnumString, arrayList});
            }
            if (caseDefinitionList != null && caseDefinitionList.size() > 0) {
                this.debugLog("listCaseDefinition", "CasePersistence returned " + caseDefinitionList.size() + " records");
                for (CaseDefinition caseDefinition : caseDefinitionList) {
                    String defnId = caseDefinition.getDefinitionId();
                    caseDefinition.getCaseMilestoneDefinitionList().size();
                    this.debugLog("listCaseDefinition", "Category for case Defn:" + defnId + "is:" + caseDefinition.getCategory());
                    this.debugLog("listCaseDefinition", "Milestones for case Defn:" + defnId + "is:" + caseDefinition.getCaseMilestoneDefinitionList().size());
                }
            } else {
                this.debugLog("listCaseDefinition", "CasePersistence returned 0 records");
            }
        }
        catch (CasePersistenceException e) {
            String string = searchByEnum != null ? searchByEnum.toString() : null;
            throw new CaseServiceException(72804, new Object[]{string, values}, (Throwable)((Object)e));
        }
        return caseDefinitionList;
    }

    @ValidateContext
    public List<CaseActivityDefinition> listCaseActivityDefinition(IBPMContext ctx, ICaseMetadataService.SEARCH_TYPE_ENUM searchByEnum, List values) throws CaseServiceException {
        this.validateContext(ctx);
        Locale locale = Locale.getDefault();
        List<Object> caseActivityDefinitionList = new ArrayList<CaseActivityDefinition>();
        if (!(searchByEnum != null && values != null && values.size() != 0 || searchByEnum == null || searchByEnum.equals((Object)ICaseMetadataService.SEARCH_TYPE_ENUM.ALL))) {
            this.debugLog("listCaseActivityDefinition", "One of the input parameters is null");
            return caseActivityDefinitionList;
        }
        ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
        this.debugLog("listCaseActivityDefinition", "Searching case definitions with search criteria:" + searchByEnum.toString() + " matching values:" + values);
        try {
            HashMap<String, Object> parameters;
            if (ICaseMetadataService.SEARCH_TYPE_ENUM.ALL.equals((Object)searchByEnum)) {
                caseActivityDefinitionList = casePersistence.findWithNamedQuery("CaseActivityDefinition.findAll");
            } else if (ICaseMetadataService.SEARCH_TYPE_ENUM.ACTIVITY_DEFINITION_ID.equals((Object)searchByEnum)) {
                parameters = new HashMap<String, Object>();
                parameters.put("definitionId", values);
                caseActivityDefinitionList = casePersistence.findWithNamedQuery("CaseActivityDefinition.findById", parameters);
            } else if (ICaseMetadataService.SEARCH_TYPE_ENUM.CATEGORY.equals((Object)searchByEnum)) {
                parameters = new HashMap();
                parameters.put("categoryName", values);
                caseActivityDefinitionList = casePersistence.findWithNamedQuery("CaseActivityDefinition.findByCategory", parameters);
            } else if (ICaseMetadataService.SEARCH_TYPE_ENUM.CASE_DEFINITION_ID.equals((Object)searchByEnum)) {
                parameters = new HashMap();
                parameters.put("caseDefinitionId", values);
                caseActivityDefinitionList = casePersistence.findWithNamedQuery("CaseActivityDefinition.findByCaseDefinitionId", parameters);
            } else {
                String searchByEnumString = searchByEnum != null ? searchByEnum.toString() : null;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(ICaseMetadataService.SEARCH_TYPE_ENUM.ALL.toString());
                arrayList.add(ICaseMetadataService.SEARCH_TYPE_ENUM.CATEGORY.toString());
                arrayList.add(ICaseMetadataService.SEARCH_TYPE_ENUM.CASE_DEFINITION_ID.toString());
                arrayList.add(ICaseMetadataService.SEARCH_TYPE_ENUM.ACTIVITY_DEFINITION_ID.toString());
                throw new CaseServiceException(72803, new Object[]{searchByEnumString, arrayList});
            }
            if (caseActivityDefinitionList != null && caseActivityDefinitionList.size() > 0) {
                for (CaseActivityDefinition caseActivityDefinition : caseActivityDefinitionList) {
                    String defnId = caseActivityDefinition.getDefinitionId();
                    caseActivityDefinition.getCaseActivityCategoryDefinitionList().size();
                    caseActivityDefinition.getCaseActivityInCaseDefinitionList().size();
                    this.debugLog("listCaseActivityDefinition", "Categories for case activity:" + defnId + "is:" + caseActivityDefinition.getCaseActivityCategoryDefinitionList().size());
                    this.debugLog("listCaseActivityDefinition", "Cases for case activity:" + defnId + "is:" + caseActivityDefinition.getCaseActivityInCaseDefinitionList().size());
                }
            } else {
                this.debugLog("listCaseActivityDefinition", "CasePersistence returned 0 records");
            }
        }
        catch (CasePersistenceException e) {
            String string = searchByEnum != null ? searchByEnum.toString() : null;
            throw new CaseServiceException(72805, new Object[]{string, values}, (Throwable)((Object)e));
        }
        return caseActivityDefinitionList;
    }

    @ValidateContext
    public CaseActivity getCaseActivityMetadata(IBPMContext ctx, String activityDefinitionId) throws CaseServiceException {
        this.validateContext(ctx);
        Locale locale = Locale.getDefault();
        CaseActivity caseActivityMetadata = null;
        CaseActivityMetadataCache metadataCache = CaseActivityMetadataCache.getInstance();
        try {
            caseActivityMetadata = (CaseActivity)metadataCache.getMetadata(activityDefinitionId);
        }
        catch (CaseMetadataException e) {
            CaseServiceException se = new CaseServiceException(72801, new Object[]{activityDefinitionId}, (Throwable)((Object)e));
            throw se;
        }
        return caseActivityMetadata;
    }

    @ValidateContext
    public void registerCaseDisplayForm(IBPMContext ctx, String caseDefinitionNamespace, String caseArtifactName, String compositeVersion, String partitionName, List<TCaseDisplayInfo> caseDisplayInfoList, ICaseMetadataService.FORM_TYPE formType) throws CaseServiceException {
        String methodName = "registerCaseDisplayForm";
        this.debugLog("registerCaseDisplayForm", "\n Called with: \n ctx user: " + ctx.getUser() + "\n caseDefinitionNamespace: " + caseDefinitionNamespace + "\n caseArtifactName: " + caseArtifactName + "\n compositeVersion: " + compositeVersion + "\n partitionName: " + partitionName + "\n formType: " + formType + "\n caseDisplayInfoList: " + caseDisplayInfoList);
        Set<String> actualNamespaces = CaseDisplayUtil.getActualNamespacesFromTemplateNS(ctx, caseDefinitionNamespace, caseArtifactName, partitionName);
        try {
            List<CaseDefinition> caseMetadata = CaseDisplayUtil.getCaseMetadataByNamespace(ctx, caseDefinitionNamespace, null, partitionName);
            if (actualNamespaces.size() == 0 || caseMetadata.size() > 0) {
                actualNamespaces.add(caseDefinitionNamespace);
            }
            for (String thisNamespace : actualNamespaces) {
                Map<String, String> partitionMetadataMap = CaseDisplayUtil.createPartitionCaseMetadataMap(ctx, thisNamespace, partitionName, compositeVersion);
                for (String thisPartition : partitionMetadataMap.keySet()) {
                    String thisVersion = partitionMetadataMap.get(thisPartition);
                    this.debugLog("registerCaseDisplayForm", "\n Creating case display info for \n namespace: " + thisNamespace + "\n partition " + thisPartition + "\n version " + thisVersion);
                    CaseDisplayUtil.deleteCaseDisplayInfo(thisNamespace, caseArtifactName, thisVersion, thisPartition, formType);
                    CaseDisplayUtil.insertCaseDisplayInfo(thisNamespace, caseArtifactName, thisVersion, thisPartition, formType, caseDisplayInfoList);
                }
            }
            if (compositeVersion == null || partitionName == null) {
                CaseDisplayUtil.deleteCaseDisplayInfo(caseDefinitionNamespace, caseArtifactName, compositeVersion, partitionName, formType);
                if (compositeVersion == null && partitionName == null) {
                    CaseDisplayUtil.deleteCaseDisplayInfoAcrossPartitions(caseDefinitionNamespace, caseArtifactName, null, formType);
                }
                CaseDisplayUtil.insertCaseDisplayInfo(caseDefinitionNamespace, caseArtifactName, compositeVersion, partitionName, formType, caseDisplayInfoList);
                this.debugLog("registerCaseDisplayForm", "\n Created dummy placeholer case Display info for \n caseDefinitionNamespace: " + caseDefinitionNamespace + "\n caseArtifactName: " + caseArtifactName + "\n partition: " + partitionName + "\n compositeVersion: " + compositeVersion);
            }
        }
        catch (CasePersistenceException e) {
            CaseServiceException se = new CaseServiceException(72812, new Object[]{caseArtifactName, formType.toString(), caseDefinitionNamespace}, (Throwable)((Object)e));
            throw se;
        }
        this.debugLog("registerCaseDisplayForm", "Completed.");
    }

    @ValidateContext
    public List<TCaseDisplayInfo> getCaseDisplayForm(IBPMContext ctx, String caseDefinitionNamespace, String caseArtifactName, String compositeVersion, String partitionName, String applicationName, String formName, ICaseMetadataService.FORM_TYPE formType) throws CaseServiceException {
        String METHOD_NAME = "getCaseDisplayInfo";
        this.debugLog("getCaseDisplayInfo", "\n Called with: \n ctx user: " + ctx.getUser() + "\n caseDefinitionNamespace: " + caseDefinitionNamespace + "\n caseArtifactName: " + caseArtifactName + "\n formType: " + formType.toString() + "\n compositeVersion: " + compositeVersion + "\n partitionName: " + partitionName + "\n applicationName: " + applicationName + "\n formName: " + formName);
        List<TCaseDisplayInfo> result = new ArrayList<TCaseDisplayInfo>();
        try {
            result.addAll(CaseDisplayUtil.getCaseDisplayInfo(caseDefinitionNamespace, caseArtifactName, formType, compositeVersion, partitionName, applicationName, formName));
        }
        catch (CasePersistenceException e) {
            CaseServiceException se = new CaseServiceException(72813, new Object[]{caseArtifactName, formType.toString(), caseDefinitionNamespace, compositeVersion, partitionName}, (Throwable)((Object)e));
            throw se;
        }
        result = CaseDisplayUtil.setCaseDisplayTranslations(ctx.getLocale(), caseDefinitionNamespace, caseArtifactName, formType, partitionName, compositeVersion, result);
        this.debugLog("getCaseDisplayInfo", "Completed. Returning: " + result);
        return result;
    }

    @ValidateContext
    public int deleteCaseForm(IBPMContext ctx, String caseNamespace, String caseArtificatName, String compositeVersion, String partitionName, ICaseMetadataService.FORM_TYPE formType) throws CaseServiceException {
        int i = 0;
        try {
            i = CaseDisplayUtil.deleteCaseDisplayInfo(caseNamespace, caseArtificatName, compositeVersion, partitionName, formType);
        }
        catch (CasePersistenceException e) {
            CaseServiceException se = new CaseServiceException(72812, new Object[]{caseArtificatName, formType.toString(), caseNamespace}, (Throwable)((Object)e));
            throw se;
        }
        return i;
    }

    @ValidateContext
    public int unregisterCaseForm(IBPMContext ctx, TCaseDisplayInfo displayInfo) throws CaseServiceException {
        int i = 0;
        try {
            i = CaseDisplayUtil.deleteCaseDisplayInfo(displayInfo);
        }
        catch (CasePersistenceException e) {
            CaseServiceException se = new CaseServiceException(72814, new Object[0], (Throwable)((Object)e));
            throw se;
        }
        return i;
    }

    private Map<String, String> getCaseMilestonesDisplayValue(CaseMetadata caseMetadata, Locale locale) {
        HashMap<String, String> translationMappings = new HashMap<String, String>();
        String defnId = ((TCaseMetadata)caseMetadata.getValue()).getId();
        TMilestones milestones = ((TCaseMetadata)caseMetadata.getValue()).getMilestones();
        if (milestones != null && milestones.getMilestone() != null && !milestones.getMilestone().isEmpty()) {
            for (TMilestone milestone : milestones.getMilestone()) {
                String displayName = CaseMetadataCache.getInstance().getDisplayValue(defnId, milestone.getName(), locale);
                translationMappings.put(milestone.getName(), displayName);
            }
        }
        return translationMappings;
    }

    private Map<String, String> getCaseStakeholdersDisplayValue(CaseMetadata caseMetadata, Locale locale) {
        HashMap<String, String> translationMappings = new HashMap<String, String>();
        String defnId = ((TCaseMetadata)caseMetadata.getValue()).getId();
        TStakeHolders stakeholders = ((TCaseMetadata)caseMetadata.getValue()).getStakeHolders();
        if (stakeholders != null && stakeholders.getStakeHolder() != null && !stakeholders.getStakeHolder().isEmpty()) {
            for (TStakeHolder stakeholder : stakeholders.getStakeHolder()) {
                String displayName = CaseMetadataCache.getInstance().getDisplayValue(defnId, stakeholder.getName(), locale);
                translationMappings.put(stakeholder.getName(), displayName);
            }
        }
        return translationMappings;
    }

    private Map<String, String> getCasePermissionsDisplayValue(CaseMetadata caseMetadata, Locale locale) {
        HashMap<String, String> translationMappings = new HashMap<String, String>();
        String defnId = ((TCaseMetadata)caseMetadata.getValue()).getId();
        TPermissionTags permissionTags = ((TCaseMetadata)caseMetadata.getValue()).getPermissionTags();
        if (permissionTags != null && permissionTags.getPermissionTag() != null && !permissionTags.getPermissionTag().isEmpty()) {
            for (TPermissionTag permissionTag : permissionTags.getPermissionTag()) {
                String displayName;
                if (permissionTag.isSetTagName()) {
                    displayName = CaseMetadataCache.getInstance().getDisplayValue(defnId, permissionTag.getTagName().toString(), locale);
                    translationMappings.put(permissionTag.getTagName().toString(), displayName);
                    continue;
                }
                if (!permissionTag.isSetCustomTagName()) continue;
                displayName = CaseMetadataCache.getInstance().getDisplayValue(defnId, permissionTag.getCustomTagName(), locale);
                translationMappings.put(permissionTag.getCustomTagName(), displayName);
            }
        }
        return translationMappings;
    }

    private Map<String, String> getCaseOutcomesDisplayValue(CaseMetadata caseMetadata, Locale locale) {
        HashMap<String, String> translationMappings = new HashMap<String, String>();
        String defnId = ((TCaseMetadata)caseMetadata.getValue()).getId();
        TOutcomes outcomes = ((TCaseMetadata)caseMetadata.getValue()).getOutcomes();
        if (outcomes != null && outcomes.getOutcome() != null && !outcomes.getOutcome().isEmpty()) {
            for (TOutcome outcome : outcomes.getOutcome()) {
                String displayName = CaseMetadataCache.getInstance().getDisplayValue(defnId, outcome.getName(), locale);
                translationMappings.put(outcome.getName(), displayName);
            }
        }
        return translationMappings;
    }

    private Map<String, String> convertResourceBundleToMap(ResourceBundle bundle) {
        HashMap<String, String> bundleMap = new HashMap<String, String>();
        if (bundle != null) {
            for (String key : bundle.keySet()) {
                String value = bundle.getString(key);
                bundleMap.put(key, value);
            }
        }
        return bundleMap;
    }

    private void validateContext(IBPMContext context) throws CaseServiceException {
    }

    private void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)methodName, (String)message);
    }

    private Map<String, String> getCaseUserDefinedEventsDisplayValue(CaseMetadata caseMetadata, Locale locale) {
        HashMap<String, String> translationMappings = new HashMap<String, String>();
        String defnId = ((TCaseMetadata)caseMetadata.getValue()).getId();
        TUserDefinedEvent events = ((TCaseMetadata)caseMetadata.getValue()).getEvents();
        if (events != null && events.getUserDefinedEvent() != null && !events.getUserDefinedEvent().isEmpty()) {
            for (String event : events.getUserDefinedEvent()) {
                String displayName = CaseMetadataCache.getInstance().getDisplayValue(defnId, event, locale);
                translationMappings.put(event, displayName);
            }
        }
        return translationMappings;
    }
}

