/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.impl;

import java.util.Locale;
import java.util.ResourceBundle;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.AbstractMetadataCache;
import oracle.bpm.casemgmt.impl.CaseMetadataException;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TMilestone;
import oracle.bpm.casemgmt.metadata.Case.model.TMilestones;
import oracle.bpm.casemgmt.metadata.Case.model.TResourceBundle;
import oracle.bpm.casemgmt.metadata.Case.model.TStakeHolder;
import oracle.bpm.casemgmt.metadata.Case.model.TStakeHolders;

public class CaseMetadataCache
extends AbstractMetadataCache {
    private static CaseMetadataCache cache = new CaseMetadataCache();

    private CaseMetadataCache() {
    }

    public static CaseMetadataCache getInstance() {
        return cache;
    }

    @Override
    public Object retrieveMetadata(String definitionId) throws CaseMetadataException {
        CaseMetadata caseMetadata = null;
        try {
            caseMetadata = ServicesLocator.getCaseSE().getCaseMetadata(definitionId, null);
        }
        catch (Exception e) {
            CaseMetadataException ex = new CaseMetadataException(72800, new Object[]{definitionId}, e);
            throw ex;
        }
        return caseMetadata;
    }

    @Override
    public ResourceBundle getResourceBundle(String definitionId, Locale locale, boolean duringDeployment) throws CaseMetadataException {
        if (definitionId == null) {
            return null;
        }
        CaseMetadata metadata = (CaseMetadata)this.getMetadata(definitionId);
        TResourceBundle bundleInfo = ((TCaseMetadata)metadata.getValue()).getResourceBundle();
        ResourceBundle bundle = this.getResourceBundle(definitionId, bundleInfo, locale, duringDeployment);
        return bundle;
    }

    protected CaseMetadata getTranslatedMetadata(CaseMetadata caseMetadata, Locale locale) throws CaseMetadataException {
        TStakeHolders stakeholders;
        TMilestones milestones;
        if (caseMetadata == null) {
            return null;
        }
        String defnId = ((TCaseMetadata)caseMetadata.getValue()).getId();
        if (defnId == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (((TCaseMetadata)caseMetadata.getValue()).getTitle() != null) {
            String title = this.getDisplayValue(defnId, (Object)((TCaseMetadata)caseMetadata.getValue()).getTitle(), locale, false);
            ((TCaseMetadata)caseMetadata.getValue()).getTitle().setTranslationValue(title);
        }
        if ((milestones = ((TCaseMetadata)caseMetadata.getValue()).getMilestones()) != null && milestones.getMilestone() != null && !milestones.getMilestone().isEmpty()) {
            for (TMilestone milestone : milestones.getMilestone()) {
                String milestoneValue = this.getDisplayValue(defnId, (Object)milestone.getName(), locale, false);
                milestone.setName(milestoneValue);
            }
        }
        if ((stakeholders = ((TCaseMetadata)caseMetadata.getValue()).getStakeHolders()) != null && stakeholders.getStakeHolder() != null && !stakeholders.getStakeHolder().isEmpty()) {
            for (TStakeHolder stakeholder : stakeholders.getStakeHolder()) {
                String name = this.getDisplayValue(defnId, (Object)stakeholder.getName(), locale, false);
                stakeholder.setName(name);
            }
        }
        return caseMetadata;
    }
}

