/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseList;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseInstanceService;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.annotations.IgnoreFirstOfMultiple;
import oracle.bpm.casemgmt.annotations.MethodPermissionMap;
import oracle.bpm.casemgmt.annotations.RaiseEvent;
import oracle.bpm.casemgmt.annotations.SetCaseObjectAction;
import oracle.bpm.casemgmt.annotations.SetCaseObjectDefaultValues;
import oracle.bpm.casemgmt.annotations.SetReturnDisplayName;
import oracle.bpm.casemgmt.annotations.ValidateAction;
import oracle.bpm.casemgmt.annotations.ValidateCaseIdentifier;
import oracle.bpm.casemgmt.annotations.ValidateContext;
import oracle.bpm.casemgmt.annotations.ValidateContextWithDefault;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.fabric.CaseManagementServiceEngine;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.impl.CaseDocumentServiceImpl;
import oracle.bpm.casemgmt.impl.CaseMetadataCache;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.interceptors.SetCaseObjectDefaultValuesAdvice;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseData;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TData;
import oracle.bpm.casemgmt.metadata.Case.model.TDataTypeEnum;
import oracle.bpm.casemgmt.metadata.Case.model.TMilestone;
import oracle.bpm.casemgmt.metadata.Case.model.TMilestones;
import oracle.bpm.casemgmt.metadata.Case.model.TStakeHolder;
import oracle.bpm.casemgmt.metadata.Case.model.TStakeHolders;
import oracle.bpm.casemgmt.metadata.casedisplay.model.TCaseDisplayInfo;
import oracle.bpm.casemgmt.metadata.caseinstance.model.TIdentityTypeEnum;
import oracle.bpm.casemgmt.metadata.common.model.TResource;
import oracle.bpm.casemgmt.metadata.common.model.TResourceIdentityType;
import oracle.bpm.casemgmt.metadata.common.model.TStaticOrXpathType;
import oracle.bpm.casemgmt.permission.ICasePermissionServiceInternal;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.ICasePersistence;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseHeader;
import oracle.bpm.casemgmt.persistence.model.CaseMilestone;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.CaseObjectUtil;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolder;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolderMember;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.casemgmt.util.CaseUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.tip.pc.services.identity.BPMIdentity;

public class CaseInstanceServiceImpl
implements ICaseInstanceService {
    private static final List<ICaseConstants.CaseInfo> CASE_INFO_MILESTONE = new ArrayList<ICaseConstants.CaseInfo>();
    private static final List<ICaseConstants.CaseInfo> CASE_INFO_CASEDATA = new ArrayList<ICaseConstants.CaseInfo>();
    private static final List<ICaseConstants.CaseInfo> CASE_INFO_STAKEHOLDER = new ArrayList<ICaseConstants.CaseInfo>();
    private static final List<ICaseConstants.CaseInfo> CASE_INFO_COMMENT = new ArrayList<ICaseConstants.CaseInfo>();

    @IgnoreFirstOfMultiple
    @MethodPermissionMap(permission="UPDATE", permissionCaseObjectType="CASE")
    @RaiseEvent(eventType="LIFECYCLE_EVENT", lifecycleEventType="STARTED", documentEventType="NA", milestoneEventType="NA")
    @SetCaseObjectDefaultValues(caseObjectType="case")
    @ValidateAction(caseObjectType="CASE", action="UPDATE")
    @ValidateContextWithDefault
    public CaseIdentifier startCase(IBPMContext context, Case caseInstance) throws CaseServiceException {
        try {
            if (caseInstance.getCaseHeader().getCompositeInstanceId() == null) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"Composite instance id is null..Checking if direct binding is set");
                String directBindingServiceName = CaseManagementServiceEngine.getInstance().getDirectBindingServiceName(caseInstance);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Direct binding service name:" + directBindingServiceName));
                if (directBindingServiceName != null) {
                    return ServicesLocator.getCaseSE().postToDirectBinding(caseInstance, directBindingServiceName);
                }
                throw new CaseServiceException(73400, new Object[]{caseInstance.getCaseHeader().getCaseDefinitionId()});
            }
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseService] startCase invoked for Case:" + caseInstance));
            this.setAttributes(context, caseInstance);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Case after setting the default:" + caseInstance));
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73420, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"startCase", (Throwable)cse);
            throw cse;
        }
        try {
            Case clonedCase = CaseObjectUtil.getCaseClone((Case)caseInstance);
            CaseServiceUtil.populateExternalCaseData(context, clonedCase);
            CaseDocumentServiceImpl.createCaseFolder(context, caseInstance, clonedCase);
            ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
            casePersistence.persist(caseInstance);
            try {
                boolean titleTranslationsAdded = ServicesLocator.getInternalCaseService().upsertCaseTitleTranslation(context, caseInstance, clonedCase);
                if (titleTranslationsAdded) {
                    casePersistence.update(caseInstance);
                }
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseService] addedTitleTranslations:" + titleTranslationsAdded));
            }
            catch (Exception e) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"Title translations failed", (Throwable)e);
            }
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] Case started");
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73420, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"startCase", (Throwable)cse);
            throw cse;
        }
        ServicesLocator.getCaseSE().onCaseStarted(caseInstance);
        return new CaseIdentifier(caseInstance.getCaseId(), caseInstance.getCaseHeader().getCaseNumber(), caseInstance.getCaseHeader().getIdentificationKey());
    }

    @MethodPermissionMap(permission="READ", permissionCaseObjectType="CASE")
    @SetCaseObjectAction
    @SetReturnDisplayName
    @ValidateAction(caseObjectType="CASE", action="READ")
    @ValidateCaseIdentifier
    @ValidateContext
    public Case getCase(IBPMContext bpmContext, CaseIdentifier caseIdentifier, List<ICaseConstants.CaseInfo> additionalCaseInfo) throws CaseServiceException {
        return this.getCase(bpmContext, caseIdentifier, additionalCaseInfo, false, true);
    }

    public Case getCaseInternal(IBPMContext bpmContext, CaseIdentifier caseIdentifier, List<ICaseConstants.CaseInfo> additionalCaseInfo, boolean readOnly) throws CaseServiceException {
        return this.getCase(bpmContext, caseIdentifier, additionalCaseInfo, true, readOnly);
    }

    public Case getCase(IBPMContext bpmContext, CaseIdentifier caseIdentifier, List<ICaseConstants.CaseInfo> additionalCaseInfo, boolean internalCall, boolean readOnly) throws CaseServiceException {
        try {
            if (caseIdentifier.getCaseIdentifierType() == null) {
                return null;
            }
            Case caseInstance = null;
            if (CaseIdentifier.CaseIdentifierType.CASEID == caseIdentifier.getCaseIdentifierType()) {
                caseInstance = ServicesLocator.getCaseInstancePersistence().findCaseByCaseId(caseIdentifier.getCaseId());
            } else if (CaseIdentifier.CaseIdentifierType.CASENUMBER == caseIdentifier.getCaseIdentifierType()) {
                caseInstance = ServicesLocator.getCaseInstancePersistence().findCaseByCaseNumber(caseIdentifier.getCaseNumber());
            } else if (CaseIdentifier.CaseIdentifierType.IDENTIFICATIONKEY == caseIdentifier.getCaseIdentifierType()) {
                caseInstance = ServicesLocator.getCaseInstancePersistence().findCaseByIdentificationKey(caseIdentifier.getIdentificationKey());
            }
            String userName = null;
            if (bpmContext != null) {
                userName = bpmContext.getUser();
            }
            ICaseIdentityService identityService = ServicesLocator.getCaseIdentityService();
            List<BPMIdentity> userAppRoleList = identityService.getApplicationRoles(bpmContext);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("User's Approles:" + userAppRoleList));
            List<BPMIdentity> userGroupList = identityService.getGroups(bpmContext);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("User's Groups:" + userGroupList));
            String locale = null;
            if (bpmContext != null) {
                if (bpmContext instanceof InternalBPMContext) {
                    locale = Locale.getDefault().getLanguage();
                } else {
                    userName = bpmContext.getUser();
                    locale = bpmContext.getLocale().getLanguage();
                }
            }
            return this.getCaseWithAddtionalCaseInfo(bpmContext, caseInstance, additionalCaseInfo, userName, locale, userAppRoleList, userGroupList, internalCall, readOnly);
        }
        catch (CasePersistenceException cpe) {
            CaseServiceException cse = new CaseServiceException(73404, new Object[0], (Throwable)((Object)cpe));
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(bpmContext, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)"CaseInstanceServiceImpl", (String)"getCase", (Throwable)cse);
            throw cse;
        }
    }

    @MethodPermissionMap(permission="READ", permissionCaseObjectType="CASE")
    @SetCaseObjectAction
    @SetReturnDisplayName
    @ValidateContext
    public CaseList queryCase(IBPMContext context, List<ICaseConstants.CaseInfo> additionalCaseInfo, String addtionalJPQLWhereCondition, String orderBy, int pageSize, int pageNumber) throws CaseServiceException {
        try {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] queryCase invoked");
            StringBuffer query = new StringBuffer();
            String userName = null;
            String locale = null;
            boolean isInternalContext = false;
            if (context != null) {
                if (context instanceof InternalBPMContext) {
                    isInternalContext = true;
                    locale = Locale.getDefault().getLanguage();
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseService] InternalBPMContext:" + context));
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseService] queryCase.locale:" + locale));
                } else {
                    userName = context.getUser();
                    locale = context.getLocale().getLanguage();
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseService] queryCase.userName:" + userName));
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseService] queryCase.locale:" + locale));
                }
            }
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            query.append("select " + ICaseConstants.caseInstance + " from Case as " + ICaseConstants.caseInstance + " join " + ICaseConstants.caseInstance + "." + ICaseConstants.caseHeader + " as " + ICaseConstants.caseHeader);
            query.append(" join " + ICaseConstants.caseInstance + "." + ICaseConstants.caseTranslations + " as " + ICaseConstants.caseTranslations + " where ( " + ICaseConstants.caseTranslations + "." + ICaseConstants.caseTranslationAttributes.locale + " = :" + ICaseConstants.caseTranslationAttributes.locale + " ) ");
            queryParameters.put(ICaseConstants.caseTranslationAttributes.locale.toString(), locale);
            List<BPMIdentity> userGroupList = null;
            List<BPMIdentity> userAppRoleList = null;
            if (!isInternalContext) {
                int i;
                StringBuffer subQuery = new StringBuffer(" and exists (select " + ICaseConstants.caseStakeHolders + " from " + ICaseConstants.caseInstance + "." + ICaseConstants.caseStakeHolders + " as " + ICaseConstants.caseStakeHolders + " join " + ICaseConstants.caseStakeHolders + "." + ICaseConstants.caseStakeHolderMembers + " as " + ICaseConstants.caseStakeHolderMembers + " where ");
                subQuery.append("((" + ICaseConstants.caseStakeHolderMembers + "." + ICaseConstants.caseStakeHolderAttributes.stakeHolder + " = :" + ICaseConstants.caseStakeHolderAttributes.stakeHolder + " and " + ICaseConstants.caseStakeHolderMembers + "." + ICaseConstants.caseStakeHolderAttributes.stakeHolderType + " = '" + ICaseConstants.IdentityType.USER + "') ");
                queryParameters.put(ICaseConstants.caseStakeHolderAttributes.stakeHolder.toString(), userName);
                ICaseIdentityService identityService = ServicesLocator.getCaseIdentityService();
                userAppRoleList = identityService.getApplicationRoles(context);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("User's Approles:" + userAppRoleList));
                if (userAppRoleList != null && userAppRoleList.size() > 0) {
                    String appRoleWhereClause = " ";
                    appRoleWhereClause = appRoleWhereClause + " or (" + ICaseConstants.caseStakeHolderMembers + "." + ICaseConstants.caseStakeHolderAttributes.stakeHolder + " IN :" + ICaseConstants.caseStakeHolderAttributes.stakeHolder + "AppRoleList" + " and " + ICaseConstants.caseStakeHolderMembers + "." + ICaseConstants.caseStakeHolderAttributes.stakeHolderType + " = '" + ICaseConstants.IdentityType.APPLICATION_ROLE + "')";
                    ArrayList<String> appRoleList = new ArrayList<String>();
                    for (i = 0; i < userAppRoleList.size(); ++i) {
                        appRoleList.add(userAppRoleList.get(i).getName());
                    }
                    subQuery.append(appRoleWhereClause);
                    queryParameters.put(ICaseConstants.caseStakeHolderAttributes.stakeHolder + "AppRoleList", appRoleList);
                }
                userGroupList = identityService.getGroups(context);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("User's Groups:" + userGroupList));
                if (userGroupList != null && userGroupList.size() > 0) {
                    String groupWhereClause = " ";
                    groupWhereClause = groupWhereClause + " or (" + ICaseConstants.caseStakeHolderMembers + "." + ICaseConstants.caseStakeHolderAttributes.stakeHolder + " IN :" + ICaseConstants.caseStakeHolderAttributes.stakeHolder + "GroupList" + " and " + ICaseConstants.caseStakeHolderMembers + "." + ICaseConstants.caseStakeHolderAttributes.stakeHolderType + " = '" + ICaseConstants.IdentityType.GROUP + "')";
                    ArrayList<String> groupList = new ArrayList<String>();
                    for (i = 0; i < userGroupList.size(); ++i) {
                        groupList.add(userGroupList.get(i).getName());
                    }
                    subQuery.append(groupWhereClause);
                    queryParameters.put(ICaseConstants.caseStakeHolderAttributes.stakeHolder + "GroupList", groupList);
                }
                subQuery.append("))");
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Case subquery:" + subQuery.toString()));
                query.append(subQuery);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Case query:" + query));
            }
            if (addtionalJPQLWhereCondition != null && addtionalJPQLWhereCondition.length() > 0) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("addtionalJPQLWhereCondition:" + addtionalJPQLWhereCondition));
                query.append(" and (" + addtionalJPQLWhereCondition + ") ");
            }
            if (CaseServiceUtil.isNullOrEmpty(orderBy)) {
                orderBy = ICaseConstants.caseInstance + "." + ICaseConstants.caseHeader + "." + ICaseConstants.caseHeaderAttributes.caseNumber.name() + " desc ";
            }
            query.append(" order by " + orderBy);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Case query:" + query.toString()));
            CaseList caseList = ServicesLocator.getCaseInstancePersistence().queryCase(query.toString(), queryParameters, pageSize, pageNumber);
            if (caseList.getCases() != null && caseList.getCases().size() > 0) {
                for (Case caseInstance : caseList.getCases()) {
                    CaseServiceUtil.setTranslatedTitle(locale, caseInstance);
                }
            }
            CaseList caseListWithClonedCases = this.getCaseWithAddtionalCaseInfo(context, caseList, additionalCaseInfo, userName, locale, userAppRoleList, userGroupList, false, true);
            return caseListWithClonedCases;
        }
        catch (CasePersistenceException cpe) {
            CaseServiceException cse = new CaseServiceException(73405, new Object[0], (Throwable)((Object)cpe));
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"queryCase", (Throwable)cse);
            throw cse;
        }
    }

    @MethodPermissionMap(permission="UPDATE", permissionCaseObjectType="DATA")
    @RaiseEvent(eventType="DATA_UPLOAD_EVENT", lifecycleEventType="NA", documentEventType="NA", milestoneEventType="NA")
    @SetCaseObjectDefaultValues(caseObjectType="caseObject")
    @ValidateAction(caseObjectType="DATA", action="UPDATE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean uploadCaseData(IBPMContext context, CaseData caseData) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] uploadCaseData invoked");
        try {
            if (caseData.getExternal()) {
                return false;
            }
            boolean caseDataUpdated = false;
            CaseData updatedCaseData = null;
            ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
            Case caseInstance = this.getCaseInternal(context, CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseData.getCaseId()), CASE_INFO_CASEDATA, false);
            ArrayList<CaseData> caseDataList = caseInstance.getCaseData();
            boolean commentUpdated = false;
            if (caseDataList == null || caseDataList.size() == 0) {
                caseDataList = new ArrayList<CaseData>();
                caseInstance.setCaseData(caseDataList);
            } else {
                for (CaseData existingCaseData : caseDataList) {
                    if (existingCaseData == null || !existingCaseData.getObjectName().equals(caseData.getObjectName())) continue;
                    caseDataUpdated = true;
                    if (CaseServiceUtil.isNullOrEmpty(existingCaseData.getData())) {
                        return false;
                    }
                    existingCaseData.setData(caseData.getData());
                    existingCaseData.setUpdatedBy(caseData.getUpdatedBy());
                    existingCaseData.setUpdatedByDisplayName(caseData.getUpdatedByDisplayName());
                    existingCaseData.setUpdatedDate(caseData.getUpdatedDate());
                    if (caseData.getComment() != null) {
                        existingCaseData.setComment(caseData.getComment());
                        existingCaseData.getComment().setCaseObjectId(existingCaseData.getId());
                        existingCaseData.getComment().setCase(caseInstance);
                        commentUpdated = true;
                    }
                    updatedCaseData = existingCaseData;
                    break;
                }
            }
            if (caseDataUpdated) {
                ICaseMetadataService caseMetadataService = ServicesLocator.getCaseMetadataService();
                CaseMetadata caseMetadata = caseMetadataService.getCaseMetadata(context, caseInstance.getCaseHeader().getCaseDefinitionId());
                if (caseMetadata == null) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)"[CaseService] CaseMetadata is null");
                    return false;
                }
                TCaseMetadata caseMetadataType = (TCaseMetadata)caseMetadata.getValue();
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("caseMetadataType:" + caseMetadataType));
                if (caseMetadataType != null) {
                    List caseDataWrapperListFromMetadata = caseMetadataType.getCaseData();
                    TCaseData caseDataWrapperFromMetadata = null;
                    List caseDataListFromMetadata = null;
                    if (caseDataWrapperListFromMetadata != null && !caseDataWrapperListFromMetadata.isEmpty()) {
                        caseDataWrapperFromMetadata = (TCaseData)caseDataWrapperListFromMetadata.get(0);
                        caseDataListFromMetadata = caseDataWrapperFromMetadata.getData();
                    }
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("caseDataListFromMetadata:" + caseDataListFromMetadata));
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("caseDataListFromMetadata():" + caseDataListFromMetadata.size()));
                    if (caseDataListFromMetadata != null && !caseDataListFromMetadata.isEmpty()) {
                        for (TData caseDataFromMetadata : caseDataListFromMetadata) {
                            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("caseDataFromMetadata:" + caseDataFromMetadata));
                            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("caseDataFromMetadata:" + caseDataFromMetadata.getName()));
                            if (!caseData.getObjectName().equals(caseDataFromMetadata.getName()) || caseDataFromMetadata.isUpdatable()) continue;
                            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("CaseData:" + caseDataFromMetadata.getName() + " isUpdatable=false, hence it cannot be updated"));
                            throw new CaseServiceException(73424, new Object[]{caseDataFromMetadata.getName()});
                        }
                    }
                }
            }
            if (caseDataUpdated) {
                if (commentUpdated) {
                    caseData.getComment().setCase(caseInstance);
                }
            } else {
                caseDataList.add(caseData);
                caseData.setCase(caseInstance);
            }
            casePersistence.update(caseInstance);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] uploadCaseData is successfull - CaseData updated");
            return true;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73406, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"uploadCaseData", (Throwable)cse);
            throw cse;
        }
    }

    @MethodPermissionMap(permission="READ", permissionCaseObjectType="DATA")
    @SetCaseObjectAction
    @SetReturnDisplayName
    @ValidateAction(caseObjectType="DATA", action="READ")
    @ValidateCaseIdentifier
    @ValidateContext
    public CaseData getCaseDataByName(IBPMContext context, CaseIdentifier caseIdentifier, String caseDataName) throws CaseServiceException {
        CaseData clonedCaseData = null;
        try {
            Case caseInstance = this.getCaseInternal(context, caseIdentifier, CASE_INFO_CASEDATA, true);
            Case caseClone = CaseObjectUtil.getCaseClone((Case)caseInstance);
            clonedCaseData = ServicesLocator.getCaseInstancePersistence().findCaseData(caseDataName, caseInstance.getCaseId(), true);
            if (clonedCaseData.getPermissionTag() != null && !"".equals(clonedCaseData.getPermissionTag())) {
                CaseServiceUtil.validateAction(context, caseIdentifier, ICaseConstants.CaseObjectPermissionType.READ, ICaseConstants.CaseObjectType.DATA, clonedCaseData.getPermissionTag());
            }
            CaseServiceUtil.populateExternalCaseData(context, clonedCaseData, caseClone);
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73407, new Object[]{caseDataName}, (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCaseDataByName", (Throwable)cse);
            throw cse;
        }
        return clonedCaseData;
    }

    @MethodPermissionMap(permission="READ", permissionCaseObjectType="DATA")
    @SetCaseObjectAction
    @SetReturnDisplayName
    @ValidateAction(caseObjectType="DATA", action="READ")
    @ValidateCaseIdentifier
    @ValidateContext
    public List<CaseData> getCaseData(IBPMContext context, CaseIdentifier caseIdentifier) throws CaseServiceException {
        ArrayList<CaseData> clonedCaseDataList = new ArrayList<CaseData>();
        try {
            Case caseInstance = this.getCaseInternal(context, caseIdentifier, CASE_INFO_CASEDATA, true);
            Case caseClone = CaseObjectUtil.getCaseClone((Case)caseInstance);
            List caseDataList = ServicesLocator.getCasePersistence().findWithNamedQuery("CaseData.findByCaseId", "case_id", caseClone.getCaseId());
            if (caseDataList != null && caseDataList.size() > 0) {
                for (CaseData caseData : caseDataList) {
                    clonedCaseDataList.add(CaseObjectUtil.getCaseDataClone((Case)caseClone, (CaseData)caseData));
                }
            }
            CaseServiceUtil.populateExternalCaseData(context, clonedCaseDataList, caseClone);
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73408, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCaseData", (Throwable)cse);
            throw cse;
        }
        return clonedCaseDataList;
    }

    @MethodPermissionMap(permission="UPDATE", permissionCaseObjectType="CASE")
    @RaiseEvent(eventType="LIFECYCLE_EVENT", lifecycleEventType="COMPLETED", documentEventType="NA", milestoneEventType="NA")
    @SetCaseObjectDefaultValues(caseObjectType="caseObject")
    @ValidateAction(caseObjectType="CASE", action="UPDATE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean closeCase(IBPMContext context, CaseIdentifier caseIdentifier, String outcome, Comment comment) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] closeCase invoked");
        try {
            Case caseInstance = this.getCaseInternal(context, caseIdentifier, CASE_INFO_COMMENT, false);
            ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
            String previousState = caseInstance.getCaseHeader().getState();
            if (ICaseConstants.CaseState.CLOSED.name().equals(previousState)) {
                return false;
            }
            if (comment != null) {
                caseInstance.getComments().add(comment);
                comment.setCase(caseInstance);
            }
            Calendar currentTime = CaseServiceUtil.getCalendarInstance(context);
            caseInstance.getCaseHeader().setEndDate(currentTime);
            caseInstance.getCaseHeader().setState(ICaseConstants.CaseState.CLOSED.name());
            caseInstance.getCaseHeader().setOutcome(outcome);
            casePersistence.update(caseInstance);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] CloseCase is successfull");
            ServicesLocator.getCaseSE().onCaseStateChange(caseInstance, previousState);
            return true;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73409, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"closeCase", (Throwable)cse);
            throw cse;
        }
    }

    @MethodPermissionMap(permission="UPDATE", permissionCaseObjectType="COMMENT")
    @RaiseEvent(eventType="COMMENT_EVENT", lifecycleEventType="NA", documentEventType="NA", milestoneEventType="NA")
    @SetCaseObjectDefaultValues(caseObjectType="caseObject")
    @ValidateAction(caseObjectType="COMMENT", action="UPDATE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean addComment(IBPMContext context, CaseIdentifier caseIdentifier, Comment comment) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] addComment invoked");
        try {
            ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
            Case caseInstance = this.getCaseInternal(context, caseIdentifier, CASE_INFO_COMMENT, false);
            caseInstance.getComments().add(comment);
            comment.setCase(caseInstance);
            casePersistence.update(caseInstance);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] addComment is successfull");
            return true;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73410, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"addComment", (Throwable)cse);
            throw cse;
        }
    }

    @MethodPermissionMap(permission="READ", permissionCaseObjectType="MILESTONE")
    @SetCaseObjectAction
    @SetReturnDisplayName
    @ValidateAction(caseObjectType="MILESTONE", action="READ")
    @ValidateCaseIdentifier
    @ValidateContext
    public List<CaseMilestone> getCaseMileStones(IBPMContext context, CaseIdentifier caseIdentifier) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] getCaseMileStones invoked");
        ArrayList<CaseMilestone> clonedCaseMilestoneList = new ArrayList<CaseMilestone>();
        try {
            Case caseInstance = this.getCaseInternal(context, caseIdentifier, null, true);
            List caseMilestoneList = ServicesLocator.getCasePersistence().findWithNamedQuery("CaseMilestone.findByCaseId", "case_id", caseInstance.getCaseId());
            if (caseMilestoneList != null && caseMilestoneList.size() > 0) {
                for (CaseMilestone caseMilestone : caseMilestoneList) {
                    clonedCaseMilestoneList.add(CaseObjectUtil.getCaseMilestoneClone((Case)caseInstance, (CaseMilestone)caseMilestone));
                }
            }
        }
        catch (CasePersistenceException e) {
            CaseServiceException cse = new CaseServiceException(73411, new Object[0], (Throwable)((Object)e));
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCaseMileStones", (Throwable)cse);
            throw cse;
        }
        return clonedCaseMilestoneList;
    }

    @MethodPermissionMap(permission="UPDATE", permissionCaseObjectType="MILESTONE")
    @RaiseEvent(eventType="MILESTONE_EVENT", milestoneEventType="REACHED", lifecycleEventType="NA", documentEventType="NA")
    @SetCaseObjectDefaultValues(caseObjectType="caseObject")
    @ValidateAction(caseObjectType="MILESTONE", action="UPDATE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean attainMilestone(IBPMContext context, CaseMilestone milestone) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] attainMilestone invoked");
        try {
            ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
            Case caseInstance = this.getCaseInternal(context, CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)milestone.getCaseId()), CASE_INFO_MILESTONE, false);
            ArrayList<CaseMilestone> caseMilestones = caseInstance.getCaseMilestones();
            String userName = "weblogic";
            String userDisplayName = "weblogic";
            Calendar currentTime = CaseServiceUtil.getCalendarInstance(context);
            if (context != null) {
                userName = context.getUser();
                userDisplayName = context.getUser();
            }
            if (caseMilestones == null) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] CaseMilestones is null");
                caseMilestones = new ArrayList<CaseMilestone>();
                caseInstance.setCaseMilestones(caseMilestones);
                if (milestone.getComment() != null) {
                    milestone.getComment().setCase(caseInstance);
                }
                milestone.setUpdatedBy(userName);
                milestone.setUpdatedByDisplayName(userDisplayName);
                milestone.setUpdatedDate(currentTime);
                caseMilestones.add(milestone);
            } else {
                for (CaseMilestone caseMilestone : caseMilestones) {
                    if (!caseMilestone.getObjectName().equals(milestone.getObjectName()) && !caseMilestone.getId().equals(milestone.getId())) continue;
                    caseMilestone.setState(ICaseConstants.CaseMilestoneState.ATTAINED.name());
                    caseMilestone.setUpdatedBy(userName);
                    caseMilestone.setUpdatedByDisplayName(userDisplayName);
                    caseMilestone.setUpdatedDate(currentTime);
                    if (milestone.getComment() == null) break;
                    caseMilestone.setComment(milestone.getComment());
                    caseMilestone.getComment().setCaseObjectId(caseMilestone.getId());
                    caseMilestone.getComment().setCase(caseInstance);
                    break;
                }
            }
            casePersistence.update(caseInstance);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] attainMilestone is successfull");
            return true;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73412, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"attainMilestone", (Throwable)cse);
            throw cse;
        }
    }

    @MethodPermissionMap(permission="UPDATE", permissionCaseObjectType="MILESTONE")
    @RaiseEvent(eventType="MILESTONE_EVENT", milestoneEventType="REVOKED", lifecycleEventType="NA", documentEventType="NA")
    @SetCaseObjectDefaultValues(caseObjectType="caseObject")
    @ValidateAction(caseObjectType="MILESTONE", action="UPDATE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean revokeMilestone(IBPMContext context, CaseMilestone milestone) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] revokeMilestone invoked");
        try {
            ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
            Case caseInstance = this.getCaseInternal(context, CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)milestone.getCaseId()), CASE_INFO_MILESTONE, false);
            List caseMilestones = caseInstance.getCaseMilestones();
            if (caseMilestones == null) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] CaseMilestones is null");
                return false;
            }
            if (caseMilestones.size() == 0) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] CaseMilestones list is empty");
                return false;
            }
            boolean milestoneRevoked = this.revokeMileStone(context, casePersistence, caseInstance, milestone);
            if (!milestoneRevoked) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] CaseMilestones is not revoked");
                return false;
            }
            casePersistence.update(caseInstance);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] revokeMilestone is successfull");
            return true;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73413, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"revokeMilestone", (Throwable)cse);
            throw cse;
        }
    }

    @MethodPermissionMap(permission="UPDATE", permissionCaseObjectType="STAKEHOLDER")
    @SetCaseObjectDefaultValues(caseObjectType="caseObject")
    @ValidateAction(caseObjectType="STAKEHOLDER", action="UPDATE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean addCaseStakeHolder(IBPMContext context, CaseStakeHolder caseStakeHolder) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] addCaseStakeHolder invoked");
        try {
            if (!this.isValid(caseStakeHolder)) {
                return false;
            }
            ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
            Case caseInstance = this.getCaseInternal(context, CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseStakeHolder.getCaseId()), CASE_INFO_STAKEHOLDER, false);
            ArrayList<CaseStakeHolder> caseStakeHolders = caseInstance.getCaseStakeHolders();
            if (caseStakeHolders == null) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] caseStakeholders is null");
                caseStakeHolders = new ArrayList<CaseStakeHolder>();
                caseInstance.setCaseStakeHolders(caseStakeHolders);
            }
            boolean caseStakeHolderExists = false;
            CaseStakeHolder existingCaseStakeHolder = null;
            ArrayList<CaseStakeHolderMember> newCaseStakeHolderMembers = new ArrayList<CaseStakeHolderMember>();
            for (int index = 0; index < caseStakeHolders.size(); ++index) {
                existingCaseStakeHolder = (CaseStakeHolder)caseStakeHolders.get(index);
                if (existingCaseStakeHolder == null || existingCaseStakeHolder.getObjectName() == null || !existingCaseStakeHolder.getObjectName().equals(caseStakeHolder.getObjectName())) continue;
                caseStakeHolderExists = true;
                break;
            }
            if (caseStakeHolderExists) {
                List existingCaseStakeHolderMembers = existingCaseStakeHolder.getCaseStakeHolderMembers();
                List caseStakeHolderMembers = caseStakeHolder.getCaseStakeHolderMembers();
                boolean needtoCompare = true;
                if ((existingCaseStakeHolderMembers == null || existingCaseStakeHolderMembers.size() == 0) && caseStakeHolderMembers != null && caseStakeHolderMembers.size() > 0) {
                    newCaseStakeHolderMembers.addAll(caseStakeHolderMembers);
                    needtoCompare = false;
                }
                if (caseStakeHolderMembers == null || caseStakeHolderMembers.size() == 0) {
                    needtoCompare = false;
                }
                if (needtoCompare) {
                    for (int index = 0; index < caseStakeHolderMembers.size(); ++index) {
                        CaseStakeHolderMember caseStakeHolderMember = (CaseStakeHolderMember)caseStakeHolderMembers.get(index);
                        boolean caseStakeHolderMemberExists = false;
                        for (int innerIndex = 0; innerIndex < existingCaseStakeHolderMembers.size(); ++innerIndex) {
                            CaseStakeHolderMember existingCaseStakeHolderMember = (CaseStakeHolderMember)existingCaseStakeHolderMembers.get(innerIndex);
                            if (existingCaseStakeHolderMember == null || caseStakeHolderMember == null || existingCaseStakeHolderMember.getStakeHolder() == null || !existingCaseStakeHolderMember.getStakeHolder().equals(caseStakeHolderMember.getStakeHolder())) continue;
                            caseStakeHolderMemberExists = true;
                            break;
                        }
                        if (caseStakeHolderMemberExists) continue;
                        newCaseStakeHolderMembers.add(caseStakeHolderMember);
                    }
                }
                if (newCaseStakeHolderMembers.size() > 0) {
                    for (CaseStakeHolderMember newCaseStakeHolderMember : newCaseStakeHolderMembers) {
                        newCaseStakeHolderMember.setCaseStakeHolder(existingCaseStakeHolder);
                    }
                }
            }
            if (caseStakeHolderExists) {
                if (caseStakeHolder.getComment() != null) {
                    existingCaseStakeHolder.setComment(caseStakeHolder.getComment());
                    existingCaseStakeHolder.getComment().setCaseObjectId(existingCaseStakeHolder.getId());
                    existingCaseStakeHolder.getComment().setCase(caseInstance);
                }
                existingCaseStakeHolder.getCaseStakeHolderMembers().addAll(newCaseStakeHolderMembers);
                existingCaseStakeHolder.setCase(caseInstance);
            } else {
                caseStakeHolders.add(caseStakeHolder);
                caseStakeHolder.setCase(caseInstance);
            }
            casePersistence.update(caseInstance);
            if (!caseStakeHolderExists) {
                ICasePermissionServiceInternal permSvcIntl = ServicesLocator.getCasePermissionServiceInternal();
                permSvcIntl.createStakeHolderAppRoleWithDefaultPermission(caseInstance, caseStakeHolder.getObjectName());
            }
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] addCaseStakeHolder is successfull");
            return true;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73414, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"addStakeholder", (Throwable)cse);
            throw cse;
        }
    }

    @MethodPermissionMap(permission="READ", permissionCaseObjectType="STAKEHOLDER")
    @SetCaseObjectAction
    @SetReturnDisplayName
    @ValidateAction(caseObjectType="STAKEHOLDER", action="READ")
    @ValidateCaseIdentifier
    @ValidateContext
    public List<CaseStakeHolder> getCaseStakeHolders(IBPMContext context, CaseIdentifier caseIdentifier) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] getCaseStakeHolders invoked");
        ArrayList<CaseStakeHolder> clonedCaseStakeholders = new ArrayList<CaseStakeHolder>();
        try {
            Case caseInstance = this.getCaseInternal(context, caseIdentifier, null, true);
            List caseStakeholders = ServicesLocator.getCasePersistence().findWithNamedQuery("CaseStakeHolder.findByCaseId", "case_id", caseInstance.getCaseId());
            String userName = "weblogic";
            if (context != null) {
                userName = context.getUser();
            }
            if (caseStakeholders != null && caseStakeholders.size() > 0) {
                for (CaseStakeHolder caseStakeHolder : caseStakeholders) {
                    clonedCaseStakeholders.add(CaseObjectUtil.getCaseStakeHolderClone((Case)caseInstance, (CaseStakeHolder)caseStakeHolder));
                }
            }
            ICaseIdentityService identityService = ServicesLocator.getCaseIdentityService();
            List<BPMIdentity> userAppRoleList = identityService.getApplicationRoles(context);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("User's Approles:" + userAppRoleList));
            List<BPMIdentity> userGroupList = identityService.getGroups(context);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("User's Groups:" + userGroupList));
            CaseServiceUtil.populateIsUserInRole(userName, userAppRoleList, userGroupList, clonedCaseStakeholders);
        }
        catch (CasePersistenceException e) {
            CaseServiceException cse = new CaseServiceException(73415, new Object[0], (Throwable)((Object)e));
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCaseStakeHolders", (Throwable)cse);
            throw cse;
        }
        return clonedCaseStakeholders;
    }

    @MethodPermissionMap(permission="READ", permissionCaseObjectType="COMMENT")
    @SetCaseObjectAction
    @SetReturnDisplayName
    @ValidateAction(caseObjectType="COMMENT", action="READ")
    @ValidateContext
    public List<Comment> getComments(IBPMContext context, CaseObject caseObject) throws CaseServiceException {
        return this.getCommentsInternal(context, caseObject);
    }

    @MethodPermissionMap(permission="UPDATE", permissionCaseObjectType="CASE")
    @SetCaseObjectDefaultValues(caseObjectType="caseObject")
    @ValidateAction(caseObjectType="CASE", action="UPDATE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean abortCase(IBPMContext context, CaseIdentifier caseIdentifier, Comment comment) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] abortCase invoked");
        try {
            ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
            Case caseInstance = this.getCaseInternal(context, caseIdentifier, null, false);
            String previousState = caseInstance.getCaseHeader().getState();
            caseInstance.getCaseHeader().setState(ICaseConstants.CaseState.ABORTED.name());
            if (comment != null) {
                caseInstance.getComments().add(comment);
                comment.setCase(caseInstance);
            }
            casePersistence.update(caseInstance);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] AbortCase is successfull");
            ServicesLocator.getCaseSE().onCaseStateChange(caseInstance, previousState);
            return true;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73417, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"abortCase", (Throwable)cse);
            throw cse;
        }
    }

    @MethodPermissionMap(permission="UPDATE", permissionCaseObjectType="CASE")
    @SetCaseObjectDefaultValues(caseObjectType="caseObject")
    @ValidateAction(caseObjectType="CASE", action="UPDATE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean suspendCase(IBPMContext context, CaseIdentifier caseIdentifier, Comment comment) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] suspendCase invoked");
        try {
            ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
            Case caseInstance = this.getCaseInternal(context, caseIdentifier, CASE_INFO_COMMENT, false);
            if (caseInstance != null && !caseInstance.getCaseHeader().getState().equals(ICaseConstants.CaseState.ACTIVE.name())) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] suspendCase : Case is not in active state, cannot suspend.");
                return false;
            }
            String previousState = caseInstance.getCaseHeader().getState();
            caseInstance.getCaseHeader().setState(ICaseConstants.CaseState.SUSPENDED.name());
            if (comment != null) {
                caseInstance.getComments().add(comment);
                comment.setCase(caseInstance);
            }
            casePersistence.update(caseInstance);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] Suspend case is successfull");
            ServicesLocator.getCaseSE().onCaseStateChange(caseInstance, previousState);
            return true;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73418, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"suspendCase", (Throwable)cse);
            throw cse;
        }
    }

    @MethodPermissionMap(permission="UPDATE", permissionCaseObjectType="CASE")
    @SetCaseObjectDefaultValues(caseObjectType="caseObject")
    @ValidateAction(caseObjectType="CASE", action="UPDATE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean resumeCase(IBPMContext context, CaseIdentifier caseIdentifier, Comment comment) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] resumeCase invoked");
        try {
            ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
            Case caseInstance = this.getCaseInternal(context, caseIdentifier, CASE_INFO_COMMENT, false);
            if (caseInstance != null && !caseInstance.getCaseHeader().getState().equals(ICaseConstants.CaseState.SUSPENDED.name())) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] resumeCase : Case is not suspended, cannot resume.");
                return false;
            }
            String previousState = caseInstance.getCaseHeader().getState();
            caseInstance.getCaseHeader().setState(ICaseConstants.CaseState.ACTIVE.name());
            if (comment != null) {
                caseInstance.getComments().add(comment);
                comment.setCase(caseInstance);
            }
            casePersistence.update(caseInstance);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] Resume case is successfull");
            ServicesLocator.getCaseSE().onCaseStateChange(caseInstance, previousState);
            return true;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73419, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"resumeCase", (Throwable)cse);
            throw cse;
        }
    }

    @MethodPermissionMap(permission="UPDATE", permissionCaseObjectType="CASE")
    @SetCaseObjectDefaultValues(caseObjectType="caseObject")
    @ValidateAction(caseObjectType="CASE", action="UPDATE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean reopenCase(IBPMContext context, CaseIdentifier caseIdentifier, Comment comment) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] reopenCase invoked");
        try {
            ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
            Case caseInstance = this.getCaseInternal(context, caseIdentifier, CASE_INFO_COMMENT, false);
            if (caseInstance != null && !caseInstance.getCaseHeader().getState().equals(ICaseConstants.CaseState.CLOSED.name())) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] resumeCase : Case is not closed, cannot reopen.");
                return false;
            }
            String previousState = caseInstance.getCaseHeader().getState();
            caseInstance.getCaseHeader().setState(ICaseConstants.CaseState.ACTIVE.name());
            if (comment != null) {
                caseInstance.getComments().add(comment);
                comment.setCase(caseInstance);
            }
            casePersistence.update(caseInstance);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] Reoopen case is successfull");
            ServicesLocator.getCaseSE().onCaseStateChange(caseInstance, previousState);
            return true;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73427, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"reopenCase", (Throwable)cse);
            throw cse;
        }
    }

    @MethodPermissionMap(permission="UPDATE", permissionCaseObjectType="CASE")
    @RaiseEvent(eventType="LIFECYCLE_EVENT", lifecycleEventType="UPDATED", documentEventType="NA", milestoneEventType="NA")
    @SetCaseObjectDefaultValues(caseObjectType="caseObject")
    @ValidateAction(caseObjectType="CASE", action="UPDATE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean updateCaseHeader(IBPMContext context, CaseHeader caseHeader, Comment comment) throws CaseServiceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] closeCase invoked");
        try {
            ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
            Case caseInstance = this.getCaseInternal(context, CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseHeader.getCaseId()), CASE_INFO_COMMENT, false);
            CaseHeader existingCaseHeader = caseInstance.getCaseHeader();
            if (caseHeader.getCategory() != null && caseHeader.getCategory().trim().length() > 0 && !caseHeader.getCategory().equals(existingCaseHeader.getCategory())) {
                existingCaseHeader.setCategory(caseHeader.getCategory());
                String categoryDisplayName = CaseMetadataCache.getInstance().getDisplayValue(caseInstance.getCaseHeader().getCaseDefinitionId(), (Object)caseHeader.getCategory(), caseInstance, Locale.getDefault());
                existingCaseHeader.setCategoryDisplayName(categoryDisplayName);
            }
            existingCaseHeader.setIdentificationKey(caseHeader.getIdentificationKey());
            existingCaseHeader.setPriority(caseHeader.getPriority());
            if (comment != null) {
                caseInstance.getComments().add(comment);
                comment.setCase(caseInstance);
            }
            casePersistence.update(caseInstance);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] updateCaseHeader is successfull");
            return true;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73428, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"updateCaseHeader", (Throwable)cse);
            throw cse;
        }
    }

    private List<Comment> getCommentsInternal(IBPMContext context, CaseObject caseObject) throws CaseServiceException {
        ArrayList<Comment> clonedComments = new ArrayList<Comment>();
        try {
            List comments = null;
            comments = caseObject instanceof CaseHeader ? ServicesLocator.getCasePersistence().findWithNamedQuery("Comment.findByCaseId", "case_id", caseObject.getId()) : ServicesLocator.getCasePersistence().findWithNamedQuery("Comment.findByCaseObjectId", "object_name", caseObject.getId());
            if (comments != null && comments.size() > 0) {
                Case caseInstance = this.getCaseInternal(context, CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseObject.getCaseId()), CASE_INFO_COMMENT, true);
                for (Comment comment : comments) {
                    clonedComments.add(CaseObjectUtil.getCommentClone((Case)caseInstance, (Comment)comment));
                }
            }
        }
        catch (CasePersistenceException e) {
            CaseServiceException cse = new CaseServiceException(73421, new Object[0], (Throwable)((Object)e));
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)"CaseInstanceServiceImpl", (String)"getComments", (Throwable)cse);
            throw cse;
        }
        return clonedComments;
    }

    private boolean isValid(CaseStakeHolder caseStakeHolder) {
        if (caseStakeHolder == null) {
            return false;
        }
        if (caseStakeHolder.getCaseStakeHolderMembers() == null || caseStakeHolder.getCaseStakeHolderMembers().size() == 0) {
            return true;
        }
        ICaseIdentityService identityService = ServicesLocator.getCaseIdentityService();
        for (CaseStakeHolderMember caseStakeHolderMember : caseStakeHolder.getCaseStakeHolderMembers()) {
            if (TIdentityTypeEnum.USER.name().equals(caseStakeHolderMember.getStakeHolderType())) {
                if (identityService.isValidUser(caseStakeHolderMember.getStakeHolder())) continue;
                return false;
            }
            if (TIdentityTypeEnum.GROUP.name().equals(caseStakeHolderMember.getStakeHolderType())) {
                if (identityService.isValidGroup(caseStakeHolderMember.getStakeHolder())) continue;
                return false;
            }
            if (TIdentityTypeEnum.APPLICATION_ROLE.name().equals(caseStakeHolderMember.getStakeHolderType())) {
                if (identityService.isValidApprole(caseStakeHolderMember.getStakeHolder(), caseStakeHolderMember.getApplicationContext())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void setAttributes(IBPMContext ctx, Case caseInstance) throws Exception {
        Calendar currentTime = CaseServiceUtil.getCalendarInstance(ctx);
        caseInstance.getCaseHeader().setState(ICaseConstants.CaseState.ACTIVE.name());
        caseInstance.getCaseHeader().setCaseNumber(null);
        this.removeEmptyCaseObjects(caseInstance);
        this.setAttributesFromCaseMetadata(ctx, caseInstance, currentTime);
    }

    private void removeEmptyCaseObjects(Case caseInstance) {
        List caseDataList;
        List caseMilestones;
        List caseStakeHolders = caseInstance.getCaseStakeHolders();
        if (caseStakeHolders != null && !caseStakeHolders.isEmpty()) {
            ArrayList<CaseStakeHolder> emptyCaseStakeHolders = new ArrayList<CaseStakeHolder>();
            for (CaseStakeHolder caseStakeHolder : caseStakeHolders) {
                List caseStakeHolderMembers;
                Comment comment = caseStakeHolder.getComment();
                if (comment == null || comment.getCaseObjectComment() == null || comment.getCaseObjectComment().trim().length() == 0) {
                    caseStakeHolder.setComment(null);
                }
                if ((caseStakeHolderMembers = caseStakeHolder.getCaseStakeHolderMembers()) == null || caseStakeHolderMembers.isEmpty()) continue;
                ArrayList<CaseStakeHolderMember> emptyCaseStakeHolderMembers = new ArrayList<CaseStakeHolderMember>();
                for (CaseStakeHolderMember caseStakeHolderMember : caseStakeHolderMembers) {
                    if (caseStakeHolderMember.getStakeHolder() == null || caseStakeHolderMember.getStakeHolder().trim().length() == 0 || caseStakeHolderMember.getStakeHolderType() == null || caseStakeHolderMember.getStakeHolderType().trim().length() == 0) {
                        emptyCaseStakeHolderMembers.add(caseStakeHolderMember);
                        continue;
                    }
                    if (!TIdentityTypeEnum.APPLICATION_ROLE.name().equals(caseStakeHolderMember.getStakeHolderType()) || caseStakeHolderMember.getApplicationContext() != null && caseStakeHolderMember.getApplicationContext().trim().length() != 0) continue;
                    emptyCaseStakeHolderMembers.add(caseStakeHolderMember);
                }
                caseStakeHolderMembers.removeAll(emptyCaseStakeHolderMembers);
                if (caseStakeHolderMembers.size() != 0) continue;
                emptyCaseStakeHolders.add(caseStakeHolder);
            }
            if (!emptyCaseStakeHolders.isEmpty()) {
                caseStakeHolders.removeAll(emptyCaseStakeHolders);
            }
        }
        if ((caseMilestones = caseInstance.getCaseMilestones()) != null && !caseMilestones.isEmpty()) {
            ArrayList<CaseMilestone> emptyCaseMilestones = new ArrayList<CaseMilestone>();
            for (CaseMilestone caseMilestone : caseMilestones) {
                if (caseMilestone.getObjectName() != null && caseMilestone.getObjectName().length() != 0) continue;
                emptyCaseMilestones.add(caseMilestone);
            }
            if (!emptyCaseMilestones.isEmpty()) {
                caseMilestones.removeAll(emptyCaseMilestones);
            }
        }
        if ((caseDataList = caseInstance.getCaseData()) != null && !caseDataList.isEmpty()) {
            ArrayList<CaseData> emptyCaseDataList = new ArrayList<CaseData>();
            for (CaseData caseData : caseDataList) {
                if (caseData.getObjectName() == null || caseData.getObjectName().length() == 0) {
                    emptyCaseDataList.add(caseData);
                }
                if (caseData.getExternal() || caseData.getData() != null && caseData.getData().length() != 0) continue;
                emptyCaseDataList.add(caseData);
            }
            if (!emptyCaseDataList.isEmpty()) {
                caseDataList.removeAll(emptyCaseDataList);
            }
        }
        if (caseInstance.getComments() != null) {
            ArrayList<Comment> emptyCaseComments = new ArrayList<Comment>();
            for (Comment comment : caseInstance.getComments()) {
                if (comment.getCaseObjectComment() != null && comment.getCaseObjectComment().length() != 0) continue;
                emptyCaseComments.add(comment);
            }
            if (!emptyCaseComments.isEmpty()) {
                caseInstance.getComments().removeAll(emptyCaseComments);
            }
        }
    }

    private void setAttributesFromCaseMetadata(IBPMContext ctx, Case caseInstance, Calendar currentTime) throws Exception {
        try {
            ICaseIdentityService identityService = ServicesLocator.getCaseIdentityService();
            ICaseMetadataService caseMetadataService = ServicesLocator.getCaseMetadataService();
            CaseMetadata caseMetadata = caseMetadataService.getCaseMetadata(ctx, caseInstance.getCaseHeader().getCaseDefinitionId());
            if (caseMetadata == null) {
                return;
            }
            TCaseMetadata caseMetadataType = (TCaseMetadata)caseMetadata.getValue();
            if (caseMetadataType.getCategory() != null) {
                CaseMetadataCache cache = CaseMetadataCache.getInstance();
                String categoryDisplayName = cache.getDisplayValue(caseInstance.getCaseHeader().getCaseDefinitionId(), (Object)caseMetadataType.getCategory().getName(), caseInstance, Locale.getDefault());
                caseInstance.getCaseHeader().setCategory(categoryDisplayName);
                caseInstance.getCaseHeader().setCategoryDisplayName(categoryDisplayName);
            }
            caseInstance.getCaseHeader().setObjectName(caseMetadataType.getName());
            caseInstance.getCaseHeader().setObjectDisplayName(CaseServiceUtil.lookupMetadataResourceBundle(ctx, caseInstance.getCaseHeader().getCaseDefinitionId(), caseMetadataType.getName()));
            caseInstance.getCaseHeader().setCaseNamespace(caseMetadataType.getTargetNamespace());
            if (caseInstance.getCaseHeader().getPriority() == 0) {
                caseInstance.getCaseHeader().setPriority(caseMetadataType.getPriority().intValue());
            }
            if (caseInstance.getCaseHeader().getPriority() == 0) {
                caseInstance.getCaseHeader().setPriority(ICaseConstants.CASE_PRIORITY_DEFAULT_VALUE);
            }
            caseInstance.getCaseHeader().setCaseDefinitionName(caseMetadataType.getName());
            TStakeHolders stakeHolders = caseMetadataType.getStakeHolders();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("stakeHolders:" + stakeHolders));
            SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder caseDefinitionIdHolder = new SetCaseObjectDefaultValuesAdvice.CaseDefinitionIdHolder();
            caseDefinitionIdHolder.caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
            CaseIdentifier caseIdentifier = CaseIdentifier.getCaseIdentifierBasedOnCaseId((String)caseInstance.getCaseId());
            if (stakeHolders != null) {
                List stakeHoldersList = stakeHolders.getStakeHolder();
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("stakeHoldersList.size():" + stakeHoldersList.size()));
                if (stakeHoldersList != null && !stakeHoldersList.isEmpty()) {
                    List caseStakeHolders = caseInstance.getCaseStakeHolders();
                    this.doesCaseStakeHolderExistInCaseInstance(caseStakeHolders, stakeHoldersList, caseDefinitionIdHolder.caseDefinitionId);
                    Map swimlaneRoleToAppRole = null;
                    for (TStakeHolder stakeHolder : stakeHoldersList) {
                        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("stakeHolder:" + stakeHolder));
                        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("stakeHolder:" + stakeHolder.getName()));
                        boolean newStakeHolder = false;
                        CaseStakeHolder caseStakeHolder = this.getExistingStakeHolderFromCaseInstance(stakeHolder.getName(), caseStakeHolders);
                        if (caseStakeHolder == null) {
                            newStakeHolder = true;
                            caseStakeHolder = new CaseStakeHolder();
                        }
                        caseStakeHolder.setObjectName(stakeHolder.getName());
                        SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues(identityService, caseMetadataService, this, ctx, caseIdentifier, caseDefinitionIdHolder, caseInstance, (CaseObject)caseStakeHolder, currentTime);
                        if (stakeHolder.getPermissionMemberRole() != null) {
                            caseStakeHolder.setPermissionMemberRole(stakeHolder.getPermissionMemberRole().getValue());
                            caseStakeHolder.setApplicationContext(stakeHolder.getPermissionMemberRole().getApplicationContext());
                            if (CaseServiceUtil.isNotNullAndEmpty(caseStakeHolder.getPermissionMemberRole())) {
                                CaseStakeHolderMember caseStakeHolderMember = new CaseStakeHolderMember();
                                caseStakeHolderMember.setId(CaseServiceUtil.getGUID());
                                caseStakeHolderMember.setCaseStakeHolder(caseStakeHolder);
                                caseStakeHolderMember.setStakeHolderType(TResourceIdentityType.APPLICATION_ROLE.name());
                                caseStakeHolderMember.setStakeHolder(stakeHolder.getPermissionMemberRole().getValue());
                                caseStakeHolderMember.setStakeHolderDisplayName(identityService.getApplicationRoleDisplayName(Locale.getDefault(), caseStakeHolder.getPermissionMemberRole()));
                                caseStakeHolderMember.setApplicationContext(stakeHolder.getPermissionMemberRole().getApplicationContext());
                                caseStakeHolder.addCaseStakeHolderMember(caseStakeHolderMember);
                            }
                        }
                        List resources = stakeHolder.getResource();
                        for (TResource resource : resources) {
                            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("stakeHolder:resource.getType():" + resource.getType()));
                            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("stakeHolder:resource.getValue():" + resource.getValue()));
                            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("stakeHolder:resource.getApplicationContext():" + resource.getApplicationContext()));
                            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("stakeHolder:resource.getIdentityType().name():" + resource.getIdentityType().name()));
                            if (resource.getIdentityType() == null || resource.getValue() == null || resource.getType() == null) continue;
                            CaseStakeHolderMember caseStakeHolderMember = new CaseStakeHolderMember();
                            caseStakeHolderMember.setId(CaseServiceUtil.getGUID());
                            String stakeholderResource = null;
                            stakeholderResource = resource.getType() == TStaticOrXpathType.STATIC ? resource.getValue() : CaseServiceUtil.evaluateXPath(ctx, caseInstance, resource.getValue());
                            if (!newStakeHolder && !this.doesCaseStakeHolderMemberExistInCaseInstance(caseStakeHolder, resource.getIdentityType().name(), stakeholderResource)) continue;
                            if (TResourceIdentityType.PROCESS_ROLE == resource.getIdentityType()) {
                                if (swimlaneRoleToAppRole == null) {
                                    swimlaneRoleToAppRole = DeploymentDescriptorUtil.getProcessRoles((String)caseInstance.getCaseHeader().getCompositeDn());
                                }
                                String stakeholderAppRole = (String)swimlaneRoleToAppRole.get(stakeholderResource);
                                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)(stakeholderResource + " mapped to " + stakeholderAppRole));
                                if (stakeholderAppRole == null || stakeholderAppRole.length() == 0) continue;
                                stakeholderResource = stakeholderAppRole;
                                caseStakeHolderMember.setStakeHolderType(TResourceIdentityType.APPLICATION_ROLE.name());
                                caseStakeHolderMember.setStakeHolder(stakeholderResource);
                                caseStakeHolderMember.setApplicationContext("OracleBPMProcessRolesApp");
                                caseStakeHolderMember.setStakeHolderDisplayName(identityService.getApplicationRoleDisplayName(Locale.getDefault(), stakeholderResource));
                            } else {
                                caseStakeHolderMember.setStakeHolderType(resource.getIdentityType().name());
                            }
                            caseStakeHolderMember.setApplicationContext(resource.getApplicationContext());
                            caseStakeHolderMember.setStakeHolder(stakeholderResource);
                            String stakeholderResourceDisplayName = stakeholderResource;
                            resource.getIdentityType();
                            if (TResourceIdentityType.USER == resource.getIdentityType()) {
                                caseStakeHolderMember.setStakeHolderDisplayName(identityService.getUserDisplayName(Locale.getDefault(), stakeholderResource));
                            } else {
                                resource.getIdentityType();
                                if (TResourceIdentityType.GROUP == resource.getIdentityType()) {
                                    caseStakeHolderMember.setStakeHolderDisplayName(identityService.getGroupDisplayName(Locale.getDefault(), stakeholderResource));
                                } else {
                                    resource.getIdentityType();
                                    if (TResourceIdentityType.APPLICATION_ROLE == resource.getIdentityType()) {
                                        caseStakeHolderMember.setStakeHolderDisplayName(identityService.getApplicationRoleDisplayName(Locale.getDefault(), stakeholderResource));
                                    } else {
                                        caseStakeHolderMember.setStakeHolderDisplayName(stakeholderResourceDisplayName);
                                    }
                                }
                            }
                            caseStakeHolderMember.setCaseStakeHolder(caseStakeHolder);
                            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Newly created caseStakeHolderMember:" + caseStakeHolderMember));
                            caseStakeHolder.addCaseStakeHolderMember(caseStakeHolderMember);
                        }
                        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Newly created caseStakeHolder:" + caseStakeHolder));
                        if (!newStakeHolder) continue;
                        caseStakeHolders.add(caseStakeHolder);
                    }
                }
            }
            TMilestones milestones = caseMetadataType.getMilestones();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("milestones:" + milestones));
            if (milestones != null) {
                List milestonesList = milestones.getMilestone();
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("milestonesList:" + milestonesList));
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("milestonesList.size():" + milestonesList.size()));
                if (milestonesList != null && !milestonesList.isEmpty()) {
                    List caseMilestones = caseInstance.getCaseMilestones();
                    for (TMilestone milestone : milestonesList) {
                        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("milestone:" + milestone));
                        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("milestone:" + milestone.getName()));
                        CaseMilestone caseMilestone = new CaseMilestone();
                        caseMilestone.setObjectName(milestone.getName());
                        caseMilestone.setObjectDisplayName(milestone.getName());
                        caseMilestone.setState(ICaseConstants.CaseMilestoneState.NOT_ATTAINED.name());
                        SetCaseObjectDefaultValuesAdvice.setCaseObjectDefaultValues(identityService, caseMetadataService, this, ctx, caseIdentifier, caseDefinitionIdHolder, caseInstance, (CaseObject)caseMilestone, currentTime);
                        caseMilestones.add(caseMilestone);
                        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Newly created caseMilestone:" + caseMilestone));
                    }
                }
            }
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"Exception while fetching the case metadata to default case attributes");
            throw e;
        }
    }

    private Case getCaseWithAddtionalCaseInfo(IBPMContext context, Case caseInstance, List<ICaseConstants.CaseInfo> additionalCaseInfo, String userName, String locale, List<BPMIdentity> userAppRoleList, List<BPMIdentity> userGroupList, boolean internalCall, boolean readOnly) throws CasePersistenceException, CaseServiceException {
        if (caseInstance == null) {
            return null;
        }
        if (additionalCaseInfo == null) {
            additionalCaseInfo = new ArrayList<ICaseConstants.CaseInfo>();
        }
        if (additionalCaseInfo.contains(ICaseConstants.CaseInfo.ALL)) {
            CaseObjectUtil.populateAll((IBPMContext)context, (Case)caseInstance);
        } else {
            if (additionalCaseInfo.contains(ICaseConstants.CaseInfo.MILESTONE)) {
                CaseObjectUtil.populateCaseMilestones((Case)caseInstance);
            }
            if (additionalCaseInfo.contains(ICaseConstants.CaseInfo.STAKEHOLDER)) {
                CaseObjectUtil.populateCaseStakeHolders((Case)caseInstance);
            }
            if (additionalCaseInfo.contains(ICaseConstants.CaseInfo.COMMENT)) {
                CaseObjectUtil.populateComments((Case)caseInstance);
            }
            if (additionalCaseInfo.contains(ICaseConstants.CaseInfo.DATA)) {
                CaseObjectUtil.populateCaseData((Case)caseInstance);
            }
            if (additionalCaseInfo.contains(ICaseConstants.CaseInfo.FABRIC_HEADER_PROPERTIES)) {
                CaseObjectUtil.populateCaseFabricHeaderProperty((Case)caseInstance);
            }
        }
        if (internalCall || !readOnly) {
            return caseInstance;
        }
        Case caseClone = CaseObjectUtil.getCaseClone((Case)caseInstance);
        if (additionalCaseInfo.contains(ICaseConstants.CaseInfo.ALL)) {
            CaseServiceUtil.populateExternalCaseData(context, caseClone);
            CaseServiceUtil.populateIsUserInRole(userName, userAppRoleList, userGroupList, caseClone.getCaseStakeHolders());
            this.populateAdditionalCaseDataInfo(context, caseClone);
            this.populateAdditionalCaseSummaryFormURI(context, caseClone);
        } else {
            if (additionalCaseInfo.contains(ICaseConstants.CaseInfo.STAKEHOLDER)) {
                CaseServiceUtil.populateIsUserInRole(userName, userAppRoleList, userGroupList, caseClone.getCaseStakeHolders());
            }
            if (additionalCaseInfo.contains(ICaseConstants.CaseInfo.DATA)) {
                this.populateAdditionalCaseDataInfo(context, caseClone);
                if (additionalCaseInfo.contains(ICaseConstants.CaseInfo.EXTERNAL_DATA)) {
                    CaseServiceUtil.populateExternalCaseData(context, caseClone);
                }
            } else {
                CaseObjectUtil.clearCaseData((Case)caseClone);
            }
            if (!additionalCaseInfo.contains(ICaseConstants.CaseInfo.MILESTONE)) {
                CaseObjectUtil.clearCaseMilestones((Case)caseClone);
            }
            if (!additionalCaseInfo.contains(ICaseConstants.CaseInfo.COMMENT)) {
                CaseObjectUtil.clearComments((Case)caseClone);
            }
            if (!additionalCaseInfo.contains(ICaseConstants.CaseInfo.FABRIC_HEADER_PROPERTIES)) {
                CaseObjectUtil.clearCaseFabricHeaderProperty((Case)caseClone);
            }
        }
        CaseObjectUtil.removeNullChildrens((Case)caseClone);
        CaseServiceUtil.setTranslatedTitle(locale, caseClone);
        return caseClone;
    }

    private void populateAdditionalCaseSummaryFormURI(IBPMContext ctx, Case caseInstance) throws CaseServiceException {
        CaseMetadata caseMetaData = ServicesLocator.getCaseMetadataService().getCaseMetadata(ctx, caseInstance.getCaseHeader().getCaseDefinitionId());
        String caseArtifact = ((TCaseMetadata)caseMetaData.getValue()).getName();
        TCaseDisplayInfo dispInfo = CaseUtil.getCaseFormURI(ctx, caseInstance, ICaseMetadataService.FORM_TYPE.CASESUMMARYFORM, caseArtifact);
        if (dispInfo != null) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Case Summary Form URI :" + dispInfo.getUri()));
            caseInstance.getCaseHeader().setCaseSummaryFormURI(dispInfo.getUri());
        }
    }

    private void populateAdditionalCaseDataInfo(IBPMContext ctx, Case caseInstance) throws CaseServiceException {
        CaseMetadata caseMetaData = ServicesLocator.getCaseMetadataService().getCaseMetadata(ctx, caseInstance.getCaseHeader().getCaseDefinitionId());
        List<TData> tDataList = CaseUtil.getMetaDataOfCaseData(caseMetaData);
        List caseDataList = caseInstance.getCaseData();
        TCaseDisplayInfo caseDisplayInfo = null;
        if (tDataList != null && !tDataList.isEmpty()) {
            block0: for (TData tData : tDataList) {
                for (CaseData caseData : caseDataList) {
                    if (caseData == null || tData == null || !tData.getName().equals(caseData.getObjectName())) continue;
                    caseData.setCaseDataType(CaseObjectUtil.getCaseDataType((String)tData.getType()));
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Case Data type set :" + caseData.getCaseDataType()));
                    caseData.setSimpleType(tData.getDataType().equals((Object)TDataTypeEnum.SIMPLE_TYPE));
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Is Case simple type :" + caseData.isSimpleType()));
                    caseDisplayInfo = CaseUtil.getCaseFormURI(ctx, caseInstance, ICaseMetadataService.FORM_TYPE.CASEDATAFORM, tData.getName());
                    if (caseDisplayInfo == null) continue block0;
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Case Data Form URI :" + caseDisplayInfo.getUri()));
                    caseData.setCaseDataFormUrl(caseDisplayInfo.getUri());
                    continue block0;
                }
            }
        }
    }

    private CaseList getCaseWithAddtionalCaseInfo(IBPMContext context, CaseList caseList, List<ICaseConstants.CaseInfo> additionalCaseInfo, String userName, String locale, List<BPMIdentity> userAppRoleList, List<BPMIdentity> userGroupList, boolean internalCall, boolean readOnly) throws CasePersistenceException, CaseServiceException {
        ArrayList<Case> caseCloneList = new ArrayList<Case>();
        if (caseList.getCases() != null && caseList.getCases().size() > 0) {
            for (Case caseInstance : caseList.getCases()) {
                caseCloneList.add(this.getCaseWithAddtionalCaseInfo(context, caseInstance, additionalCaseInfo, userName, locale, userAppRoleList, userGroupList, internalCall, readOnly));
            }
        }
        return new CaseList(caseList.getTotalNumberOfCases(), caseList.getPageSize(), caseList.getTotalNumberOfPages(), caseList.getPageNumber(), caseCloneList);
    }

    private boolean revokeMileStone(IBPMContext context, ICasePersistence casePersistence, Case caseInstance, CaseMilestone milestoneToBeRevoked) throws CasePersistenceException, CaseServiceException {
        ICaseMetadataService caseMetadataService;
        CaseMetadata caseMetadata;
        String userName = "weblogic";
        String userDisplayName = "weblogic";
        Calendar currentTime = CaseServiceUtil.getCalendarInstance(context);
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Milestone: to be revoked" + milestoneToBeRevoked.getObjectName()));
        List caseMilestones = caseInstance.getCaseMilestones();
        if (context != null) {
            userName = context.getUser();
            userDisplayName = context.getUser();
        }
        if ((caseMetadata = (caseMetadataService = ServicesLocator.getCaseMetadataService()).getCaseMetadata(context, caseInstance.getCaseHeader().getCaseDefinitionId())) == null) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)"[CaseService] CaseMetadata is null");
            return false;
        }
        TCaseMetadata caseMetadataType = (TCaseMetadata)caseMetadata.getValue();
        TMilestones milestones = caseMetadataType.getMilestones();
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("milestones:" + milestones));
        if (milestones != null) {
            List milestonesList = milestones.getMilestone();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("milestonesList:" + milestonesList));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("milestonesList.size():" + milestonesList.size()));
            if (milestonesList != null && !milestonesList.isEmpty()) {
                for (TMilestone milestone : milestonesList) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("milestone:" + milestone));
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("milestone:" + milestone.getName()));
                    if (!milestoneToBeRevoked.getObjectName().equals(milestone.getName())) continue;
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Milestones are equal and isSoft:" + milestone.isIsSoft()));
                    if (milestone.isIsSoft()) continue;
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("Milestone:" + milestone.getName() + " isSoft=false, hence it cannot be revoked"));
                    throw new CaseServiceException(73423, new Object[]{milestone.getName()});
                }
            }
        }
        for (CaseMilestone caseMilestone : caseMilestones) {
            if (!caseMilestone.getId().equals(milestoneToBeRevoked.getId()) && !caseMilestone.getObjectName().equals(milestoneToBeRevoked.getObjectName())) continue;
            if (!ICaseConstants.CaseMilestoneState.ATTAINED.name().equals(caseMilestone.getState())) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseService] revokeMilestone : Milestone " + caseMilestone.getObjectName() + " is not attained, cannot revoke."));
                return false;
            }
            caseMilestone.setState(ICaseConstants.CaseMilestoneState.REVOKED.name());
            caseMilestone.setUpdatedBy(userName);
            caseMilestone.setUpdatedByDisplayName(userDisplayName);
            caseMilestone.setUpdatedDate(currentTime);
            if (milestoneToBeRevoked.getComment() != null) {
                caseMilestone.setComment(milestoneToBeRevoked.getComment());
                caseMilestone.getComment().setCaseObjectId(caseMilestone.getId());
                caseMilestone.getComment().setCase(caseInstance);
            }
            casePersistence.update(caseInstance);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseService] CaseMilestone updated");
            return true;
        }
        return false;
    }

    private void doesCaseStakeHolderExistInCaseInstance(List<CaseStakeHolder> caseStakeHolders, List<TStakeHolder> stakeHoldersList, String caseDefinitionId) throws CaseServiceException {
        Iterator<CaseStakeHolder> i$ = caseStakeHolders.iterator();
        if (i$.hasNext()) {
            CaseStakeHolder caseStakeHolder = i$.next();
            for (TStakeHolder tStakeHolder : stakeHoldersList) {
                if (!caseStakeHolder.getObjectName().equals(tStakeHolder.getName())) continue;
                return;
            }
            throw new CaseServiceException(73429, new Object[]{caseDefinitionId, caseStakeHolder.getObjectName()});
        }
    }

    private CaseStakeHolder getExistingStakeHolderFromCaseInstance(String stakeHolderName, List<CaseStakeHolder> caseStakeHolders) {
        try {
            for (int i = 0; i < caseStakeHolders.size(); ++i) {
                if (!stakeHolderName.equals(caseStakeHolders.get(i).getObjectName())) continue;
                return caseStakeHolders.get(i);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean doesCaseStakeHolderMemberExistInCaseInstance(CaseStakeHolder caseStakeHolder, String stakeHolderMemberType, String stakeHolderMember) {
        List caseStakeHolderMembers = caseStakeHolder.getCaseStakeHolderMembers();
        for (CaseStakeHolderMember caseStakeHolderMember : caseStakeHolderMembers) {
            if (!caseStakeHolderMember.getStakeHolder().equals(stakeHolderMember) || !caseStakeHolderMember.getStakeHolderType().equals(stakeHolderMemberType)) continue;
            return false;
        }
        return true;
    }

    static {
        CASE_INFO_MILESTONE.add(ICaseConstants.CaseInfo.MILESTONE);
        CASE_INFO_MILESTONE.add(ICaseConstants.CaseInfo.COMMENT);
        CASE_INFO_CASEDATA.add(ICaseConstants.CaseInfo.DATA);
        CASE_INFO_CASEDATA.add(ICaseConstants.CaseInfo.COMMENT);
        CASE_INFO_STAKEHOLDER.add(ICaseConstants.CaseInfo.STAKEHOLDER);
        CASE_INFO_MILESTONE.add(ICaseConstants.CaseInfo.COMMENT);
        CASE_INFO_COMMENT.add(ICaseConstants.CaseInfo.COMMENT);
    }
}

