/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseObjectsList;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseEventService;
import oracle.bpm.casemgmt.annotations.MethodPermissionMap;
import oracle.bpm.casemgmt.annotations.SetCaseObjectAction;
import oracle.bpm.casemgmt.annotations.SetCaseObjectDefaultValues;
import oracle.bpm.casemgmt.annotations.SetReturnDisplayName;
import oracle.bpm.casemgmt.annotations.ValidateAction;
import oracle.bpm.casemgmt.annotations.ValidateCaseIdentifier;
import oracle.bpm.casemgmt.annotations.ValidateContext;
import oracle.bpm.casemgmt.annotations.ValidateUserCaseAccess;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.event.CaseEventUtil;
import oracle.bpm.casemgmt.event.ICaseEventPublisher;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.metadata.event.model.TEventType;
import oracle.bpm.casemgmt.persistence.ICasePersistence;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseEventServiceImpl
implements ICaseEventService {
    @MethodPermissionMap(permission="INVOKE", permissionCaseObjectType="EVENT")
    @SetCaseObjectDefaultValues(caseObjectType="caseObject")
    @ValidateAction(caseObjectType="EVENT", action="INVOKE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean raiseCaseEvent(IBPMContext context, CaseIdentifier caseIdentifier, CaseEvent caseEvent) throws CaseServiceException {
        if (caseEvent.getLifecycleState() == null && caseEvent.getLifecycleEvent() != null) {
            caseEvent.setLifecycleState(caseEvent.getLifecycleEvent().value());
        }
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_EVENT, (Severity)Severity.DEBUG, (String)("CaseEventServiceImpl.raiseCaseEvent(): eventType=" + caseEvent.getEventType() + ", id=" + caseEvent.getId() + ", eventId=" + caseEvent.getEventId() + ", caseId=" + caseEvent.getCaseId()));
        Object entityManager = null;
        try {
            ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
            if (!caseEvent.isCommentShared() && caseEvent.getComment() != null) {
                casePersistence.persist(caseEvent.getComment());
            }
            casePersistence.persist(caseEvent);
            ICaseEventPublisher cep = ServicesLocator.getCaseEventPublisher();
            cep.publish(context, caseIdentifier, caseEvent);
            ICaseEventPublisher ceEdnPub = ServicesLocator.getCaseEventEDNPublisher();
            ceEdnPub.publish(context, caseIdentifier, caseEvent);
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73200, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_EVENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"raiseCaseEvent", (Throwable)cse);
            throw cse;
        }
        return true;
    }

    @MethodPermissionMap(permission="INVOKE", permissionCaseObjectType="EVENT")
    @SetCaseObjectAction
    @SetReturnDisplayName
    @ValidateCaseIdentifier
    @ValidateContext
    @ValidateUserCaseAccess
    public CaseObjectsList getAudit(IBPMContext context, CaseIdentifier caseIdentifier, TEventType eventType, String updatedBy, int pageSize, int pageNumber) throws CaseServiceException {
        return this.queryCaseEvent(context, caseIdentifier, eventType, null, updatedBy, pageSize, pageNumber, null);
    }

    @MethodPermissionMap(permission="INVOKE", permissionCaseObjectType="EVENT")
    @SetCaseObjectAction
    @SetReturnDisplayName
    @ValidateCaseIdentifier
    @ValidateContext
    @ValidateUserCaseAccess
    public CaseObjectsList queryCaseEvent(IBPMContext context, CaseIdentifier caseIdentifier, TEventType eventType, String searchString, String updatedBy, int pageSize, int pageNumber, List<ICaseConstants.CaseEventInfo> additionalCaseEventInfo) throws CaseServiceException {
        try {
            String searchStringByJPA = null;
            boolean contextHasDefaultLocale = false;
            if (context.getLocale() == Locale.getDefault()) {
                contextHasDefaultLocale = true;
                searchStringByJPA = searchString;
            } else {
                contextHasDefaultLocale = false;
                searchStringByJPA = null;
            }
            CaseObjectsList caseEvents = ServicesLocator.getCaseEventPersistence().findCaseEvent(caseIdentifier.getCaseId(), eventType, searchStringByJPA, updatedBy, pageSize, pageNumber);
            ArrayList<CaseEvent> clonedEvents = new ArrayList<CaseEvent>();
            for (CaseEvent caseEvent : caseEvents.getCaseObjects()) {
                if (searchString != null && !contextHasDefaultLocale) {
                    String eventDisplayName = CaseEventUtil.getEventDisplayName(context, caseEvent);
                    caseEvent.setObjectDisplayName(eventDisplayName);
                    if (!this.searchEvent(caseEvent, searchString)) continue;
                }
                caseEvent.getPropertyBagCollection().size();
                String instanceId = ServicesLocator.getInternalCaseService().getInstanceIdFromEvent(caseIdentifier.getCaseId(), caseEvent);
                if (instanceId != null) {
                    caseEvent.setActivityId(instanceId);
                }
                CaseEvent clonedEvent = caseEvent.clone();
                if (caseEvent.getComment() != null) {
                    clonedEvent.setComment(caseEvent.getComment().clone());
                }
                clonedEvents.add(clonedEvent);
                if (additionalCaseEventInfo == null || additionalCaseEventInfo.size() <= 0) continue;
                for (ICaseConstants.CaseEventInfo caseEventInfo : additionalCaseEventInfo) {
                    switch (caseEventInfo) {
                        case taskInfo: {
                            clonedEvent.setTaskInfo(context);
                            break;
                        }
                    }
                }
            }
            CaseObjectsList clonedCaseEvents = new CaseObjectsList(caseEvents.getTotalNumberOfCaseObjects(), caseEvents.getPageSize(), caseEvents.getTotalNumberOfPages(), caseEvents.getPageNumber(), clonedEvents);
            return clonedCaseEvents;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73201, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_EVENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getAudit", (Throwable)cse);
            throw cse;
        }
    }

    private boolean searchEvent(CaseEvent ce, String searchString) {
        boolean found = false;
        block7: for (CaseEventUtil.CaseEventStringSearchField searchStringField : CaseEventUtil.CaseEventStringSearchField.values()) {
            switch (searchStringField) {
                case object_display_name: {
                    found = this.find(ce.getObjectDisplayName(), searchString);
                    if (!found) continue block7;
                    return true;
                }
                case case_id: {
                    found = this.find(ce.getCaseId(), searchString);
                    if (!found) continue block7;
                    return true;
                }
                case commentEventComment: {
                    found = this.find(ce.getCommentEventComment(), searchString);
                    if (!found) continue block7;
                    return true;
                }
                case updated_by_display_name: {
                    found = this.find(ce.getUpdatedByDisplayName(), searchString);
                    if (!found) continue block7;
                    return true;
                }
                case updated_date: {
                    found = this.find(ce.getUpdatedDate().toString(), searchString);
                    if (!found) continue block7;
                    return true;
                }
                default: {
                    found = false;
                }
            }
        }
        return found;
    }

    private boolean find(String string, String searchString) {
        return string != null && string.contains(searchString);
    }
}

