/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.impl;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.ecm.api.ContentObjectFactory;
import oracle.bpel.services.workflow.ecm.api.DocumentObject;
import oracle.bpel.services.workflow.ecm.api.IContentObject;
import oracle.bpm.casemgmt.CaseDocumentObject;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseDocumentStreamService;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.annotations.RaiseEvent;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.metadata.event.model.TDocumentEvent;
import oracle.bpm.casemgmt.persistence.factory.CaseEventFactory;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseDocumentStreamService
implements ICaseDocumentStreamService {
    @RaiseEvent(eventType="DOCUMENT_EVENT", documentEventType="ADDED", lifecycleEventType="NA", milestoneEventType="NA")
    public boolean uploadDocument(IBPMContext pContext, CaseIdentifier caseIdentifier, String docName, String mimeType, InputStream inputStream, String comments, String permissionTag) throws CaseServiceException {
        boolean result = false;
        IBPMContext context = null;
        try {
            String permissionTagDocAttributeName = DocumentObject.getEMPermissionTagAttributeName();
            String permissionTagValue = permissionTag == null ? "" : permissionTag;
            context = CaseServiceUtil.validateContext(pContext);
            ICaseService caseService = ServicesLocator.getCaseService();
            Set permissionTagsUserCanUse = caseService.getPermissionTagsUserCanUse(pContext, caseIdentifier, ICaseConstants.CaseObjectPermissionType.UPDATE, ICaseConstants.CaseObjectType.DOCUMENT);
            if (permissionTag != null && !permissionTagsUserCanUse.contains(permissionTag)) {
                throw new Exception("Invalid permissionTag: " + permissionTag);
            }
            CaseServiceUtil.validateAction(context, caseIdentifier, ICaseConstants.CaseObjectPermissionType.UPDATE, ICaseConstants.CaseObjectType.DOCUMENT, permissionTag);
            HashMap<String, String> docMetadataMap = new HashMap<String, String>();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_DOCUMENT, (Severity)Severity.DEBUG, (String)("Setting document metadata: name = " + permissionTagDocAttributeName + ", value = " + permissionTagValue));
            docMetadataMap.put(permissionTagDocAttributeName, permissionTagValue);
            docMetadataMap.put("dDocLastModifier", context.getUser());
            docMetadataMap.put("dDocCreator", context.getUser());
            docMetadataMap.put("caseId", caseIdentifier.getCaseId());
            IContentObject contentObject = ContentObjectFactory.getContentObject();
            Object uploadResult = contentObject.createDocument(CaseDocumentObject.getFolder((IBPMContext)context, (CaseIdentifier)caseIdentifier), docName, mimeType, null, inputStream, comments, docMetadataMap);
            if (uploadResult != null && uploadResult instanceof String) {
                result = true;
                String documentId = (String)uploadResult;
                CaseEvent ce = CaseEventFactory.createCaseDocumentEvent((TDocumentEvent)TDocumentEvent.ADDED, (String)docName, null, (String)documentId, null, null);
                caseService.raiseCaseEvent(context, caseIdentifier, ce);
            }
            return result;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73802, new Object[]{docName}, (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_DOCUMENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"uploadDocument", (Throwable)cse);
            throw cse;
        }
    }

    public InputStream downloadDocument(IBPMContext pContext, CaseIdentifier caseIdentifier, String docName) throws CaseServiceException {
        IBPMContext context = null;
        try {
            context = CaseServiceUtil.validateContext(pContext);
            IContentObject contentObject = ContentObjectFactory.getContentObject();
            String docPath = CaseDocumentObject.getDocumentPath((IBPMContext)context, (CaseIdentifier)caseIdentifier, (String)docName);
            String permissionTag = CaseServiceUtil.getPermissionTag(pContext, caseIdentifier, docName);
            CaseServiceUtil.validateAction(context, caseIdentifier, ICaseConstants.CaseObjectPermissionType.READ, ICaseConstants.CaseObjectType.DOCUMENT, permissionTag);
            return contentObject.getDocContentStream(docPath);
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73803, new Object[]{docName}, (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_DOCUMENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"downloadDocument", (Throwable)cse);
            throw cse;
        }
    }
}

