/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.ecm.api.ContentObjectFactory;
import oracle.bpel.services.workflow.ecm.api.DocumentObject;
import oracle.bpel.services.workflow.ecm.api.IContentObject;
import oracle.bpel.services.workflow.ecm.api.IDocumentObject;
import oracle.bpm.casemgmt.CaseDocumentObject;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseDocumentService;
import oracle.bpm.casemgmt.IInternalCaseService;
import oracle.bpm.casemgmt.annotations.MethodPermissionMap;
import oracle.bpm.casemgmt.annotations.RaiseEvent;
import oracle.bpm.casemgmt.annotations.SetCaseObjectAction;
import oracle.bpm.casemgmt.annotations.ValidateAction;
import oracle.bpm.casemgmt.annotations.ValidateContext;
import oracle.bpm.casemgmt.annotations.ValidateUserCaseAccess;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TECMFolder;
import oracle.bpm.casemgmt.metadata.common.model.TStaticOrXPath;
import oracle.bpm.casemgmt.metadata.common.model.TStaticOrXpathType;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseDocumentServiceImpl
implements ICaseDocumentService {
    public static String createCaseFolder(IBPMContext context, Case caseInstance, Case caseClone) throws CaseServiceException {
        boolean isDBStore;
        IContentObject contentObject;
        String caseInstanceFolder;
        String parentFolder;
        TECMFolder ecmFolder;
        String caseFolder;
        block21: {
            TStaticOrXPath caseInstanceFolderStaticOrXPath;
            caseFolder = caseClone.getCaseHeader().getEcmFolder();
            if (caseFolder != null) {
                return caseFolder;
            }
            String caseDefId = caseClone.getCaseHeader().getCaseDefinitionId();
            CaseMetadata caseMetadata = null;
            caseMetadata = ServicesLocator.getCaseMetadataService().getCaseMetadata(context, caseDefId);
            if (caseMetadata == null) {
                return null;
            }
            ecmFolder = ((TCaseMetadata)caseMetadata.getValue()).getEcmFolder();
            if (ecmFolder == null) {
                return null;
            }
            parentFolder = null;
            caseInstanceFolder = null;
            contentObject = ContentObjectFactory.getContentObject();
            isDBStore = contentObject instanceof IInternalCaseService;
            TStaticOrXPath parentFolderStaticOrXPath = ecmFolder.getParentFolder();
            if (parentFolderStaticOrXPath == null) {
                if (!isDBStore) {
                    throw new CaseServiceException(73805, null);
                }
            } else {
                block20: {
                    if (parentFolderStaticOrXPath.getType() == TStaticOrXpathType.STATIC) {
                        parentFolder = parentFolderStaticOrXPath.getValue();
                    } else {
                        try {
                            parentFolder = CaseServiceUtil.evaluateXPath(context, caseClone, parentFolderStaticOrXPath.getValue());
                        }
                        catch (CaseServiceException cse) {
                            if (isDBStore) break block20;
                            throw new CaseServiceException(73807, null, (Throwable)cse);
                        }
                    }
                }
                if ((parentFolder == null || parentFolder.equals("")) && !isDBStore) {
                    throw new CaseServiceException(73805, null);
                }
            }
            if ((caseInstanceFolderStaticOrXPath = ecmFolder.getCaseInstanceFolder()) == null) {
                if (!isDBStore) {
                    throw new CaseServiceException(73806, null);
                }
            } else if (caseInstanceFolderStaticOrXPath.getType() == TStaticOrXpathType.STATIC) {
                caseInstanceFolder = caseInstanceFolderStaticOrXPath.getValue();
            } else {
                try {
                    caseInstanceFolder = CaseServiceUtil.evaluateXPath(context, caseClone, caseInstanceFolderStaticOrXPath.getValue());
                }
                catch (CaseServiceException cse) {
                    if (isDBStore) break block21;
                    throw new CaseServiceException(73807, null, (Throwable)cse);
                }
            }
        }
        if ((caseInstanceFolder == null || caseInstanceFolder.equals("")) && !isDBStore) {
            throw new CaseServiceException(73806, null);
        }
        caseFolder = parentFolder + "/" + caseInstanceFolder;
        if (ecmFolder.isCreateSubFolderOnCaseInstanceCreation()) {
            contentObject.createFolder(caseFolder);
        }
        caseInstance.getCaseHeader().setEcmFolder(caseFolder);
        return caseFolder;
    }

    public static CaseDocumentObject createCaseDocumentObject(IDocumentObject documentObject, String caseId) {
        CaseDocumentObject cdo = new CaseDocumentObject();
        cdo.setDocStoreType(documentObject.getDocStoreType());
        cdo.setObjectType(documentObject.getObjectType());
        cdo.setId(documentObject.getDocId());
        cdo.setObjectName(documentObject.getDocName());
        cdo.setObjectDisplayName(documentObject.getDocDisplayName());
        cdo.setUpdatedBy(documentObject.getDocUpdatedBy());
        cdo.setUpdatedByDisplayName(documentObject.getDocUpdatedBy());
        cdo.setUpdatedDate(documentObject.getDocUpdatedDate());
        cdo.setPermissionTagAttributeName(documentObject.getPermissionTagAttributeName());
        cdo.setPermissionTag(documentObject.getPermissionTag());
        cdo.setFolder(documentObject.getFolder());
        cdo.setDocSize(documentObject.getDocSize());
        cdo.setDocVersion(documentObject.getDocVersion());
        cdo.setDocComment(documentObject.getDocComment());
        cdo.setCaseId(caseId);
        return cdo;
    }

    public static void setPermissionTag(IBPMContext context, CaseIdentifier caseIdentifier, CaseDocumentObject caseDocObject, String permissionTag) throws Exception {
        String folder = caseDocObject.getFolder();
        String docName = caseDocObject.getObjectName();
        HashMap<String, String> docMetadataMap = new HashMap<String, String>();
        docMetadataMap.put(DocumentObject.getEMPermissionTagAttributeName(), permissionTag);
        IContentObject contentObject = ContentObjectFactory.getContentObject();
        contentObject.updateProperties(folder, docName, docMetadataMap);
    }

    @MethodPermissionMap(permission="READ", permissionCaseObjectType="DOCUMENT")
    @SetCaseObjectAction
    @ValidateContext
    @ValidateUserCaseAccess
    public List<CaseDocumentObject> listDocuments(IBPMContext context, CaseIdentifier caseIdentifier) throws CaseServiceException {
        try {
            Case caseInstance = ServicesLocator.getInternalCaseService().getCase(context, caseIdentifier, null);
            IContentObject contentObject = ContentObjectFactory.getContentObject();
            ArrayList<CaseDocumentObject> caseDocObjects = new ArrayList<CaseDocumentObject>();
            String caseFolder = CaseDocumentObject.getFolder((IBPMContext)context, (CaseIdentifier)caseIdentifier);
            List docObjects = contentObject.listObjects(caseFolder);
            for (IDocumentObject docObject : docObjects) {
                caseDocObjects.add(CaseDocumentServiceImpl.createCaseDocumentObject(docObject, caseInstance.getCaseId()));
            }
            return caseDocObjects;
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73800, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_DOCUMENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"listDocuments", (Throwable)cse);
            throw cse;
        }
    }

    @MethodPermissionMap(permission="UPDATE", permissionCaseObjectType="DOCUMENT")
    @RaiseEvent(eventType="DOCUMENT_EVENT", documentEventType="DELETED", lifecycleEventType="NA", milestoneEventType="NA")
    @ValidateAction(caseObjectType="DOCUMENT", action="UPDATE")
    @ValidateContext
    public boolean deleteDocument(IBPMContext context, CaseIdentifier caseIdentifier, CaseDocumentObject caseDocObj, boolean allVersions) throws CaseServiceException {
        boolean result = false;
        try {
            IContentObject contentObject = ContentObjectFactory.getContentObject();
            String docPath = caseDocObj.getDocumentPath(context, caseIdentifier);
            result = contentObject.deleteDocument(docPath, allVersions);
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73801, new Object[0], (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(context, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_DOCUMENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"deleteDocument", (Throwable)cse);
            throw cse;
        }
        return result;
    }
}

