/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.config.CustomizationsClassloader;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.task.impl.TaskUtil;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseActivityService;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.IInternalCaseService;
import oracle.bpm.casemgmt.annotations.MethodPermissionMap;
import oracle.bpm.casemgmt.annotations.SetCaseActivityAction;
import oracle.bpm.casemgmt.annotations.SetReturnDisplayName;
import oracle.bpm.casemgmt.annotations.ValidateAction;
import oracle.bpm.casemgmt.annotations.ValidateAdminContext;
import oracle.bpm.casemgmt.annotations.ValidateCaseIdentifier;
import oracle.bpm.casemgmt.annotations.ValidateContext;
import oracle.bpm.casemgmt.annotations.ValidateUserCaseAccess;
import oracle.bpm.casemgmt.caseactivity.ActivityListingUtil;
import oracle.bpm.casemgmt.caseactivity.CaseActivityException;
import oracle.bpm.casemgmt.caseactivity.CaseActivityUtil;
import oracle.bpm.casemgmt.caseactivity.ICaseActivityCallback;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityAttrib;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityAttribPK;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityDefinition;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.fabric.CaseSEException;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.metadata.activity.model.CaseActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TBpmnActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TCaseActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TCaseDataInput;
import oracle.bpm.casemgmt.metadata.activity.model.TComponentInfo;
import oracle.bpm.casemgmt.metadata.activity.model.TCustomActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TGlobalActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TInputParameter;
import oracle.bpm.casemgmt.metadata.activity.model.TInputs;
import oracle.bpm.casemgmt.metadata.activity.model.TOutput;
import oracle.bpm.casemgmt.metadata.activity.model.TOutputParameter;
import oracle.bpm.casemgmt.metadata.activity.model.TOutputParameters;
import oracle.bpm.casemgmt.metadata.activity.model.TOutputs;
import oracle.bpm.casemgmt.metadata.activity.model.TParameters;
import oracle.bpm.casemgmt.metadata.activity.model.TPayloadInput;
import oracle.bpm.casemgmt.metadata.activity.model.TPayloadOutput;
import oracle.bpm.casemgmt.metadata.activity.model.TSaveData;
import oracle.bpm.casemgmt.metadata.activity.model.TSaveDataAs;
import oracle.bpm.casemgmt.metadata.activity.model.TWorkflowActivity;
import oracle.bpm.casemgmt.metadata.event.model.TActivityEvent;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.ICasePersistence;
import oracle.bpm.casemgmt.persistence.activity.ICaseActivityPersistence;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.fabric.common.NormalizedMessage;
import oracle.fabric.common.NormalizedMessageImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CaseActivityServiceImpl
implements ICaseActivityService {
    private static final String CUSTOM = "CUSTOM";
    private static final String BPMN = "BPMN";
    private static final String HWF = "HWF";
    private static final String BPMN_PARAMETERS = "parameters";
    private static final String HWF_PAYLOAD = "payload";
    private static final String CORRELATION_ID = "correlationId";
    private static final String TASK_NS = "http://xmlns.oracle.com/bpel/workflow/task";

    @MethodPermissionMap(permission="INVOKE", permissionCaseObjectType="ACTIVITY")
    @SetCaseActivityAction
    @SetReturnDisplayName
    @ValidateCaseIdentifier
    @ValidateContext
    @ValidateUserCaseAccess
    public List<CaseActivityDefinition> getActivatableCaseActivities(IBPMContext context, CaseIdentifier caseIdentifier) throws CaseServiceException {
        String methodName = "getActivatableCaseActivities";
        String caseId = caseIdentifier.getCaseId();
        this.logStartOfMethod(methodName, "Case Id is: " + caseId);
        try {
            ArrayList<CaseActivityDefinition> caseActivities = new ArrayList<CaseActivityDefinition>();
            ICaseActivityPersistence persistence = ServicesLocator.getCaseActivityPersistence();
            caseActivities.addAll(persistence.getAllInstanceActivities(caseId));
            caseActivities.addAll(persistence.getAllManualActivitiesWithoutAssociations());
            IInternalCaseService service = ServicesLocator.getInternalCaseService();
            Case caseInstance = service.getCase(context, caseIdentifier, null);
            String caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
            String categoryName = caseInstance.getCaseHeader().getCategory();
            caseActivities.addAll(persistence.getAllManualActivitiesForCase(caseDefinitionId));
            List<CaseActivityDefinition> categoryActivities = persistence.getAllManualActivitiesForCategory(categoryName);
            caseActivities.addAll(CaseActivityUtil.excludeDuplicateCaseActivityDefinition(categoryActivities, caseDefinitionId));
            ArrayList<CaseActivityDefinition> removedActivities = new ArrayList<CaseActivityDefinition>();
            for (CaseActivityDefinition caseActDef : caseActivities) {
                if (service.canInitiateActivity(context, caseId, caseActDef.getDefinitionId(), ICaseConstants.ActivityFilterType.AVAILABLE)) continue;
                removedActivities.add(caseActDef);
            }
            caseActivities.removeAll(removedActivities);
            ActivityListingUtil.getInstance().populateActivityAttributes(caseId, caseActivities);
            ActivityListingUtil.getInstance().setCaseActivityForm(context, caseInstance, caseActivities);
            this.logCaseActivities(methodName, caseActivities, "Printing the library:");
            this.logEndOfMethod(methodName, "Case Id is: " + caseId);
            return this.cloneActivities(caseActivities);
        }
        catch (CasePersistenceException e) {
            throw new CaseServiceException(74000, new Object[]{caseId}, (Throwable)((Object)e));
        }
        catch (BPMException e1) {
            throw new CaseServiceException(74000, new Object[]{caseId}, (Throwable)e1);
        }
    }

    @MethodPermissionMap(permission="INVOKE", permissionCaseObjectType="ACTIVITY")
    @SetCaseActivityAction
    @SetReturnDisplayName
    @ValidateCaseIdentifier
    @ValidateContext
    @ValidateUserCaseAccess
    public List<CaseActivityDefinition> getCaseActivities(IBPMContext context, CaseIdentifier caseIdentifier, ICaseConstants.ActivityFilterType filter, String orderBy, ICaseConstants.ActivitySortOrder sortOrder, List<ICaseConstants.ActivityOptionalInfo> optionalInfo, String additionalJPQLWhereClause) throws CaseServiceException {
        String caseId = caseIdentifier.getCaseId();
        Case caseInstance = ServicesLocator.getInternalCaseService().getCase(context, caseIdentifier, null);
        ArrayList<CaseActivityDefinition> caseActivities = new ArrayList();
        try {
            caseActivities = ActivityListingUtil.getInstance().findCaseActivities(context, caseInstance, filter, orderBy, sortOrder, optionalInfo, additionalJPQLWhereClause);
            return this.cloneActivities(caseActivities);
        }
        catch (CasePersistenceException e) {
            throw new CaseServiceException(74000, new Object[]{caseId}, (Throwable)((Object)e));
        }
        catch (BPMException e) {
            throw new CaseServiceException(74000, new Object[]{caseId}, (Throwable)e);
        }
    }

    @MethodPermissionMap(permission="INVOKE", permissionCaseObjectType="ACTIVITY")
    @ValidateAction(caseObjectType="ACTIVITY", action="INVOKE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean initiateCaseActivity(IBPMContext context, CaseIdentifier caseIdentifier, String caseActivityDefinitionId, Map<String, Object> payload, Comment comment) throws CaseServiceException {
        String methodName = "intiateCaseActivity";
        this.debugLog(methodName, "Initiating case activity for:" + caseActivityDefinitionId);
        String caseId = caseIdentifier.getCaseId();
        String activityInstanceId = null;
        String correlationId = null;
        CaseActivityDefinition caseActivityDefinition = null;
        IInternalCaseService service = ServicesLocator.getInternalCaseService();
        try {
            service.canInitiateActivityInternal(context, caseId, caseActivityDefinitionId, ICaseConstants.ActivityFilterType.AVAILABLE);
            caseActivityDefinition = service.getCaseActivityDefinition(caseActivityDefinitionId);
            this.logStartOfMethod(methodName, "Activity name:" + caseActivityDefinition.getName());
            if (caseActivityDefinition == null) {
                throw new CaseActivityException(74001, new Object[]{caseActivityDefinitionId});
            }
            if (payload == null) {
                payload = new HashMap<String, Object>();
            }
            String activityType = caseActivityDefinition.getType();
            boolean isInvoked = false;
            activityInstanceId = null;
            correlationId = this.generateCorrelation();
            if (activityType.equalsIgnoreCase(CUSTOM)) {
                this.debugLog(methodName, "Custom activity called....");
                activityInstanceId = this.initiateCustomActivity(context, caseId, caseActivityDefinition, correlationId, payload);
                isInvoked = true;
            } else if (activityType.equalsIgnoreCase(BPMN)) {
                this.debugLog(methodName, "BPMN called ...");
                isInvoked = this.initiateBPMNActivity(context, caseId, caseActivityDefinition, correlationId, payload);
            } else if (activityType.equalsIgnoreCase(HWF)) {
                this.debugLog(methodName, "HWF called ...");
                isInvoked = this.initiateHWFActivity(context, caseId, caseActivityDefinition, correlationId, payload);
                activityInstanceId = correlationId;
            }
            if (isInvoked) {
                try {
                    if (!caseActivityDefinition.getIsRepeatable()) {
                        this.debugLog(methodName, "The activity is actually invoked. Delete the activity instance if available..");
                        ICaseActivityPersistence persistence = ServicesLocator.getCaseActivityPersistence();
                        persistence.deleteCaseActivityInstance(caseId, caseActivityDefinitionId);
                    }
                }
                catch (CasePersistenceException e) {
                    throw new CaseActivityException(74002, new Object[]{caseActivityDefinitionId, caseId}, (Throwable)((Object)e));
                }
                if (this.isSynchronous(caseActivityDefinitionId, activityType)) {
                    service.raiseCaseActivityEvent(context, caseActivityDefinition.getDefinitionId(), caseActivityDefinition.getType(), caseActivityDefinition.getName(), caseId, activityInstanceId, correlationId, TActivityEvent.COMPLETED, comment, true);
                } else {
                    service.raiseCaseActivityEvent(context, caseActivityDefinition.getDefinitionId(), caseActivityDefinition.getType(), caseActivityDefinition.getName(), caseId, activityInstanceId, correlationId, TActivityEvent.ACTIVATED, comment, false);
                }
            }
            this.logEndOfMethod(methodName, "Activity name:" + caseActivityDefinition.getName());
        }
        catch (CaseActivityException e1) {
            throw new CaseServiceException(74003, new Object[]{caseActivityDefinitionId, caseId}, (Throwable)((Object)e1));
        }
        catch (Exception e) {
            try {
                if (caseActivityDefinition != null) {
                    service.raiseCaseActivityEvent(context, caseActivityDefinition.getDefinitionId(), caseActivityDefinition.getType(), caseActivityDefinition.getName(), caseId, activityInstanceId, correlationId, TActivityEvent.FAULTED, comment, true);
                } else {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)"Case Activity Definition is null.");
                }
            }
            catch (CaseActivityException e1) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)("Unable to raise faulted event for case activity initiaition." + e1.getMessage()));
            }
            throw new CaseServiceException(74003, new Object[]{caseActivityDefinitionId, caseId}, (Throwable)e);
        }
        this.debugLog(methodName, "Case Activity completed");
        return true;
    }

    @MethodPermissionMap(permission="INVOKE", permissionCaseObjectType="ACTIVITY")
    @ValidateAdminContext
    public void registerCaseActivity(IBPMContext context, CaseActivity caseActivity) throws CaseServiceException {
        String methodName = "registerCaseActivity";
        try {
            IInternalCaseService service = ServicesLocator.getInternalCaseService();
            this.debugLog(methodName, "Registering case activity with case activity id:" + ((TCaseActivity)caseActivity.getValue()).getActivityDefinitionId());
            service.onDeployCaseActivity(context, null, caseActivity, false, false, null);
        }
        catch (Exception e) {
            throw new CaseServiceException(74017, new Object[]{((TCaseActivity)caseActivity.getValue()).getActivityDefinitionId()}, (Throwable)e);
        }
    }

    @MethodPermissionMap(permission="INVOKE", permissionCaseObjectType="ACTIVITY")
    @ValidateAction(caseObjectType="ACTIVITY", action="INVOKE")
    @ValidateContext
    public void rateActivityDefinition(IBPMContext context, String caseActivityDefinitionId, int rating) throws CaseServiceException {
    }

    @MethodPermissionMap(permission="INVOKE", permissionCaseObjectType="ACTIVITY")
    @ValidateAction(caseObjectType="ACTIVITY", action="INVOKE")
    @ValidateCaseIdentifier
    @ValidateContext
    public void rateActivityInstance(IBPMContext context, CaseIdentifier caseIdentifier, String caseActivityDefinitionId, int rating) throws CaseServiceException {
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        String caseId = caseIdentifier.getCaseId();
        if (!this.isValidRating(rating)) {
            throw new CaseServiceException(74018, new Object[]{rating, 1, 5}, null);
        }
        CaseActivityAttribPK attribPK = new CaseActivityAttribPK(caseActivityDefinitionId, caseId);
        try {
            CaseActivityAttrib oldAttrib = persistence.find(CaseActivityAttrib.class, attribPK);
            if (oldAttrib != null) {
                if (oldAttrib.getActivityRating() != rating) {
                    oldAttrib.setActivityRating(rating);
                    persistence.update(oldAttrib);
                }
            } else {
                CaseActivityAttrib newAttrib = new CaseActivityAttrib();
                newAttrib.setCaseId(caseId);
                newAttrib.setActivityDefinitionId(caseActivityDefinitionId);
                newAttrib.setActivityRating(rating);
                persistence.persist(newAttrib);
            }
        }
        catch (CasePersistenceException e) {
            throw new CaseServiceException(74020, new Object[]{caseActivityDefinitionId, rating, caseId}, (Throwable)((Object)e));
        }
    }

    @MethodPermissionMap(permission="UPDATE", permissionCaseObjectType="HEADER", caseObjectType="ACTIVITY")
    @ValidateAction(caseObjectType="HEADER", action="UPDATE")
    @ValidateCaseIdentifier
    @ValidateContext
    public boolean addWorkItem(IBPMContext context, CaseIdentifier caseIdentifier, String caseActivityDefinitionId) throws CaseServiceException {
        try {
            if (this.isUnAvailableActivity(context, caseIdentifier, caseActivityDefinitionId)) {
                String caseId = caseIdentifier.getCaseId();
                IInternalCaseService internalCaseService = ServicesLocator.getInternalCaseService();
                internalCaseService.activateActivity(caseId, caseActivityDefinitionId);
                return true;
            }
        }
        catch (CasePersistenceException e) {
            e.printStackTrace();
        }
        catch (CaseServiceException e) {
            e.printStackTrace();
        }
        catch (CaseActivityException e) {
            e.printStackTrace();
        }
        return false;
    }

    @MethodPermissionMap(permission="INVOKE", permissionCaseObjectType="ACTIVITY")
    @ValidateAction(caseObjectType="ACTIVITY", action="INVOKE")
    public void markActivityRelevance(IBPMContext context, CaseIdentifier caseIdentifier, String caseActivityDefinitionId, ICaseConstants.ActivityRelevance relevance) throws CaseServiceException {
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        String caseId = caseIdentifier.getCaseId();
        CaseActivityAttribPK attribPK = new CaseActivityAttribPK(caseActivityDefinitionId, caseId);
        try {
            CaseActivityAttrib oldAttrib = persistence.find(CaseActivityAttrib.class, attribPK);
            int relevanceInt = CaseActivityUtil.getRelevanceEnumToInt(relevance);
            if (oldAttrib != null) {
                if (oldAttrib.getActivityRating() != relevanceInt) {
                    oldAttrib.setActivityRating(relevanceInt);
                    persistence.update(oldAttrib);
                }
            } else {
                CaseActivityAttrib newAttrib = new CaseActivityAttrib();
                newAttrib.setCaseId(caseId);
                newAttrib.setActivityDefinitionId(caseActivityDefinitionId);
                newAttrib.setActivityRating(relevanceInt);
                persistence.persist(newAttrib);
            }
        }
        catch (CasePersistenceException e) {
            throw new CaseServiceException(74041, new Object[]{caseActivityDefinitionId, relevance.toString(), caseId}, (Throwable)((Object)e));
        }
    }

    private static Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = XMLUtil.getDocumentBuilderFactory();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder().newDocument();
    }

    private List<CaseActivityDefinition> cloneActivities(List<CaseActivityDefinition> caseActivities) {
        ArrayList<CaseActivityDefinition> clonedActivities = new ArrayList<CaseActivityDefinition>();
        for (CaseActivityDefinition activity : caseActivities) {
            try {
                clonedActivities.add((CaseActivityDefinition)activity.clone());
            }
            catch (CloneNotSupportedException e) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)("Unable to clone for case activity defintion." + activity.getDefinitionId() + " Activity Name: " + activity.getName() + e.getMessage()));
            }
        }
        return clonedActivities;
    }

    private boolean isUnAvailableActivity(IBPMContext context, CaseIdentifier caseIdentifier, String caseActivityDefinitionId) throws CasePersistenceException, CaseServiceException {
        String query = "select activityDefinition from CaseActivityDefinition activityDefinition where (EXISTS (select caseAssociation from activityDefinition.caseActivityInCaseDefinitionList caseAssociation where caseAssociation.caseDefinitionId = :caseDefinitionId and activityDefinition.isManual = 'Y' and activityDefinition.isConditional = 'Y' and activityDefinition.isCaseSpecific = 'Y')) AND (NOT EXISTS (select activityInstance from CaseActivityInstance activityInstance where activityInstance.caseId = :caseId and activityDefinition.definitionId = activityInstance.activityDefinitionId)) AND ((activityDefinition.definitionId = :definitionId ))";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String caseId = caseIdentifier.getCaseId();
        Case caseInstance = ServicesLocator.getInternalCaseService().getCase(context, caseIdentifier, null);
        String caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
        parameters.put("caseDefinitionId", caseDefinitionId);
        parameters.put("caseId", caseId);
        parameters.put("definitionId", caseActivityDefinitionId);
        List activityDefinitionList = persistence.findWithQuery(query, parameters);
        return activityDefinitionList != null && activityDefinitionList.size() == 1;
    }

    private boolean isSynchronous(String caseActivityDefinitionId, String activityType) throws BPMException, CaseServiceException {
        if (activityType.equalsIgnoreCase(CUSTOM)) {
            return true;
        }
        if (activityType.equalsIgnoreCase(HWF)) {
            return false;
        }
        if (activityType.equalsIgnoreCase(BPMN)) {
            ICaseService svc = ServicesLocator.getCaseService();
            IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
            CaseActivity activity = svc.getCaseActivityMetadata(ctx, caseActivityDefinitionId);
            return ((TCaseActivity)activity.getValue()).getBpmnActivity().getComponentInfo().isIsSynchronous();
        }
        return false;
    }

    private String generateCorrelation() {
        return Util.getGuid();
    }

    private boolean initiateHWFActivity(IBPMContext context, String caseId, CaseActivityDefinition caseActivityDefinition, String correlationId, Map<String, Object> payload) throws CaseServiceException, CaseActivityException {
        String methodName = "initiateHWFActivity";
        String activityDefinitionId = caseActivityDefinition.getDefinitionId();
        ICaseMetadataService service = ServicesLocator.getCaseMetadataService();
        CaseActivity caseActivity = null;
        caseActivity = service.getCaseActivityMetadata(context, activityDefinitionId);
        if (caseActivity == null) {
            return false;
        }
        TWorkflowActivity hwfActivity = ((TCaseActivity)caseActivity.getValue()).getWorkflowActivity();
        TComponentInfo componentInfo = hwfActivity.getComponentInfo();
        String referenceName = componentInfo.getReferenceName();
        String operationName = componentInfo.getOperationName();
        String namespace = componentInfo.getNamespace();
        TParameters parameters = hwfActivity.getParameters();
        try {
            String caseDefinitionId = this.getCaseDefinitionId(caseId);
            this.debugLog(methodName, "Calling HWF composite with reference name:" + referenceName + "\n" + "operation name:" + operationName + "\n" + "namespace:" + namespace + "\n" + "case definition id:" + caseDefinitionId + "\n" + "correlation id:" + correlationId + "\n" + "case id:" + caseId);
            return this.invokeHWFCompositeActivity(caseId, caseDefinitionId, referenceName, operationName, correlationId, this.createHWFInput(context, referenceName, operationName, namespace, parameters, caseId, payload));
        }
        catch (Exception e) {
            throw new CaseActivityException(74034, new Object[]{referenceName, operationName, ((TCaseActivity)caseActivity.getValue()).getActivityDefinitionId(), caseId}, e);
        }
    }

    private String getCaseDefinitionId(String caseId) throws BPMException, CaseServiceException {
        CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
        IBPMContext context = InternalBPMContext.getInternalBPMContext();
        Case caseInstance = ServicesLocator.getInternalCaseService().getCase(context, caseIdentifier, null);
        String caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
        return caseDefinitionId;
    }

    private String getCategoryName(String caseId) throws BPMException, CaseServiceException {
        CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
        IBPMContext context = InternalBPMContext.getInternalBPMContext();
        Case caseInstance = ServicesLocator.getInternalCaseService().getCase(context, caseIdentifier, null);
        String categoryName = caseInstance.getCaseHeader().getCategory();
        return categoryName;
    }

    private boolean invokeHWFCompositeActivity(String caseId, String caseDefinitionId, String referenceName, String operationName, String correlationId, Element input) throws CaseSEException, CaseServiceException {
        NormalizedMessageImpl inputNM = new NormalizedMessageImpl();
        HashMap<String, Element> payload = new HashMap<String, Element>();
        payload.put(HWF_PAYLOAD, input);
        inputNM.setPayload(payload);
        ServicesLocator.getCaseSE().setNMProperties((NormalizedMessage)inputNM, caseId, correlationId, correlationId);
        ServicesLocator.getCaseSE().requestComponent(caseDefinitionId, referenceName, operationName, (NormalizedMessage)inputNM);
        return true;
    }

    private Element createHWFInput(IBPMContext context, String referenceName, String operationName, String namespace, TParameters parameters, String caseId, Map<String, Object> payload) throws CaseActivityException {
        String methodName = "createHWFInput";
        Document document = null;
        try {
            TInputs inputs;
            document = CaseActivityServiceImpl.createDocument();
            Element input = document.createElementNS(namespace, operationName);
            Task task = this.createTask(context);
            if (parameters != null && (inputs = parameters.getInputs()) != null) {
                List parameterList = inputs.getParameter();
                boolean isPayloadPopulated = false;
                if (parameterList != null) {
                    Element payloadElement = document.createElementNS(TASK_NS, HWF_PAYLOAD);
                    int indexOfPayloadElement = -1;
                    for (TInputParameter parameter : parameterList) {
                        Element data;
                        if (parameter.getCaseDataInput() == null && parameter.getPayloadInput() != null) {
                            ++indexOfPayloadElement;
                        }
                        if ((data = this.getDataElement(caseId, parameter, payload, indexOfPayloadElement)) == null) continue;
                        payloadElement.appendChild(document.importNode(data, true));
                        isPayloadPopulated = true;
                    }
                    if (isPayloadPopulated) {
                        task.setPayloadAsElement(payloadElement);
                    }
                }
            }
            Element taskElement = TaskUtil.getInstance().toElement((Object)task);
            input.appendChild(document.importNode(taskElement, true));
            return input;
        }
        catch (Exception e) {
            throw new CaseActivityException(74036, new Object[]{referenceName, operationName, caseId}, e);
        }
    }

    private Element getDataElement(String caseId, TInputParameter parameter, Map<String, Object> payload, int indexOfPayloadElement) throws CaseActivityException {
        String methodName = "getDataElement";
        TCaseDataInput caseDataInput = parameter.getCaseDataInput();
        if (caseDataInput != null) {
            String caseDataName = caseDataInput.getCaseDataName();
            this.debugLog(methodName, "Adding parameter case data name:" + caseDataName + "\n");
            Element data = this.getCaseDataElement(caseId, caseDataName);
            return data;
        }
        TPayloadInput payloadInput = parameter.getPayloadInput();
        if (payloadInput != null) {
            String dataName = payloadInput.getActivityParamName();
            String elementName = payloadInput.getElementName();
            TSaveData saveData = payloadInput.getSaveData();
            Element data = this.getPayloadElement(dataName, elementName, payload, indexOfPayloadElement);
            if (saveData != null) {
                TSaveDataAs saveType = saveData.getSaveDataAs();
                String caseDataName = saveData.getDataName();
                if (data != null && saveType != null && caseDataName != null) {
                    this.saveData(caseId, caseDataName, data, saveType);
                    return data;
                }
            }
            return data;
        }
        return null;
    }

    private void populatePayloadInInput(String caseId, TInputParameter parameter, Map<String, Object> payload, int indexOfPayloadElement) throws CaseActivityException {
        String methodName = "populatePayloadDataElement";
        TCaseDataInput caseDataInput = parameter.getCaseDataInput();
        if (caseDataInput != null) {
            String caseDataName = caseDataInput.getCaseDataName();
            this.debugLog(methodName, "Adding parameter case data name:" + caseDataName + "\n");
            Element data = this.getCaseDataElement(caseId, caseDataName);
            payload.put(caseDataName, data);
        } else {
            TPayloadInput payloadInput = parameter.getPayloadInput();
            if (payloadInput != null) {
                String dataName = payloadInput.getActivityParamName();
                String elementName = payloadInput.getElementName();
                TSaveData saveData = payloadInput.getSaveData();
                TSaveDataAs saveType = saveData.getSaveDataAs();
                String caseDataName = saveData.getDataName();
                Element data = this.getPayloadElement(dataName, elementName, payload, indexOfPayloadElement);
                if (data != null && saveType != null && caseDataName != null) {
                    this.saveData(caseId, caseDataName, data, saveType);
                }
            }
        }
    }

    private void saveData(String caseId, String dataName, Element data, TSaveDataAs saveType) throws CaseActivityException {
        if (saveType != null && saveType.compareTo((Enum)TSaveDataAs.CASE_DATA) == 0) {
            CaseActivityUtil.uploadCaseData(dataName, data, caseId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element getPayloadElement(String dataName, String elementName, Map<String, Object> payload, int indexOfPayloadElement) throws CaseActivityException {
        Object value = payload.get(dataName);
        Document document = null;
        ArrayList elements = new ArrayList();
        if (value != null) {
            if (value instanceof Element) {
                return (Element)value;
            }
            if (!(value instanceof String)) throw new CaseActivityException(74033, new Object[]{dataName});
            try {
                document = XMLUtil.parseDocument((String)((String)value));
            }
            catch (Exception e) {
                throw new CaseActivityException(74033, new Object[]{dataName}, e);
            }
            if (document == null) return null;
            return document.getDocumentElement();
        }
        value = payload.get("ActivityInputs");
        if (value == null) throw new CaseActivityException(74032, new Object[]{dataName});
        return this.getPayloadElementFromActivityInputs(dataName, elementName, value, indexOfPayloadElement);
    }

    private Element getPayloadElementFromActivityInputs(String dataName, String elementName, Object value, int indexOfPayloadElement) throws CaseActivityException {
        Document document = null;
        ArrayList<Element> elements = new ArrayList<Element>();
        if (value instanceof String) {
            Node element = null;
            NodeList nodeList = null;
            try {
                document = XMLUtil.parseDocument((String)((String)value));
            }
            catch (Exception e) {
                throw new CaseActivityException(74033, new Object[]{dataName}, e);
            }
            if (document != null) {
                nodeList = document.getElementsByTagName("ActivityInputs").item(0).getChildNodes();
                if (nodeList != null && nodeList.getLength() > 0) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        if (nodeList.item(i).getNodeType() != 1) continue;
                        elements.add((Element)nodeList.item(i));
                    }
                    if (indexOfPayloadElement <= elements.size() - 1) {
                        element = (Element)elements.get(indexOfPayloadElement);
                    }
                }
                if (element == null || !dataName.equals(element.getLocalName()) && !elementName.equals(element.getLocalName())) {
                    throw new CaseActivityException(74033, new Object[]{dataName});
                }
                return element;
            }
        } else {
            throw new CaseActivityException(74033, new Object[]{dataName});
        }
        return null;
    }

    private Element getCaseDataElement(String caseId, String caseDataName) throws CaseActivityException {
        CaseData caseData = null;
        try {
            ICaseService caseService = ServicesLocator.getCaseService();
            CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
            IBPMContext context = InternalBPMContext.getInternalBPMContext();
            caseData = caseService.getCaseDataByName(context, caseIdentifier, caseDataName);
            String caseDataString = caseData.getData();
            Element caseDataElement = XMLUtil.parseDocumentFromXMLString((String)caseDataString).getDocumentElement();
            return caseDataElement;
        }
        catch (CaseActivityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CaseActivityException(74031, new Object[]{caseDataName, caseId}, e);
        }
    }

    private Task createTask(IBPMContext context) {
        ObjectFactory objFactory = new ObjectFactory();
        Task task = objFactory.createTask();
        this.setCreator(context, task);
        return task;
    }

    private void setCreator(IBPMContext context, Task task) {
        if (context != null && !(context instanceof InternalBPMContext)) {
            String user = context.getUser();
            task.setCreator(user);
        }
    }

    private boolean initiateBPMNActivity(IBPMContext context, String caseId, CaseActivityDefinition caseActivityDefinition, String correlationId, Map<String, Object> payload) throws CaseServiceException, ParserConfigurationException, Exception {
        String methodName = "initiateBPMNActivity";
        String activityDefinitionId = caseActivityDefinition.getDefinitionId();
        ICaseMetadataService service = ServicesLocator.getCaseMetadataService();
        CaseActivity caseActivity = null;
        caseActivity = service.getCaseActivityMetadata(context, activityDefinitionId);
        if (caseActivity == null) {
            return false;
        }
        String caseDefinitionId = this.getCaseDefinitionId(caseId);
        TBpmnActivity bpmnActivity = ((TCaseActivity)caseActivity.getValue()).getBpmnActivity();
        TComponentInfo componentInfo = bpmnActivity.getComponentInfo();
        String referenceName = componentInfo.getReferenceName();
        String operationName = componentInfo.getOperationName();
        String namespace = componentInfo.getNamespace();
        boolean isSync = componentInfo.isIsSynchronous();
        TParameters parameters = bpmnActivity.getParameters();
        this.debugLog(methodName, "Calling BPMN composite with reference name:" + referenceName + "\n" + "operation name:" + operationName + "\n" + "namespace:" + namespace + "\n" + "case definition id:" + caseDefinitionId + "\n" + "correlation id:" + correlationId + "\n" + "case id:" + caseId);
        return this.invokeBPMNCompositeActivity(caseId, caseDefinitionId, referenceName, operationName, correlationId, this.createBPMNInput(referenceName, operationName, namespace, parameters, caseId, payload), isSync, caseActivity);
    }

    private Element createBPMNInput(String referenceName, String operationName, String namespace, TParameters parameters, String caseId, Map<String, Object> payload) throws CaseActivityException {
        String methodName = "createBPMNInput";
        Document document = null;
        try {
            List parameterList;
            TInputs inputs;
            document = CaseActivityServiceImpl.createDocument();
            Element input = document.createElementNS(namespace, operationName);
            if (parameters != null && (inputs = parameters.getInputs()) != null && (parameterList = inputs.getParameter()) != null) {
                int indexOfPayloadElement = -1;
                for (TInputParameter parameter : parameterList) {
                    Element data;
                    if (parameter.getCaseDataInput() == null && parameter.getPayloadInput() != null) {
                        ++indexOfPayloadElement;
                    }
                    if ((data = this.getDataElement(caseId, parameter, payload, indexOfPayloadElement)) == null) continue;
                    input.appendChild(document.importNode(data, true));
                }
            }
            return input;
        }
        catch (Exception e) {
            throw new CaseActivityException(74037, new Object[]{referenceName, operationName, caseId}, e);
        }
    }

    private boolean invokeBPMNCompositeActivity(String caseId, String caseDefinitionId, String referenceName, String operationName, String correlationId, Element input, boolean isSync, CaseActivity caseActivity) throws CaseSEException, CaseServiceException, CaseActivityException {
        NormalizedMessageImpl inputNM = new NormalizedMessageImpl();
        HashMap<String, Element> payload = new HashMap<String, Element>();
        payload.put(BPMN_PARAMETERS, input);
        inputNM.setPayload(payload);
        ServicesLocator.getCaseSE().setNMProperties((NormalizedMessage)inputNM, caseId, correlationId, null);
        if (!isSync) {
            ServicesLocator.getCaseSE().postToComponent(caseDefinitionId, referenceName, operationName, (NormalizedMessage)inputNM);
        } else {
            NormalizedMessage outputNM = ServicesLocator.getCaseSE().requestComponent(caseDefinitionId, referenceName, operationName, (NormalizedMessage)inputNM);
            IInternalCaseService internalSvc = ServicesLocator.getInternalCaseService();
            internalSvc.populateBPMNOutput(outputNM, caseActivity, caseId);
        }
        return true;
    }

    private String initiateCustomActivity(IBPMContext context, String caseId, CaseActivityDefinition caseActivityDefinition, String correlationId, Map<String, Object> payload) throws CaseActivityException, CaseServiceException {
        ClassLoader originalClassloader;
        String className;
        block13: {
            Class<?> callbackClass;
            CaseActivity caseActivity;
            String caseActivityDefinitionId;
            block12: {
                className = caseActivityDefinition.getClassName();
                caseActivityDefinitionId = caseActivityDefinition.getDefinitionId();
                String methodName = "initiateCustomActivity";
                this.debugLog(methodName, "Calling Custom Activity:\ncorrelation id:" + correlationId + "\n" + "case id:" + caseId + "\n" + "case activity definition id:" + caseActivityDefinitionId + "\n" + "class name:" + className);
                if (className == null) {
                    throw new CaseActivityException(74030, new Object[]{caseActivityDefinition.getDefinitionId()});
                }
                caseActivity = null;
                ICaseMetadataService metadataService = ServicesLocator.getCaseMetadataService();
                caseActivity = metadataService.getCaseActivityMetadata(context, caseActivityDefinitionId);
                this.populatePayload(context, caseId, caseActivityDefinition, payload, caseActivity);
                originalClassloader = null;
                String caseDefinitionId = this.getCaseDefinitionId(caseId);
                if (correlationId != null) {
                    payload.put(CORRELATION_ID, correlationId);
                }
                originalClassloader = ServicesLocator.getCaseSE().setCompositeClassLoaderAsThreadContextLoader("COMPOSITE_CLASSLOADER", caseDefinitionId);
                callbackClass = null;
                try {
                    callbackClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                    this.debugLog(methodName, "callback class found:" + callbackClass.getName());
                }
                catch (ClassNotFoundException cnfe) {
                    ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
                    Object customizationsClassLoader = CustomizationsClassloader.getInstance((ClassLoader)parentClassLoader);
                    if (customizationsClassLoader == null) {
                        customizationsClassLoader = parentClassLoader;
                    }
                    if ((callbackClass = Class.forName(className, true, (ClassLoader)customizationsClassLoader)) == null) break block12;
                    this.debugLog(methodName, "callback class found:" + callbackClass.getName());
                }
            }
            if (callbackClass == null) break block13;
            ICaseActivityCallback activityCallback = (ICaseActivityCallback)callbackClass.newInstance();
            Class[] parameterTypes = new Class[]{IBPMContext.class, CaseIdentifier.class, String.class, Map.class};
            Method initiate = callbackClass.getMethod("initiate", parameterTypes);
            Object[] arguments = new Object[]{context, new CaseIdentifier(caseId, null, null), caseActivityDefinitionId, payload};
            String instanceId = (String)initiate.invoke((Object)activityCallback, arguments);
            this.populatePayloadOutputs(payload, caseActivity, caseId);
            String string = instanceId;
            if (originalClassloader != null) {
                Thread.currentThread().setContextClassLoader(originalClassloader);
            }
            return string;
        }
        try {
            try {
                throw new CaseActivityException(74040, new Object[]{className, caseActivityDefinition.getDefinitionId(), caseId});
            }
            catch (Exception e) {
                throw new CaseActivityException(74004, new Object[]{caseActivityDefinition.getClassName(), caseId}, e);
            }
        }
        catch (Throwable throwable) {
            if (originalClassloader != null) {
                Thread.currentThread().setContextClassLoader(originalClassloader);
            }
            throw throwable;
        }
    }

    private void populatePayloadOutputs(Map<String, Object> payload, CaseActivity caseActivity, String caseId) throws CaseActivityException {
        if (caseActivity != null) {
            TOutputParameters outputParam;
            List output;
            TOutputs outputs;
            TCustomActivity customActivity = ((TCaseActivity)caseActivity.getValue()).getCustomActivity();
            TParameters parameters = null;
            if (customActivity != null) {
                parameters = customActivity.getParameters();
            } else {
                TGlobalActivity globalActivity = ((TCaseActivity)caseActivity.getValue()).getGlobalActivity();
                if (globalActivity != null) {
                    parameters = globalActivity.getParameters();
                }
            }
            if (parameters != null && (outputs = parameters.getOutputs()) != null && (output = outputs.getOutput()) != null && output.size() > 0 && (outputParam = ((TOutput)output.get(0)).getParameters()) != null) {
                List outputParameters = outputParam.getParameter();
                for (TOutputParameter parameter : outputParameters) {
                    this.populateCaseDataFromPayloadOutput(caseId, parameter, payload);
                }
            }
        }
    }

    private void populateCaseDataFromPayloadOutput(String caseId, TOutputParameter parameter, Map<String, Object> payload) throws CaseActivityException {
        try {
            String methodName = "populateCaseDataFromPayloadOutput";
            TPayloadOutput payloadOutput = parameter.getPayloadOutput();
            if (payloadOutput != null) {
                TSaveDataAs saveType;
                String dataName = payloadOutput.getActivityParamName();
                TSaveData saveData = payloadOutput.getSaveData();
                if (saveData != null && (saveType = saveData.getSaveDataAs()) != null && saveType.compareTo((Enum)TSaveDataAs.CASE_DATA) == 0) {
                    Object value = payload.get(dataName);
                    Element data = null;
                    if (value instanceof Element) {
                        data = (Element)value;
                    } else if (value instanceof String) {
                        data = XMLUtil.parseDocument((String)((String)value)).getDocumentElement();
                    }
                    String caseDataName = saveData.getDataName();
                    if (data != null && caseDataName != null) {
                        CaseActivityUtil.uploadCaseData(caseDataName, data, caseId);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CaseActivityException(74038, new Object[]{parameter.getPayloadOutput().getActivityParamName()}, e);
        }
    }

    private void populatePayload(IBPMContext context, String caseId, CaseActivityDefinition caseActivityDefinition, Map<String, Object> payload, CaseActivity caseActivity) throws CaseActivityException {
        try {
            if (caseActivity != null) {
                TInputs inputs;
                TCustomActivity customActivity = ((TCaseActivity)caseActivity.getValue()).getCustomActivity();
                TParameters parameters = null;
                if (customActivity != null) {
                    parameters = customActivity.getParameters();
                } else {
                    TGlobalActivity globalActivity = ((TCaseActivity)caseActivity.getValue()).getGlobalActivity();
                    if (globalActivity != null) {
                        parameters = globalActivity.getParameters();
                    }
                }
                if (parameters != null && (inputs = parameters.getInputs()) != null) {
                    List inputParameters = inputs.getParameter();
                    int indexOfPayloadElement = -1;
                    for (TInputParameter parameter : inputParameters) {
                        if (parameter.getCaseDataInput() == null && parameter.getPayloadInput() != null) {
                            ++indexOfPayloadElement;
                        }
                        this.populatePayloadInInput(caseId, parameter, payload, indexOfPayloadElement);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CaseActivityException(74039, new Object[]{caseActivityDefinition.getDefinitionId(), caseId}, e);
        }
    }

    private boolean isValidRating(int rating) {
        return rating <= 5 && rating >= 1;
    }

    private void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + message + "\n"));
    }

    private void logCaseActivities(String methodName, List<CaseActivityDefinition> caseActivities, String message) {
        if (caseActivities == null) {
            return;
        }
        this.debugLog(methodName, message);
        this.debugLog(methodName, "Case Activity List count:" + caseActivities.size());
        for (CaseActivityDefinition caseActivity : caseActivities) {
            this.logCaseActivity(methodName, caseActivity, null);
        }
    }

    private void logCaseActivity(String methodName, CaseActivityDefinition caseActivity, String message) {
        String msg = message + "\n" + "CaseActivityDefinition for :" + caseActivity.getName() + "\n" + "Definition Id:" + caseActivity.getDefinitionId() + "\n" + "Is custom activity:" + caseActivity.getIsCustom() + "\n" + "Is global:" + caseActivity.getIsGlobal() + "\n" + "Is case specific:" + caseActivity.getIsCaseSpecific() + "\n" + "Is conditional:" + caseActivity.getIsConditional() + "\n" + "Required:" + caseActivity.getIsRequired() + "\n" + "Repeatable:" + caseActivity.getIsRepeatable() + "\n" + "Manual:" + caseActivity.getIsManual() + "\n" + "State:" + caseActivity.getState() + "\n" + "Class Name:" + caseActivity.getClassName() + "\n" + "Type: " + caseActivity.getType() + "\n" + "Relevance:" + caseActivity.getRelevance().toString() + "\n";
        this.debugLog(methodName, msg);
    }

    private void logStartOfMethod(String methodName, String string) {
        String msg = "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\nStart of " + methodName + "\n" + string + "\n" + "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" + "\n";
        this.debugLog(methodName, msg);
    }

    private void logEndOfMethod(String methodName, String string) {
        String msg = "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\nEnd of " + methodName + "\n" + string + "\n" + "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" + "\n";
        this.debugLog(methodName, msg);
    }
}

