/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.impl;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.bpm.casemgmt.caseactivity.CaseActivityUtil;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityDefinition;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.AbstractMetadataCache;
import oracle.bpm.casemgmt.impl.CaseMetadataException;
import oracle.bpm.casemgmt.metadata.activity.model.CaseActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TAssociations;
import oracle.bpm.casemgmt.metadata.activity.model.TCaseActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TCaseCategory;

public class CaseActivityMetadataCache
extends AbstractMetadataCache {
    private static CaseActivityMetadataCache cache = new CaseActivityMetadataCache();

    private CaseActivityMetadataCache() {
    }

    public static CaseActivityMetadataCache getInstance() {
        return cache;
    }

    @Override
    public Object retrieveMetadata(String definitionId) throws CaseMetadataException {
        CaseActivity caseActivity = null;
        try {
            CaseActivityDefinition defn = ServicesLocator.getCasePersistence().find(CaseActivityDefinition.class, definitionId);
            caseActivity = defn != null && defn.getType().equalsIgnoreCase("CUSTOM") ? CaseActivityUtil.fromClob(defn.getPayload()) : ServicesLocator.getCaseSE().getCaseActivityMetadata(definitionId, null);
        }
        catch (Exception e) {
            CaseMetadataException ex = new CaseMetadataException(72801, new Object[]{definitionId}, e);
            throw ex;
        }
        return caseActivity;
    }

    @Override
    public ResourceBundle getResourceBundle(String definitionId, Locale locale, boolean duringDeployment) {
        return null;
    }

    protected CaseActivity getTranslatedMetadata(CaseActivity caseActivityMetadata, Locale locale) throws CaseMetadataException {
        List categories;
        TAssociations associations;
        String defnId = ((TCaseActivity)caseActivityMetadata.getValue()).getActivityDefinitionId();
        if (defnId == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (((TCaseActivity)caseActivityMetadata.getValue()).getName() != null) {
            String name = this.getDisplayValue(defnId, (Object)((TCaseActivity)caseActivityMetadata.getValue()).getName(), locale, false);
            ((TCaseActivity)caseActivityMetadata.getValue()).setName(name);
        }
        if (((TCaseActivity)caseActivityMetadata.getValue()).getCaseAssociations() != null && ((TCaseActivity)caseActivityMetadata.getValue()).getCaseAssociations().getAssociations() != null && (associations = ((TCaseActivity)caseActivityMetadata.getValue()).getCaseAssociations().getAssociations()).getCaseCategories() != null && (categories = associations.getCaseCategories().getCaseCategory()) != null) {
            for (TCaseCategory category : categories) {
                String categoryValue = this.getDisplayValue(defnId, (Object)category.getName(), locale, false);
                category.setName(categoryValue);
            }
        }
        return caseActivityMetadata;
    }
}

