/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.impl;

import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseMetadataException;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.metadata.Case.model.TResourceBundle;
import oracle.bpm.casemgmt.metadata.common.model.TTranslatableValue;
import oracle.bpm.casemgmt.metadata.common.model.TTranslatableValueTypeEnum;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.resource.Casei18nUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;

public abstract class AbstractMetadataCache {
    protected final String KEY_SEPARATOR = "_";
    private Map<String, Object> metadataMap = new HashMap<String, Object>();
    private Map<String, Object> translationMap = new HashMap<String, Object>();

    public abstract Object retrieveMetadata(String var1) throws CaseMetadataException;

    public abstract ResourceBundle getResourceBundle(String var1, Locale var2, boolean var3) throws CaseMetadataException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String definitionId) {
        if (this.metadataMap.containsKey(definitionId)) {
            Map<String, Object> map = this.metadataMap;
            synchronized (map) {
                this.metadataMap.remove(definitionId);
                this.debugLog("removeFromCache", "Removing key:" + definitionId + " from metadata cache");
            }
        }
        Iterator<String> iterator = this.translationMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!key.startsWith(definitionId)) continue;
            Map<String, Object> map = this.translationMap;
            synchronized (map) {
                iterator.remove();
                this.debugLog("removeFromCache", "Removing key:" + key + " from translation cache");
            }
        }
    }

    public String getDisplayValue(String definitionId, Object object, Locale locale) {
        return this.getDisplayValue(definitionId, object, null, locale, false);
    }

    public String getDisplayValue(String definitionId, Object object, Locale locale, boolean duringDeployment) {
        return this.getDisplayValue(definitionId, object, null, locale, duringDeployment);
    }

    public String getDisplayValue(String definitionId, Object object, Case caseInstance, Locale locale) {
        return this.getDisplayValue(definitionId, object, caseInstance, locale, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDisplayValue(String definitionId, Object object, Case caseInstance, Locale locale, boolean duringDeployment) {
        String translationValue = null;
        try {
            String value = null;
            boolean isTranlslationBasedOnXPath = false;
            if (object instanceof TTranslatableValue) {
                TTranslatableValue translatableValue = (TTranslatableValue)object;
                if (translatableValue.getTranslationType() != TTranslatableValueTypeEnum.RESOURCE) return translatableValue.getTranslationValue();
                translationValue = translatableValue.getTranslationValue();
                isTranlslationBasedOnXPath = true;
            } else {
                translationValue = (String)object;
            }
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("translationValue:" + translationValue));
            String cacheKey = this.getCacheKey(definitionId, translationValue, locale);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("cacheKey:" + cacheKey));
            if (isTranlslationBasedOnXPath) {
                value = this.translate(InternalBPMContext.getInternalBPMContext(), definitionId, object, caseInstance, locale, duringDeployment);
            } else {
                Map<String, Object> map = this.translationMap;
                synchronized (map) {
                    if (this.translationMap.containsKey(cacheKey)) {
                        value = (String)this.translationMap.get(cacheKey);
                    } else {
                        value = this.translate(InternalBPMContext.getInternalBPMContext(), definitionId, object, caseInstance, locale, duringDeployment);
                        if (value != null) {
                            this.translationMap.put(cacheKey, value);
                        }
                    }
                }
            }
            this.debugLog("getDisplayValue", "Display value for " + translationValue + " is " + value);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("Display value for " + translationValue));
            return value;
        }
        catch (Exception e) {
            this.debugLog("getDisplayValue", "Exception encountered while trying to get the displayName, parameters: Locale:" + locale.toString() + " ,definitionId:" + definitionId + " ,translationValue:" + translationValue + " : " + e.getMessage());
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getMetadata(String definitionId) throws CaseMetadataException {
        String methodName = "getMetadata";
        Object metadata = null;
        if (definitionId == null) {
            this.debugLog(methodName, "Null definition id is passed");
            return null;
        }
        Map<String, Object> map = this.metadataMap;
        synchronized (map) {
            if (this.metadataMap.containsKey(definitionId)) {
                metadata = this.metadataMap.get(definitionId);
                this.debugLog(methodName, "Metadata with id:" + definitionId + " exists in cache");
                return metadata;
            }
            metadata = this.retrieveMetadata(definitionId);
            if (metadata != null) {
                this.debugLog(methodName, "Adding metadata to cache with id:" + definitionId);
                this.metadataMap.put(definitionId, metadata);
                return metadata;
            }
            this.debugLog(methodName, "Case Service Engine returned null metadata for id:" + definitionId);
            return null;
        }
    }

    protected ResourceBundle getResourceBundle(String definitionId, TResourceBundle bundleInfo, Locale locale) throws CaseMetadataException {
        return this.getResourceBundle(definitionId, bundleInfo, locale, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceBundle getResourceBundle(String definitionId, TResourceBundle bundleInfo, Locale locale, boolean duringDeployment) throws CaseMetadataException {
        if (definitionId == null) {
            this.debugLog("getResourceBundle", "Input definition id is null");
            return null;
        }
        if (bundleInfo == null) {
            this.debugLog("getResourceBundle", "Bundle info for definition with id:" + definitionId + " is null");
            return null;
        }
        String resourceBundleName = bundleInfo.getName();
        if (resourceBundleName == null) {
            this.debugLog("getResourceBundle", "Bundle name for definition with id:" + definitionId + " is null");
            return null;
        }
        resourceBundleName = resourceBundleName.trim();
        this.debugLog("getResourceBundle", "Bundle name for definition with id:" + definitionId + " is " + resourceBundleName);
        ResourceBundle resourceBundle = null;
        ClassLoader originalClassLoader = null;
        try {
            if (!duringDeployment) {
                originalClassLoader = ServicesLocator.getCaseSE().setCompositeClassLoaderAsThreadContextLoader("RESOURCE_CLASSLOADER", definitionId);
            }
            if (locale == null) {
                this.debugLog("getResourceBundle", "Using default locale for definition with id:" + definitionId);
                locale = Locale.getDefault();
            }
            try {
                ResourceBundle resourceBundle2 = resourceBundle = ResourceBundle.getBundle(resourceBundleName, locale, Thread.currentThread().getContextClassLoader());
                return resourceBundle2;
            }
            catch (Exception e) {
                this.debugLog("getResourceBundle", "Resource bundle for locale:" + locale.toString() + " not found for case_definition_id:" + definitionId + " using the class loader:" + Thread.currentThread().getContextClassLoader());
                CaseMetadataException caseMetadataException = new CaseMetadataException(72802, new Object[]{resourceBundleName, definitionId, locale.toString()}, e);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getResourceBundle", (Throwable)((Object)caseMetadataException));
                ResourceBundle resourceBundle3 = null;
                if (!duringDeployment && originalClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
                return resourceBundle3;
            }
        }
        finally {
            if (!duringDeployment && originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    protected ResourceBundle loadResourceBundle(String resourceBundleName, URL url, Locale locale) {
        URLClassLoader resourceClassLoader = new URLClassLoader(new URL[]{url});
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(resourceBundleName, locale, resourceClassLoader);
        }
        catch (Exception e) {
            this.debugLog("loadResourceBundle", e.getMessage());
            this.debugLog("loadResourceBundle", "Exception thrown while loading resource bundle " + resourceBundleName + " for locale:" + locale.toString() + " at url:" + url.toString() + " using the class loader:" + resourceClassLoader);
            return null;
        }
        return resourceBundle;
    }

    protected URL getResourceBundleURL(String definitionURL) {
        try {
            String relativeURI = new URL(definitionURL).toString();
            URI uri = new URI(relativeURI.substring(0, relativeURI.lastIndexOf(47) + 1));
            URL url = uri.toURL();
            return url;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getCacheKey(String definitionId, String translationValue, Locale locale) {
        String key = definitionId + "_" + locale.toString() + "_" + translationValue;
        return key;
    }

    protected String translate(IBPMContext ctx, String definitionId, Object object, Case caseInstance, Locale locale, boolean duringDeployment) {
        String translationKey = null;
        ArrayList<String> translationParams = new ArrayList<String>();
        if (object instanceof TTranslatableValue) {
            TTranslatableValue tTranslatableValue = (TTranslatableValue)object;
            translationKey = tTranslatableValue.getTranslationValue();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("Translation fro TTranslatableValue:'" + tTranslatableValue));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("translationKey:'" + translationKey));
            List parameters = tTranslatableValue.getTranslationParam();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)(" Translation parameters:" + parameters));
            if (parameters != null) {
                for (String param : parameters) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)(" Translation parameter:" + param));
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)(" Translation parameter:" + param));
                    try {
                        String val = CaseServiceUtil.evaluateXPath(ctx, caseInstance, param);
                        translationParams.add(val);
                    }
                    catch (CaseServiceException e) {
                        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"translate", (Throwable)e);
                        translationParams.add(null);
                    }
                }
            }
            this.debugLog("translate", "key:" + translationKey + "parameters:" + translationParams);
        } else if (object instanceof String) {
            translationKey = (String)object;
            this.debugLog("translate", "No translation defined for:" + translationKey);
        }
        String translatedValue = null;
        try {
            translatedValue = Casei18nUtil.getValue(ctx, definitionId, locale, translationKey, null, duringDeployment);
        }
        catch (Exception e) {
            this.debugLog("translate", "Exception thrown while retrieving bundle found for definition:" + definitionId + " for locale:" + locale.toString());
            return translationKey;
        }
        if (translatedValue != null) {
            if (translationParams != null && translationParams.size() > 0) {
                translatedValue = MessageFormat.format(translatedValue, translationParams.toArray());
            }
            this.debugLog("translate", "Translated value for key:" + translationKey + " is:" + translatedValue);
            return translatedValue;
        }
        this.debugLog("translate", "Value for key:" + translationKey + " is not available in resource bundle for locale:" + locale.toString());
        return translationKey;
    }

    protected void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)methodName, (String)message);
    }
}

