/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.identity;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.verification.IVerificationService;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.tip.pc.services.common.ServiceFactory;
import oracle.tip.pc.services.identity.BPMAppRole;
import oracle.tip.pc.services.identity.BPMAuthorizationService;
import oracle.tip.pc.services.identity.BPMGroup;
import oracle.tip.pc.services.identity.BPMIdentity;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMUser;
import oracle.tip.pc.services.identity.config.ISConfiguration;

public class CaseIdentityService
implements ICaseIdentityService {
    private IVerificationService verificationService = null;
    private static final String PROCESS_ROLES_APP = "OracleBPMProcessRolesApp";

    public IVerificationService getVerificationService() {
        if (this.verificationService == null) {
            this.verificationService = new VerificationService();
        }
        return this.verificationService;
    }

    public void setVerificationService(IVerificationService newVerificationService) {
        this.verificationService = newVerificationService;
    }

    @Override
    public IBPMContext validateContext(IBPMContext context) throws BPMException {
        try {
            IBPMContext ctx = (IBPMContext)this.getVerificationService().validateContext((IWorkflowContext)context);
            return ctx;
        }
        catch (Exception cause) {
            throw new BPMException(71054, null, (Throwable)cause);
        }
    }

    @Override
    public IBPMContext getBPMContextForAuthenticatedUser() throws BPMException, WorkflowException {
        String subjectUser = VerificationService.getAuthenticatedUserName();
        if (subjectUser == null) {
            return null;
        }
        try {
            IBPMContext ctx = (IBPMContext)VerificationService.createWorkflowContextFromWSRequest(null);
            return ctx;
        }
        catch (Exception cause) {
            throw new BPMException(71054, null, (Throwable)cause);
        }
    }

    @Override
    public String getContextUserDisplayNameInDefaultLocale(IBPMContext ctx) {
        return this.getUserDisplayName(Locale.getDefault(), ctx.getUser());
    }

    @Override
    public boolean isAdminContext(IBPMContext ctx) {
        try {
            BPMUser bpmUser = VerificationService.lookupUser((IWorkflowContext)ctx);
            return bpmUser.isInAppRole("BPMOrganizationAdmin", "soa-infra");
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"isAdminContext", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isUserInGroup(IBPMContext ctx, String group) {
        try {
            BPMUser user = VerificationService.lookupUser((IWorkflowContext)ctx);
            return user.isInGroup(group);
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"isUserInGroup", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isInAppRole(IBPMContext ctx, String appRoleName, String appCtx) {
        try {
            BPMUser user = VerificationService.lookupUser((IWorkflowContext)ctx);
            return user.isInAppRole(appRoleName, CaseIdentityService.getAppStripe(appCtx));
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"isInAppRole", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isValidUser(String userId) {
        try {
            BPMAuthorizationService identityService = ServiceFactory.getAuthorizationServiceInstance((String)ISConfiguration.getDefaultRealmName());
            BPMUser user = identityService.lookupUser(userId);
            return true;
        }
        catch (BPMIdentityException e) {
            return false;
        }
    }

    @Override
    public boolean isValidGroup(String group) {
        try {
            BPMAuthorizationService identityService = ServiceFactory.getAuthorizationServiceInstance((String)ISConfiguration.getDefaultRealmName());
            BPMGroup bpmGroup = identityService.lookupGroup(group);
            return true;
        }
        catch (BPMIdentityException e) {
            return false;
        }
    }

    @Override
    public boolean isValidApprole(String approle, String appId) {
        try {
            BPMAuthorizationService identityService = ServiceFactory.getAuthorizationServiceInstance((String)ISConfiguration.getDefaultRealmName());
            BPMAppRole bpmAppRole = identityService.lookupAppRole(approle, appId);
            return true;
        }
        catch (BPMIdentityException e) {
            return false;
        }
    }

    @Override
    public String getUserDisplayName(Locale locale, String user) {
        try {
            if (user == null) {
                return null;
            }
            ArrayList<String> usersList = new ArrayList<String>();
            usersList.add(user);
            BPMAuthorizationService identityService = ServiceFactory.getAuthorizationServiceInstance((String)ISConfiguration.getDefaultRealmName());
            List userDisplayNames = identityService.getLocaleSpecificUserNames(usersList, locale);
            String displayName = (String)userDisplayNames.get(0);
            if (displayName == null) {
                return user;
            }
            return displayName;
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getUserDisplayName", (Throwable)e);
            return user;
        }
    }

    @Override
    public List<BPMIdentity> getApplicationRoles(IBPMContext ctx) {
        if (ctx == null) {
            return null;
        }
        try {
            BPMUser bpmUser = VerificationService.lookupUser((IWorkflowContext)ctx);
            return bpmUser.getAppRoles(false);
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getApplicationRoles", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<BPMIdentity> getGroups(IBPMContext ctx) {
        if (ctx == null) {
            return null;
        }
        try {
            BPMUser bpmUser = VerificationService.lookupUser((IWorkflowContext)ctx);
            return bpmUser.getGroups(false);
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getGroups", (Throwable)e);
            return null;
        }
    }

    @Override
    public BPMUser lookupUser(IBPMContext ctx) {
        if (ctx == null) {
            return null;
        }
        try {
            return VerificationService.lookupUser((IWorkflowContext)ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public BPMAppRole lookupAppRole(String name, String appId) {
        if (name == null || name.trim().equals("")) {
            return null;
        }
        try {
            BPMAuthorizationService identityService = ServiceFactory.getAuthorizationServiceInstance((String)ISConfiguration.getDefaultRealmName());
            List appRoles = identityService.searchAppRoles(name, appId);
            if (appRoles != null & appRoles.size() > 0) {
                return (BPMAppRole)appRoles.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getApplicationRoleDisplayName(Locale locale, String approle) {
        return approle;
    }

    @Override
    public String getGroupDisplayName(Locale locale, String group) {
        try {
            ArrayList<String> groupsList = new ArrayList<String>();
            groupsList.add(group);
            BPMAuthorizationService identityService = ServiceFactory.getAuthorizationServiceInstance((String)ISConfiguration.getDefaultRealmName());
            List groupDisplayNames = null;
            groupDisplayNames = identityService.getLocaleSpecificGroupNames(groupsList, locale);
            String displayName = (String)groupDisplayNames.get(0);
            if (displayName == null) {
                return group;
            }
            return displayName;
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getGroupDisplayName", (Throwable)e);
            return null;
        }
    }

    private static String getAppStripe(String appCtx) {
        if (appCtx == null || "".equals(appCtx.trim())) {
            return PROCESS_ROLES_APP;
        }
        return appCtx;
    }

    private void debugLog(String method, String msg) {
        System.out.println("CaseIdentityService." + method + " () : " + msg);
    }
}

