/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.factory;

import oracle.bpm.casemgmt.ICaseActivityService;
import oracle.bpm.casemgmt.ICaseDocumentService;
import oracle.bpm.casemgmt.ICaseDocumentStreamService;
import oracle.bpm.casemgmt.ICaseEventService;
import oracle.bpm.casemgmt.ICaseInstanceService;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.ICasePermissionService;
import oracle.bpm.casemgmt.ICaseRuleService;
import oracle.bpm.casemgmt.ICaseRuleStreamService;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.IInternalCaseService;
import oracle.bpm.casemgmt.caserule.ICaseRuleMDSUtil;
import oracle.bpm.casemgmt.caserule.IECARuleProcessor;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.eca.IECAProcessor;
import oracle.bpm.casemgmt.event.ICaseEventPublisher;
import oracle.bpm.casemgmt.fabric.ICaseSEWrapper;
import oracle.bpm.casemgmt.factory.CaseServiceLocator;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.permission.IAuthenticationStoreManager;
import oracle.bpm.casemgmt.permission.ICasePermissionServiceInternal;
import oracle.bpm.casemgmt.persistence.ICasePersistence;
import oracle.bpm.casemgmt.persistence.activity.ICaseActivityPersistence;
import oracle.bpm.casemgmt.persistence.caserule.ICaseRulePersistance;
import oracle.bpm.casemgmt.persistence.emf.IEntityManagerFactory;
import oracle.bpm.casemgmt.persistence.event.ICaseEventPersistence;
import oracle.bpm.casemgmt.persistence.instance.ICaseInstancePersistence;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;

public class ServicesLocator {
    public static String LOCATOR_FACTORY_SELECTOR = "classpath*:oracle/bpm/casemgmt/config/beanRefContext.xml";
    private static final String SELECTOR = "casemgmtSpringContext";
    public static final String CASE_INSTANCE_SERVICE_IMPL = "CaseInstanceServiceImpl";
    public static final String CASE_METADATA_SERVICE_IMPL = "CaseMetadataServiceImpl";
    public static final String CASE_EVENT_SERVICE_IMPL = "CaseEventServiceImpl";
    public static final String CASE_ACTIVITY_SERVICE_IMPL = "CaseActivityServiceImpl";
    public static final String CASE_DOCUMENT_SERVICE_IMPL = "CaseDocumentServiceImpl";
    public static final String CASE_INSTANCE_PERSISTENCE = "CaseInstancePersistence";
    public static final String CASE_EVENT_PERSISTENCE = "CaseEventPersistence";
    public static final String CASE_EVENT_PUBLISHER = "CaseEventPublisher";
    public static final String CASE_EVENT_EDN_PUBLISHER = "CaseEventEDNPublisher";
    public static final String ENTITY_MANAGER_FACTORY = "EntityManagerFactory";
    public static final String ECA_PROCESSOR = "ECAProcessor";
    public static final String CASE_SE = "CaseSE";
    public static final String CASE_PERSISTENCE = "CasePersistence";
    public static final String CASE_RULE_SERVICE = "CaseRuleServiceImpl";
    public static final String CASE_DOCUMENT_STREAM_SERVICE = "CaseDocumentStreamService";
    public static final String CASE_RULE_PERSISTANCE = "CaseRulePersistance";
    public static final String CASE_RULE_MDSUTIL = "CaseRuleMDSUtil";
    public static final String ECA_RULE_PROCESSOR = "ECARuleProcessor";
    public static final String CASE_IDENTITY_SERVICE = "CaseIdentityService";
    public static final String CASE_AUTH_STORE_MGR = "AuthStoreManager";
    public static final String CASE_PERMISSION_SERVICE_IMPL = "CasePermissionServiceImpl";
    public static final String CASE_PERM_SVC_INTERNAL = "CasePermissionServiceInternal";
    public static final String CASE_ACTIVITY_PERSISTENCE = "CaseActivityPersistence";

    public static Object getService(String beanName) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("Getting bean " + beanName + " from " + LOCATOR_FACTORY_SELECTOR));
        BeanFactoryLocator locator = ContextSingletonBeanFactoryLocator.getInstance((String)LOCATOR_FACTORY_SELECTOR);
        BeanFactoryReference reference = locator.useBeanFactory(SELECTOR);
        Object returnObj = reference.getFactory().getBean(beanName);
        return returnObj;
    }

    public static ICaseService getCaseService() {
        return CaseServiceLocator.getCaseService();
    }

    public static ICaseInstanceService getCaseInstanceService() {
        return (ICaseInstanceService)ServicesLocator.getService(CASE_INSTANCE_SERVICE_IMPL);
    }

    public static ICaseMetadataService getCaseMetadataService() {
        return (ICaseMetadataService)ServicesLocator.getService(CASE_METADATA_SERVICE_IMPL);
    }

    public static ICaseEventService getCaseEventService() {
        return (ICaseEventService)ServicesLocator.getService(CASE_EVENT_SERVICE_IMPL);
    }

    public static ICaseActivityService getCaseActivityService() {
        return (ICaseActivityService)ServicesLocator.getService(CASE_ACTIVITY_SERVICE_IMPL);
    }

    public static ICaseDocumentService getCaseDocumentService() {
        return (ICaseDocumentService)ServicesLocator.getService(CASE_DOCUMENT_SERVICE_IMPL);
    }

    public static ICaseInstancePersistence getCaseInstancePersistence() {
        return (ICaseInstancePersistence)ServicesLocator.getService(CASE_INSTANCE_PERSISTENCE);
    }

    public static ICaseEventPersistence getCaseEventPersistence() {
        return (ICaseEventPersistence)ServicesLocator.getService(CASE_EVENT_PERSISTENCE);
    }

    public static ICaseEventPublisher getCaseEventPublisher() {
        return (ICaseEventPublisher)ServicesLocator.getService(CASE_EVENT_PUBLISHER);
    }

    public static ICaseEventPublisher getCaseEventEDNPublisher() {
        return (ICaseEventPublisher)ServicesLocator.getService(CASE_EVENT_EDN_PUBLISHER);
    }

    public static IEntityManagerFactory getEntityManagerFactory() {
        return (IEntityManagerFactory)ServicesLocator.getService(ENTITY_MANAGER_FACTORY);
    }

    public static IECAProcessor getECAProcessor() {
        return (IECAProcessor)ServicesLocator.getService(ECA_PROCESSOR);
    }

    public static ICaseSEWrapper getCaseSE() {
        return (ICaseSEWrapper)ServicesLocator.getService(CASE_SE);
    }

    public static ICasePersistence getCasePersistence() {
        return (ICasePersistence)ServicesLocator.getService(CASE_PERSISTENCE);
    }

    public static IInternalCaseService getInternalCaseService() {
        return (IInternalCaseService)CaseServiceLocator.jndiLookup((String)"ejb.bpm.case.InternalCaseService");
    }

    public static ICaseRuleService getCaseRuleService() {
        return (ICaseRuleService)ServicesLocator.getService(CASE_RULE_SERVICE);
    }

    public static ICaseRuleStreamService getCaseRuleStreamService() {
        return (ICaseRuleStreamService)ServicesLocator.getService(CASE_RULE_SERVICE);
    }

    public static ICaseRulePersistance getCaseRulePersistance() {
        return (ICaseRulePersistance)ServicesLocator.getService(CASE_RULE_PERSISTANCE);
    }

    public static ICaseRuleMDSUtil getCaseRuleMDSUtil() {
        return (ICaseRuleMDSUtil)ServicesLocator.getService(CASE_RULE_MDSUTIL);
    }

    public static IECARuleProcessor getECARuleProcessor() {
        return (IECARuleProcessor)ServicesLocator.getService(ECA_RULE_PROCESSOR);
    }

    public static ICaseDocumentStreamService getCaseDocumentStreamService() {
        return (ICaseDocumentStreamService)ServicesLocator.getService(CASE_DOCUMENT_STREAM_SERVICE);
    }

    public static ICaseIdentityService getCaseIdentityService() {
        return (ICaseIdentityService)ServicesLocator.getService(CASE_IDENTITY_SERVICE);
    }

    public static IAuthenticationStoreManager getAuthenticationStoreManager() {
        return (IAuthenticationStoreManager)ServicesLocator.getService(CASE_AUTH_STORE_MGR);
    }

    public static ICasePermissionService getCasePermissionService() {
        return (ICasePermissionService)ServicesLocator.getService(CASE_PERMISSION_SERVICE_IMPL);
    }

    public static ICasePermissionServiceInternal getCasePermissionServiceInternal() {
        return (ICasePermissionServiceInternal)ServicesLocator.getService(CASE_PERM_SVC_INTERNAL);
    }

    public static ICaseActivityPersistence getCaseActivityPersistence() {
        return (ICaseActivityPersistence)ServicesLocator.getService(CASE_ACTIVITY_PERSISTENCE);
    }
}

