/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.facade;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseList;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.soa.management.CompositeDN;
import oracle.soa.management.facade.Component;
import oracle.soa.management.facade.ComponentInstance;
import oracle.soa.management.internal.facade.casemgmt.CaseManagementComponentImpl;
import oracle.soa.management.internal.facade.casemgmt.CaseManagementInstanceImpl;
import oracle.soa.management.util.ComponentFilter;
import oracle.soa.management.util.ComponentInstanceFilter;

public class CaseComponentHelper {
    private IBPMContext mBPMContext;
    private Locale mLocale;
    private static String CASE_HEADER_PREFIX = ICaseConstants.caseInstance + "." + ICaseConstants.caseHeader + ".";
    private static String AND_OPERATOR = " and ";
    public static Map<String, Integer> CASE_STATE_MAP = new HashMap<String, Integer>();
    public static final Map<Integer, Set<String>> FABRIC_STATE_MAP = new HashMap<Integer, Set<String>>();
    private static final String NO_CASE_STATE = "NO_STATE_TO_MAP";

    public CaseComponentHelper(IBPMContext ctx, Locale locale) {
        this.mLocale = locale;
        this.mBPMContext = ctx;
    }

    public static String stripIdPrefix(String id) {
        String returnValue = id;
        if (id.startsWith("casemanagement:")) {
            returnValue = id.substring("casemanagement:".length());
        }
        return returnValue;
    }

    public static int getNormalizedState(String caseState) {
        return CASE_STATE_MAP.get(caseState);
    }

    public List<ComponentInstance> getInstances(ComponentInstanceFilter filter) throws BPMException, CaseServiceException {
        this.debugLog("getInstances", "Getting case instances using filter: " + filter);
        ArrayList<ComponentInstance> instances = new ArrayList<ComponentInstance>();
        ICaseService caseService = ServicesLocator.getCaseService();
        int pageStart = filter.getPageStart();
        int pageEnd = filter.getPageSize();
        String additionalQuery = this.getCaseSearchString(filter);
        String orderBy = this.getOrdering(filter);
        this.debugLog("getInstances", "Executing CaseService.queryCase with query:" + additionalQuery + " and ordering:" + orderBy);
        IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
        CaseList caseList = caseService.queryCase(ctx, null, additionalQuery, orderBy, pageStart, pageEnd);
        this.debugLog("getInstances", "CaseList returned from queryCase:" + caseList);
        if (caseList != null && caseList.getCases() != null && caseList.getCases().size() > 0) {
            for (Case caseInstance : caseList.getCases()) {
                CaseManagementInstanceImpl instance = this.createInstanceFromCase(caseInstance);
                if (instance == null) continue;
                instances.add((ComponentInstance)instance);
            }
        }
        this.debugLog("getInstances", "Returning " + instances.size() + " case instances.");
        return instances;
    }

    public List<Component> getComponentSnapshot(ComponentFilter filter) throws CasePersistenceException, Exception {
        ArrayList<Component> caseComponents = new ArrayList<Component>();
        String whereClause = this.getCaseSearchString(filter);
        StringBuffer queryBuffer = new StringBuffer();
        queryBuffer.append("select count(" + ICaseConstants.caseInstance + "),").append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.applicationName).append(',').append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.compositeName).append(',').append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.compositeVersion).append(',').append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.componentName).append(',').append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.state).append(" from Case as ").append(ICaseConstants.caseInstance);
        if (whereClause != null && whereClause.trim().length() > 0) {
            queryBuffer.append(" where ").append(whereClause);
        }
        queryBuffer.append(" group by ").append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.applicationName).append(',').append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.compositeName).append(',').append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.compositeVersion).append(',').append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.componentName).append(',').append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.state).append(" order by ").append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.applicationName).append(',').append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.compositeName).append(',').append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.compositeVersion).append(',').append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.componentName).append(',').append(CASE_HEADER_PREFIX).append(ICaseConstants.caseHeaderAttributes.state);
        String query = queryBuffer.toString();
        this.debugLog("getComponentSnapshot", "Query to get case instance snapshot:" + query);
        List<Object> result = new ArrayList();
        HashMap<String, Component> componentMap = new HashMap<String, Component>();
        result = ServicesLocator.getInternalCaseService().getCaseInstancesSnapshot(query);
        for (Object[] objectArray : result) {
            int count = ((Long)objectArray[0]).intValue();
            String appName = (String)objectArray[1];
            String compositeName = (String)objectArray[2];
            String compositeVersion = (String)objectArray[3];
            String componentName = (String)objectArray[4];
            String state = (String)objectArray[5];
            String compositeDN = new CompositeDN(appName, compositeName, compositeVersion).toString();
            String key = compositeDN + "/" + componentName;
            this.debugLog("getComponentSnapshot", "Count for: " + key + ", " + state + ": " + count);
            Component component = (Component)componentMap.get(key);
            if (component == null) {
                component = new CaseManagementComponentImpl(compositeDN, componentName);
                component.setNumberOfActiveInstances(0);
                component.setNumberOfFaultedInstances(0);
                component.setNumberOfInstances(0);
                component.setNumberOfRecoverableInstances(0);
                componentMap.put(key, component);
            }
            int fabricState = CaseComponentHelper.getNormalizedState(state);
            int current = 0;
            switch (fabricState) {
                case 0: {
                    current = component.getNumberOfActiveInstances();
                    component.setNumberOfActiveInstances(current + count);
                    break;
                }
                case 3: {
                    current = component.getNumberOfFaultedInstances();
                    component.setNumberOfFaultedInstances(current + count);
                    break;
                }
                case 1: {
                    current = component.getNumberOfRecoverableInstances();
                    component.setNumberOfRecoverableInstances(current + count);
                }
            }
            current = component.getNumberOfInstances();
            component.setNumberOfInstances(current + count);
        }
        caseComponents.addAll(componentMap.values());
        this.debugLog("getComponentSnapshot", "Returning: " + caseComponents.size());
        return caseComponents;
    }

    private CaseManagementInstanceImpl createInstanceFromCase(Case caseInstance) {
        CaseManagementInstanceImpl caseMgmtInstance = new CaseManagementInstanceImpl();
        caseMgmtInstance.setApplicationName(caseInstance.getCaseHeader().getApplicationName());
        caseMgmtInstance.setCompositeDN(new CompositeDN(caseInstance.getCaseHeader().getCompositeDn()));
        caseMgmtInstance.setComponentName(caseInstance.getCaseHeader().getComponentName());
        caseMgmtInstance.setCompositeInstanceId(caseInstance.getCaseHeader().getCompositeInstanceId());
        caseMgmtInstance.setECID(caseInstance.getCaseHeader().getEcid());
        caseMgmtInstance.setParentId(caseInstance.getCaseHeader().getParentComponentInstanceId());
        caseMgmtInstance.setParentReferenceId(caseInstance.getCaseHeader().getParentComponentInstRefId());
        caseMgmtInstance.setCreationDate(caseInstance.getCaseHeader().getCreatedDate().getTime());
        caseMgmtInstance.setCreator(caseInstance.getCaseHeader().getCreatedBy());
        caseMgmtInstance.setId("casemanagement:" + caseInstance.getCaseHeader().getCaseNumber());
        caseMgmtInstance.setModifyDate(caseInstance.getCaseHeader().getUpdatedDate().getTime());
        caseMgmtInstance.setStatus(caseInstance.getCaseHeader().getState());
        caseMgmtInstance.setState(CaseComponentHelper.getNormalizedState(caseInstance.getCaseHeader().getState()));
        caseMgmtInstance.setNormalizedState(CaseComponentHelper.getNormalizedState(caseInstance.getCaseHeader().getState()));
        caseMgmtInstance.setCaseId(caseInstance.getCaseId());
        return caseMgmtInstance;
    }

    private String getCaseSearchString(ComponentInstanceFilter filter) {
        StringBuffer filterBuffer = new StringBuffer();
        boolean addAndOperator = false;
        if (filter.getComponentName() != null) {
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.componentName.name() + "= '" + filter.getComponentName() + "'");
            addAndOperator = true;
        }
        if (filter.getCompositeName() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.compositeName.name() + " = '" + filter.getCompositeName() + "'");
            addAndOperator = true;
        }
        if (filter.getCompositeDN() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.compositeDn.name() + " LIKE '" + filter.getCompositeDN() + "%'");
            addAndOperator = true;
        }
        if (filter.getCompositeInstanceId() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.compositeInstanceId.name() + "= '" + filter.getCompositeInstanceId() + "'");
            addAndOperator = true;
        }
        if (filter.getECID() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.ecid.name() + "= '" + filter.getECID() + "'");
            addAndOperator = true;
        }
        if (filter.getId() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            String id = CaseComponentHelper.stripIdPrefix(filter.getId());
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.caseNumber.name() + " = '" + id + "'");
            addAndOperator = true;
        }
        if (filter.getMaxCreationDate() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.createdDate.name() + " < '" + this.getTimestamp(filter.getMaxCreationDate()) + "'");
            addAndOperator = true;
        }
        if (filter.getMaxModifyDate() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(ICaseConstants.caseHeaderAttributes.updated_date.name() + " < '" + this.getTimestamp(filter.getMaxModifyDate()) + "'");
            addAndOperator = true;
        }
        if (filter.getMinCreationDate() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.createdDate.name() + " > '" + this.getTimestamp(filter.getMinCreationDate()) + "'");
            addAndOperator = true;
        }
        if (filter.getMinModifyDate() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(ICaseConstants.caseHeaderAttributes.updated_date.name() + " > '" + this.getTimestamp(filter.getMinModifyDate()) + "'");
            addAndOperator = true;
        }
        if (filter.getParentId() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.parentComponentInstanceId.name() + " = '" + filter.getParentId() + "'");
            addAndOperator = true;
        }
        if (filter.getParentReferenceId() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.parentComponentInstRefId.name() + "= '" + filter.getParentReferenceId() + "'");
            addAndOperator = true;
        }
        int[] normalizedStates = filter.getNormalizedStates();
        HashSet caseStates = new HashSet();
        if (normalizedStates != null && normalizedStates.length > 0) {
            for (int state : normalizedStates) {
                Integer fabricState = state;
                caseStates.addAll(FABRIC_STATE_MAP.get(fabricState));
            }
        }
        if (caseStates.size() > 0) {
            StringBuffer caseListString = new StringBuffer();
            Iterator iterator = caseStates.iterator();
            while (iterator.hasNext()) {
                caseListString.append("'").append(iterator.next()).append("'");
                if (!iterator.hasNext()) continue;
                caseListString.append(" , ");
            }
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.state.name() + " IN  (" + caseListString + ")");
            addAndOperator = true;
        }
        return filterBuffer.toString();
    }

    private String getOrdering(ComponentInstanceFilter filter) {
        String ordering = null;
        String asc = " asc";
        String desc = " desc";
        if (filter.getOrderBy() == 1) {
            ordering = CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.createdDate.name() + asc;
        } else if (filter.getOrderBy() == 0) {
            ordering = CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.createdDate.name() + desc;
        } else if (filter.getOrderBy() == 3) {
            ordering = CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.updated_date.name() + asc;
        } else if (filter.getOrderBy() == 2) {
            ordering = CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.updated_date.name() + desc;
        }
        return ordering;
    }

    private String getCaseSearchString(ComponentFilter filter) {
        StringBuffer filterBuffer = new StringBuffer();
        boolean addAndOperator = false;
        if (filter.getComponentName() != null) {
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.componentName.name() + "= '" + filter.getComponentName() + "'");
            addAndOperator = true;
        }
        if (filter.getCompositeName() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.compositeName.name() + " = '" + filter.getCompositeName() + "'");
            addAndOperator = true;
        }
        if (filter.getLabel() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.compositeDn.name() + " LIKE '%" + filter.getLabel() + "%'");
            addAndOperator = true;
        }
        if (filter.getPartition() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.applicationName.name() + "= '" + filter.getPartition() + "'");
            addAndOperator = true;
        }
        if (filter.getRevision() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.compositeVersion.name() + "= '" + filter.getRevision() + "'");
            addAndOperator = true;
        }
        if (filter.getMaxCreationDate() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.createdDate.name() + " < '" + this.getTimestamp(filter.getMaxCreationDate()) + "'");
            addAndOperator = true;
        }
        if (filter.getMaxModifyDate() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(ICaseConstants.caseHeaderAttributes.updated_date.name() + " < '" + this.getTimestamp(filter.getMaxModifyDate()) + "'");
            addAndOperator = true;
        }
        if (filter.getMinCreationDate() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(CASE_HEADER_PREFIX + ICaseConstants.caseHeaderAttributes.createdDate.name() + " > '" + this.getTimestamp(filter.getMinCreationDate()) + "'");
            addAndOperator = true;
        }
        if (filter.getMinModifyDate() != null) {
            if (addAndOperator) {
                filterBuffer.append(AND_OPERATOR);
            }
            filterBuffer.append(ICaseConstants.caseHeaderAttributes.updated_date.name() + " > '" + this.getTimestamp(filter.getMinModifyDate()) + "'");
            addAndOperator = true;
        }
        return filterBuffer.toString();
    }

    private void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ENGINE, (Severity)Severity.DEBUG, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + message + "\n"));
    }

    private Timestamp getTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    static {
        CASE_STATE_MAP.put(ICaseConstants.CaseState.ACTIVE.name(), 0);
        CASE_STATE_MAP.put(NO_CASE_STATE, 1);
        CASE_STATE_MAP.put(ICaseConstants.CaseState.SUSPENDED.name(), 5);
        CASE_STATE_MAP.put(ICaseConstants.CaseState.CLOSED.name(), 2);
        CASE_STATE_MAP.put(ICaseConstants.CaseState.EXPIRED.name(), 2);
        CASE_STATE_MAP.put(ICaseConstants.CaseState.ERRORED.name(), 3);
        CASE_STATE_MAP.put(ICaseConstants.CaseState.STALE.name(), 6);
        CASE_STATE_MAP.put(ICaseConstants.CaseState.ABORTED.name(), 4);
        Set<String> caseStates = CASE_STATE_MAP.keySet();
        for (String caseState : caseStates) {
            Integer fabricState = CASE_STATE_MAP.get(caseState);
            Set<String> states = FABRIC_STATE_MAP.get(fabricState);
            if (states == null) {
                states = new HashSet<String>();
                FABRIC_STATE_MAP.put(fabricState, states);
            }
            states.add(caseState);
        }
    }
}

