/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.fabric;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.rules.fabric.MdsCompositeQuery;
import oracle.bpel.services.workflow.client.worklist.util.TaskFlowPropsUtil;
import oracle.bpel.services.workflow.fabric.DatabaseInfo;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseList;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.IInternalCaseService;
import oracle.bpm.casemgmt.caseactivity.CaseActivityException;
import oracle.bpm.casemgmt.caseactivity.CaseActivityInvocationCallback;
import oracle.bpm.casemgmt.caseactivity.CaseActivityInvocationCallbackProvider;
import oracle.bpm.casemgmt.caseactivity.ICaseActivityInvocationCallback;
import oracle.bpm.casemgmt.casemetadata.model.CaseDefinition;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.customactivity.activityrating.ActivityRatingCallbackUtil;
import oracle.bpm.casemgmt.customactivity.notification.NotificationCallbackUtil;
import oracle.bpm.casemgmt.customactivity.simplewf.SimpleWFCallbackUtil;
import oracle.bpm.casemgmt.fabric.CaseSEException;
import oracle.bpm.casemgmt.facade.CaseComponentHelper;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TData;
import oracle.bpm.casemgmt.metadata.activity.model.CaseActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TCaseActivity;
import oracle.bpm.casemgmt.permission.ICasePermissionServiceInternal;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseFabricHeaderProperty;
import oracle.bpm.casemgmt.persistence.model.CaseHeader;
import oracle.bpm.casemgmt.persistence.model.CaseMilestone;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.casemgmt.persistence.util.MOXyUtil;
import oracle.bpm.casemgmt.util.CaseUtil;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.bpm.services.organization.model.Organization;
import oracle.fabric.blocks.BindingType;
import oracle.fabric.blocks.ImplementationType;
import oracle.fabric.blocks.RedeploymentTarget;
import oracle.fabric.blocks.ServiceEngine;
import oracle.fabric.blocks.mesh.FabricMesh;
import oracle.fabric.common.BusinessFaultException;
import oracle.fabric.common.FabricDeploymentException;
import oracle.fabric.common.FabricInvocationException;
import oracle.fabric.common.InvocationContext;
import oracle.fabric.common.InvocationContextFactory;
import oracle.fabric.common.MetadataManager;
import oracle.fabric.common.NormalizedMessage;
import oracle.fabric.common.NormalizedMessageImpl;
import oracle.fabric.common.Operation;
import oracle.fabric.composite.CompositeClassLoader;
import oracle.fabric.composite.component.implementation.BPMNImplementation;
import oracle.fabric.composite.component.implementation.CaseManagementImplementation;
import oracle.fabric.composite.component.implementation.WorkflowImplementation;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import oracle.fabric.composite.model.CompositeNameModel;
import oracle.fabric.composite.model.ServiceConfigModel;
import oracle.fabric.composite.model.WireModel;
import oracle.ide.net.URLFileSystem;
import oracle.integration.platform.blocks.FabricConfigManager;
import oracle.integration.platform.blocks.FacadeService;
import oracle.integration.platform.blocks.cluster.ClusterInterface;
import oracle.integration.platform.blocks.mesh.FabricLifecycleListener;
import oracle.integration.platform.blocks.migration.ComponentInstanceReportFactory;
import oracle.integration.platform.blocks.migration.ComponentInstanceResultFactory;
import oracle.integration.platform.blocks.migration.InstanceMigrationParticipant;
import oracle.integration.platform.common.MDSMetadataManagerImpl;
import oracle.integration.platform.common.NMUtil;
import oracle.integration.platform.common.OperationImpl;
import oracle.integration.platform.instance.InstanceManager;
import oracle.soa.api.XMLMessageFactory;
import oracle.soa.api.invocation.DirectConnection;
import oracle.soa.api.message.Message;
import oracle.soa.management.CompositeDN;
import oracle.soa.management.facade.Component;
import oracle.soa.management.facade.ComponentInstance;
import oracle.soa.management.facade.ComponentInstanceMigrationReport;
import oracle.soa.management.facade.ComponentInstanceMigrationResult;
import oracle.soa.management.facade.Fault;
import oracle.soa.management.facade.InstanceMigrationContext;
import oracle.soa.management.facade.Locator;
import oracle.soa.management.facade.LocatorFactory;
import oracle.soa.management.facade.MigrationFeasibility;
import oracle.soa.management.facade.MigrationPlan;
import oracle.soa.management.facade.casemgmt.CaseManagementInstance;
import oracle.soa.management.internal.facade.casemgmt.CaseManagementComponentImpl;
import oracle.soa.management.util.ComponentFilter;
import oracle.soa.management.util.ComponentInstanceFilter;
import oracle.soa.management.util.FaultFilter;
import oracle.xml.jaxb.JaxbNode;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CaseManagementServiceEngine
implements ServiceEngine,
RedeploymentTarget<ComponentModel>,
FabricLifecycleListener,
FacadeService,
InstanceMigrationParticipant {
    private Map<String, CaseManagementComponentImpl> caseComponentMap = new HashMap<String, CaseManagementComponentImpl>();
    private final ImplementationType implementationType = new ImplementationType("implementation.casemanagement");
    private Map<String, CaseActivity> mCaseActivityMetadataCache = new HashMap<String, CaseActivity>();
    private Map<String, CaseMetadata> mCaseMetadataCache = new HashMap<String, CaseMetadata>();
    private ClusterInterface mClusterInterface;
    private FabricConfigManager mFabricConfigManager;
    private FabricMesh mFabricMesh;
    private InstanceManager mInstanceManager;
    private static final String WORKFLOW_SE_IMPL = "implementation.workflow";
    private static final String BPMN_SE_IMPL = "implementation.bpmn";
    public static final String CLASS_LOADER_TYPE_COMPOSITE = "COMPOSITE_CLASSLOADER";
    public static final String CLASS_LOADER_TYPE_RESOURCE = "RESOURCE_CLASSLOADER";
    private static final String START_CASE = "startCase";
    private static final String ABORT_CASE = "abortCase";
    private static final String CLOSE_CASE = "closeCase";
    private static final String RESUME_CASE = "resumeCase";
    private static final String SUSPEND_CASE = "suspendCase";
    private static final String REOPEN_CASE = "reopenCase";
    private static final String ATTAIN_MILESTONE = "attainMilestone";
    private static final String REVOKE_MILESTONE = "revokeMilestone";
    private static final String PAYLOAD_ELEMENT = "payload";
    private static final String RESULT_ELEMENT = "result";
    private static final String NM_CASEID = "cm.caseId";
    private static final String CASE_ID_ELEMENT = "caseId";
    private static final String CASE_IDENTIFIER_ELEMENT = "caseIdentifier";
    private static final String OUTCOME_ELEMENT = "outcome";
    private static final String CASE_NUMBER_ELEMENT = "caseNumber";
    private static final String ID_KEY_ELEMENT = "identificationKey";
    private static final String COMMENT_ELEMENT = "comment";
    private static final String MILESTONE_ELEMENT = "milestone";
    private static final String OUTPUT_MESSAGE = "OutputMessage";
    private static final String ORGANIZATION_FILE_NAME = "organization.xml";
    private static CaseManagementServiceEngine engine;
    private static final String METADATA_ID_DELIMITER = "/";
    private static final String SERVICE_REFERENCE = ".service.reference";
    private static final String CASE_NS = "http://xmlns.oracle.com/bpm/case";
    private static final String CASESERVICE_NS = "http://xmlns.oracle.com/CaseService/types";
    public static final String ID_PREFIX = "casemanagement:";
    private static final String TASK_ID = "cm.taskId";
    private static final String CASE_HEADER_QUERY_PREFIX;

    public CaseManagementServiceEngine() {
        engine = this;
    }

    public static CaseManagementServiceEngine getInstance() {
        return engine;
    }

    public NormalizedMessage request(NormalizedMessage normalizedMessage, Operation operation, InvocationContext invocationContext) {
        String methodName = "request";
        try {
            String operationName = operation.getName();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ENGINE, (Severity)Severity.DEBUG, (String)("Request came -----------------:" + operationName));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ENGINE, (Severity)Severity.DEBUG, (String)("normalizedMessage:" + normalizedMessage));
            this.logNormalizedMessage(methodName, "Processing request - operation: " + operationName + "\n sourceURI: " + invocationContext.getWire().getSourceURI() + "\n targetURI: " + invocationContext.getWire().getTargetURI() + "\n message:", normalizedMessage);
            if (invocationContext.isCallback()) {
                this.debugLog(methodName, "request is a callback");
                IInternalCaseService service = ServicesLocator.getInternalCaseService();
                IBPMContext ctx = null;
                return service.onActivityCallback(ctx, normalizedMessage, operation, invocationContext);
            }
            this.validateRequest(normalizedMessage, operationName, invocationContext);
            Element inputElement = this.getPayloadElement(normalizedMessage);
            ICaseService caseService = ServicesLocator.getCaseService();
            IBPMContext context = InternalBPMContext.getInternalBPMContext();
            if (START_CASE.equals(operationName)) {
                Case caseInstance = this.getCase(inputElement);
                CaseHeader caseHeader = caseInstance.getCaseHeader();
                if (caseHeader == null) {
                    caseHeader = new CaseHeader();
                    caseInstance.setCaseHeader(caseHeader);
                }
                String compositeDN = invocationContext.getCompositeDN();
                String componentName = invocationContext.getWire().getTargetURI().split(METADATA_ID_DELIMITER)[0];
                this.debugLog(methodName, "compositeDN: " + compositeDN);
                this.debugLog(methodName, "componentName: " + componentName);
                String caseDefinitionId = this.getCaseDefinitionId(componentName, compositeDN);
                this.debugLog(methodName, "caseDefinitionId: " + caseDefinitionId);
                caseHeader.setCaseDefinitionId(caseDefinitionId);
                this.setCaseScaProperties(normalizedMessage, compositeDN, componentName, caseHeader);
                this.setCaseNMProperties(normalizedMessage, caseInstance);
                this.debugLog(methodName, "Case Instance:" + caseInstance);
                CaseIdentifier response = caseService.startCase(context, caseInstance);
                Element responseElem = this.getCaseIdentifierElement(operationName + OUTPUT_MESSAGE, response);
                NormalizedMessageImpl returnMessage = new NormalizedMessageImpl();
                returnMessage.getPayload().put(PAYLOAD_ELEMENT, responseElem);
                return returnMessage;
            }
            if (CLOSE_CASE.equals(operationName)) {
                CaseIdentifier caseIdentifier = this.getCaseIdentifier(inputElement);
                String outcome = this.getOutcome(inputElement);
                Comment comment = this.getComment(inputElement);
                boolean result = caseService.closeCase(context, caseIdentifier, outcome, comment);
                Element responseElem = this.getBooleanResultElement(operationName + OUTPUT_MESSAGE, RESULT_ELEMENT, result);
                NormalizedMessageImpl returnMessage = new NormalizedMessageImpl();
                returnMessage.getPayload().put(PAYLOAD_ELEMENT, responseElem);
                return returnMessage;
            }
            if (ABORT_CASE.equals(operationName)) {
                CaseIdentifier caseIdentifier = this.getCaseIdentifier(inputElement);
                Comment comment = this.getComment(inputElement);
                boolean result = caseService.abortCase(context, caseIdentifier, comment);
                Element responseElem = this.getBooleanResultElement(operationName + OUTPUT_MESSAGE, RESULT_ELEMENT, result);
                NormalizedMessageImpl returnMessage = new NormalizedMessageImpl();
                returnMessage.getPayload().put(PAYLOAD_ELEMENT, responseElem);
                return returnMessage;
            }
            if (SUSPEND_CASE.equals(operationName)) {
                CaseIdentifier caseIdentifier = this.getCaseIdentifier(inputElement);
                Comment comment = this.getComment(inputElement);
                boolean result = caseService.suspendCase(context, caseIdentifier, comment);
                Element responseElem = this.getBooleanResultElement(operationName + OUTPUT_MESSAGE, RESULT_ELEMENT, result);
                NormalizedMessageImpl returnMessage = new NormalizedMessageImpl();
                returnMessage.getPayload().put(PAYLOAD_ELEMENT, responseElem);
                return returnMessage;
            }
            if (RESUME_CASE.equals(operationName)) {
                CaseIdentifier caseIdentifier = this.getCaseIdentifier(inputElement);
                Comment comment = this.getComment(inputElement);
                boolean result = caseService.resumeCase(context, caseIdentifier, comment);
                Element responseElem = this.getBooleanResultElement(operationName + OUTPUT_MESSAGE, RESULT_ELEMENT, result);
                NormalizedMessageImpl returnMessage = new NormalizedMessageImpl();
                returnMessage.getPayload().put(PAYLOAD_ELEMENT, responseElem);
                return returnMessage;
            }
            if (ATTAIN_MILESTONE.equals(operationName)) {
                CaseMilestone milestone = this.getMilestone(inputElement);
                boolean result = caseService.attainMilestone(context, milestone);
                Element responseElem = this.getBooleanResultElement(operationName + OUTPUT_MESSAGE, RESULT_ELEMENT, result);
                NormalizedMessageImpl returnMessage = new NormalizedMessageImpl();
                returnMessage.getPayload().put(PAYLOAD_ELEMENT, responseElem);
                return returnMessage;
            }
            if (REVOKE_MILESTONE.equals(operationName)) {
                CaseMilestone milestone = this.getMilestone(inputElement);
                boolean result = caseService.revokeMilestone(context, milestone);
                Element responseElem = this.getBooleanResultElement(operationName + OUTPUT_MESSAGE, RESULT_ELEMENT, result);
                NormalizedMessageImpl returnMessage = new NormalizedMessageImpl();
                returnMessage.getPayload().put(PAYLOAD_ELEMENT, responseElem);
                return returnMessage;
            }
            if (REOPEN_CASE.equals(operationName)) {
                CaseIdentifier caseIdentifier = this.getCaseIdentifier(inputElement);
                Comment comment = this.getComment(inputElement);
                boolean result = caseService.reopenCase(context, caseIdentifier, comment);
                Element responseElem = this.getBooleanResultElement(operationName + OUTPUT_MESSAGE, RESULT_ELEMENT, result);
                NormalizedMessageImpl returnMessage = new NormalizedMessageImpl();
                returnMessage.getPayload().put(PAYLOAD_ELEMENT, responseElem);
                return returnMessage;
            }
        }
        catch (Exception e) {
            new FabricInvocationException((Throwable)e);
        }
        return null;
    }

    public void post(NormalizedMessage normalizedMessage, Operation operation, InvocationContext invocationContext) {
        String methodName = "post";
        this.logNormalizedMessage(methodName, "Processing post - operation: " + operation.getName() + "\n sourceURI: " + invocationContext.getWire().getSourceURI() + "\n targetURI: " + invocationContext.getWire().getTargetURI() + "\n message:", normalizedMessage);
        if (invocationContext.isCallback()) {
            this.debugLog(methodName, "post is a callback");
            IInternalCaseService service = ServicesLocator.getInternalCaseService();
            IBPMContext ctx = null;
            try {
                service.onActivityCallback(ctx, normalizedMessage, operation, invocationContext);
            }
            catch (CaseActivityException e) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"post", (String)"Exception in post", (Throwable)((Object)e));
            }
        }
    }

    public void load(ComponentModel componentModel) {
    }

    public void init(ComponentModel componentModel) {
        this.addCaseMgmtComponent(componentModel);
        this.initInvocationCallback();
    }

    public void unload(ComponentModel componentModel) {
    }

    public void uninit(ComponentModel componentModel) {
        String componentDN = this.getComponentDN(componentModel);
        this.debugLog("uninit", "Removing component:" + componentDN + "from component map");
        this.caseComponentMap.remove(componentDN);
    }

    public void deploy(ComponentModel componentModel) {
        this.deploy(componentModel, false, false);
    }

    public void deploy(ComponentModel componentModel, boolean keepInstancesOnRedeploy) {
        this.deploy(componentModel, true, keepInstancesOnRedeploy);
    }

    public void undeploy(ComponentModel componentModel) {
        this.undeploy(componentModel, false, false);
    }

    public void undeploy(ComponentModel componentModel, boolean keepInstancesOnRedeploy) {
        this.undeploy(componentModel, true, keepInstancesOnRedeploy);
    }

    public Component getComponent(String componentDN) {
        if (this.isCaseSupported()) {
            this.debugLog("getComponent()", "Get component invoked for componentDN:" + componentDN);
            return (Component)this.caseComponentMap.get(componentDN);
        }
        return null;
    }

    public List<ComponentInstance> getComponentInstances(ComponentInstanceFilter componentInstanceFilter) {
        try {
            if (this.isCaseSupported()) {
                this.debugLog("getComponentInstances()", "Get component instances invoked for component filter" + componentInstanceFilter);
                return this.getComponentHelper().getInstances(componentInstanceFilter);
            }
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getComponentInstances", (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    public int getNumberOfComponentInstances(ComponentInstanceFilter componentInstanceFilter) {
        int count = 0;
        List<ComponentInstance> caseInstances = null;
        try {
            if (this.isCaseSupported()) {
                this.debugLog("getNumberOfComponentInstances", "Invoked with filter:" + componentInstanceFilter);
                caseInstances = this.getComponentHelper().getInstances(componentInstanceFilter);
            }
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getNumberOfComponentInstances", (Throwable)e);
        }
        if (caseInstances != null && caseInstances.size() > 0) {
            count = caseInstances.size();
        }
        this.debugLog("getNumberOfComponentInstances", "Returned:" + count);
        return count;
    }

    public List<Component> getComponentsSnapshot(ComponentFilter componentFilter) {
        int count = 0;
        List<Component> caseInstances = null;
        try {
            if (this.isCaseSupported()) {
                this.debugLog("getComponentsSnapshot", "Invoked with filter:" + componentFilter);
                caseInstances = this.getComponentHelper().getComponentSnapshot(componentFilter);
            }
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getComponentsSnapshot", (Throwable)e);
        }
        if (caseInstances != null && caseInstances.size() > 0) {
            count = caseInstances.size();
        }
        this.debugLog("getComponentsSnapshot", "Returned:" + count);
        return caseInstances;
    }

    public Object executeEngineMethod(String string, Object[] objects) {
        return null;
    }

    public Object executeComponentMethod(CompositeDN compositeDN, String string, String string1, Object[] objects) {
        return null;
    }

    public Object executeComponentInstanceMethod(String string, String string1, Object[] objects) {
        return null;
    }

    public List<Fault> getFaults(FaultFilter faultFilter) {
        return Collections.emptyList();
    }

    public int getNumberOfFaults(FaultFilter faultFilter) {
        return 0;
    }

    public String getComponentDefinition(CompositeDN compositeDN, String componentName) {
        if (this.isCaseSupported()) {
            String caseDefinitionId = this.getCaseDefinitionId(componentName, compositeDN.getStringDN());
            this.debugLog("getComponentDefinition", "CaseMetadata Id:" + caseDefinitionId);
            CaseMetadata metadata = null;
            try {
                metadata = this.getCaseMetadata(caseDefinitionId, null);
            }
            catch (CaseSEException e) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getComponentDefinition", (Throwable)((Object)e));
            }
            String caseMetadataStr = this.getXMLStringFromCaseMetadata(metadata);
            this.debugLog("getComponentDefinition", "CaseMetadata string:" + caseMetadataStr);
            return caseMetadataStr;
        }
        return null;
    }

    public String getComponentInstanceAuditTrail(String string) {
        return null;
    }

    public String getEngineType() {
        return "casemanagement";
    }

    public int deleteInstancesByCompositeDN(CompositeDN compositeDN) throws Exception {
        try {
            if (this.isCaseSupported()) {
                this.debugLog("deleteInstancesByCompositeDN", "Method invoked");
                StringBuffer deleteWhereClause = new StringBuffer();
                deleteWhereClause.append(CASE_HEADER_QUERY_PREFIX).append(ICaseConstants.caseHeaderAttributes.compositeDn.name()).append(" LIKE '").append(compositeDN.getStringDN()).append("%'");
                int result = ServicesLocator.getInternalCaseService().deleteCaseInstances(deleteWhereClause.toString());
                this.debugLog("deleteInstancesByCompositeDN", "Deleted " + result + " case instances matching compositedn: " + compositeDN.getStringDN());
                return result;
            }
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"deleteInstancesByCompositeDN", (Throwable)e);
            throw e;
        }
        return 0;
    }

    public int deleteInstancesByCompositeInstanceId(long compositeInstanceId) throws Exception {
        try {
            if (this.isCaseSupported()) {
                this.debugLog("deleteInstancesByCompositeInstanceId", "Method invoked");
                StringBuffer deleteWhereClause = new StringBuffer();
                deleteWhereClause.append(CASE_HEADER_QUERY_PREFIX).append(ICaseConstants.caseHeaderAttributes.compositeInstanceId.name()).append("='").append(compositeInstanceId).append("'");
                int result = ServicesLocator.getInternalCaseService().deleteCaseInstances(deleteWhereClause.toString());
                this.debugLog("deleteInstancesByCompositeInstanceId", "Deleted " + result + " case instances matching composite instance id: " + compositeInstanceId);
                return result;
            }
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"deleteInstancesByCompositeInstanceId", (Throwable)e);
            throw e;
        }
        return 0;
    }

    public int abortInstancesByCompositeInstanceId(long compositeInstanceId) throws Exception {
        try {
            if (this.isCaseSupported()) {
                this.debugLog("abortInstancesByCompositeInstanceId", "Method invoked");
                StringBuffer addtionalJPQLWhereClause = new StringBuffer();
                IBPMContext context = InternalBPMContext.getInternalBPMContext();
                addtionalJPQLWhereClause.append(CASE_HEADER_QUERY_PREFIX).append(ICaseConstants.caseHeaderAttributes.compositeInstanceId.name()).append("='").append(compositeInstanceId).append("'");
                CaseList caseList = ServicesLocator.getCaseService().queryCase(context, null, addtionalJPQLWhereClause.toString(), null, 0, 0);
                int result = 0;
                if (caseList != null && caseList.getCases() != null) {
                    for (Case caseInstance : caseList.getCases()) {
                        boolean aborted = ServicesLocator.getCaseService().abortCase(context, new CaseIdentifier(caseInstance.getCaseId(), null, null), null);
                        if (!aborted) continue;
                        ++result;
                    }
                    this.debugLog("abortInstancesByCompositeInstanceId", "Aborted " + result + " case instances matching composite instance id: " + compositeInstanceId);
                }
                return result;
            }
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"abortInstancesByCompositeInstanceId", (Throwable)e);
            throw e;
        }
        return 0;
    }

    public boolean isCompositeInstanceInflight(long compositeInstanceId) {
        this.debugLog("isCompositeInstanceInflight", "Method invoked");
        ComponentInstanceFilter filter = new ComponentInstanceFilter();
        filter.setCompositeInstanceId(String.valueOf(compositeInstanceId));
        filter.setNormalizedStates(ComponentInstance.STATES_INFLIGHT);
        boolean result = this.getNumberOfComponentInstances(filter) > 0;
        this.debugLog("isCompositeInstanceInflight", "Returned:" + result);
        return result;
    }

    public Element toElement(Object t) {
        XMLElement element = ((JaxbNode)t).getDOMNode();
        Document doc = element.getOwnerDocument();
        Element docRoot = doc.getDocumentElement();
        if (docRoot == null && docRoot != element) {
            Object parent = element;
            while (parent.getParentNode() != null) {
                parent = parent.getParentNode();
            }
            doc.appendChild((Node)parent);
        }
        return element;
    }

    public ComponentInstanceMigrationReport checkCompatibility(InstanceMigrationContext instanceMigrationContext, ComponentInstance componentInstance, CompositeModel compositeModel) {
        ComponentInstanceMigrationReport componentInstanceMigrationReport = ComponentInstanceReportFactory.getInstance().create(componentInstance.getComponentName(), componentInstance.getId(), MigrationFeasibility.Automatic);
        return componentInstanceMigrationReport;
    }

    public ComponentInstanceMigrationResult migrate(InstanceMigrationContext instanceMigrationContext, ComponentInstance componentInstance, CompositeModel newRevisionCompositeModel, MigrationPlan plan) {
        this.debugLog("migrate", "\n componentInstance.getId(): " + componentInstance.getId() + "\n componentInstance.getComponentName(): " + componentInstance.getComponentName());
        CaseManagementInstance instance = (CaseManagementInstance)componentInstance;
        String caseId = instance.getCaseId();
        String componentName = componentInstance.getComponentName();
        String compositeDN = newRevisionCompositeModel.getDN();
        String version = newRevisionCompositeModel.getRevision();
        String caseDefinitionId = this.getCaseDefinitionId(componentName, compositeDN);
        IInternalCaseService internalSvc = ServicesLocator.getInternalCaseService();
        String failureReason = "";
        try {
            internalSvc.migrateCaseCompositeVersion(caseId, caseDefinitionId, compositeDN, version);
            return ComponentInstanceResultFactory.getInstance().create(componentInstance.getComponentName(), componentInstance.getServiceEngine().getEngineType(), componentInstance.getId(), true, failureReason);
        }
        catch (Exception e) {
            failureReason = e.getLocalizedMessage();
            this.debugLog("migrate", "Failed during migrateCaseCompositeVersion()  due to error: " + failureReason);
            return ComponentInstanceResultFactory.getInstance().create(componentInstance.getComponentName(), componentInstance.getServiceEngine().getEngineType(), componentInstance.getId(), false, failureReason);
        }
    }

    public void migrationCompleted(List<String> migratedComponentIds) {
    }

    public void prepareConfigChange(ComponentModel componentModel) {
    }

    public void commitConfigChange(ComponentModel componentModel, boolean b) {
    }

    public ImplementationType getImplementationType() {
        return this.implementationType;
    }

    public void setMesh(FabricMesh mesh) {
        this.mFabricMesh = mesh;
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ENGINE, (Severity)Severity.DEBUG, (String)"Case Management Service Engine initialization --> setMesh");
    }

    public void setInstanceManager(InstanceManager instanceManager) {
        this.mInstanceManager = instanceManager;
    }

    public void setFabricConfigManager(FabricConfigManager fabricConfigManager) {
        this.mFabricConfigManager = fabricConfigManager;
    }

    public void setClusterInterface(ClusterInterface clusterInterface) {
        this.mClusterInterface = clusterInterface;
    }

    public CaseMetadata getCaseMetadata(String caseDefinitionId, String mdsLabel) throws CaseSEException {
        String methodName = "getCaseMetadata";
        CaseMetadata caseMetadata = null;
        if (mdsLabel == null) {
            caseMetadata = this.getCaseMetadataFromCache(caseDefinitionId);
        }
        if (caseMetadata == null) {
            ComponentModel componentModel = this.getCaseComponentModel(caseDefinitionId);
            CompositeModel compositeModel = componentModel.getComposite();
            String componentName = componentModel.getName();
            this.debugLog(methodName, "Getting metadata for component " + componentName + " and mds label " + mdsLabel);
            caseMetadata = this.getCaseMetadata(compositeModel, componentName, mdsLabel);
            ((TCaseMetadata)caseMetadata.getValue()).setId(caseDefinitionId);
        }
        return caseMetadata;
    }

    public CaseActivity getCaseActivityMetadata(String caseActivityDefinitionId, String mdsLabel) throws CaseSEException {
        String methodName = "getCaseActivityMetadata";
        CompositeModel compositeModel = this.getCompositeModelFromCaseActivityDefinitionId(caseActivityDefinitionId);
        String activityName = this.getActivityNameFromCaseActivityDefinitionId(caseActivityDefinitionId);
        CaseActivity caseActivity = this.getCaseActivityMetadata(compositeModel, activityName);
        ((TCaseActivity)caseActivity.getValue()).setActivityDefinitionId(caseActivityDefinitionId);
        return caseActivity;
    }

    public CompositeModel getCompositeModelFromCaseDefinitionId(String caseDefinitionId) {
        if (caseDefinitionId == null) {
            return null;
        }
        String methodName = "getCompositeModelFromCaseDefinitionId";
        int position = caseDefinitionId.lastIndexOf(METADATA_ID_DELIMITER);
        this.debugLog(methodName, "position: " + position);
        if (position == -1) {
            return null;
        }
        String compositeDN = caseDefinitionId.substring(0, position);
        this.debugLog(methodName, "compositeDN: " + compositeDN);
        return this.getCompositeModelFromCompositeDN(compositeDN);
    }

    public CompositeModel getCompositeModelFromCaseActivityDefinitionId(String caseActivityDefinitionId) {
        String methodName = "getCompositeModelFromCaseActivityDefinitionId";
        int position = caseActivityDefinitionId.lastIndexOf(METADATA_ID_DELIMITER);
        this.debugLog(methodName, "position: " + position);
        if (position == -1) {
            return null;
        }
        String compositeDN = caseActivityDefinitionId.substring(0, position);
        this.debugLog(methodName, "compositeDN: " + compositeDN);
        return this.getCompositeModelFromCompositeDN(compositeDN);
    }

    public CaseMetadata getCaseMetadata(CompositeModel compositeModel, String componentName, String mdsLabel) throws CaseSEException {
        String methodName = "getCaseMetadata";
        ComponentModel componentModel = this.getComponentModel(compositeModel, componentName);
        String caseDef = this.getCaseSource(componentModel);
        this.debugLog(methodName, "Location of case metadata xml is: " + caseDef);
        Document caseDocument = this.getDocument(compositeModel.getMetadataManager(), caseDef, mdsLabel);
        CaseMetadata caseMetadata = null;
        try {
            caseMetadata = this.unmarshalCaseMetadata(caseDocument);
        }
        catch (JAXBException e) {
            throw new CaseSEException(74206, new Object[]{caseDef}, e);
        }
        return caseMetadata;
    }

    public CaseActivity getCaseActivityMetadata(CompositeModel compositeModel, String activityName) throws CaseSEException {
        List<URI> activitiesURI = null;
        CaseActivity caseActivity = null;
        activitiesURI = this.getActivities(compositeModel);
        if (activitiesURI != null) {
            for (URI activityURI : activitiesURI) {
                if (!activityURI.toString().contains(activityName)) continue;
                caseActivity = this.getCaseActivityMetadata(activityURI, compositeModel, false, false);
                break;
            }
        }
        return caseActivity;
    }

    public ClassLoader setCompositeClassLoaderAsThreadContextLoader(String classLoaderType, String caseDefinitionId) {
        CompositeModel composite = this.getCompositeModelFromCaseDefinitionId(caseDefinitionId);
        return this.setCompositeClassLoaderAsThreadContextLoader(composite, classLoaderType, caseDefinitionId);
    }

    public ClassLoader setCompositeClassLoaderAsThreadContextLoader(CompositeModel composite, String classLoaderType, String caseDefinitionId) {
        String methodName = "setCompositeClassLoaderAsThreadContextLoader";
        if (caseDefinitionId == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        if (classLoaderType == null || classLoaderType.equals("")) {
            classLoaderType = CLASS_LOADER_TYPE_COMPOSITE;
        }
        if (composite != null) {
            if (!CompositeNameModel.isValidCompositeName((String)composite.getDN())) {
                this.debugLog(methodName, "Composite not valid for case metadata with id:" + caseDefinitionId);
                return Thread.currentThread().getContextClassLoader();
            }
            try {
                CompositeClassLoader cl = null;
                if (classLoaderType.equals(CLASS_LOADER_TYPE_COMPOSITE)) {
                    cl = composite.getCompositeClassloader();
                    this.debugLog(methodName, "Got composite class loader from composite for case metadata id:" + caseDefinitionId);
                } else if (classLoaderType.equals(CLASS_LOADER_TYPE_RESOURCE)) {
                    cl = composite.getResourceClassloader();
                    this.debugLog(methodName, "Got composite resource loader from composite for case metadata id:" + caseDefinitionId);
                } else {
                    return Thread.currentThread().getContextClassLoader();
                }
                return cl.setAsThreadContextLoader();
            }
            catch (Exception e) {
                return Thread.currentThread().getContextClassLoader();
            }
        }
        this.debugLog(methodName, "Composite model for case definition with id:" + caseDefinitionId + " is null");
        return Thread.currentThread().getContextClassLoader();
    }

    public void setNMProperties(NormalizedMessage nm, String caseId, String correlationId, String taskId) throws CaseSEException {
        String methodName = "setNMProperties";
        Map properties = new HashMap();
        Case caseInstance = null;
        try {
            IBPMContext context = InternalBPMContext.getInternalBPMContext();
            CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
            ArrayList<ICaseConstants.CaseInfo> additionalCaseInfo = new ArrayList<ICaseConstants.CaseInfo>();
            additionalCaseInfo.add(ICaseConstants.CaseInfo.FABRIC_HEADER_PROPERTIES);
            caseInstance = ServicesLocator.getInternalCaseService().getCase(context, caseIdentifier, additionalCaseInfo);
        }
        catch (Exception e) {
            throw new CaseSEException(74200, new Object[]{caseInstance.getCaseId()}, e);
        }
        properties = this.getCaseNMProperties(caseInstance);
        String caseComponentId = ID_PREFIX + caseInstance.getCaseHeader().getCaseNumber();
        nm.setProperties(properties);
        nm.addProperty(NM_CASEID, (Object)caseId);
        if (correlationId != null) {
            nm.addProperty("cm.correlationId", (Object)correlationId);
        }
        if (taskId != null) {
            nm.addProperty(TASK_ID, (Object)taskId);
        }
        nm.addProperty("tracking.parentComponentInstanceId", (Object)caseComponentId);
        this.debugLog(methodName, "Setting case id: " + caseId + " parent component instance id: " + caseComponentId + " and correlation id: " + correlationId + " in normalized message");
        this.logNormalizedMessage(methodName, "message:", nm);
    }

    public NormalizedMessage requestComponent(String caseDefinitionId, String reference, String operation, NormalizedMessage normalizedMessage) throws CaseServiceException {
        String methodName = "requestComponent";
        this.logNormalizedMessage(methodName, "Case Metadata Id:" + caseDefinitionId + " Reference: " + reference + " Operation: " + operation, normalizedMessage);
        ComponentModel componentModel = this.getCaseComponentModel(caseDefinitionId);
        this.debugLog(methodName, "component model:" + componentModel.getName());
        InvocationContext invocationContext = InvocationContextFactory.createContext((ComponentModel)componentModel, (String)reference);
        this.debugLog(methodName, "composite DN:" + invocationContext.getCompositeDN() + "reference:" + invocationContext.getReference());
        return this.requestToMesh(normalizedMessage, operation, invocationContext);
    }

    public void postToComponent(String caseDefinitionId, String reference, String operation, NormalizedMessage normalizedMessage) throws CaseServiceException {
        String methodName = "postToComponent";
        this.logNormalizedMessage(methodName, "Reference: " + reference + " Operation: " + operation, normalizedMessage);
        ComponentModel componentModel = this.getCaseComponentModel(caseDefinitionId);
        InvocationContext invocationContext = InvocationContextFactory.createContext((ComponentModel)componentModel, (String)reference);
        this.postToMesh(normalizedMessage, operation, invocationContext);
    }

    public String getCaseDefinitionId(ComponentModel componentModel) {
        CompositeModel compositeModel = componentModel.getComposite();
        String componentName = componentModel.getName();
        String compositeDN = compositeModel.getDN();
        return this.getCaseDefinitionId(componentName, compositeDN);
    }

    public CaseMetadata getCaseMetadata(ComponentModel componentModel) throws CaseSEException {
        return this.getCaseMetadata(this.getCaseDefinitionId(componentModel), null);
    }

    public void stateChanged(int i) {
        String methodName = "stateChanged";
        if (3 == i) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ENGINE, (Severity)Severity.DEBUG, (String)"Fabric is running");
            if (DatabaseInfo.isWorkflowSchemaFor111170orLater() && this.isCaseSupported()) {
                try {
                    NotificationCallbackUtil.registerEmailActivity();
                    SimpleWFCallbackUtil.registerActivity();
                }
                catch (CaseActivityException e) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"stateChanged", (Throwable)((Object)e));
                }
                ActivityRatingCallbackUtil.registerActivity();
                this.debugLog(methodName, "Custom activities registered");
            } else {
                this.debugLog(methodName, "Not the right database version to register custom activities.");
            }
        }
    }

    public ComponentModel getCaseComponentModel(String caseDefinitionId) {
        String methodName = "getCaseComponentModel";
        CompositeModel compositeModel = this.getCompositeModelFromCaseDefinitionId(caseDefinitionId);
        String componentName = this.getComponentNameFromCaseDefinitionId(caseDefinitionId);
        ComponentModel componentModel = this.getComponentModel(compositeModel, componentName);
        return componentModel;
    }

    public CaseIdentifier postToDirectBinding(Case caseInstance, String directBindingServiceName) {
        if (caseInstance == null) {
            this.debugLog("postToDirectBinding", "CaseInstance object is null, returning");
            return null;
        }
        String caseDefnId = caseInstance.getCaseHeader().getCaseDefinitionId();
        if (caseDefnId == null) {
            this.debugLog("postToDirectBinding", "CaseDefinitionId is null, returning");
            return null;
        }
        this.debugLog("postToDirectBinding", "Call to invoke direct binding:" + directBindingServiceName + "for case defn id:" + caseDefnId);
        CompositeModel compositeModel = this.getCompositeModelFromCaseDefinitionId(caseDefnId);
        String compositeDN = compositeModel.getDN();
        Locator locator = null;
        DirectConnection directConnection = null;
        try {
            locator = LocatorFactory.createLocator();
            directConnection = locator.createDirectConnection(new CompositeDN(compositeDN), directBindingServiceName);
            Element caseElement = this.getCaseElementFromCase(caseInstance);
            HashMap<String, Element> payload = new HashMap<String, Element>();
            payload.put(PAYLOAD_ELEMENT, caseElement);
            Message m = XMLMessageFactory.getInstance().createMessage(payload);
            Message response = directConnection.request(START_CASE, m);
            Map responsePayload = response.getPayload().getData();
            XMLElement retElement = (XMLElement)responsePayload.get(PAYLOAD_ELEMENT);
            this.debugLog("postToDirectBinding", "Response Element from start case:" + XMLUtil.toString((Node)retElement));
            CaseIdentifier caseIdentifier = this.getCaseIdentifierFromElement((Element)retElement);
            if (caseIdentifier != null) {
                this.debugLog("postToDirectBinding", "Returning case identifier:\n" + caseIdentifier);
                return caseIdentifier;
            }
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"postToDirectBinding", (Throwable)e);
        }
        return null;
    }

    public String getDirectBindingServiceName(Case caseInstance) {
        if (caseInstance == null) {
            return null;
        }
        String caseDefnId = caseInstance.getCaseHeader().getCaseDefinitionId();
        if (caseDefnId == null) {
            return null;
        }
        ComponentModel componentModel = this.getCaseComponentModel(caseDefnId);
        CompositeModel compositeModel = componentModel.getComposite();
        String componentName = componentModel.getName();
        Collection wires = compositeModel.getWires();
        for (WireModel wire : wires) {
            BindingType bt;
            ServiceConfigModel scm;
            String source = wire.getSource();
            String target = wire.getTarget();
            if (!componentName.equals(target) || (scm = compositeModel.getConfigService(source)) == null || !"binding.direct".equals((bt = scm.getImplementationType()).getType()) || !"entryPoint".equals(bt.getMode())) continue;
            this.debugLog("getDirectBindingServiceName", "Found direct binding service name:" + source);
            return source;
        }
        this.debugLog("getDirectBindingServiceName", "Direct binding service name not found");
        return null;
    }

    public void onCaseStarted(Case caseInstance) {
        String methodName = "onCaseStarted";
        CaseHeader caseHeader = caseInstance.getCaseHeader();
        if (caseHeader != null && caseHeader.getCompositeInstanceId() != null && caseHeader.getCompositeInstanceId().length() > 0) {
            long compositeInstanceId = Long.parseLong(caseHeader.getCompositeInstanceId());
            String componentInstanceId = String.valueOf(caseHeader.getCaseNumber());
            try {
                this.debugLog("onCaseStarted", "Notifying fabric of Case instance " + componentInstanceId + " start");
                this.mInstanceManager.componentInstanceStarts(compositeInstanceId, componentInstanceId);
            }
            catch (Exception e) {
                this.warnLog("onCaseStarted", "Failed to notify fabric of Case instance start due to exception: " + e.getLocalizedMessage());
            }
        }
    }

    public void onCaseStateChange(Case caseInstance, String previousState) {
        String methodName = "onCaseStateChange";
        String caseId = caseInstance.getCaseId();
        this.debugLog("onCaseStateChange", "caseId:" + caseId + " previousState:" + previousState);
        CaseHeader caseHeader = caseInstance.getCaseHeader();
        if (caseHeader != null && caseHeader.getCompositeInstanceId() != null && caseHeader.getCompositeInstanceId().length() > 0 && previousState != null) {
            String currentState = caseHeader.getState();
            if (currentState == null) {
                return;
            }
            long compositeInstanceId = Long.parseLong(caseHeader.getCompositeInstanceId());
            String componentInstanceId = String.valueOf(caseHeader.getCaseNumber());
            int normalizedCurrentState = CaseComponentHelper.getNormalizedState(currentState);
            int normalizedPreviousState = CaseComponentHelper.getNormalizedState(previousState);
            if ((normalizedPreviousState == 1 || normalizedPreviousState == 5) && normalizedCurrentState == 0) {
                try {
                    this.debugLog("onCaseStateChange", "Notifiying fabric of Case instance " + componentInstanceId + " restart from state=" + previousState + " to state=" + currentState);
                    this.mInstanceManager.componentInstanceStarts(compositeInstanceId, componentInstanceId, normalizedPreviousState);
                }
                catch (Exception e) {
                    this.warnLog("onCaseStateChange", "Failed to notify fabric of Case instance restart due to exception: " + e.getLocalizedMessage());
                }
            }
            if (normalizedCurrentState == 2 || normalizedCurrentState == 3 || normalizedCurrentState == 1 || normalizedCurrentState == 5 || normalizedCurrentState == 4) {
                try {
                    this.debugLog("onCaseStateChange", "Notify fabric of case instance " + componentInstanceId + " completion with state: " + currentState);
                    this.mInstanceManager.componentInstanceCompletes(compositeInstanceId, componentInstanceId, normalizedCurrentState);
                }
                catch (Exception e) {
                    this.warnLog("onCaseStateChange", "Failed to notify fabric of completion of case instance " + componentInstanceId + " due to exception: " + e.getLocalizedMessage());
                }
            }
        }
    }

    public String getCaseDefinitionId(String componentName, String compositeDN) {
        int index = compositeDN.indexOf(42);
        if (index > 0) {
            compositeDN = compositeDN.substring(0, index);
        }
        return compositeDN + METADATA_ID_DELIMITER + componentName;
    }

    public String getComponentNameFromCaseDefinitionId(String caseDefinitionId) {
        String methodName = "getComponentNameFromCaseDefinitionId";
        this.debugLog(methodName, "case metadata id:" + caseDefinitionId);
        int position = caseDefinitionId.lastIndexOf(METADATA_ID_DELIMITER);
        this.debugLog(methodName, "position:" + position);
        if (position == -1) {
            return null;
        }
        String componentName = caseDefinitionId.substring(position + 1);
        this.debugLog(methodName, "component name:" + componentName);
        return componentName;
    }

    public String getCompositeDNFromCaseDefinitionId(String caseDefinitionId) {
        String methodName = "getCompositeDNFromCaseDefinitionId";
        this.debugLog(methodName, "case metadata id:" + caseDefinitionId);
        int position = caseDefinitionId.lastIndexOf(METADATA_ID_DELIMITER);
        this.debugLog(methodName, "position:" + position);
        if (position == -1) {
            return null;
        }
        String compositeDN = caseDefinitionId.substring(0, position);
        this.debugLog(methodName, "composite dn:" + compositeDN);
        return compositeDN;
    }

    public String getProcessName(String activityDefinitionId) throws BPMException, CaseServiceException {
        String methodName = "getProcessName";
        this.debugLog(methodName, "activity definitiond id:" + activityDefinitionId);
        ICaseMetadataService service = ServicesLocator.getCaseMetadataService();
        IBPMContext context = InternalBPMContext.getInternalBPMContext();
        CaseActivity caseActivity = service.getCaseActivityMetadata(context, activityDefinitionId);
        if (caseActivity.getValue() == null || ((TCaseActivity)caseActivity.getValue()).getBpmnActivity() == null || ((TCaseActivity)caseActivity.getValue()).getBpmnActivity().getComponentInfo() == null) {
            return null;
        }
        String namespace = ((TCaseActivity)caseActivity.getValue()).getBpmnActivity().getComponentInfo().getNamespace();
        return this.getProcessNameFromNamespace(namespace);
    }

    public String getHumanTaskName(String activityDefinitionId) throws BPMException, CaseServiceException {
        String methodName = "getHumanTaskName";
        this.debugLog(methodName, "activity definitiond id:" + activityDefinitionId);
        ICaseMetadataService service = ServicesLocator.getCaseMetadataService();
        IBPMContext context = InternalBPMContext.getInternalBPMContext();
        CaseActivity caseActivity = service.getCaseActivityMetadata(context, activityDefinitionId);
        if (caseActivity.getValue() == null || ((TCaseActivity)caseActivity.getValue()).getWorkflowActivity() == null || ((TCaseActivity)caseActivity.getValue()).getWorkflowActivity().getComponentInfo() == null) {
            return null;
        }
        String reference = ((TCaseActivity)caseActivity.getValue()).getWorkflowActivity().getComponentInfo().getReferenceName();
        return this.getHumanTaskNameFromReference(reference);
    }

    public String getActiveCompositeVersion(String appName, String compositeName) {
        String METHOD_NAME = "getActiveCompositeVersion";
        this.debugLog("getActiveCompositeVersion", "Getting active composite version: " + appName + METADATA_ID_DELIMITER + compositeName);
        String activeCompositeDN = appName + METADATA_ID_DELIMITER + compositeName;
        this.debugLog("getActiveCompositeVersion", "Locating composite in mesh using DN: " + activeCompositeDN);
        CompositeModel composite = this.getCompositeModelFromCompositeDN(activeCompositeDN);
        if (composite == null) {
            this.debugLog("getActiveCompositeVersion", "Failed to locate composite, returning null");
            return null;
        }
        String revision = composite.getRevision();
        this.debugLog("getActiveCompositeVersion", "Found active composite version: " + revision);
        return revision;
    }

    private static String getCaseActivityDefinitionId(String componentName, String compositeDN) {
        int index = compositeDN.indexOf(42);
        if (index > 0) {
            compositeDN = compositeDN.substring(0, index);
        }
        return compositeDN + METADATA_ID_DELIMITER + componentName;
    }

    private String getProcessNameFromNamespace(String namespace) {
        String methodName = "getProcessName";
        if (namespace != null && !namespace.trim().equals("")) {
            int position = namespace.lastIndexOf(METADATA_ID_DELIMITER);
            String processName = namespace.substring(position + 1);
            this.debugLog(methodName, "process name is:" + processName);
            return processName;
        }
        return null;
    }

    private String getHumanTaskNameFromReference(String reference) {
        String methodName = "getHumanTaskNameFromReference";
        if (reference != null && !reference.trim().equals("")) {
            String humanTaskName = reference.replace(SERVICE_REFERENCE, "");
            this.debugLog(methodName, "Human Task name is:" + humanTaskName);
            return humanTaskName;
        }
        return null;
    }

    private List<CaseActivity> getCaseActivityMetadataList(CompositeModel compositeModel) throws CaseSEException {
        ArrayList<CaseActivity> activityList = new ArrayList<CaseActivity>();
        List<URI> activitiesURI = null;
        Object caseActivity = null;
        activitiesURI = this.getActivities(compositeModel);
        if (activitiesURI != null) {
            for (URI activityURI : activitiesURI) {
                activityList.add(this.getCaseActivityMetadata(activityURI, compositeModel, false, false));
            }
        }
        return activityList;
    }

    private CaseActivity getCaseActivityMetadata(URI activityURI, CompositeModel compositeModel, boolean isRedeployment, boolean keepInstancesOnRedeploy) throws CaseSEException {
        CaseActivity caseActivity;
        String methodName = "getCaseActivityMetadata";
        Document document = null;
        MetadataManager metadataManager = compositeModel.getMetadataManager();
        String token = null;
        String activityName = null;
        String caseActivityDefinitionId = null;
        try {
            activityName = this.getActivityNameWithoutSuffix(activityURI);
            caseActivityDefinitionId = this.getCaseActivityDefinitionId(compositeModel, activityURI);
        }
        catch (MalformedURLException e2) {
            throw new CaseSEException(74205, new Object[]{activityName}, e2);
        }
        String activityRelativePath = null;
        try {
            token = metadataManager.initializeURLResolvers();
            String activityURIWithoutPrefix = URLFileSystem.getPath((URL)activityURI.toURL());
            activityRelativePath = activityURIWithoutPrefix.replace(compositeModel.getCompositeFolderName(), "");
            document = this.getDocument(metadataManager, activityRelativePath, null);
        }
        catch (Exception e) {
            if (!isRedeployment) {
                throw new CaseSEException(74205, new Object[]{activityName}, e);
            }
            if (activityURI != null) {
                if (keepInstancesOnRedeploy) {
                    throw new CaseSEException(74213, new Object[]{activityName}, e);
                }
                IInternalCaseService service = ServicesLocator.getInternalCaseService();
                try {
                    IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
                    service.onUndeployCaseActivity(ctx, caseActivityDefinitionId, false);
                    CaseActivity caseActivity2 = null;
                    return caseActivity2;
                }
                catch (Exception e1) {
                    throw new CaseSEException(74205, new Object[]{activityName}, e1);
                }
            }
            throw new CaseSEException(74205, new Object[]{activityName}, e);
        }
        finally {
            if (token != null) {
                metadataManager.uninitializeURLResolvers(token);
            }
        }
        try {
            caseActivity = this.unmarshalCaseActivityMetadata(document);
        }
        catch (JAXBException e) {
            throw new CaseSEException(74204, new Object[]{activityName}, e);
        }
        return caseActivity;
    }

    private String getCaseActivityDefinitionId(CompositeModel compositeModel, URI activityURI) throws MalformedURLException {
        String name = this.getActivityNameWithoutSuffix(activityURI);
        String compositeDN = compositeModel.getDN();
        return CaseManagementServiceEngine.getCaseActivityDefinitionId(name, compositeDN);
    }

    private String getActivityNameWithoutSuffix(URI activityURI) throws MalformedURLException {
        String activity = URLFileSystem.getName((URL)activityURI.toURL());
        return activity.replace(".caseactivity", "");
    }

    private CaseManagementComponentImpl addCaseMgmtComponent(ComponentModel componentModel) {
        String componentName = componentModel.getName();
        this.debugLog("addCaseMgmtComponent", "Adding Case Mgmt Component for :" + componentName);
        CaseManagementComponentImpl caseComponent = new CaseManagementComponentImpl(componentModel.getComposite().getDN(), componentName);
        String componentDN = this.getComponentDN(componentModel);
        this.caseComponentMap.put(componentDN, caseComponent);
        this.debugLog("addCaseMgmtComponent", "Added Case Mgmt Component:\n" + caseComponent);
        return caseComponent;
    }

    private String getComponentDN(ComponentModel componentModel) {
        return componentModel.getComposite().getDN() + METADATA_ID_DELIMITER + componentModel.getName();
    }

    private CaseComponentHelper getComponentHelper() throws Exception {
        Locale locale = Locale.getDefault();
        if (this.isCaseSupported()) {
            IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
            return new CaseComponentHelper(ctx, locale);
        }
        return new CaseComponentHelper(null, locale);
    }

    private Comment getComment(Element param) {
        String commentString;
        NodeList nodelist = param.getElementsByTagNameNS(CASE_NS, COMMENT_ELEMENT);
        if (nodelist.getLength() == 0) {
            return null;
        }
        Element node = (Element)nodelist.item(0);
        Comment comment = this.getCommentFromCommentElement(node);
        if (comment != null && ((commentString = comment.getCaseObjectComment()) == null || commentString.trim().equals(""))) {
            return null;
        }
        return comment;
    }

    private Comment getCommentFromCommentElement(Element node) {
        MOXyUtil moxyUtil = new MOXyUtil("moxy/caseinstance/eclipselink-oxm.xml", "oracle.bpm.casemgmt.persistence.model", Comment.class);
        return (Comment)moxyUtil.unmarshall((Node)node, Comment.class);
    }

    private CaseMilestone getMilestone(Element param) {
        String comment;
        NodeList nodelist = param.getElementsByTagNameNS(CASE_NS, MILESTONE_ELEMENT);
        if (nodelist.getLength() == 0) {
            return null;
        }
        Element node = (Element)nodelist.item(0);
        CaseMilestone milestone = this.getMilestoneFromElement(node);
        if (milestone.getComment() != null && ((comment = milestone.getComment().getCaseObjectComment()) == null || comment.trim().equals(""))) {
            milestone.setComment(null);
        }
        return milestone;
    }

    private CaseMilestone getMilestoneFromElement(Element node) {
        MOXyUtil moxyUtil = new MOXyUtil("moxy/caseinstance/eclipselink-oxm.xml", "oracle.bpm.casemgmt.persistence.model", CaseMilestone.class);
        return (CaseMilestone)moxyUtil.unmarshall((Node)node, CaseMilestone.class);
    }

    private IBPMContext getBPMContext(Element param) throws BPMException {
        return InternalBPMContext.getInternalBPMContext();
    }

    private void setCaseNMProperties(NormalizedMessage normalizedMessage, Case caseInstance) {
        String methodName = "setCaseNMProperties";
        Map transferableProperties = NMUtil.getTransferrableProperties((HashMap)((HashMap)normalizedMessage.getProperties()));
        CaseFabricHeaderProperty caseFabricHeaderProperty = new CaseFabricHeaderProperty();
        caseFabricHeaderProperty.setCase(caseInstance);
        caseFabricHeaderProperty.setCompositeCreatedTime(CaseServiceUtil.getCalendarInstance(null));
        if (transferableProperties.size() > 0) {
            byte[] bytes = NMUtil.serializeProperties((Map)transferableProperties);
            caseFabricHeaderProperty.setProperties(bytes);
            caseInstance.setCaseFabricHeaderProperty(caseFabricHeaderProperty);
        } else {
            this.debugLog(methodName, "No transferable properties set in normalized message");
        }
    }

    private Map getCaseNMProperties(Case caseInstance) throws CaseSEException {
        String methodName = "getCaseNMProperties";
        byte[] properties = null;
        if (caseInstance.getCaseFabricHeaderProperty() != null) {
            if (caseInstance.getCaseFabricHeaderProperty().getProperties() != null) {
                properties = caseInstance.getCaseFabricHeaderProperty().getProperties();
            } else {
                this.debugLog(methodName, "CaseFabricHeaderProperty properties is null.");
            }
        } else {
            this.debugLog(methodName, "CaseFabricHeaderProperty is null");
        }
        if (properties != null && properties.length > 0) {
            return NMUtil.deSerializeProperties((byte[])properties);
        }
        if (properties != null) {
            this.debugLog(methodName, "Properties in CaseHeaderFabric Property is of size  0");
        }
        throw new CaseSEException(74200, new Object[]{caseInstance.getCaseId()}, null);
    }

    private void setCaseScaProperties(NormalizedMessage normalizedMessage, String compositeDN, String componentName, CaseHeader caseHeader) {
        caseHeader.setCompositeInstanceId((String)normalizedMessage.getProperty("tracking.compositeInstanceId"));
        caseHeader.setCompositeDn(compositeDN);
        CompositeNameModel compositeNameModel = CompositeNameModel.parseDN((String)compositeDN);
        caseHeader.setApplicationName(compositeNameModel.getFolder());
        caseHeader.setCompositeName(compositeNameModel.getCompositeName());
        caseHeader.setCompositeVersion(compositeNameModel.getRevision());
        caseHeader.setComponentName(componentName);
        caseHeader.setParentComponentInstanceId((String)normalizedMessage.getProperty("tracking.parentComponentInstanceId"));
        caseHeader.setParentComponentInstRefId((String)normalizedMessage.getProperty("tracking.parentReferenceId"));
        caseHeader.setEcid((String)normalizedMessage.getProperty("tracking.ecid"));
    }

    private Case getCase(Element element) {
        NodeList nodelist = element.getElementsByTagNameNS(CASE_NS, "case");
        if (nodelist.getLength() == 0) {
            return null;
        }
        Element node = (Element)nodelist.item(0);
        return this.getCaseFromCaseElement(node);
    }

    private Case getCaseFromCaseElement(Element node) {
        MOXyUtil moxyUtil = new MOXyUtil("moxy/caseinstance/eclipselink-oxm.xml", "oracle.bpm.casemgmt.persistence.model", Case.class);
        return (Case)moxyUtil.unmarshall((Node)node, Case.class);
    }

    private CaseIdentifier getCaseIdentifierFromElement(Element node) {
        if (node == null) {
            return null;
        }
        String caseId = null;
        Long caseNumber = null;
        String identificationKey = null;
        NodeList nodeList = node.getElementsByTagNameNS(CASESERVICE_NS, CASE_ID_ELEMENT);
        if (nodeList.getLength() != 0) {
            caseId = nodeList.item(0).getTextContent();
        }
        if ((nodeList = node.getElementsByTagNameNS(CASESERVICE_NS, ID_KEY_ELEMENT)).getLength() != 0) {
            identificationKey = nodeList.item(0).getTextContent();
        }
        if ((nodeList = node.getElementsByTagNameNS(CASESERVICE_NS, CASE_NUMBER_ELEMENT)).getLength() != 0 && nodeList.item(0).getTextContent() != null) {
            caseNumber = Long.valueOf(nodeList.item(0).getTextContent());
        }
        CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, caseNumber, identificationKey);
        return caseIdentifier;
    }

    private Element getCaseElementFromCase(Case caseInstance) throws Exception {
        MOXyUtil moxyUtil = new MOXyUtil("moxy/caseinstance/eclipselink-oxm.xml", "oracle.bpm.casemgmt.persistence.model", Case.class);
        Element caseElement = (Element)((Object)XMLUtil.createDocument());
        moxyUtil.marshal((Object)caseInstance, (Node)caseElement);
        return caseElement;
    }

    private String getXMLStringFromCaseMetadata(CaseMetadata caseMetadata) {
        Element element = this.toElement(caseMetadata);
        return XMLUtil.toString((Node)element);
    }

    private String getOutcome(Element param) {
        Element inputElement = XMLUtil.convertToXMLElement((Element)param);
        String outcome = XMLUtil.getFirstChildElementValue((Element)inputElement, (String)OUTCOME_ELEMENT);
        return outcome;
    }

    private CaseIdentifier getCaseIdentifier(Element param) {
        Element inputElement = XMLUtil.convertToXMLElement((Element)param);
        Element caseIdentifierElement = XMLUtil.getFirstChildElement((Element)inputElement, (String)CASE_IDENTIFIER_ELEMENT);
        if (caseIdentifierElement != null) {
            String caseId = XMLUtil.getFirstChildElementValue((Element)caseIdentifierElement, (String)CASE_ID_ELEMENT);
            String identificationKey = XMLUtil.getFirstChildElementValue((Element)caseIdentifierElement, (String)ID_KEY_ELEMENT);
            String caseNumberString = XMLUtil.getFirstChildElementValue((Element)caseIdentifierElement, (String)CASE_NUMBER_ELEMENT);
            Long caseNumber = 0L;
            if (caseNumberString != null && !caseNumberString.trim().equals("")) {
                caseNumber = new Long(caseNumberString);
            }
            CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, caseNumber, identificationKey);
            return caseIdentifier;
        }
        return null;
    }

    private Element getCaseIdentifierElement(String outputMessage, CaseIdentifier caseIdentifier) throws Exception {
        Document document = XMLUtil.createDocument();
        Element message = document.createElementNS(CASESERVICE_NS, outputMessage);
        Element parent = document.createElementNS(CASESERVICE_NS, CASE_IDENTIFIER_ELEMENT);
        String caseId = caseIdentifier.getCaseId();
        String identificationKey = caseIdentifier.getIdentificationKey();
        Long caseNumber = caseIdentifier.getCaseNumber();
        Element caseIdElement = document.createElementNS(CASESERVICE_NS, CASE_ID_ELEMENT);
        caseIdElement.appendChild(document.createTextNode(caseId));
        parent.appendChild(caseIdElement);
        Element idKeyElement = document.createElementNS(CASESERVICE_NS, ID_KEY_ELEMENT);
        idKeyElement.appendChild(document.createTextNode(identificationKey));
        parent.appendChild(idKeyElement);
        Element caseNumberElement = document.createElementNS(CASESERVICE_NS, CASE_NUMBER_ELEMENT);
        caseNumberElement.appendChild(document.createTextNode(caseNumber.toString()));
        parent.appendChild(caseNumberElement);
        message.appendChild(parent);
        document.appendChild(message);
        return message;
    }

    private Element getBooleanResultElement(String outputMessage, String elementName, boolean value) throws Exception {
        Document document = XMLUtil.createDocument();
        Element message = document.createElementNS(CASESERVICE_NS, outputMessage);
        Element booleanResult = document.createElementNS(CASESERVICE_NS, elementName);
        booleanResult.appendChild(document.createTextNode(Boolean.toString(value)));
        message.appendChild(booleanResult);
        return message;
    }

    private Element getPayloadElement(NormalizedMessage normalizedMessage) {
        Map payload = normalizedMessage.getPayload();
        Element casePayload = (Element)payload.get(PAYLOAD_ELEMENT);
        if (casePayload instanceof Element) {
            return (Element)casePayload.cloneNode(true);
        }
        return null;
    }

    private void deploy(ComponentModel componentModel, boolean isRedeployment, boolean keepInstancesOnRedeploy) {
        String methodName = "deploy";
        if (!this.mClusterInterface.isLeader()) {
            this.debugLog(methodName, "Not a lead node in cluster");
            return;
        }
        this.importOrganization(componentModel);
        String caseDefinitionId = null;
        try {
            caseDefinitionId = this.deployCaseMetadata(componentModel, isRedeployment);
            this.deployCaseActivities(componentModel, isRedeployment, keepInstancesOnRedeploy, caseDefinitionId);
            this.registerCaseForms(componentModel, caseDefinitionId);
            this.onDeployCreateCasePermissions(componentModel, caseDefinitionId, isRedeployment);
        }
        catch (Exception e) {
            throw new FabricDeploymentException((Throwable)e);
        }
        finally {
            this.removeCaseMetadataFromCache(caseDefinitionId);
        }
    }

    private void registerCaseForms(ComponentModel compModel, String caseDefId) throws CaseSEException {
        try {
            List<TData> caseDataList;
            List<CaseActivity> activityList;
            IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
            IInternalCaseService service = ServicesLocator.getInternalCaseService();
            CaseMetadata caseMetadata = ServicesLocator.getCaseMetadataService().getCaseMetadata(ctx, caseDefId);
            ArrayList<String> values = new ArrayList<String>();
            values.add(caseDefId);
            List metadataList = ServicesLocator.getCaseService().listCaseDefinition(ctx, ICaseMetadataService.SEARCH_TYPE_ENUM.CASE_DEFINITION_ID, values);
            TCaseActivity activity = null;
            CaseDefinition metadata = null;
            if (metadataList != null && !metadataList.isEmpty()) {
                metadata = (CaseDefinition)metadataList.get(0);
            }
            if ((activityList = this.getCaseActivityMetadataList(compModel.getComposite())) != null && !activityList.isEmpty()) {
                for (CaseActivity activityMetadata : activityList) {
                    activity = (TCaseActivity)activityMetadata.getValue();
                    service.deployCaseDisplayInfo(metadata, activity.getName(), ICaseMetadataService.FORM_TYPE.CASEACTIVITYFORM);
                }
            }
            if ((caseDataList = CaseUtil.getMetaDataOfCaseData(caseMetadata)) != null && !caseDataList.isEmpty()) {
                for (TData caseData : caseDataList) {
                    service.deployCaseDisplayInfo(metadata, caseData.getName(), ICaseMetadataService.FORM_TYPE.CASEDATAFORM);
                }
            }
            service.deployCaseDisplayInfo(metadata, metadata.getName(), ICaseMetadataService.FORM_TYPE.CASESUMMARYFORM);
        }
        catch (Exception e) {
            throw new FabricDeploymentException((Throwable)e);
        }
    }

    private void importOrganization(ComponentModel componentModel) {
        try {
            CompositeModel compositeModel = componentModel.getComposite();
            Document dom = compositeModel.getMetadataManager().getDocumentAsDOM(ORGANIZATION_FILE_NAME);
            if (dom == null) {
                return;
            }
            Organization organization = DeploymentDescriptorUtil.getBPMOrganization((Document)dom);
            if (organization == null) {
                return;
            }
            IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
            DeploymentDescriptorUtil.importOrganization((IBPMContext)ctx, (Organization)organization);
        }
        catch (Exception e) {
            throw new FabricDeploymentException((Throwable)e);
        }
    }

    private void undeploy(ComponentModel componentModel, boolean isRedeployment, boolean keepInstancesOnRedeploy) {
        String methodName = "undeploy";
        if (!this.mClusterInterface.isLeader()) {
            this.debugLog(methodName, "Not a lead node in cluster");
            return;
        }
        boolean thisComponentRemoved = false;
        if (isRedeployment) {
            thisComponentRemoved = this.wasUndeployedComponentRemoved(componentModel.getComposite().getDN(), componentModel.getName());
        }
        if (thisComponentRemoved) {
            this.debugLog(methodName, "Detected task component was removed in redeploy, setting isRedployment and keepIntances flags to false");
            isRedeployment = false;
            keepInstancesOnRedeploy = false;
        }
        IInternalCaseService internalService = ServicesLocator.getInternalCaseService();
        String caseDefinitionId = this.getCaseDefinitionId(componentModel);
        IBPMContext context = null;
        try {
            context = InternalBPMContext.getInternalBPMContext();
            internalService.onUndeployComponent(context, caseDefinitionId, keepInstancesOnRedeploy);
            this.undeployCaseDefinition(componentModel, isRedeployment);
            this.undeployCaseActivityDefinitions(componentModel, isRedeployment);
        }
        catch (Exception e) {
            throw new FabricDeploymentException((Throwable)e);
        }
    }

    private FabricConfigManager getFabricConfigManager() {
        return this.mFabricConfigManager;
    }

    private FabricMesh getMesh() {
        return this.mFabricMesh;
    }

    private String deployCaseMetadata(ComponentModel componentModel, boolean isRedeployment) throws CaseSEException {
        String methodName = "deployCaseMetadata";
        String caseDefinitionId = null;
        try {
            CompositeModel compositeModel = componentModel.getComposite();
            String componentName = componentModel.getName();
            this.debugLog(methodName, "componentName: " + componentName);
            caseDefinitionId = this.getCaseDefinitionId(componentModel);
            CaseMetadata caseMetadata = this.getCaseMetadata(compositeModel, componentName, null);
            ((TCaseMetadata)caseMetadata.getValue()).setId(caseDefinitionId);
            this.cacheCaseMetadata(caseDefinitionId, caseMetadata);
            IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
            IInternalCaseService service = ServicesLocator.getInternalCaseService();
            service.onDeployCase(ctx, componentModel, caseMetadata, isRedeployment);
            this.debugLog(methodName, "case metadata id:" + caseDefinitionId);
            return caseDefinitionId;
        }
        catch (Exception e) {
            throw new CaseSEException(74207, new Object[]{componentModel.getName()}, e);
        }
    }

    private void onDeployCreateCasePermissions(ComponentModel componentModel, String caseDefinitionId, boolean isRedeployment) throws CaseSEException {
        try {
            IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
            CaseMetadata metadata = this.getCaseMetadataFromCache(caseDefinitionId);
            CompositeModel compositeModel = componentModel.getComposite();
            ICasePermissionServiceInternal permSvcIntl = ServicesLocator.getCasePermissionServiceInternal();
            permSvcIntl.onDeployCreateCasePermissions(ctx, compositeModel.getName(), metadata, isRedeployment);
        }
        catch (Exception e) {
            throw new CaseSEException(74209, new Object[]{componentModel.getName()}, e);
        }
    }

    private String getCaseActivitySource(ComponentModel componentModel) {
        String methodName = "getCaseActivitySource";
        ImplementationType implementationType = componentModel.getImplementationType();
        String caseActivityPath = null;
        this.debugLog(methodName, "Implementation Type is: " + implementationType.getType());
        if (implementationType.getType() != null) {
            if (implementationType.getType().equalsIgnoreCase(WORKFLOW_SE_IMPL)) {
                WorkflowImplementation workflowImpl = (WorkflowImplementation)componentModel.getImplementation();
                String taskPath = workflowImpl.getSrc();
                this.debugLog(methodName, "Getting case activity path for workflow path: " + taskPath);
                caseActivityPath = this.getCaseActivityPathForTask(taskPath);
            } else if (implementationType.getType().equalsIgnoreCase(BPMN_SE_IMPL)) {
                BPMNImplementation BPMNImpl = (BPMNImplementation)componentModel.getImplementation();
                String bpmnPath = BPMNImpl.getSrc();
                this.debugLog(methodName, "Getting case activity path for bpmn path: " + bpmnPath);
                caseActivityPath = this.getCaseActivityPathforBPMN(bpmnPath);
            } else {
                return null;
            }
        }
        return caseActivityPath;
    }

    private void deployCaseActivities(ComponentModel componentModel, boolean isRedeployment, boolean keepInstancesOnRedeploy, String caseMetadataId) throws CaseSEException {
        String methodName = "deployCaseActivities";
        CompositeModel compositeModel = componentModel.getComposite();
        List<URI> activitiesURI = this.getActivities(compositeModel);
        for (URI activityURI : activitiesURI) {
            this.debugLog(methodName, "Activity URI:" + activityURI);
            this.deployCaseActivity(activityURI, componentModel, isRedeployment, keepInstancesOnRedeploy, caseMetadataId);
        }
    }

    private List<URI> getActivities(CompositeModel compositeModel) throws CaseSEException {
        MdsCompositeQuery compositeQuery = new MdsCompositeQuery(compositeModel);
        List allActivities = null;
        try {
            allActivities = compositeQuery.query("", "%.caseactivity");
        }
        catch (Exception e) {
            throw new CaseSEException(74203, new Object[0], e);
        }
        return allActivities;
    }

    private void deployCaseActivity(URI activityURI, ComponentModel componentModel, boolean isRedeployment, boolean keepInstancesOnRedeploy, String caseMetadataId) throws CaseSEException {
        CompositeModel compositeModel = componentModel.getComposite();
        String caseActivityDefinitionId = null;
        CaseActivity caseActivity = this.getCaseActivityMetadata(activityURI, compositeModel, isRedeployment, keepInstancesOnRedeploy);
        try {
            if (caseActivity != null) {
                caseActivityDefinitionId = this.getCaseActivityDefinitionId(compositeModel, activityURI);
                ((TCaseActivity)caseActivity.getValue()).setActivityDefinitionId(caseActivityDefinitionId);
                this.cacheCaseActivityMetadata(caseActivityDefinitionId, caseActivity);
                IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
                IInternalCaseService service = ServicesLocator.getInternalCaseService();
                service.onDeployCaseActivity(ctx, componentModel, caseActivity, isRedeployment, keepInstancesOnRedeploy, caseMetadataId);
            }
        }
        catch (Exception e) {
            throw new CaseSEException(74208, new Object[]{activityURI}, e);
        }
        finally {
            this.removeCaseActivityMetadataFromCache(caseActivityDefinitionId);
        }
    }

    private CaseActivity unmarshalCaseActivityMetadata(Document caseActivityDocument) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"oracle.bpm.casemgmt.metadata.activity.model");
        return (CaseActivity)jaxbContext.createUnmarshaller().unmarshal((Node)caseActivityDocument);
    }

    private String getCaseActivityPathforBPMN(String bpmnPath) {
        String caseActivityPath = bpmnPath.replace(".bpmn", ".caseactivity");
        return caseActivityPath;
    }

    private String getCaseActivityPathForTask(String taskPath) {
        String caseActivityPath = taskPath.replace(".task", ".caseactivity");
        return caseActivityPath;
    }

    private ClusterInterface getClusterInterface() {
        return this.mClusterInterface;
    }

    private InstanceManager getInstanceManager() {
        return this.mInstanceManager;
    }

    private String getActivityNameFromCaseActivityDefinitionId(String caseActivityDefinitionId) {
        int position = caseActivityDefinitionId.lastIndexOf(METADATA_ID_DELIMITER);
        if (position == -1) {
            return null;
        }
        String activityNameWithoutSuffix = caseActivityDefinitionId.substring(position + 1);
        return activityNameWithoutSuffix + ".caseactivity";
    }

    private CompositeModel getCompositeModelFromCompositeDN(String compositeDN) {
        return this.getMesh().getComposite(compositeDN);
    }

    private String getCaseSource(ComponentModel componentModel) {
        CaseManagementImplementation cmImpl = (CaseManagementImplementation)componentModel.getImplementation();
        return cmImpl.getSrc();
    }

    private synchronized void cacheCaseMetadata(String caseDefinitionId, CaseMetadata caseMetadata) {
        this.mCaseMetadataCache.put(caseDefinitionId, caseMetadata);
    }

    private synchronized void removeCaseMetadataFromCache(String caseDefinitionId) {
        if (caseDefinitionId != null) {
            this.mCaseMetadataCache.remove(caseDefinitionId);
        }
    }

    private CaseMetadata getCaseMetadataFromCache(String caseDefinitionId) {
        return this.mCaseMetadataCache.get(caseDefinitionId);
    }

    private synchronized void cacheCaseActivityMetadata(String caseActivityDefinitionId, CaseActivity caseActivity) {
        this.mCaseActivityMetadataCache.put(caseActivityDefinitionId, caseActivity);
    }

    private synchronized void removeCaseActivityMetadataFromCache(String caseActivityDefinitionId) {
        if (caseActivityDefinitionId != null) {
            this.mCaseActivityMetadataCache.remove(caseActivityDefinitionId);
        }
    }

    private CaseActivity getCaseActivityMetadataFromCache(String caseActivityDefinitionId) {
        return this.mCaseActivityMetadataCache.get(caseActivityDefinitionId);
    }

    private CaseMetadata unmarshalCaseMetadata(Document caseDocument) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"oracle.bpm.casemgmt.metadata.Case.model");
        return (CaseMetadata)jaxbContext.createUnmarshaller().unmarshal((Node)caseDocument);
    }

    private ComponentModel getComponentModel(CompositeModel compositeModel, String componentName) {
        if (compositeModel == null) {
            return null;
        }
        ComponentModel componentModel = compositeModel.getComponent(componentName);
        return componentModel;
    }

    private synchronized Document getDocument(MetadataManager mdm, String caseDef, String mdsLabel) {
        if (mdm instanceof MDSMetadataManagerImpl && mdsLabel != null) {
            try {
                ((MDSMetadataManagerImpl)mdm).updateSession(mdsLabel);
            }
            catch (RuntimeException re) {
                // empty catch block
            }
        }
        return mdm.getDocumentAsDOM(caseDef);
    }

    private void undeployCaseDefinition(ComponentModel componentModel, boolean isRedeployment) throws CaseSEException {
        String caseDefinitionId = null;
        try {
            caseDefinitionId = this.getCaseDefinitionId(componentModel);
            IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
            IInternalCaseService service = ServicesLocator.getInternalCaseService();
            service.onUndeployCase(ctx, caseDefinitionId, isRedeployment);
        }
        catch (Exception e) {
            throw new CaseSEException(74210, new Object[]{caseDefinitionId}, e);
        }
    }

    private void undeployCaseActivityDefinitions(ComponentModel componentModel, boolean isRedeployment) throws CaseSEException {
        CompositeModel compositeModel = componentModel.getComposite();
        List<URI> activitiesURI = this.getActivities(compositeModel);
        for (URI activityURI : activitiesURI) {
            this.undeployCaseActivityDefinition(activityURI, componentModel, isRedeployment);
        }
    }

    private void undeployCaseActivityDefinition(URI activityURI, ComponentModel componentModel, boolean isRedeployment) throws CaseSEException {
        String caseActivityDefinitionId = null;
        try {
            CompositeModel compositeModel = componentModel.getComposite();
            caseActivityDefinitionId = this.getCaseActivityDefinitionId(compositeModel, activityURI);
            IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
            IInternalCaseService service = ServicesLocator.getInternalCaseService();
            service.onUndeployCaseActivity(ctx, caseActivityDefinitionId, isRedeployment);
        }
        catch (Exception e) {
            throw new CaseSEException(74211, new Object[]{caseActivityDefinitionId}, e);
        }
    }

    private NormalizedMessage requestToMesh(NormalizedMessage normalizedMessage, String operationName, InvocationContext invocationContext) throws CaseServiceException {
        String methodName = "requestToMesh";
        this.logNormalizedMessage(methodName, "Processing request - operation: " + operationName + "\n sourceURI: " + invocationContext.getWire().getSourceURI() + "\n targetURI: " + invocationContext.getWire().getTargetURI() + "\n message:", normalizedMessage);
        OperationImpl operation = new OperationImpl();
        operation.setName(operationName);
        NormalizedMessage reply = null;
        this.logNormalizedMessage(methodName, "Requesting to mesh:", normalizedMessage);
        try {
            reply = this.getMesh().request(normalizedMessage, (Operation)operation, invocationContext);
            this.logNormalizedMessage(methodName, "Output Normalized Message:", reply);
        }
        catch (BusinessFaultException e) {
            throw new CaseServiceException(74202, new Object[]{operationName, invocationContext.getWire().getSourceURI(), invocationContext.getWire().getTargetURI()}, (Throwable)e);
        }
        catch (FabricInvocationException e) {
            throw new CaseServiceException(74202, new Object[]{operationName, invocationContext.getWire().getSourceURI(), invocationContext.getWire().getTargetURI()}, (Throwable)e);
        }
        return reply;
    }

    private void postToMesh(NormalizedMessage normalizedMessage, String operationName, InvocationContext invocationContext) throws CaseServiceException {
        String methodName = "postToMesh";
        OperationImpl operation = new OperationImpl();
        operation.setName(operationName);
        this.logNormalizedMessage(methodName, "Processing post - operation: " + operationName + "\n sourceURI: " + invocationContext.getWire().getSourceURI() + "\n targetURI: " + invocationContext.getWire().getTargetURI() + "\n message:", normalizedMessage);
        try {
            this.getMesh().post(normalizedMessage, (Operation)operation, invocationContext);
        }
        catch (FabricInvocationException e) {
            throw new CaseServiceException(74201, new Object[]{operationName, invocationContext.getWire().getSourceURI(), invocationContext.getWire().getTargetURI()}, (Throwable)e);
        }
    }

    private void initInvocationCallback() {
        CaseActivityInvocationCallbackProvider provider = CaseActivityInvocationCallbackProvider.getInstance();
        CaseActivityInvocationCallback callback = new CaseActivityInvocationCallback();
        provider.setCallback((ICaseActivityInvocationCallback)callback);
    }

    private boolean wasUndeployedComponentRemoved(String sourceCompositeDN, String sourceComponentName) {
        boolean wasUndeployedComponentRemoved = false;
        CompositeModel targetCompositeModel = this.findTargetCompositeForRedeployKeepInstancesRunning(new oracle.fabric.composite.CompositeDN(sourceCompositeDN));
        if (targetCompositeModel != null) {
            ComponentModel targetComponentModel = targetCompositeModel.getComponent(sourceComponentName);
            return targetComponentModel == null;
        }
        return wasUndeployedComponentRemoved;
    }

    private CompositeModel findTargetCompositeForRedeployKeepInstancesRunning(oracle.fabric.composite.CompositeDN sourceCompositeDN) {
        CompositeModel result = null;
        for (CompositeModel runningModel : this.getMesh().listComposites()) {
            oracle.fabric.composite.CompositeDN runningCompositeDN = new oracle.fabric.composite.CompositeDN(runningModel.getDN());
            if (!runningCompositeDN.getApplicationName().equals(sourceCompositeDN.getApplicationName()) || !runningCompositeDN.getCompositeName().equals(sourceCompositeDN.getCompositeName()) || !runningCompositeDN.getRevision().equals(sourceCompositeDN.getRevision()) || runningCompositeDN.getLabel().equals(sourceCompositeDN.getLabel())) continue;
            result = runningModel;
            break;
        }
        return result;
    }

    private void validateRequest(NormalizedMessage normalizedMessage, String operationName, InvocationContext invocationContext) throws FabricInvocationException {
        String caseId;
        if (START_CASE.equals(operationName)) {
            return;
        }
        Object property = normalizedMessage.getProperty(NM_CASEID);
        if (property != null && (caseId = (String)property) != null && !caseId.trim().equals("")) {
            return;
        }
        throw new FabricInvocationException();
    }

    private boolean isWeblogicServer() {
        return TaskFlowPropsUtil.isWeblogicServer();
    }

    private boolean isCaseSupported() {
        return CaseServiceUtil.isCaseInstall() && this.isWeblogicServer() && DatabaseInfo.isWorkflowSchemaFor111170orLater();
    }

    private void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ENGINE, (Severity)Severity.DEBUG, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + message + "\n"));
    }

    private void warnLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ENGINE, (Severity)Severity.WARNING, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + message + "\n"));
    }

    private void logNormalizedMessage(String methodName, String message, NormalizedMessage nm) {
        StringBuffer buf = new StringBuffer();
        buf.append(message);
        buf.append("\n---------------------------------------------------------------\n");
        buf.append("NormalizedMessage Headers:\n");
        if (nm.getHeaders() != null) {
            for (Object header : nm.getHeaders()) {
                buf.append(header).append("\n");
            }
        }
        buf.append("\n---------------------------------------------------------------\n");
        buf.append("NormalizedMessage Properties:\n");
        if (nm.getProperties() != null) {
            for (Object propName : nm.getProperties().keySet()) {
                buf.append(propName + ":" + nm.getProperties().get(propName) + "\n");
            }
        }
        buf.append("\n---------------------------------------------------------------\n");
        buf.append("NormalizedMessage Payload:\n");
        Map payloadMap = nm.getPayload();
        if (payloadMap != null) {
            for (Object payloadKey : payloadMap.keySet()) {
                Object payload = payloadMap.get(payloadKey);
                String payloadStr = payload instanceof Node ? XMLUtil.toString((Node)((Node)payload)) : payload.toString();
                buf.append(payloadKey + ":\n").append(payloadStr);
            }
        }
        this.debugLog(methodName, buf.toString());
    }

    static {
        CASE_HEADER_QUERY_PREFIX = ICaseConstants.caseInstance + "." + ICaseConstants.caseHeader + ".";
    }
}

