/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.event;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.common.resources.i18n.CaseManagementResourceBundle;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.interceptors.SetReturnDisplayNameAdvice;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseEventUtil {
    public static String getEventDisplayName(IBPMContext ctx, CaseEvent ce) {
        switch (ce.getEventType()) {
            case ACTIVITY_EVENT: {
                return CaseEventUtil.getActivityEventDisplayName(ctx, ce.getCaseId(), ce.getActivityEvent().value(), ce.getActivityName());
            }
            case COMMENT_EVENT: {
                return CaseEventUtil.getCommentEventDisplayName(ctx, ce);
            }
            case DOCUMENT_EVENT: {
                return CaseEventUtil.getDocumentEventDisplayName(ctx, ce.getDocumentEvent().value(), ce.getDocumentName());
            }
            case LIFECYCLE_EVENT: {
                return CaseEventUtil.getLifecycleEventDisplayName(ctx, ce.getLifecycleEvent().value());
            }
            case MILESTONE_EVENT: {
                return CaseEventUtil.getMilestoneEventDisplayName(ctx, ce.getCaseId(), ce.getMilestone(), ce.getMilestoneEvent().value());
            }
            case USER_DEFINED_EVENT: {
                return CaseEventUtil.getUserDefinedEventDisplayName(ctx, ce.getUserDefinedEvent());
            }
            case DATA_UPLOAD_EVENT: {
                return CaseEventUtil.getDataUploadEventDisplayName(ctx, ce.getDataName());
            }
        }
        return null;
    }

    public static String getActivityEventDisplayName(IBPMContext ctx, String caseId, String activityEventValue, String activityName) {
        String translated_activityName = caseId != null ? CaseEventUtil.getDisplayNameFromCaseDefinition(ctx, caseId, activityName) : activityName;
        String[] args = new String[]{translated_activityName};
        String msgKey = "msg.activity." + activityEventValue;
        return CaseEventUtil.getEventDisplayName(ctx, msgKey, args);
    }

    public static String getCommentEventDisplayName(IBPMContext ctx, CaseEvent ce) {
        String commentString = ": ";
        if (ce.getCommentEventComment() != null) {
            commentString = commentString + ce.getCommentEventComment();
        } else if (ce.getComment() != null && ce.getComment().getCaseObjectComment() != null) {
            commentString = commentString + ce.getComment().getCaseObjectComment();
        }
        return CaseEventUtil.getEventDisplayName(ctx, "msg.comment", null) + commentString;
    }

    public static String getDocumentEventDisplayName(IBPMContext ctx, String documentEventValue, String documentName) {
        String[] args = new String[]{documentName};
        String msgKey = "msg.document." + documentEventValue;
        return CaseEventUtil.getEventDisplayName(ctx, msgKey, args);
    }

    public static String getLifecycleEventDisplayName(IBPMContext ctx, String lifecycleEventValue) {
        String msgKey = "msg.Case." + lifecycleEventValue;
        return CaseEventUtil.getEventDisplayName(ctx, msgKey, null);
    }

    public static String getMilestoneEventDisplayName(IBPMContext ctx, String caseId, String milestoneName, String milestoneEventValue) {
        String translated_milestoneName = caseId != null ? CaseEventUtil.getDisplayNameFromCaseDefinition(ctx, caseId, milestoneName) : milestoneName;
        String[] args = new String[]{translated_milestoneName};
        String msgKey = "msg.milestone." + milestoneEventValue;
        return CaseEventUtil.getEventDisplayName(ctx, msgKey, args);
    }

    public static String getUserDefinedEventDisplayName(IBPMContext ctx, String userDefinedEvent) {
        String[] args = new String[]{userDefinedEvent};
        return CaseEventUtil.getEventDisplayName(ctx, "msg.user_defined_event", args);
    }

    public static String getDataUploadEventDisplayName(IBPMContext ctx, String dataName) {
        String[] args = new String[]{dataName};
        return CaseEventUtil.getEventDisplayName(ctx, "msg.data_upload", args);
    }

    private static Locale getLocale(IBPMContext ctx) {
        Locale locale = null;
        if (locale == null && ctx != null) {
            locale = ctx.getDisplayNameLocale();
        }
        if (locale == null && ctx != null) {
            locale = ctx.getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private static ResourceBundle getBundle(IBPMContext ctx) {
        Locale locale = CaseEventUtil.getLocale(ctx);
        return ResourceBundle.getBundle(CaseManagementResourceBundle.class.getName(), locale);
    }

    private static String getEventDisplayName(IBPMContext ctx, String key, String[] args) {
        String value = CaseExceptionUtil.lookupKey((ResourceBundle)CaseEventUtil.getBundle(ctx), (String)key);
        String eventDisplayName = value != null ? MessageFormat.format(value, args) : "";
        return eventDisplayName;
    }

    private static String getDisplayNameFromCaseDefinition(IBPMContext ctx, String caseId, String key) {
        Locale locale = CaseEventUtil.getLocale(ctx);
        String caseDefinitionId = null;
        try {
            Case caseInstance = ServicesLocator.getCaseInstancePersistence().findCaseByCaseId(caseId);
            caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
            if (caseDefinitionId == null) {
                throw new IllegalArgumentException("No caseDefinitionId for caseId " + caseId);
            }
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)CaseEventUtil.class.getName(), (String)"getDisplayNameFromCaseDefinition", (Throwable)e);
            return null;
        }
        return SetReturnDisplayNameAdvice.getDisplayName(ctx, caseDefinitionId, locale, key);
    }

    public static enum CaseEventStringSearchField {
        object_display_name,
        case_id,
        commentEventComment,
        updated_by_display_name,
        updated_date;

    }
}

