/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.event;

import java.io.Serializable;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.event.ICaseEventPublisher;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseEventPublisher
implements ICaseEventPublisher {
    private String caseEventConnectionFactory;
    private String caseEventQueue;
    private QueueConnection m_connection;
    private Queue m_queue;
    private QueueSender m_sender;
    private QueueSession m_session;

    public void init() throws Exception {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_EVENT, (Severity)Severity.DEBUG, (String)("Using caseEventConnectionFactory = " + this.caseEventConnectionFactory + ", caseEventQueue = " + this.caseEventQueue));
        InitialContext jndi = new InitialContext();
        QueueConnectionFactory conFactory = (QueueConnectionFactory)jndi.lookup(this.caseEventConnectionFactory);
        this.m_connection = conFactory.createQueueConnection();
        this.m_session = this.m_connection.createQueueSession(false, 1);
        this.m_queue = (Queue)jndi.lookup(this.caseEventQueue);
        this.m_sender = this.m_session.createSender(this.m_queue);
        this.m_connection.start();
    }

    public void setCaseEventConnectionFactory(String factory) {
        this.caseEventConnectionFactory = factory;
    }

    public String getCaseEventConnectionFactory() {
        return this.caseEventConnectionFactory;
    }

    public void setCaseEventQueue(String queue) {
        this.caseEventQueue = queue;
    }

    public String getCaseEventQueue() {
        return this.caseEventQueue;
    }

    @Override
    public void publish(IBPMContext context, CaseIdentifier caseIdentifier, CaseEvent event) throws Exception {
        if (this.m_sender == null) {
            this.init();
        }
        ObjectMessage message = this.m_session.createObjectMessage();
        message.setObject((Serializable)event);
        this.m_sender.send((Message)message);
    }
}

