/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.event;

import java.io.File;
import java.util.UUID;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.event.ICaseEventPublisher;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.util.MOXyUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.fabric.blocks.event.BusinessEventConnection;
import oracle.fabric.common.BusinessEvent;
import oracle.integration.platform.blocks.event.BusinessEventBuilder;
import oracle.integration.platform.blocks.event.saq.SAQRemoteBusinessEventConnectionFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CaseEventEDNPublisher
implements ICaseEventPublisher {
    private BusinessEventConnection bec;
    private static final String CASE_EVENT_NAMESPACE = "http://xmlns.oracle.com/bpm/case/event";
    private static final String CASE_EVENT_LOCAL_NAME = "CaseEvent";

    public CaseEventEDNPublisher() {
        try {
            InitialContext ctx = new InitialContext();
            DataSource datasource = (DataSource)ctx.lookup("jdbc/EDNLocalTxDataSource");
            SAQRemoteBusinessEventConnectionFactory factory = new SAQRemoteBusinessEventConnectionFactory(datasource, datasource, null);
            this.bec = factory.createBusinessEventConnection();
        }
        catch (NamingException ne) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_EVENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"CaseEventEDNPublisher", (String)"Naming Exception", (Throwable)ne);
        }
    }

    @Override
    public void publish(IBPMContext context, CaseIdentifier caseIdentifier, CaseEvent ce) throws Exception {
        try {
            Case caseInstance = ServicesLocator.getInternalCaseService().getCase(context, caseIdentifier, null);
            String caseDefId = caseInstance.getCaseHeader().getCaseDefinitionId();
            CaseMetadata caseMetadata = ServicesLocator.getCaseMetadataService().getCaseMetadata(context, caseDefId);
            if (caseMetadata != null && ((TCaseMetadata)caseMetadata.getValue()).isSetPublishCaseEventsToEDN()) {
                BusinessEvent be = CaseEventEDNPublisher.buildEvent(ce);
                this.bec.publishEvent(be, 3);
            }
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_EVENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"publish", (String)"Exception in publishing business event", (Throwable)e);
        }
    }

    private static BusinessEvent buildEvent(CaseEvent ce) throws Exception {
        MOXyUtil moxyUtil = new MOXyUtil("moxy/event/eclipselink-oxm.xml", "oracle.bpm.casemgmt.persistence.model", CaseEvent.class);
        File tmpFile = File.createTempFile("activity.xml", null);
        String tmpFileName = tmpFile.getCanonicalPath();
        moxyUtil.marshal((Object)ce, tmpFileName);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document ceDoc = factory.newDocumentBuilder().parse(tmpFile);
        Element ceElem = ceDoc.getDocumentElement();
        QName eventName = new QName(CASE_EVENT_NAMESPACE, CASE_EVENT_LOCAL_NAME);
        BusinessEventBuilder beb = BusinessEventBuilder.newInstance();
        beb.setEventName(eventName);
        beb.setBody(ceElem);
        UUID uuid = UUID.randomUUID();
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_EVENT, (Severity)Severity.DEBUG, (String)("Creating event with eventName = " + eventName + ", BusinessEvent.EVENT_ID: " + "id" + " = " + uuid + ", caseEventDisplayName: " + ce.getObjectDisplayName()));
        beb.setProperty("id", (Object)uuid);
        beb.setProperty("tracking.conversationId", (Object)uuid);
        return beb.createEvent();
    }
}

