/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ejb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.config.ConfigurationManager;
import oracle.bpel.services.workflow.resource.i18NUtil;
import oracle.bpm.casemgmt.Case.model.CaseTranslation;
import oracle.bpm.casemgmt.Case.model.CaseTranslationPK;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseActivityService;
import oracle.bpm.casemgmt.ICaseEventService;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.IInternalCaseService;
import oracle.bpm.casemgmt.caseactivity.CaseActivityException;
import oracle.bpm.casemgmt.caseactivity.CaseActivityUtil;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityAttrib;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityAttribPK;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityCorrelation;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityCorrelationPK;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityDefinition;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityInCaseDefinition;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityInCaseDefinitionPK;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityInstance;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityInstancePK;
import oracle.bpm.casemgmt.casemetadata.model.CaseDefinition;
import oracle.bpm.casemgmt.casemetadata.model.CaseMilestoneDefinition;
import oracle.bpm.casemgmt.caserule.CaseBaseDictionaryFinder;
import oracle.bpm.casemgmt.caserule.CaseMgmtDictionaryHandler;
import oracle.bpm.casemgmt.caserule.model.CaseRule;
import oracle.bpm.casemgmt.caserule.model.CaseRuleEdit;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.ecm.database.DatabaseContentObject;
import oracle.bpm.casemgmt.event.CaseEventUtil;
import oracle.bpm.casemgmt.fabric.CaseManagementServiceEngine;
import oracle.bpm.casemgmt.fabric.CaseSEException;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseActivityMetadataCache;
import oracle.bpm.casemgmt.impl.CaseInstanceServiceImpl;
import oracle.bpm.casemgmt.impl.CaseMetadataCache;
import oracle.bpm.casemgmt.impl.CaseMetadataException;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCategory;
import oracle.bpm.casemgmt.metadata.Case.model.TMilestone;
import oracle.bpm.casemgmt.metadata.Case.model.TMilestones;
import oracle.bpm.casemgmt.metadata.activity.model.CaseActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TBpmnActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TCaseActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TCaseAssociations;
import oracle.bpm.casemgmt.metadata.activity.model.TCaseIdentifier;
import oracle.bpm.casemgmt.metadata.activity.model.TNMOutput;
import oracle.bpm.casemgmt.metadata.activity.model.TOutput;
import oracle.bpm.casemgmt.metadata.activity.model.TOutputParameter;
import oracle.bpm.casemgmt.metadata.activity.model.TOutputParameters;
import oracle.bpm.casemgmt.metadata.activity.model.TOutputs;
import oracle.bpm.casemgmt.metadata.activity.model.TParameters;
import oracle.bpm.casemgmt.metadata.activity.model.TSaveData;
import oracle.bpm.casemgmt.metadata.activity.model.TSaveDataAs;
import oracle.bpm.casemgmt.metadata.activity.model.TWorkflowActivity;
import oracle.bpm.casemgmt.metadata.event.model.TActivityEvent;
import oracle.bpm.casemgmt.metadata.event.model.TEventType;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.ICasePersistence;
import oracle.bpm.casemgmt.persistence.event.ICaseEventPersistence;
import oracle.bpm.casemgmt.persistence.factory.CaseEventFactory;
import oracle.bpm.casemgmt.persistence.instance.ICaseInstancePersistence;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.casemgmt.persistence.model.PropertyBag;
import oracle.bpm.casemgmt.util.CaseDisplayUtil;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.fabric.common.InvocationContext;
import oracle.fabric.common.NormalizedMessage;
import oracle.fabric.common.Operation;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import oracle.fabric.composite.model.CompositeNameModel;
import oracle.rules.sdk2.dictionary.DictionaryFinder;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import oracle.soa.management.config.workflow.LocaleType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class InternalCaseManagementService
extends DatabaseContentObject
implements IInternalCaseService {
    private static final String BPMN = "BPMN";
    private static final String HWF = "HWF";
    private static final String CUSTOM = "CUSTOM";
    private static final String BPMN_PARAMETERS = "parameters";
    private static final String HWF_PAYLOAD = "payload";
    private static final String CASE_ID = "cm.caseId";
    private static final String CORRELATION_ID = "cm.correlationId";
    private static final String DB_CORRELATION_ID = "correlationId";
    private static final String RESPONSE = "Response";
    private static final String INSTANCE_ID = "instanceId";
    private static final String TASK_NS = "http://xmlns.oracle.com/bpel/workflow/task";

    @Override
    public boolean updateCaseEvent(IBPMContext context, CaseEvent caseEvent, boolean raiseEvent) {
        String methodName = "updateCaseEvent";
        Calendar currentTime = CaseServiceUtil.getCalendarInstance(context);
        caseEvent.setUpdatedDate(currentTime);
        try {
            IBPMContext defaultLocaleCtx = null;
            String ceDisplayName = null;
            ceDisplayName = CaseEventUtil.getEventDisplayName(defaultLocaleCtx, caseEvent);
            this.logStartOfMethod(methodName, "Display Name:" + ceDisplayName + "\n" + "Case Id: " + caseEvent.getCaseId() + "\n" + "Event Type: " + caseEvent.getEventType() + "\n" + "Activity Name: " + caseEvent.getActivityName() + "\n" + "Activity Event: " + caseEvent.getActivityEvent() + "\n" + "Lifecycle Event: " + caseEvent.getLifecycleEvent() + "\n" + "Lifecycle State: " + caseEvent.getLifecycleState() + "\n" + "Milestone Event: " + caseEvent.getMilestoneEvent() + "\n" + "Milestone: " + caseEvent.getMilestone() + "\n" + "raiseEvent: " + raiseEvent + "\n");
            caseEvent.setObjectDisplayName(ceDisplayName);
            ServicesLocator.getCasePersistence().update(caseEvent);
            if (raiseEvent) {
                CaseIdentifier caseIdentifier = new CaseIdentifier(caseEvent.getCaseId(), null, null);
                ServicesLocator.getCaseEventPublisher().publish(context, caseIdentifier, caseEvent);
                ServicesLocator.getCaseEventEDNPublisher().publish(context, caseIdentifier, caseEvent);
            }
            this.logEndOfMethod(methodName, "Display Name:" + ceDisplayName + "\n" + "Case Id: " + caseEvent.getCaseId() + "\n" + "Event Type: " + caseEvent.getEventType() + "\n" + "Activity Name: " + caseEvent.getActivityName() + "\n" + "Activity Event: " + caseEvent.getActivityEvent() + "\n" + "Lifecycle Event: " + caseEvent.getLifecycleEvent() + "\n" + "Lifecycle State: " + caseEvent.getLifecycleState() + "\n" + "Milestone Event: " + caseEvent.getMilestoneEvent() + "\n" + "Milestone: " + caseEvent.getMilestone() + "\n");
            return true;
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_EVENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"updateCaseEvent", (String)"Exception in event publishing", (Throwable)e);
            return false;
        }
    }

    @Override
    public void onDeployCase(IBPMContext ctx, ComponentModel componentModel, CaseMetadata caseMetadata, boolean isRedeployment) throws CaseMetadataException {
        ClassLoader originalClassLoader = null;
        String caseDefinitionId = null;
        try {
            originalClassLoader = ServicesLocator.getCaseSE().setCompositeClassLoaderAsThreadContextLoader(componentModel.getComposite(), "RESOURCE_CLASSLOADER", ((TCaseMetadata)caseMetadata.getValue()).getId());
            if (isRedeployment) {
                this.purgeCaseMetadataFromCache(((TCaseMetadata)caseMetadata.getValue()).getId());
            }
            CaseDefinition caseDefn = this.createCaseDefinition(componentModel, caseMetadata);
            caseDefinitionId = caseDefn.getDefinitionId();
            ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
            CaseDefinition defn = casePersistence.find(CaseDefinition.class, caseDefinitionId);
            if (defn != null && isRedeployment) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onDeployCase", (String)("Redeploment chosen. Updating old caseDefn w/ id:" + caseDefinitionId));
                casePersistence.delete(CaseDefinition.class, caseDefinitionId);
                casePersistence.persist(caseDefn);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onDeployCase", (String)("CaseDefn w/ id:" + caseDefinitionId + " successfully updated"));
            } else {
                casePersistence.persist(caseDefn);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onDeployCase", (String)("New CaseDefn w/ id:" + caseDefinitionId + " successfully inserted"));
            }
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        catch (CasePersistenceException e) {
            try {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onDeployCase", (String)("CaseDefn w/ id:" + caseDefinitionId + " could not be persisted"));
                throw new CaseMetadataException(72806, new Object[]{caseDefinitionId}, (Throwable)((Object)e));
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onDeployCaseActivity(IBPMContext ctx, ComponentModel componentModel, CaseActivity caseActivity, boolean isRedeployment, boolean keepInstancesOnRedeploy, String caseDefinitionId) throws CaseMetadataException {
        String activityDefinitionId = null;
        ClassLoader originalClassLoader = null;
        try {
            CaseActivityDefinition caseActivityDefn;
            ICasePersistence casePersistence;
            CaseActivityDefinition defn;
            if (componentModel != null) {
                originalClassLoader = ServicesLocator.getCaseSE().setCompositeClassLoaderAsThreadContextLoader(componentModel.getComposite(), "RESOURCE_CLASSLOADER", caseDefinitionId);
            }
            if (isRedeployment) {
                this.purgeCaseActivityMetadataFromCache(((TCaseActivity)caseActivity.getValue()).getActivityDefinitionId());
            }
            if ((defn = (casePersistence = ServicesLocator.getCasePersistence()).find(CaseActivityDefinition.class, activityDefinitionId = (caseActivityDefn = this.createCaseActivityDefinition(componentModel, caseActivity, caseDefinitionId)).getDefinitionId())) != null && isRedeployment && !keepInstancesOnRedeploy) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onDeployCaseActivity", (String)("Redeployment chosen. Deleting and recreating old activityDefn w/ id:" + activityDefinitionId));
                casePersistence.delete(CaseActivityDefinition.class, activityDefinitionId);
                casePersistence.persist(caseActivityDefn);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onDeployCaseActivity", (String)("ActivityDefn w/ id:" + activityDefinitionId + " successfully recreated."));
            } else if (defn == null || !isRedeployment || !keepInstancesOnRedeploy) {
                casePersistence.persist(caseActivityDefn);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onDeployCaseActivity", (String)("New ActivityDefn w/ id:" + activityDefinitionId + " successfully inserted"));
            } else {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onDeployCaseActivity", (String)("Redeployment chosen. Updating old activityDefn w/ id:" + activityDefinitionId));
                casePersistence.update(caseActivityDefn);
                List caseActivityInCaseList = caseActivityDefn.getCaseActivityInCaseDefinitionList();
                for (CaseActivityInCaseDefinition caseAssociatedActivity : caseActivityInCaseList) {
                    CaseActivityInCaseDefinitionPK existingDefinitionPK = new CaseActivityInCaseDefinitionPK(caseAssociatedActivity.getActivityDefinitionId(), caseAssociatedActivity.getCaseDefinitionId());
                    CaseActivityInCaseDefinition existingDefinition = casePersistence.find(CaseActivityInCaseDefinition.class, existingDefinitionPK);
                    if (existingDefinition != null) {
                        casePersistence.delete(CaseActivityInCaseDefinition.class, existingDefinitionPK);
                        casePersistence.persist(caseAssociatedActivity);
                        continue;
                    }
                    casePersistence.persist(caseAssociatedActivity);
                }
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onDeployCaseActivity", (String)("ActivityDefn w/ id:" + activityDefinitionId + " successfully updated"));
            }
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            return;
        }
        catch (CasePersistenceException e) {
            try {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onDeployCaseActivity", (String)("ActivityDefn w/ id:" + activityDefinitionId + " could not be persisted"));
                throw new CaseMetadataException(72807, new Object[]{activityDefinitionId}, (Throwable)((Object)e));
                catch (CaseActivityException e2) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onDeployCaseActivity", (String)("ActivityDefn w/ id:" + activityDefinitionId + " could not be persisted."));
                    throw new CaseMetadataException(72807, new Object[]{activityDefinitionId}, (Throwable)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
                throw throwable;
            }
        }
    }

    @Override
    public void onUndeployCase(IBPMContext ctx, String caseDefinitionId, boolean isRedeployment) throws CaseMetadataException {
        this.purgeCaseMetadataFromCache(caseDefinitionId);
        try {
            if (!isRedeployment) {
                ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
                if (casePersistence.find(CaseDefinition.class, caseDefinitionId) != null) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onUndeployCase", (String)("Redeployment is not chosen. Deleting old definition w/ id:" + caseDefinitionId));
                    casePersistence.delete(CaseDefinition.class, caseDefinitionId);
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onUndeployCase", (String)("Delete for id:" + caseDefinitionId + " is successfull"));
                }
            } else {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onUndeployCase", (String)("Redeployment is chosen. Not deleting definition for id:" + caseDefinitionId));
            }
        }
        catch (CasePersistenceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onUndeployCase", (String)("Could not delete case defn with id:" + caseDefinitionId));
            throw new CaseMetadataException(72808, new Object[]{caseDefinitionId}, (Throwable)((Object)e));
        }
    }

    @Override
    public void onUndeployCaseActivity(IBPMContext ctx, String caseActivityDefinitionId, boolean isRedeployment) throws CaseMetadataException {
        this.purgeCaseActivityMetadataFromCache(caseActivityDefinitionId);
        try {
            if (!isRedeployment) {
                ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
                if (casePersistence.find(CaseActivityDefinition.class, caseActivityDefinitionId) != null) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onUndeployCaseActivity", (String)("Redeployment is not chosen. Deleting old definition w/ id:" + caseActivityDefinitionId));
                    casePersistence.delete(CaseActivityDefinition.class, caseActivityDefinitionId);
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onUndeployCaseActivity", (String)("Delete for id:" + caseActivityDefinitionId + " is successful"));
                }
            } else {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onUndeployCaseActivity", (String)("Redeployment is chosen. Not deleting definition for id:" + caseActivityDefinitionId));
            }
        }
        catch (CasePersistenceException e) {
            throw new CaseMetadataException(72809, new Object[]{caseActivityDefinitionId}, (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployCaseRule(IBPMContext ctx, ComponentModel componentModel, String comments, boolean isRedeploy) {
        CaseMetadata caseMetadata = null;
        try {
            caseMetadata = CaseManagementServiceEngine.getInstance().getCaseMetadata(componentModel);
        }
        catch (CaseSEException e1) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"deployCaseRule", (String)"Exception in getting case metadata", (Throwable)((Object)e1));
        }
        String caseNamespace = ((TCaseMetadata)caseMetadata.getValue()).getTargetNamespace();
        InputStream dictIs = null;
        InputStream updatedIs = null;
        RuleDictionary caseRd = null;
        try {
            CaseMgmtDictionaryHandler caseDictHandler = new CaseMgmtDictionaryHandler(componentModel);
            if (isRedeploy && (dictIs = ServicesLocator.getCaseRuleStreamService().getActiveDictionary(ctx, caseNamespace)) != null) {
                caseRd = RuleDictionary.readDictionary((Reader)new InputStreamReader(dictIs), (DictionaryFinder)new CaseBaseDictionaryFinder());
                caseDictHandler.updateDictionaryWithNewFacts(caseRd);
                updatedIs = this.dictionaryAsInputStream(caseRd.toDocument());
                ServicesLocator.getCaseRuleStreamService().commitDictionary(ctx, caseNamespace, updatedIs, comments, false);
            }
            if (dictIs == null) {
                caseRd = caseDictHandler.generateCaseRuleDictionary();
                dictIs = this.dictionaryAsInputStream(caseRd.toDocument());
                ServicesLocator.getCaseRuleStreamService().commitDictionary(ctx, caseNamespace, dictIs, comments, false);
            }
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"deployCaseRule", (String)"Exception in creating and saving dictionary", (Throwable)e);
        }
        finally {
            if (dictIs != null) {
                try {
                    dictIs.close();
                }
                catch (IOException e) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"deployCaseRule", (String)"Exception in saving dictionary", (Throwable)e);
                }
            }
        }
    }

    @Override
    public NormalizedMessage onActivityCallback(IBPMContext context, NormalizedMessage normalizedMessage, Operation operation, InvocationContext invocationContext) throws CaseActivityException {
        String methodName = "onActivityCallback";
        if (!invocationContext.isCallback()) {
            return null;
        }
        String caseId = (String)normalizedMessage.getProperty(CASE_ID);
        String correlationId = (String)normalizedMessage.getProperty(CORRELATION_ID);
        CaseEvent ce = null;
        boolean alreadyCompleted = false;
        try {
            ce = this.getStartActivityEvent(caseId, correlationId);
            if (ce == null && (ce = this.getEndActivityEvent(caseId, correlationId)) != null) {
                alreadyCompleted = true;
            }
            if (ce != null) {
                ICaseService caseService = ServicesLocator.getCaseService();
                IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
                CaseActivity caseActivity = caseService.getCaseActivityMetadata(ctx, ce.getObjectName());
                if (ce.getActivityType().equals(BPMN)) {
                    this.debugActivityLog(methodName, "BPMN callback. Need to populate the output data ..");
                    this.populateBPMNOutput(normalizedMessage, caseActivity, caseId);
                } else if (ce.getActivityType().equals(HWF)) {
                    this.debugActivityLog(methodName, "HWF callback. Need to populate the output data ..");
                    this.populateHWFOutput(normalizedMessage, caseActivity, caseId);
                }
                if (!alreadyCompleted) {
                    this.updateCaseActivityEvent(context, ce, TActivityEvent.COMPLETED, null, null, null, true);
                }
            }
        }
        catch (Exception e) {
            if (ce != null) {
                this.updateCaseActivityEvent(context, ce, TActivityEvent.FAULTED, null, null, null, true);
            }
            throw new CaseActivityException(74016, new Object[]{ce.getActivityId(), caseId, correlationId}, e);
        }
        return null;
    }

    public CaseEvent getStartActivityEvent(String caseId, String correlationId) throws CaseActivityException {
        String methodName = "getStartActivityEvent";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseId", caseId);
        parameters.put("eventType", TEventType.ACTIVITY_EVENT);
        parameters.put("activityEventType", TActivityEvent.ACTIVATED);
        parameters.put("propertyName", DB_CORRELATION_ID);
        parameters.put("propertyValue", correlationId);
        List events = null;
        try {
            events = persistence.findWithQuery(" select e from  CaseEvent e JOIN e.propertyBagCollection p  where e.case_id  = :caseId and e.event_type = :eventType and e.activity_event = :activityEventType  and  p.name = :propertyName and p.value = :propertyValue", parameters);
            if (events != null) {
                this.debugActivityLog(methodName, "count:" + events.size() + "\n");
            }
            if (events != null && events.size() == 1) {
                this.debugActivityLog(methodName, "event id:" + ((CaseEvent)events.get(0)).getEventId() + "\n" + "activity id:" + ((CaseEvent)events.get(0)).getActivityId() + "\n" + "activity type:" + ((CaseEvent)events.get(0)).getActivityType() + "\n" + "activity name:" + ((CaseEvent)events.get(0)).getActivityName());
                return (CaseEvent)events.get(0);
            }
            if (events == null || events.size() == 0) {
                return null;
            }
            if (events != null && events.size() > 1) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.WARNING, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + "Multiple Start activity events found for case id: " + caseId + " and correlationId: " + correlationId + "\n"));
                throw new CaseActivityException(74008, new Object[]{caseId, correlationId}, null);
            }
        }
        catch (CasePersistenceException e) {
            throw new CaseActivityException(74007, new Object[]{caseId, correlationId}, (Throwable)((Object)e));
        }
        throw new CaseActivityException(74007, new Object[]{caseId, correlationId}, null);
    }

    public CaseEvent getEndActivityEvent(String caseId, String correlationId) throws CaseActivityException {
        String methodName = "getEndActivityEvent";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseId", caseId);
        parameters.put("eventType", TEventType.ACTIVITY_EVENT);
        parameters.put("activityEventType", TActivityEvent.COMPLETED);
        parameters.put("propertyName", DB_CORRELATION_ID);
        parameters.put("propertyValue", correlationId);
        List events = null;
        try {
            events = persistence.findWithQuery(" select e from  CaseEvent e JOIN e.propertyBagCollection p  where e.case_id  = :caseId and e.event_type = :eventType and e.activity_event = :activityEventType  and  p.name = :propertyName and p.value = :propertyValue", parameters);
            if (events != null) {
                this.debugActivityLog(methodName, "count:" + events.size() + "\n");
            }
            if (events != null && events.size() == 1) {
                this.debugActivityLog(methodName, "event id:" + ((CaseEvent)events.get(0)).getEventId() + "\n" + "activity id:" + ((CaseEvent)events.get(0)).getActivityId() + "\n" + "activity type:" + ((CaseEvent)events.get(0)).getActivityType() + "\n" + "activity name:" + ((CaseEvent)events.get(0)).getActivityName());
                return (CaseEvent)events.get(0);
            }
            if (events == null || events.size() == 0) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + "End activity event for case id: " + caseId + " and correlationId: " + correlationId + " not found." + "\n"));
                return null;
            }
            if (events != null && events.size() > 1) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.WARNING, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + "Multiple End activity events found for case id: " + caseId + " and correlationId: " + correlationId + "\n"));
                return null;
            }
        }
        catch (CasePersistenceException e) {
            throw new CaseActivityException(74007, new Object[]{caseId, correlationId}, (Throwable)((Object)e));
        }
        return null;
    }

    @Override
    public void addActivityCorrelation(String caseId, String correlationId, String instanceId) throws CaseActivityException, CasePersistenceException {
        CaseActivityCorrelationPK correlationPK = new CaseActivityCorrelationPK(caseId, correlationId);
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        CaseActivityCorrelation oldCorrelation = persistence.find(CaseActivityCorrelation.class, correlationPK);
        if (oldCorrelation == null) {
            CaseActivityCorrelation correlation = new CaseActivityCorrelation();
            correlation.setCaseId(caseId);
            correlation.setCorrelationId(correlationId);
            correlation.setInstanceId(instanceId);
            persistence.persist(correlation);
        }
    }

    @Override
    public void invokeCaseActivity(IBPMContext ctx, String caseId, String caseActivityDefinitionId) throws CaseActivityException, CaseServiceException {
        ICaseActivityService service = ServicesLocator.getCaseActivityService();
        try {
            if (!this.isAutomaticActivity(caseActivityDefinitionId)) {
                if (this.isRepeatable(this.getCaseActivityDefinition(caseActivityDefinitionId), caseId)) {
                    this.activateActivity(caseId, caseActivityDefinitionId);
                }
            } else if (this.isRepeatable(this.getCaseActivityDefinition(caseActivityDefinitionId), caseId)) {
                IBPMContext context = InternalBPMContext.getInternalBPMContext();
                CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
                service.initiateCaseActivity(context, caseIdentifier, caseActivityDefinitionId, null, null);
            }
        }
        catch (BPMException e) {
            throw new CaseActivityException(74015, new Object[]{caseActivityDefinitionId, caseId}, e);
        }
        catch (CasePersistenceException e) {
            throw new CaseActivityException(74015, new Object[]{caseActivityDefinitionId, caseId}, (Throwable)((Object)e));
        }
    }

    @Override
    public CaseActivityDefinition getCaseActivityDefinition(String caseActivityDefinitionId) throws CasePersistenceException {
        String methodName = "getCaseActivityDefinition";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        this.debugLog(methodName, "Getting activity definition for definition id:" + caseActivityDefinitionId);
        return persistence.find(CaseActivityDefinition.class, caseActivityDefinitionId);
    }

    @Override
    public boolean canInitiateActivity(IBPMContext context, String caseId, String caseActivityDefinitionId, ICaseConstants.ActivityFilterType filter) throws CasePersistenceException, BPMException, CaseServiceException {
        String methodName = "canInitiateActivity";
        try {
            return this.canInitiateActivityInternal(context, caseId, caseActivityDefinitionId, filter);
        }
        catch (CaseActivityException cae) {
            this.debugLog(methodName, "Activity is not active.Cannot be initiated");
            return false;
        }
    }

    @Override
    public boolean canInitiateActivityInternal(IBPMContext context, String caseId, String caseActivityDefinitionId, ICaseConstants.ActivityFilterType filter) throws CasePersistenceException, BPMException, CaseServiceException, CaseActivityException {
        CaseActivityDefinition defn;
        String methodName = "canInitiateActivity";
        CaseActivityDefinition definition = this.getCaseActivityDefinition(caseActivityDefinitionId);
        if (definition == null) {
            throw new CaseActivityException(74001, new Object[]{caseActivityDefinitionId});
        }
        String caseDefinitionId = this.getCaseDefinitionId(caseId);
        ICaseMetadataService metadataService = ServicesLocator.getCaseMetadataService();
        if (definition.getIsCaseSpecific()) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(caseDefinitionId);
            List definitionList = metadataService.listCaseActivityDefinition(context, ICaseMetadataService.SEARCH_TYPE_ENUM.CASE_DEFINITION_ID, values);
            boolean isActivityCaseSpecific = false;
            if (definitionList != null && definitionList.size() > 0) {
                for (CaseActivityDefinition activityDefinition : definitionList) {
                    if (!activityDefinition.getDefinitionId().equals(caseActivityDefinitionId)) continue;
                    isActivityCaseSpecific = true;
                    break;
                }
            }
            if (!isActivityCaseSpecific) {
                throw new CaseActivityException(74044, new Object[]{caseActivityDefinitionId, caseDefinitionId});
            }
        }
        if (definition.getIsManual() && definition.getIsConditional() && filter.equals((Object)ICaseConstants.ActivityFilterType.AVAILABLE) && (defn = this.getInstanceActivity(caseId, caseActivityDefinitionId)) == null) {
            throw new CaseActivityException(74045, new Object[]{caseActivityDefinitionId});
        }
        if (!definition.getIsManual() && !(context instanceof InternalBPMContext)) {
            throw new CaseActivityException(74043, new Object[]{caseActivityDefinitionId, context.getUser()});
        }
        boolean isRepeatable = this.isRepeatable(definition, caseId);
        if (!isRepeatable) {
            throw new CaseActivityException(74042, new Object[]{caseActivityDefinitionId});
        }
        return true;
    }

    @Override
    public void activateActivity(String caseId, String caseActivityDefinitionId) throws CaseActivityException {
        String methodName = "activateActivity";
        String query = "select caseActivityDefn from CaseActivityDefinition caseActivityDefn where caseActivityDefn.isManual = 'Y' and caseActivityDefn.isConditional = 'Y' and caseActivityDefn.definitionId = :definitionId";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("definitionId", caseActivityDefinitionId);
            List activities = persistence.findWithQuery(query, parameters);
            if (activities != null && activities.size() > 0) {
                CaseActivityInstancePK key = new CaseActivityInstancePK(caseActivityDefinitionId, caseId);
                CaseActivityInstance previousInstance = persistence.find(CaseActivityInstance.class, key);
                if (previousInstance != null) {
                    this.debugLog(methodName, "Activity is already activated,doing nothing.");
                    return;
                }
                CaseActivityInstance instance = new CaseActivityInstance();
                instance.setCaseId(caseId);
                instance.setActivityDefinitionId(caseActivityDefinitionId);
                instance.setCaseActivityDefinition((CaseActivityDefinition)activities.get(0));
                persistence.persist(instance);
            }
        }
        catch (CasePersistenceException e) {
            throw new CaseActivityException(74014, new Object[]{caseActivityDefinitionId, caseId}, (Throwable)((Object)e));
        }
    }

    @Override
    public boolean isAutomaticActivity(String caseActivityDefinitionId) throws CasePersistenceException {
        String methodName = "isAutomaticActivity";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("definitionId", caseActivityDefinitionId);
        List activities = persistence.findWithNamedQuery("CaseActivityDefinition.findIfAutomaticActivity", parameters);
        this.logCaseActivities(methodName, activities, "automatic activity:");
        if (activities != null && activities.size() > 0) {
            this.debugLog(methodName, "The activity with definition id:" + caseActivityDefinitionId + " is an automatic activity");
            return true;
        }
        this.debugLog(methodName, "The activity with definition id:" + caseActivityDefinitionId + " is not an automatic activity");
        return false;
    }

    @Override
    public void updateCaseActivityEvent(IBPMContext context, CaseEvent event, TActivityEvent activityEvent, String activityInstanceId, String correlationId, Comment comment, boolean raiseEvent) throws CaseActivityException {
        String commentStr;
        String methodName = "updateCaseActivityEvent";
        this.logStartOfMethod(methodName, "Raise Case Activity Event: \n activityId: " + event.getActivityId() + "\n activityType: " + event.getActivityType() + "\n caseId: " + event.getCaseId() + "\n activityInstanceId: " + activityInstanceId + "\n" + "activity name:" + event.getActivityName() + "\n correlationId: " + correlationId + "\n activityEvent: " + activityEvent);
        this.debugLog(methodName, "updating case activity event with activityEvent:" + activityEvent + " activityInstanceId:" + activityInstanceId + " correlationId:" + correlationId);
        IInternalCaseService service = ServicesLocator.getInternalCaseService();
        if (activityEvent != null) {
            event.setActivityEvent(activityEvent);
            Calendar currentTime = CaseServiceUtil.getCalendarInstance(context);
            if (activityEvent.compareTo((Enum)TActivityEvent.COMPLETED) == 0 || activityEvent.compareTo((Enum)TActivityEvent.FAULTED) == 0) {
                event.setCompletedDate(currentTime);
            }
        }
        ArrayList pBagCollection = new ArrayList();
        event.setPropertyBagCollection(pBagCollection);
        if (correlationId != null) {
            PropertyBag bag2 = new PropertyBag();
            bag2.setCaseEvent(event);
            bag2.setName(DB_CORRELATION_ID);
            bag2.setValue(correlationId);
            event.addPropertyBag(bag2);
            event.setDocumentId(correlationId);
        }
        if (comment != null && (commentStr = comment.getCaseObjectComment()) != null && !commentStr.trim().isEmpty()) {
            PropertyBag bag3 = new PropertyBag();
            bag3.setCaseEvent(event);
            bag3.setName("comment");
            bag3.setValue(commentStr);
            event.addPropertyBag(bag3);
        }
        IBPMContext ctx = null;
        try {
            ctx = context == null ? InternalBPMContext.getInternalBPMContext() : context;
            service.updateCaseEvent(ctx, event, raiseEvent);
            if (activityInstanceId != null) {
                this.addActivityCorrelation(event.getCaseId(), correlationId, activityInstanceId);
            }
            this.logEndOfMethod(methodName, "Raise Case Activity Event: \n activityId: " + event.getActivityId() + "\n activityType: " + event.getActivityType() + "\n caseId: " + event.getCaseId() + "\n activityInstanceId: " + activityInstanceId + "\n" + "activity name:" + event.getActivityName() + "\n correlationId: " + correlationId + "\n activityEvent: " + activityEvent);
        }
        catch (Exception e) {
            throw new CaseActivityException(74013, new Object[]{event.getActivityId(), event.getCaseId()}, e);
        }
    }

    @Override
    public void raiseCaseActivityEvent(IBPMContext context, String activityId, String activityType, String activityName, String caseId, String activityInstanceId, String correlationId, TActivityEvent activityEvent, Comment comment, boolean isSync) throws CaseActivityException {
        String methodName = "raiseCaseActivityEvent";
        this.logStartOfMethod(methodName, "Raise Case Activity Event: \n activityId: " + activityId + "\n activityType: " + activityType + "\n caseId: " + caseId + "\n activityInstanceId: " + activityInstanceId + "\n" + "activity name:" + activityName + "\n correlationId: " + correlationId + "\n activityEvent: " + activityEvent);
        ICaseEventService service = ServicesLocator.getCaseEventService();
        CaseEvent event = CaseEventFactory.createCaseActivityEvent((TActivityEvent)activityEvent, (String)activityType, (String)activityName, (String)activityId, null, (Comment)comment);
        event.setCaseId(caseId);
        event.setActivityId(activityInstanceId);
        event.setObjectName(activityId);
        event.setDocumentId(correlationId);
        Calendar currentTime = CaseServiceUtil.getCalendarInstance(context);
        if (isSync) {
            event.setStartedDate(currentTime);
            event.setCompletedDate(currentTime);
        } else if (activityEvent.compareTo((Enum)TActivityEvent.ACTIVATED) == 0) {
            event.setStartedDate(currentTime);
        } else if (activityEvent.compareTo((Enum)TActivityEvent.COMPLETED) == 0 || activityEvent.compareTo((Enum)TActivityEvent.FAULTED) == 0) {
            event.setCompletedDate(currentTime);
        }
        ArrayList pBagCollection = new ArrayList();
        event.setPropertyBagCollection(pBagCollection);
        if (correlationId != null) {
            PropertyBag bag2 = new PropertyBag();
            bag2.setCaseEvent(event);
            bag2.setName(DB_CORRELATION_ID);
            bag2.setValue(correlationId);
            event.addPropertyBag(bag2);
        }
        IBPMContext ctx = null;
        try {
            ctx = context == null ? InternalBPMContext.getInternalBPMContext() : context;
            CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
            service.raiseCaseEvent(ctx, caseIdentifier, event);
            if (activityInstanceId != null) {
                this.addActivityCorrelation(caseId, correlationId, activityInstanceId);
            }
            this.logEndOfMethod(methodName, "Raise Case Activity Event: \n activityId: " + activityId + "\n activityType: " + activityType + "\n caseId: " + caseId + "\n activityInstanceId: " + activityInstanceId + "\n" + "activity name:" + activityName + "\n correlationId: " + correlationId + "\n activityEvent: " + activityEvent);
        }
        catch (Exception e) {
            throw new CaseActivityException(74012, new Object[]{activityId, caseId}, e);
        }
    }

    @Override
    public String getCaseActivityDefinitionId(String caseId, String caseActivityName) throws CaseActivityException, CaseMetadataException {
        try {
            String caseDefinitionId = this.getCaseDefinitionId(caseId);
            String categoryName = this.getCategoryName(caseId);
            String activityVersion = this.getActivityVersion(caseDefinitionId);
            CaseActivityDefinition activity = this.getActivityForCaseFromName(caseDefinitionId, caseActivityName, activityVersion);
            if (activity == null) {
                activity = this.getActivityForCategoryFromName(categoryName, caseActivityName, activityVersion);
                if (activity == null) {
                    activity = this.getActivityWithoutAssociationsFromName(caseActivityName, activityVersion);
                    if (activity == null) {
                        throw new CaseActivityException(74009, new Object[]{caseActivityName, caseId});
                    }
                    return activity.getDefinitionId();
                }
                return activity.getDefinitionId();
            }
            return activity.getDefinitionId();
        }
        catch (CaseActivityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CaseActivityException(74009, new Object[]{caseActivityName, caseId}, e);
        }
    }

    @Override
    public void invokeCaseActivitesPostDeploy(String caseActivityDefinitionId) {
    }

    @Override
    public void undeployCaseRule(IBPMContext ctx, ComponentModel componentModel) {
    }

    @Override
    public CaseRuleEdit getUserDictionaryInternal(IBPMContext ctx, String namespace) throws CasePersistenceException {
        return ServicesLocator.getCaseRulePersistance().findCaseRuleByUser(ctx.getUser(), namespace, "tenantId");
    }

    @Override
    public CaseRule getActiveDictionaryInternal(IBPMContext ctx, String namespace) throws CasePersistenceException {
        return ServicesLocator.getCaseRulePersistance().findActiveCaseDictionary(namespace, "tenantId");
    }

    @Override
    public void persistCaseRuleDictionary(Object ruleDictionary) throws CasePersistenceException {
        ServicesLocator.getCaseRulePersistance().persist(ruleDictionary);
    }

    @Override
    public void updateCaseRuleDictionary(Object ruleDictionary) throws CasePersistenceException {
        ServicesLocator.getCaseRulePersistance().update(ruleDictionary);
    }

    @Override
    public void onCaseComplete(String caseId) throws CaseActivityException {
        String methodName = "onCaseComplete";
        boolean pendingRequiredActivities = false;
        boolean pendingRunningActivities = false;
        try {
            pendingRequiredActivities = this.areRequiredActivitiesPending(caseId);
            pendingRunningActivities = this.areRunningActivitiesPending(caseId);
        }
        catch (CasePersistenceException e) {
            throw new CaseActivityException(74005, new Object[]{caseId}, (Throwable)((Object)e));
        }
        catch (BPMException e) {
            throw new CaseActivityException(74005, new Object[]{caseId}, e);
        }
        catch (CaseServiceException e) {
            throw new CaseActivityException(74005, new Object[]{caseId}, e);
        }
        if (pendingRequiredActivities) {
            throw new CaseActivityException(74006, new Object[]{caseId});
        }
        if (pendingRunningActivities) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"onCaseComplete", (String)("There are activities still running for case id:" + caseId));
        }
    }

    @Override
    public boolean migrateCaseCompositeVersion(String caseId, String newCaseDefinitionId, String newCompositeDN, String newCompositeVersion) throws CasePersistenceException, CaseServiceException {
        CompositeNameModel compositeNameModel = CompositeNameModel.parseDN((String)newCompositeDN);
        String newApplicationName = compositeNameModel.getFolder();
        String newCompositeName = compositeNameModel.getCompositeName();
        ICaseInstancePersistence persistence = ServicesLocator.getCaseInstancePersistence();
        persistence.updateCaseCompositeVersion(caseId, newCaseDefinitionId, newCompositeDN, newCompositeVersion, newApplicationName, newCompositeName);
        ICaseService caseService = ServicesLocator.getCaseService();
        try {
            IBPMContext context = InternalBPMContext.getInternalBPMContext();
            Case caseInstance = this.getCase(context, new CaseIdentifier(caseId, null, null), null);
            String caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
            String oldCompositeDN = caseInstance.getCaseHeader().getCompositeDn();
            ArrayList<String> caseDefinitionIds = new ArrayList<String>();
            caseDefinitionIds.add(caseDefinitionId);
            List definitionList = caseService.listCaseActivityDefinition(context, ICaseMetadataService.SEARCH_TYPE_ENUM.CASE_DEFINITION_ID, caseDefinitionIds);
            Map<String, String> activityDefinitionMap = this.getNewActivityDefinitionIdsMap(definitionList, oldCompositeDN, newCompositeDN);
            this.migrateCaseActivityInstanceAndAttrib(caseId, activityDefinitionMap);
            this.migrateCaseActivityEvent(caseId, activityDefinitionMap);
        }
        catch (BPMException e) {
            e.printStackTrace();
        }
        catch (CasePersistenceException e) {
            throw e;
        }
        catch (CaseServiceException e) {
            throw e;
        }
        return true;
    }

    public boolean areRequiredActivitiesPending(String caseId) throws CasePersistenceException, BPMException, CaseServiceException {
        String methodName = "areRequiredActivitiesPending";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        List<String> caseDefnIdList = this.getAllRequiredCaseActivities(caseId);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseId", caseId);
        parameters.put("activityEventType", TActivityEvent.COMPLETED);
        parameters.put("eventType", TEventType.ACTIVITY_EVENT);
        parameters.put("defnIdList", caseDefnIdList);
        List pendingRequiredActivities = persistence.findWithQuery("select o from CaseActivityDefinition o  where o.isRequired = 'Y'  and o.definitionId in :defnIdList and o.definitionId NOT IN (select e.object_name from CaseEvent e where e.case_id = :caseId and e.activity_event = :activityEventType and e.event_type = :eventType)", parameters);
        this.logCaseActivities(methodName, pendingRequiredActivities, "Completed Required Activities for case id:" + caseId);
        return pendingRequiredActivities != null && pendingRequiredActivities.size() > 0;
    }

    public List<String> getAllRequiredActivitiesForCase(String caseDefinitionId) throws CasePersistenceException {
        String methodName = "getAllRequiredActivitiesForCase";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseDefinitionId", caseDefinitionId);
        List activityIds = persistence.findWithNamedQuery("CaseActivityDefinition.findRequiredActivitiesForCase", parameters);
        return activityIds;
    }

    public List<String> getAllRequiredActivitiesForCategory(String categoryName) throws CasePersistenceException {
        String methodName = "getAllRequiredActivitiesForCategory";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("categoryName", categoryName);
        List activityIds = persistence.findWithNamedQuery("CaseActivityDefinition.findRequiredActivitiesForCategory", parameters);
        return activityIds;
    }

    public List<String> getAllRequiredActivitiesWithoutAssociations() throws CasePersistenceException {
        String methodName = "getAllRequiredActivitiesWithoutAssociations";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        List activityIds = persistence.findWithNamedQuery("CaseActivityDefinition.findRequiredActivitiesWithoutAssociations", parameters);
        return activityIds;
    }

    @Override
    public void populateHWFOutput(NormalizedMessage message, CaseActivity caseActivity, String caseId) throws CaseActivityException {
        String methodName = "populateHWFOutput";
        TWorkflowActivity activity = ((TCaseActivity)caseActivity.getValue()).getWorkflowActivity();
        Map payload = message.getPayload();
        Element output = (Element)payload.get(HWF_PAYLOAD);
        if (output != null) {
            List parameterList;
            TOutputParameters outputParameters;
            List activityoutput;
            TOutputs outputs;
            this.debugLog(methodName, "Task: \n" + XMLUtil.toString((Node)output));
            TParameters parameters = activity.getParameters();
            if (parameters != null && (outputs = parameters.getOutputs()) != null && (activityoutput = outputs.getOutput()) != null && activityoutput.size() > 0 && (outputParameters = ((TOutput)activityoutput.get(0)).getParameters()) != null && (parameterList = outputParameters.getParameter()) != null) {
                for (TOutputParameter parameter : parameterList) {
                    this.populateCaseDataFromNM(output, parameter, caseId);
                }
            }
        } else {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.WARNING, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + "Task element not found in payload of normalized message.\n"));
        }
    }

    @Override
    public void populateBPMNOutput(NormalizedMessage message, CaseActivity caseActivity, String caseId) throws CaseActivityException {
        List activityoutputs;
        TOutputs outputs;
        TBpmnActivity activity = ((TCaseActivity)caseActivity.getValue()).getBpmnActivity();
        TParameters parameters = activity.getParameters();
        if (parameters != null && (outputs = parameters.getOutputs()) != null && (activityoutputs = outputs.getOutput()) != null && activityoutputs.size() > 0) {
            Map payload = message.getPayload();
            Element output = (Element)payload.get(BPMN_PARAMETERS);
            this.debugLog("populateBPMNOutput", "BPMN Output:\n" + XMLUtil.toString((Node)output));
            String outputOperationName = output.getNodeName();
            this.debugLog("populateBPMNOutput", "Output Operation Name: " + outputOperationName);
            for (TOutput activityoutput : activityoutputs) {
                List parameterList;
                String activityOperationName = activityoutput.getOperationName();
                if (activityOperationName != null) {
                    activityOperationName = activityOperationName + RESPONSE;
                }
                this.debugLog("populateBPMNOutput", "Activity Operation Name: " + activityOperationName);
                if (activityOperationName == null || !activityOperationName.equals(outputOperationName)) continue;
                TOutputParameters outputParameters = activityoutput.getParameters();
                if (outputParameters == null || (parameterList = outputParameters.getParameter()) == null) break;
                for (TOutputParameter parameter : parameterList) {
                    this.populateCaseDataFromNM(output, parameter, caseId);
                }
            }
        }
    }

    @Override
    public boolean upsertCaseTitleTranslation(IBPMContext ctx, Case caseInstance, Case clonedCase) throws CaseServiceException, CaseMetadataException {
        if (caseInstance == null || clonedCase == null) {
            return false;
        }
        ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
        CaseMetadataCache cache = CaseMetadataCache.getInstance();
        ICaseMetadataService caseMetadataService = ServicesLocator.getCaseMetadataService();
        CaseMetadata caseMetadata = caseMetadataService.getCaseMetadata(ctx, clonedCase.getCaseHeader().getCaseDefinitionId());
        List<Locale> localeList = InternalCaseManagementService.getLocaleList();
        String defaultLocale = Locale.getDefault().getLanguage();
        for (Locale locale : localeList) {
            String translatedTitle = cache.getDisplayValue(clonedCase.getCaseHeader().getCaseDefinitionId(), (Object)((TCaseMetadata)caseMetadata.getValue()).getTitle(), clonedCase, locale);
            CaseTranslation case_tl = new CaseTranslation(clonedCase.getCaseId(), locale.toString(), translatedTitle);
            try {
                CaseTranslationPK tl_pk = new CaseTranslationPK(clonedCase.getCaseId(), locale.toString());
                CaseTranslation tl = casePersistence.find(CaseTranslation.class, tl_pk);
                if (tl == null) {
                    casePersistence.persist(case_tl);
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"translateAndInsert", (String)("Inserted one record for id:" + clonedCase.getCaseId() + " for locale:" + locale.toString()));
                } else {
                    casePersistence.update(case_tl);
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"translateAndInsert", (String)("Updated one record for id:" + clonedCase.getCaseId() + " for locale:" + locale.toString()));
                }
                if (!defaultLocale.equals(locale.getLanguage())) continue;
                caseInstance.getCaseHeader().setTitle(case_tl.getTitle());
            }
            catch (Exception e) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"translateAndInsert", (String)("Exception while persisting case_translation record for id:" + clonedCase.getCaseId() + " for locale:" + locale.toString()));
                throw new CaseMetadataException(72811, new Object[]{clonedCase.getCaseId(), locale.toString()}, e);
            }
        }
        return true;
    }

    @Override
    public void invokeCaseActivitiesOnCaseStart(String caseId) throws CaseServiceException, CaseActivityException {
        String methodName = "invokeCaseActivitiesOnCaseStart";
        ArrayList<CaseActivityDefinition> caseActivities = new ArrayList<CaseActivityDefinition>();
        try {
            IBPMContext context = InternalBPMContext.getInternalBPMContext();
            CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
            Case caseInstance = this.getCase(context, caseIdentifier, null);
            caseActivities.addAll(this.getAllAutomaticActivitiesWithoutAssociations());
            String caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
            String categoryName = caseInstance.getCaseHeader().getCategory();
            caseActivities.addAll(this.getAllAutomaticActivitiesForCase(caseDefinitionId));
            List<CaseActivityDefinition> categoryActivities = this.getAllAutomaticActivitiesForCategory(categoryName);
            caseActivities.addAll(CaseActivityUtil.excludeDuplicateCaseActivityDefinition(categoryActivities, caseDefinitionId));
            this.logCaseActivities(methodName, caseActivities, "Initiate the following case activities on start of case with case id:" + caseId + " definition id:" + caseDefinitionId + " category name:" + categoryName);
            this.initiateCaseActivities(caseId, caseActivities);
        }
        catch (CaseServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CaseActivityException(74011, new Object[0], e);
        }
    }

    @Override
    public int deleteCaseInstances(String deleteWhereClause) throws CaseServiceException {
        this.debugLog("deleteCaseInstances", "Method invoked with deleteCriteria:" + deleteWhereClause);
        try {
            if (deleteWhereClause != null) {
                StringBuffer query = new StringBuffer();
                query.append("delete from Case ").append(ICaseConstants.caseInstance).append(" where ").append(deleteWhereClause);
                this.debugLog("deleteCaseInstances", "Query string is " + query);
                ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
                int result = casePersistence.executeUpdateWithQuery(query.toString());
                this.debugLog("deleteCaseInstances", "Deleted " + result + " records");
                return result;
            }
        }
        catch (Exception e) {
            this.debugLog("deleteCaseInstances", "Delete case is not successfull: " + e.getMessage());
            throw new CaseServiceException(74212, new Object[]{deleteWhereClause}, (Throwable)e);
        }
        return 0;
    }

    @Override
    public void deleteCaseActivityInstance(String caseId, String caseActivityDefinitionId) throws CasePersistenceException {
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("comes into delete case activity instance for:" + caseActivityDefinitionId + ":" + caseId));
        CaseActivityInstancePK key = new CaseActivityInstancePK(caseActivityDefinitionId, caseId);
        CaseActivityInstance instance = persistence.find(CaseActivityInstance.class, key);
        if (instance != null) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)"Instance found for deletion");
            persistence.delete(CaseActivityInstance.class, key);
        }
    }

    @Override
    public List<Object[]> getCaseInstancesSnapshot(String query) throws CasePersistenceException {
        List resultList = ServicesLocator.getCasePersistence().findWithQuery(query);
        if (resultList != null && resultList.size() > 0) {
            this.debugLog("getCaseInstancesSnapshot", "Got " + resultList.size() + " instances from database");
            int i = 0;
            for (Object[] tuple : resultList) {
                this.debugLog("getCaseInstancesSnapshot", "Row " + ++i);
                for (Object value : tuple) {
                    this.debugLog("getCaseInstancesSnapshot", "Row " + i + " value:" + value);
                }
            }
        }
        return resultList;
    }

    public List<CaseActivityDefinition> getAllAutomaticActivitiesWithoutAssociations() throws CasePersistenceException {
        String methodName = "getAllAutomaticActivitiesWithoutAssociations";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        List activities = persistence.findWithNamedQuery("CaseActivityDefinition.findAllAutomaticActivitiesWithoutAssociations");
        this.logCaseActivities(methodName, activities, "Get all automatic activities without associations");
        return activities;
    }

    public List<CaseActivityDefinition> getAllAutomaticActivitiesForCase(String caseDefinitionId) throws CasePersistenceException {
        String methodName = "getAllAutomaticActivitiesForCase";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseDefinitionId", caseDefinitionId);
        List activities = persistence.findWithNamedQuery("CaseActivityDefinition.findAllAutomaticActivitiesForCase", parameters);
        this.logCaseActivities(methodName, activities, "Get all Automatic Activities for case with case definition id:" + caseDefinitionId);
        return activities;
    }

    public List<CaseActivityDefinition> getAllAutomaticActivitiesForCategory(String categoryName) throws CasePersistenceException {
        String methodName = "getAllAutomaticActivitiesForCategory";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("categoryName", categoryName);
        List activities = persistence.findWithNamedQuery("CaseActivityDefinition.findAllAutomaticActivitiesForCategory", parameters);
        this.logCaseActivities(methodName, activities, "All Automatic Activities For Category for category name:" + categoryName);
        return activities;
    }

    @Override
    public Case getCase(String caseId) throws CasePersistenceException {
        return ServicesLocator.getCaseInstancePersistence().findCaseByCaseId(caseId);
    }

    @Override
    public Case getCase(IBPMContext bpmContext, CaseIdentifier caseIdentifier, List<ICaseConstants.CaseInfo> additionalCaseInfo) throws CaseServiceException {
        return new CaseInstanceServiceImpl().getCase(bpmContext, caseIdentifier, additionalCaseInfo, true, true);
    }

    @Override
    public List<CaseData> getCaseData(IBPMContext context, CaseIdentifier caseIdentifier) throws CaseServiceException {
        return new CaseInstanceServiceImpl().getCaseData(context, caseIdentifier);
    }

    @Override
    public void onUndeployComponent(IBPMContext ctx, String caseDefinitionId, boolean keepInstancesonRedeploy) throws CasePersistenceException {
        if (!keepInstancesonRedeploy) {
            ServicesLocator.getCaseInstancePersistence().markInstancesAsStale(caseDefinitionId);
        }
    }

    @Override
    public void deployCaseDisplayInfo(CaseDefinition metadata, String caseArtifactName, ICaseMetadataService.FORM_TYPE formType) throws CasePersistenceException {
        CaseDisplayUtil.deployCaseDisplayInfo(metadata, caseArtifactName, formType);
    }

    @Override
    public String getInstanceIdFromEvent(String caseId, CaseEvent event) throws CasePersistenceException {
        if (event.getActivityId() == null) {
            ICasePersistence persistence = ServicesLocator.getCasePersistence();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("caseId", caseId);
            parameters.put(DB_CORRELATION_ID, event.getActivityCorrelationId());
            List instanceIdList = persistence.findWithQuery("select activityCorrelation.instanceId from CaseActivityCorrelation activityCorrelation where activityCorrelation.caseId = :caseId and  activityCorrelation.correlationId = :correlationId", parameters);
            if (instanceIdList != null && instanceIdList.size() == 1) {
                String instanceId = (String)instanceIdList.get(0);
                return instanceId;
            }
        } else {
            return event.getActivityId();
        }
        return null;
    }

    void purgeCaseMetadataFromCache(String definitionId) {
        CaseMetadataCache metadataCache = CaseMetadataCache.getInstance();
        metadataCache.removeFromCache(definitionId);
    }

    void purgeCaseActivityMetadataFromCache(String definitionId) {
        CaseActivityMetadataCache metadataCache = CaseActivityMetadataCache.getInstance();
        metadataCache.removeFromCache(definitionId);
    }

    private static List<Locale> getLocaleList() {
        List localeList = new ArrayList();
        ArrayList<Locale> unduplicatedLocalesList = new ArrayList<Locale>();
        try {
            localeList = ConfigurationManager.getConfiguration().getLocaleList().getLocale();
            for (LocaleType localeType : localeList) {
                Locale locale = i18NUtil.getLocaleForLocaleType((LocaleType)localeType);
                if (unduplicatedLocalesList.contains(locale)) continue;
                unduplicatedLocalesList.add(locale);
            }
        }
        catch (WorkflowException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)InternalCaseManagementService.class.getName(), (String)"getLocaleList", (String)"Exception in getting locale list", (Throwable)e);
        }
        return unduplicatedLocalesList;
    }

    private boolean isRepeatable(CaseActivityDefinition caseActivityDefinition, String caseId) throws CasePersistenceException {
        String methodName = "isRepeatable";
        String activityDefinitionId = caseActivityDefinition.getDefinitionId();
        if (!caseActivityDefinition.getIsRepeatable() && this.hasActivityOccurredInCase(caseId, activityDefinitionId)) {
            this.debugLog(methodName, "The activity with definition id:" + activityDefinitionId + " is not repeatable and has occurred before.");
            return false;
        }
        this.debugLog(methodName, "The activity with definition id:" + activityDefinitionId + " is repeatable or has not occurred before.");
        return true;
    }

    private boolean hasActivityOccurredInCase(String caseId, String activityDefinitionId) throws CasePersistenceException {
        String methodName = "hasActivityOccurredInCase";
        boolean hasOccurred = this.listActivityOccurrenceInCase(caseId, activityDefinitionId).size() > 0;
        this.debugLog(methodName, "has activity occurred in case with case id:" + caseId + " -- " + hasOccurred);
        return hasOccurred;
    }

    private List<CaseActivityDefinition> listActivityOccurrenceInCase(String caseId, String activityDefinitionId) throws CasePersistenceException {
        String methodName = "listActivityOccurrenceInCase";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseId", caseId);
        parameters.put("definitionId", activityDefinitionId);
        parameters.put("eventType", TEventType.ACTIVITY_EVENT);
        List activities = persistence.findWithQuery("select o from CaseActivityDefinition o where o.definitionId = :definitionId and o.definitionId IN (select e.object_name from CaseEvent e where e.case_id  = :caseId and e.event_type = :eventType)", parameters);
        this.logCaseActivities(methodName, activities, "The activity with definition Id:" + activityDefinitionId + "has following occurrences for case id" + caseId);
        return activities;
    }

    private CaseActivityDefinition getInstanceActivity(String caseId, String caseActivityDefinitionId) throws CasePersistenceException {
        String methodName = "getInstanceActivity";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseId", caseId);
        parameters.put("definitionId", caseActivityDefinitionId);
        List activities = persistence.findWithQuery("select o from CaseActivityInstance i  JOIN i.caseActivityDefinition o where o.isManual = 'Y' and i.caseId = :caseId and o.definitionId = :definitionId", parameters);
        this.logCaseActivities(methodName, activities, "Get activity instance for case activity with activity definition id:" + caseActivityDefinitionId + " for case id:" + caseId);
        if (activities != null && activities.size() > 0) {
            return (CaseActivityDefinition)activities.get(0);
        }
        return null;
    }

    private void migrateCaseActivityInstanceAndAttrib(String caseId, Map<String, String> activityDefinitionMap) throws CasePersistenceException {
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        for (String definitionId : activityDefinitionMap.keySet()) {
            CaseActivityAttribPK key2;
            CaseActivityAttrib attrib;
            String newDefinitionId = activityDefinitionMap.get(definitionId);
            CaseActivityInstancePK key = new CaseActivityInstancePK(definitionId, caseId);
            CaseActivityInstance instance = persistence.find(CaseActivityInstance.class, key);
            if (instance != null) {
                CaseActivityInstance newInstance = new CaseActivityInstance();
                newInstance.setCaseId(caseId);
                newInstance.setActivityDefinitionId(newDefinitionId);
                persistence.delete(CaseActivityInstance.class, key);
                persistence.persist(newInstance);
            }
            if ((attrib = persistence.find(CaseActivityAttrib.class, key2 = new CaseActivityAttribPK(definitionId, caseId))) == null) continue;
            CaseActivityAttrib newAttrib = new CaseActivityAttrib();
            newAttrib.setCaseId(caseId);
            newAttrib.setActivityDefinitionId(newDefinitionId);
            newAttrib.setActivityRating(attrib.getActivityRating());
            newAttrib.setPermissionTag(attrib.getPermissionTag());
            persistence.delete(CaseActivityAttrib.class, key2);
            persistence.persist(newAttrib);
        }
    }

    private void migrateCaseActivityEvent(String caseId, Map<String, String> activityDefinitionMap) throws CasePersistenceException {
        ICaseEventPersistence persistence = ServicesLocator.getCaseEventPersistence();
        for (String definitionId : activityDefinitionMap.keySet()) {
            String newDefinitionId = activityDefinitionMap.get(definitionId);
            persistence.migrateCaseActivityEvent(caseId, definitionId, newDefinitionId);
        }
    }

    private Map<String, String> getNewActivityDefinitionIdsMap(List<CaseActivityDefinition> definitionList, String oldCompositeDN, String newCompositeDN) {
        HashMap<String, String> activityDefinitionMap = new HashMap<String, String>();
        for (CaseActivityDefinition activity : definitionList) {
            String oldActivityDefinitionId = activity.getDefinitionId();
            String componentName = ServicesLocator.getCaseSE().getComponentNameFromCaseDefinitionId(oldActivityDefinitionId);
            String newActivityDefinitionId = ServicesLocator.getCaseSE().getCaseDefinitionId(componentName, newCompositeDN);
            activityDefinitionMap.put(oldActivityDefinitionId, newActivityDefinitionId);
        }
        return activityDefinitionMap;
    }

    private void initiateCaseActivities(String caseId, List<CaseActivityDefinition> caseActivities) throws CaseServiceException, BPMException {
        IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
        CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
        ICaseService svc = ServicesLocator.getCaseService();
        for (CaseActivityDefinition caseActivityDefinition : caseActivities) {
            String caseActivityDefinitionId = caseActivityDefinition.getDefinitionId();
            svc.initiateCaseActivity(ctx, caseIdentifier, caseActivityDefinitionId, null, null);
        }
    }

    private boolean areRunningActivitiesPending(String caseId) throws CasePersistenceException {
        String methodName = "areRunningActivitiesPending";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseId", caseId);
        parameters.put("activityEventType", TActivityEvent.ACTIVATED);
        parameters.put("eventType", TEventType.ACTIVITY_EVENT);
        List startActivities = persistence.findWithQuery("select e.object_name from CaseEvent e where e.case_id = :caseId and e.activity_event = :activityEventType and e.event_type = :eventType", parameters);
        this.logCaseActivities(methodName, startActivities, "All start Activities for case id:" + caseId);
        parameters = new HashMap();
        parameters.put("caseId", caseId);
        parameters.put("activityEventType", TActivityEvent.COMPLETED);
        parameters.put("eventType", TEventType.ACTIVITY_EVENT);
        List endActivities = persistence.findWithQuery("select e.object_name from CaseEvent e where e.case_id = :caseId and e.activity_event = :activityEventType and e.event_type = :eventType", parameters);
        this.logCaseActivities(methodName, startActivities, "All end Activities for case id:" + caseId);
        return endActivities.size() < startActivities.size();
    }

    private List<String> getAllRequiredCaseActivities(String caseId) throws CasePersistenceException, CaseServiceException, BPMException {
        ICaseService caseService = ServicesLocator.getCaseService();
        IBPMContext context = InternalBPMContext.getInternalBPMContext();
        CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
        Case caseInstance = this.getCase(context, caseIdentifier, null);
        String caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
        String categoryName = caseInstance.getCaseHeader().getCategory();
        ArrayList<String> caseActivityIds = new ArrayList<String>();
        caseActivityIds.addAll(this.getAllRequiredActivitiesWithoutAssociations());
        caseActivityIds.addAll(this.getAllRequiredActivitiesForCase(caseDefinitionId));
        caseActivityIds.addAll(this.getAllRequiredActivitiesForCategory(categoryName));
        return caseActivityIds;
    }

    private CaseActivityDefinition getActivityForCaseFromName(String caseDefinitionId, String caseActivityName, String version) throws CaseActivityException {
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = null;
        List activities = null;
        try {
            if (version != null) {
                parameters = new HashMap<String, Object>();
                parameters.put("name", caseActivityName);
                parameters.put("caseDefinitionId", caseDefinitionId);
                parameters.put("version", version);
                activities = persistence.findWithNamedQuery("CaseActivityDefinition.findActivityForCaseFromNameVersion", parameters);
            }
            if (activities == null || activities.size() == 0) {
                parameters = new HashMap();
                parameters.put("name", caseActivityName);
                parameters.put("caseDefinitionId", caseDefinitionId);
                activities = persistence.findWithNamedQuery("CaseActivityDefinition.findActivityForCaseFromName", parameters);
            }
        }
        catch (CasePersistenceException e) {
            // empty catch block
        }
        if (activities != null && activities.size() > 1) {
            throw new CaseActivityException(74010, new Object[]{caseActivityName});
        }
        if (activities != null && activities.size() == 1) {
            return (CaseActivityDefinition)activities.get(0);
        }
        return null;
    }

    private String getActivityVersion(String caseDefinitionId) throws CaseMetadataException {
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        CaseDefinition defn = null;
        try {
            defn = persistence.find(CaseDefinition.class, caseDefinitionId);
            return defn.getCompositeVersion();
        }
        catch (CasePersistenceException e) {
            throw new CaseMetadataException(72800, new Object[]{caseDefinitionId}, (Throwable)((Object)e));
        }
    }

    private CaseActivityDefinition getActivityForCategoryFromName(String categoryName, String caseActivityName, String version) throws CaseActivityException {
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = null;
        List activities = null;
        try {
            if (version != null) {
                parameters = new HashMap<String, Object>();
                parameters.put("name", caseActivityName);
                parameters.put("categoryName", categoryName);
                parameters.put("version", version);
                activities = persistence.findWithNamedQuery("CaseActivityDefinition.findActivityForCategoryFromNameVersion", parameters);
            }
            if (activities == null || activities.size() == 0) {
                parameters = new HashMap();
                parameters.put("name", caseActivityName);
                parameters.put("categoryName", categoryName);
                activities = persistence.findWithNamedQuery("CaseActivityDefinition.findActivityForCategoryFromName", parameters);
            }
        }
        catch (CasePersistenceException e) {
            // empty catch block
        }
        if (activities != null && activities.size() > 1) {
            throw new CaseActivityException(74010, new Object[]{caseActivityName}, null);
        }
        if (activities != null && activities.size() == 1) {
            return (CaseActivityDefinition)activities.get(0);
        }
        return null;
    }

    private CaseActivityDefinition getActivityWithoutAssociationsFromName(String caseActivityName, String version) throws CaseActivityException {
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = null;
        List activities = null;
        try {
            if (version != null) {
                parameters = new HashMap<String, Object>();
                parameters.put("name", caseActivityName);
                parameters.put("version", version);
                activities = persistence.findWithNamedQuery("CaseActivityDefinition.findActivityWithoutAssociationsFromNameVersion", parameters);
            }
            if (activities == null || activities.size() == 0) {
                parameters = new HashMap();
                parameters.put("name", caseActivityName);
                activities = persistence.findWithNamedQuery("CaseActivityDefinition.findActivityWithoutAssociationsFromName", parameters);
            }
        }
        catch (CasePersistenceException e) {
            // empty catch block
        }
        if (activities != null && activities.size() > 1) {
            throw new CaseActivityException(74010, new Object[]{caseActivityName}, null);
        }
        if (activities != null && activities.size() == 1) {
            return (CaseActivityDefinition)activities.get(0);
        }
        return null;
    }

    private void populateCaseDataFromNM(Element output, TOutputParameter parameter, String caseId) throws CaseActivityException {
        String methodName = "populateCaseDataFromNM";
        TNMOutput nmOutput = parameter.getNmOutput();
        if (nmOutput != null) {
            NodeList nodeList;
            TSaveDataAs saveType;
            String elementName = nmOutput.getElementName();
            TSaveData saveData = nmOutput.getSaveData();
            if (saveData != null && (saveType = saveData.getSaveDataAs()).compareTo((Enum)TSaveDataAs.CASE_DATA) == 0 && (nodeList = output.getElementsByTagName(elementName)).getLength() > 0) {
                Element data = (Element)nodeList.item(0);
                String caseDataName = saveData.getDataName();
                if (data != null && caseDataName != null && !caseDataName.trim().equals("")) {
                    CaseActivityUtil.uploadCaseData(caseDataName, data, caseId);
                }
            }
        }
    }

    private InputStream dictionaryAsInputStream(Document ruleDoc) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DOMSource xmlSource = new DOMSource(ruleDoc);
        StreamResult outputTarget = new StreamResult(outputStream);
        TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private void addCaseAssociationsToCaseActivity(CaseActivityDefinition caseActivityDefn, CaseActivity caseActivity, String caseDefinitionId) throws CaseMetadataException {
        String methodName = "addCaseAssociationsToCaseDefinition";
        ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
        this.debugLog(methodName, "case definition id:" + caseDefinitionId);
        CaseDefinition caseDefinition = null;
        if (caseDefinitionId != null) {
            try {
                caseActivityDefn.setCaseActivityInCaseDefinitionList(new ArrayList());
                caseActivityDefn.setCaseActivityCategoryDefinitionList(new ArrayList());
                caseDefinition = casePersistence.find(CaseDefinition.class, caseDefinitionId);
                this.debugLog(methodName, caseDefinition.getDefinitionId());
                if (caseDefinition != null) {
                    this.debugLog(methodName, caseActivityDefn.getDefinitionId());
                    caseActivityDefn.addCaseActivityInCaseDefinition(new CaseActivityInCaseDefinition(caseActivityDefn, caseDefinition));
                }
            }
            catch (CasePersistenceException e) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"addCaseAssociationsToCaseActivity", (String)("Error during association of case activity of definition id:" + caseActivityDefn.getDefinitionId() + " with case of definition id:" + caseDefinitionId + " and category:" + caseDefinition.getCategory()));
                throw new CaseMetadataException(72810, new Object[]{caseActivityDefn.getDefinitionId(), caseDefinitionId, caseDefinition.getCategory()}, (Throwable)((Object)e));
            }
        }
    }

    private void addCasesToCaseActivity(CaseActivityDefinition caseActivityDefn, CaseActivity caseActivity) {
        List caseList;
        caseActivityDefn.setCaseActivityInCaseDefinitionList(new ArrayList());
        TCaseAssociations caseAssociations = ((TCaseActivity)caseActivity.getValue()).getCaseAssociations();
        ICasePersistence casePersistence = ServicesLocator.getCasePersistence();
        if (caseAssociations != null && caseAssociations.getAssociations() != null && caseAssociations.getAssociations().getCases() != null && (caseList = caseAssociations.getAssociations().getCases().getCase()) != null) {
            for (TCaseIdentifier caseObject : caseList) {
                String caseDefinitionId = caseObject.getCaseMetadataId();
                if (caseDefinitionId == null) continue;
                try {
                    CaseDefinition caseDefinition = casePersistence.find(CaseDefinition.class, caseDefinitionId);
                    if (caseDefinition == null) continue;
                    caseActivityDefn.addCaseActivityInCaseDefinition(new CaseActivityInCaseDefinition(caseActivityDefn, caseDefinition));
                }
                catch (CasePersistenceException e) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"addCasesToCaseActivity", (String)"Exception in updating case activity", (Throwable)((Object)e));
                }
            }
        }
    }

    private CaseActivityDefinition createCaseActivityDefinition(ComponentModel componentModel, CaseActivity caseActivity, String caseDefinitionId) throws CaseMetadataException, CaseActivityException {
        String componentName = null;
        String compositeDN = null;
        String compositeName = null;
        String revision = null;
        String applicationName = null;
        if (componentModel != null) {
            componentName = componentModel.getName();
            CompositeModel compositeModel = componentModel.getComposite();
            compositeDN = compositeModel.getDN();
            compositeName = compositeModel.getName();
            revision = compositeModel.getRevision();
            applicationName = compositeModel.getApplicationName();
        }
        String caseActivityDefinitionId = ((TCaseActivity)caseActivity.getValue()).getActivityDefinitionId();
        String activityType = ((TCaseActivity)caseActivity.getValue()).getActivityType().name();
        String name = ((TCaseActivity)caseActivity.getValue()).getName();
        String displayName = CaseMetadataCache.getInstance().getDisplayValue(caseDefinitionId, ((TCaseActivity)caseActivity.getValue()).getName(), Locale.getDefault());
        if (displayName == null || displayName.trim().equals("")) {
            displayName = name;
        }
        boolean required = ((TCaseActivity)caseActivity.getValue()).isRequired();
        boolean manual = ((TCaseActivity)caseActivity.getValue()).isManual();
        boolean repeatable = ((TCaseActivity)caseActivity.getValue()).isRepeatable();
        boolean custom = false;
        if (activityType.equalsIgnoreCase(CUSTOM)) {
            custom = true;
        }
        boolean isGlobalActivity = ((TCaseActivity)caseActivity.getValue()).isIsGlobal();
        boolean conditional = ((TCaseActivity)caseActivity.getValue()).isIsConditional();
        String namespace = ((TCaseActivity)caseActivity.getValue()).getTargetNamespace();
        String productVersion = ((TCaseActivity)caseActivity.getValue()).getProductVersion();
        String permissionTag = ((TCaseActivity)caseActivity.getValue()).getPermissionTag();
        String className = null;
        if (custom) {
            className = CaseActivityUtil.getCustomClassName(caseActivity);
        }
        boolean isCaseSpecific = CaseActivityUtil.isCaseAssociated(caseActivity, caseDefinitionId);
        CaseActivityDefinition caseActivityDefn = new CaseActivityDefinition();
        caseActivityDefn.setName(name);
        caseActivityDefn.setDisplayName(displayName);
        caseActivityDefn.setApplicationName(applicationName);
        caseActivityDefn.setClassName(className);
        caseActivityDefn.setComponentName(componentName);
        caseActivityDefn.setCompositeDn(compositeDN);
        caseActivityDefn.setCompositeName(compositeName);
        caseActivityDefn.setCompositeVersion(revision);
        caseActivityDefn.setIsCustom(custom);
        caseActivityDefn.setDefinitionId(caseActivityDefinitionId);
        caseActivityDefn.setIsCaseSpecific(isCaseSpecific);
        caseActivityDefn.setIsConditional(conditional);
        caseActivityDefn.setIsGlobal(isGlobalActivity);
        caseActivityDefn.setIsManual(manual);
        caseActivityDefn.setNamespace(namespace);
        caseActivityDefn.setProductVersion(productVersion);
        caseActivityDefn.setPermissionTag(permissionTag);
        if (caseActivityDefn.getIsCustom()) {
            caseActivityDefn.setPayload(CaseActivityUtil.toClob(caseActivity));
        }
        caseActivityDefn.setIsRepeatable(repeatable);
        caseActivityDefn.setIsRequired(required);
        caseActivityDefn.setType(activityType);
        this.addCaseAssociationsToCaseActivity(caseActivityDefn, caseActivity, caseDefinitionId);
        return caseActivityDefn;
    }

    private CaseDefinition createCaseDefinition(ComponentModel componentModel, CaseMetadata caseMetadata) {
        TMilestones milestones;
        String caseDefinitionId = ((TCaseMetadata)caseMetadata.getValue()).getId();
        CompositeModel compositeModel = componentModel.getComposite();
        String componentName = componentModel.getName();
        String compositeDN = compositeModel.getDN();
        String compositeName = compositeModel.getName();
        String revision = compositeModel.getRevision();
        String applicationName = compositeModel.getApplicationName();
        String namespace = ((TCaseMetadata)caseMetadata.getValue()).getTargetNamespace();
        String name = CaseMetadataCache.getInstance().getDisplayValue(caseDefinitionId, (Object)((TCaseMetadata)caseMetadata.getValue()).getName(), Locale.getDefault(), true);
        if (name == null || name.trim().equals("")) {
            name = ((TCaseMetadata)caseMetadata.getValue()).getName();
        }
        CaseDefinition caseDefn = new CaseDefinition();
        caseDefn.setDefinitionId(caseDefinitionId);
        caseDefn.setName(name);
        caseDefn.setNamespace(namespace);
        caseDefn.setApplicationName(applicationName);
        caseDefn.setComponentName(componentName);
        caseDefn.setCompositeDn(compositeDN);
        caseDefn.setCompositeName(compositeName);
        caseDefn.setCompositeVersion(revision);
        caseDefn.setCaseMilestoneDefinitionList(new ArrayList());
        TCategory category = ((TCaseMetadata)caseMetadata.getValue()).getCategory();
        if (category != null) {
            String categoryName = CaseMetadataCache.getInstance().getDisplayValue(caseDefinitionId, (Object)category.getName(), Locale.getDefault(), true);
            caseDefn.setCategory(categoryName);
        }
        if ((milestones = ((TCaseMetadata)caseMetadata.getValue()).getMilestones()) != null && milestones.getMilestone() != null && milestones.getMilestone().size() > 0) {
            for (TMilestone milestone : milestones.getMilestone()) {
                String milestoneId = milestone.getName();
                String milestoneName = CaseMetadataCache.getInstance().getDisplayValue(caseDefinitionId, (Object)milestone.getName(), Locale.getDefault(), true);
                caseDefn.addCaseMilestoneDefinition(new CaseMilestoneDefinition(caseDefn, milestoneId, milestoneName));
            }
        }
        return caseDefn;
    }

    private String getCaseDefinitionId(String caseId) throws BPMException, CaseServiceException {
        ICaseService caseService = ServicesLocator.getCaseService();
        CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
        IBPMContext context = InternalBPMContext.getInternalBPMContext();
        Case caseInstance = this.getCase(context, caseIdentifier, null);
        String caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
        return caseDefinitionId;
    }

    private String getCategoryName(String caseId) throws BPMException, CaseServiceException {
        ICaseService caseService = ServicesLocator.getCaseService();
        CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
        IBPMContext context = InternalBPMContext.getInternalBPMContext();
        Case caseInstance = this.getCase(context, caseIdentifier, null);
        String categoryName = caseInstance.getCaseHeader().getCategory();
        return categoryName;
    }

    private void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + message + "\n"));
    }

    private void debugActivityLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + message + "\n"));
    }

    private void logCaseActivities(String methodName, List<CaseActivityDefinition> caseActivities, String message) {
        if (caseActivities == null) {
            return;
        }
        this.debugLog(methodName, message);
        this.debugLog(methodName, "Case Activity List count:" + caseActivities.size());
        for (CaseActivityDefinition caseActivity : caseActivities) {
            this.logCaseActivity(methodName, caseActivity, null);
        }
    }

    private void logCaseActivity(String methodName, CaseActivityDefinition caseActivity, String message) {
        String msg = message + "\n" + "CaseActivityDefinition for :" + caseActivity.getName() + "\n" + "Definition Id:" + caseActivity.getDefinitionId() + "\n" + "Is custom activity:" + caseActivity.getIsCustom() + "\n" + "Is global:" + caseActivity.getIsGlobal() + "\n" + "Is case specific:" + caseActivity.getIsCaseSpecific() + "\n" + "Is conditional:" + caseActivity.getIsConditional() + "\n" + "Required:" + caseActivity.getIsRequired() + "\n" + "Repeatable:" + caseActivity.getIsRepeatable() + "\n" + "Manual:" + caseActivity.getIsManual() + "\n" + "State:" + caseActivity.getState() + "\n" + "Class Name:" + caseActivity.getClassName() + "\n" + "Type: " + caseActivity.getType() + "\n" + "Relevance:" + caseActivity.getRelevance().toString() + "\n";
        this.debugActivityLog(methodName, msg);
    }

    private void logStartOfMethod(String methodName, String string) {
        String msg = "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\nStart of " + methodName + "\n" + string + "\n" + "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" + "\n";
        this.debugActivityLog(methodName, msg);
    }

    private void logEndOfMethod(String methodName, String string) {
        String msg = "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\nEnd of " + methodName + "\n" + string + "\n" + "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" + "\n";
        this.debugActivityLog(methodName, msg);
    }
}

