/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ejb;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseDocumentObject;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseList;
import oracle.bpm.casemgmt.CaseObjectsList;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityDefinition;
import oracle.bpm.casemgmt.casemetadata.model.CaseDefinition;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.activity.model.CaseActivity;
import oracle.bpm.casemgmt.metadata.casedisplay.model.TCaseDisplayInfo;
import oracle.bpm.casemgmt.metadata.event.model.TEventType;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.model.CaseHeader;
import oracle.bpm.casemgmt.persistence.model.CaseMilestone;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolder;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class CaseManagementService
implements ICaseService {
    public boolean raiseCaseEvent(IBPMContext context, CaseIdentifier caseIdentifier, CaseEvent caseEvent) throws CaseServiceException {
        return ServicesLocator.getCaseEventService().raiseCaseEvent(context, caseIdentifier, caseEvent);
    }

    public CaseObjectsList getAudit(IBPMContext context, CaseIdentifier caseIdentifier, TEventType eventType, String updatedBy, int pageSize, int pageNumber) throws CaseServiceException {
        return ServicesLocator.getCaseEventService().getAudit(context, caseIdentifier, eventType, updatedBy, pageSize, pageNumber);
    }

    public CaseObjectsList queryCaseEvent(IBPMContext context, CaseIdentifier caseIdentifier, TEventType eventType, String searchString, String updatedBy, int pageSize, int pageNumber, List<ICaseConstants.CaseEventInfo> additionalCaseEventInfo) throws CaseServiceException {
        return ServicesLocator.getCaseEventService().queryCaseEvent(context, caseIdentifier, eventType, searchString, updatedBy, pageSize, pageNumber, additionalCaseEventInfo);
    }

    public List<CaseDocumentObject> listDocuments(IBPMContext context, CaseIdentifier caseIdentifier) throws CaseServiceException {
        return ServicesLocator.getCaseDocumentService().listDocuments(context, caseIdentifier);
    }

    public boolean deleteDocument(IBPMContext context, CaseIdentifier caseIdentifier, CaseDocumentObject caseDocObj, boolean allVersions) throws CaseServiceException {
        return ServicesLocator.getCaseDocumentService().deleteDocument(context, caseIdentifier, caseDocObj, allVersions);
    }

    public CaseMetadata getCaseMetadata(IBPMContext ctx, String caseDefinitionId) throws CaseServiceException {
        CaseMetadata returnObj = null;
        try {
            returnObj = ServicesLocator.getCaseMetadataService().getCaseMetadata(ctx, caseDefinitionId);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCaseMetadata", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(ctx, null));
            throw e;
        }
        return returnObj;
    }

    public Map<String, String> getCaseMetadataDisplayValues(IBPMContext ctx, String caseDefinitionId, ICaseMetadataService.TRANSLATABLES_ENUM translatableEnum, Locale locale) throws CaseServiceException {
        Map returnObj = null;
        try {
            returnObj = ServicesLocator.getCaseMetadataService().getCaseMetadataDisplayValues(ctx, caseDefinitionId, translatableEnum, locale);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCaseMetadataDisplayValues", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(ctx, null));
            throw e;
        }
        return returnObj;
    }

    public List<CaseDefinition> listCaseDefinition(IBPMContext ctx, ICaseMetadataService.SEARCH_TYPE_ENUM searchByEnum, List values) throws CaseServiceException {
        List returnList = null;
        try {
            returnList = ServicesLocator.getCaseMetadataService().listCaseDefinition(ctx, searchByEnum, values);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"listCaseDefinition", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(ctx, null));
            throw e;
        }
        return returnList;
    }

    public CaseActivity getCaseActivityMetadata(IBPMContext ctx, String activityDefinitionId) throws CaseServiceException {
        CaseActivity returnObj = null;
        try {
            returnObj = ServicesLocator.getCaseMetadataService().getCaseActivityMetadata(ctx, activityDefinitionId);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCaseActivityMetadata", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(ctx, null));
            throw e;
        }
        return returnObj;
    }

    public List<CaseActivityDefinition> listCaseActivityDefinition(IBPMContext ctx, ICaseMetadataService.SEARCH_TYPE_ENUM searchByEnum, List values) throws CaseServiceException {
        List returnList = null;
        try {
            returnList = ServicesLocator.getCaseMetadataService().listCaseActivityDefinition(ctx, searchByEnum, values);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"listCaseActivityDefinition", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(ctx, null));
            throw e;
        }
        return returnList;
    }

    public CaseIdentifier startCase(IBPMContext context, Case caseInstance) throws CaseServiceException {
        CaseIdentifier returnObj = null;
        try {
            returnObj = ServicesLocator.getCaseInstanceService().startCase(null, caseInstance);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"startCase", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return returnObj;
    }

    public Case getCase(IBPMContext context, CaseIdentifier caseIdentifier, List<ICaseConstants.CaseInfo> additionalCaseInfo) throws CaseServiceException {
        Case returnObj = null;
        try {
            returnObj = ServicesLocator.getCaseInstanceService().getCase(context, caseIdentifier, additionalCaseInfo);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCase", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return returnObj;
    }

    public CaseList queryCase(IBPMContext context, List<ICaseConstants.CaseInfo> additionalCaseInfo, String addtionalJPQLWhereClause, String orderBy, int pageSize, int pageNumber) throws CaseServiceException {
        CaseList returnObj = null;
        try {
            returnObj = ServicesLocator.getCaseInstanceService().queryCase(context, additionalCaseInfo, addtionalJPQLWhereClause, orderBy, pageSize, pageNumber);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"queryCase", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return returnObj;
    }

    public boolean uploadCaseData(IBPMContext context, CaseData caseData) throws CaseServiceException {
        boolean upload = false;
        try {
            upload = ServicesLocator.getCaseInstanceService().uploadCaseData(context, caseData);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"uploadCaseData", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return upload;
    }

    public CaseData getCaseDataByName(IBPMContext context, CaseIdentifier caseIdentifier, String caseDataName) throws CaseServiceException {
        CaseData returnObj = null;
        try {
            returnObj = ServicesLocator.getCaseInstanceService().getCaseDataByName(context, caseIdentifier, caseDataName);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCaseDataByName", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return returnObj;
    }

    public List<CaseData> getCaseData(IBPMContext context, CaseIdentifier caseIdentifier) throws CaseServiceException {
        List returnObj = null;
        try {
            returnObj = ServicesLocator.getCaseInstanceService().getCaseData(context, caseIdentifier);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCaseData", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return returnObj;
    }

    public boolean closeCase(IBPMContext context, CaseIdentifier caseIdentifier, String outcome, Comment comment) throws CaseServiceException {
        boolean closed = false;
        try {
            closed = ServicesLocator.getCaseInstanceService().closeCase(context, caseIdentifier, outcome, comment);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"closeCase", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return closed;
    }

    public boolean addComment(IBPMContext context, CaseIdentifier caseIdentifier, Comment comment) throws CaseServiceException {
        boolean addComment = false;
        try {
            addComment = ServicesLocator.getCaseInstanceService().addComment(context, caseIdentifier, comment);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"closeCase", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return addComment;
    }

    public List<CaseMilestone> getCaseMileStones(IBPMContext context, CaseIdentifier caseIdentifier) throws CaseServiceException {
        List milestoneList = null;
        try {
            milestoneList = ServicesLocator.getCaseInstanceService().getCaseMileStones(context, caseIdentifier);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCaseMileStones", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return milestoneList;
    }

    public boolean attainMilestone(IBPMContext context, CaseMilestone milestone) throws CaseServiceException {
        boolean attained = false;
        try {
            attained = ServicesLocator.getCaseInstanceService().attainMilestone(context, milestone);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"attainMilestone", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return attained;
    }

    public boolean revokeMilestone(IBPMContext context, CaseMilestone milestone) throws CaseServiceException {
        boolean revoked = false;
        try {
            revoked = ServicesLocator.getCaseInstanceService().revokeMilestone(context, milestone);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"revokeMilestone", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return revoked;
    }

    public boolean addCaseStakeHolder(IBPMContext context, CaseStakeHolder caseStakeHolder) throws CaseServiceException {
        boolean added = false;
        try {
            added = ServicesLocator.getCaseInstanceService().addCaseStakeHolder(context, caseStakeHolder);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_METADATA, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"addCaseStakeHolder", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return added;
    }

    public List<CaseStakeHolder> getCaseStakeHolders(IBPMContext context, CaseIdentifier caseIdentifier) throws CaseServiceException {
        List returnObj = null;
        try {
            returnObj = ServicesLocator.getCaseInstanceService().getCaseStakeHolders(context, caseIdentifier);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCaseStakeHolders", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return returnObj;
    }

    public List<Comment> getComments(IBPMContext context, CaseObject caseObject) throws CaseServiceException {
        List returnObj = null;
        try {
            returnObj = ServicesLocator.getCaseInstanceService().getComments(context, caseObject);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getComments", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return returnObj;
    }

    public List<CaseActivityDefinition> getActivatableCaseActivities(IBPMContext context, CaseIdentifier caseIdentifier) throws CaseServiceException {
        List returnObj = null;
        try {
            returnObj = ServicesLocator.getCaseActivityService().getActivatableCaseActivities(context, caseIdentifier);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getActivatableCaseActivities", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return returnObj;
    }

    public List<CaseActivityDefinition> getCaseActivities(IBPMContext context, CaseIdentifier caseIdentifier, ICaseConstants.ActivityFilterType filter, String orderBy, ICaseConstants.ActivitySortOrder sortOrder, List<ICaseConstants.ActivityOptionalInfo> optionalInfo, String additionalJPQLWhereClause) throws CaseServiceException {
        List returnObj = null;
        try {
            returnObj = ServicesLocator.getCaseActivityService().getCaseActivities(context, caseIdentifier, filter, orderBy, sortOrder, optionalInfo, additionalJPQLWhereClause);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCaseActivities", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return returnObj;
    }

    public boolean initiateCaseActivity(IBPMContext context, CaseIdentifier caseIdentifier, String caseActivityMetadataId, Map<String, Object> payload, Comment comment) throws CaseServiceException {
        boolean initiated = false;
        try {
            initiated = ServicesLocator.getCaseActivityService().initiateCaseActivity(context, caseIdentifier, caseActivityMetadataId, payload, comment);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"initiateCaseActivity", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return initiated;
    }

    public void registerCaseActivity(IBPMContext context, CaseActivity caseActivity) throws CaseServiceException {
        try {
            ServicesLocator.getCaseActivityService().registerCaseActivity(context, caseActivity);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"registerCaseActivity", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
    }

    public void deleteUserDictionary(IBPMContext ctx, String namespace) throws CaseServiceException {
        try {
            ServicesLocator.getCaseRuleService().deleteUserDictionary(ctx, namespace);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"deleteUserDictionary", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(ctx, null));
            throw e;
        }
    }

    public Set<String> getPermissionTags(IBPMContext ctx, CaseIdentifier caseId) throws CaseServiceException {
        Set returnObj = null;
        try {
            returnObj = ServicesLocator.getCasePermissionService().getPermissionTags(ctx, caseId);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_PERMISSION, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getPermissionTags", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(ctx, null));
            throw e;
        }
        return returnObj;
    }

    public Set<String> getPermissionTagsUserCanUse(IBPMContext ctx, CaseIdentifier caseId, ICaseConstants.CaseObjectPermissionType action, ICaseConstants.CaseObjectType caseObjectType) throws CaseServiceException {
        return ServicesLocator.getCasePermissionService().getPermissionTagsUserCanUse(ctx, caseId, action, caseObjectType);
    }

    public Set<ICaseConstants.CaseObjectPermissionType> getActionsUserCanPerform(IBPMContext ctx, CaseIdentifier caseId, ICaseConstants.CaseObjectType caseObjectType) throws CaseServiceException {
        Set returnObj = null;
        try {
            returnObj = ServicesLocator.getCasePermissionService().getActionsUserCanPerform(ctx, caseId, caseObjectType);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_PERMISSION, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getActionsUserCanPerform", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(ctx, null));
            throw e;
        }
        return returnObj;
    }

    public Set<ICaseConstants.CaseObjectPermissionType> getActionsUserCanPerformOnCaseObject(IBPMContext ctx, CaseIdentifier caseId, CaseObject caseObj) throws CaseServiceException {
        return ServicesLocator.getCasePermissionService().getActionsUserCanPerformOnCaseObject(ctx, caseId, caseObj);
    }

    public boolean checkCaseTagPermission(IBPMContext ctx, CaseIdentifier caseId, String permissionTag, ICaseConstants.CaseObjectPermissionType action, ICaseConstants.CaseObjectType caseObjectType) throws CaseServiceException {
        boolean check = false;
        try {
            check = ServicesLocator.getCasePermissionService().checkCaseTagPermission(ctx, caseId, permissionTag, action, caseObjectType);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_PERMISSION, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"checkCaseTagPermission", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(ctx, null));
            throw e;
        }
        return check;
    }

    public boolean setPermissionTag(IBPMContext context, CaseIdentifier caseIdentifier, CaseObject caseObject, String permissionTag) throws CaseServiceException {
        boolean setPermTag = false;
        try {
            setPermTag = ServicesLocator.getCasePermissionService().setPermissionTag(context, caseIdentifier, caseObject, permissionTag);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"setPermissionTag", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return setPermTag;
    }

    public boolean setCaseActivityPermissionTag(IBPMContext context, CaseIdentifier caseIdentifier, String caseActivityMetadataId, String permissionTag) throws CaseServiceException {
        boolean setPermTag = false;
        try {
            setPermTag = ServicesLocator.getCasePermissionService().setCaseActivityPermissionTag(context, caseIdentifier, caseActivityMetadataId, permissionTag);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"setCaseActivityPermissionTag", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return setPermTag;
    }

    public void rateActivityInstance(IBPMContext context, CaseIdentifier caseIdentifier, String caseActivityMetadataId, int rating) throws CaseServiceException {
        try {
            ServicesLocator.getCaseActivityService().rateActivityInstance(context, caseIdentifier, caseActivityMetadataId, rating);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"rateActivityInstance", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
    }

    public boolean abortCase(IBPMContext context, CaseIdentifier caseIdentifier, Comment comment) throws CaseServiceException {
        boolean aborted = false;
        try {
            aborted = ServicesLocator.getCaseInstanceService().abortCase(context, caseIdentifier, comment);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"abortCase", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return aborted;
    }

    public boolean suspendCase(IBPMContext context, CaseIdentifier caseIdentifier, Comment comment) throws CaseServiceException {
        boolean suspended = false;
        try {
            suspended = ServicesLocator.getCaseInstanceService().suspendCase(context, caseIdentifier, comment);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"suspendCase", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return suspended;
    }

    public boolean resumeCase(IBPMContext context, CaseIdentifier caseIdentifier, Comment comment) throws CaseServiceException {
        boolean resumed = false;
        try {
            resumed = ServicesLocator.getCaseInstanceService().resumeCase(context, caseIdentifier, comment);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"resumeCase", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return resumed;
    }

    public void rateActivityDefinition(IBPMContext context, String caseActivityMetadataId, int rating) throws CaseServiceException {
        try {
            ServicesLocator.getCaseActivityService().rateActivityDefinition(context, caseActivityMetadataId, rating);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"rateActivityDefinition", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
    }

    public boolean reopenCase(IBPMContext context, CaseIdentifier caseIdentifier, Comment comment) throws CaseServiceException {
        boolean reopened = false;
        try {
            reopened = ServicesLocator.getCaseInstanceService().reopenCase(context, caseIdentifier, comment);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"reopenCase", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return reopened;
    }

    public void registerCaseDisplayForm(IBPMContext ctx, String caseDefinitionNamespace, String caseArtifactName, String compositeVersion, String partitionName, List<TCaseDisplayInfo> caseDisplayInfoList, ICaseMetadataService.FORM_TYPE formType) throws CaseServiceException {
        try {
            ServicesLocator.getCaseMetadataService().registerCaseDisplayForm(ctx, caseDefinitionNamespace, caseArtifactName, compositeVersion, partitionName, caseDisplayInfoList, formType);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"registerCaseDisplayForm", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(ctx, null));
            throw e;
        }
    }

    public List<TCaseDisplayInfo> getCaseDisplayForm(IBPMContext ctx, String caseDefinitionNamespace, String caseArtifactName, String compositeVersion, String partitionName, String applicationName, String formName, ICaseMetadataService.FORM_TYPE formType) throws CaseServiceException {
        try {
            return ServicesLocator.getCaseMetadataService().getCaseDisplayForm(ctx, caseDefinitionNamespace, caseArtifactName, compositeVersion, partitionName, applicationName, formName, formType);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCaseDisplayForm", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(ctx, null));
            throw e;
        }
    }

    public int deleteCaseForm(IBPMContext ctx, String caseNamespace, String caseArtificatName, String compositeVersion, String partitionName, ICaseMetadataService.FORM_TYPE formType) throws CaseServiceException {
        return ServicesLocator.getCaseMetadataService().deleteCaseForm(ctx, caseNamespace, caseArtificatName, compositeVersion, partitionName, formType);
    }

    public int unregisterCaseForm(IBPMContext ctx, TCaseDisplayInfo displayInfo) throws CaseServiceException {
        return ServicesLocator.getCaseMetadataService().unregisterCaseForm(ctx, displayInfo);
    }

    public boolean addWorkItem(IBPMContext context, CaseIdentifier caseIdentifier, String caseActivityDefinitionId) throws CaseServiceException {
        try {
            return ServicesLocator.getCaseActivityService().addWorkItem(context, caseIdentifier, caseActivityDefinitionId);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"addWorkItem", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
    }

    public boolean updateCaseHeader(IBPMContext context, CaseHeader caseHeader, Comment comment) throws CaseServiceException {
        boolean updated = false;
        try {
            updated = ServicesLocator.getCaseInstanceService().updateCaseHeader(context, caseHeader, comment);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"updateCaseHeader", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
        return updated;
    }

    public void markActivityRelevance(IBPMContext context, CaseIdentifier caseIdentifier, String caseActivityDefinitionId, ICaseConstants.ActivityRelevance relevance) throws CaseServiceException {
        try {
            ServicesLocator.getCaseActivityService().markActivityRelevance(context, caseIdentifier, caseActivityDefinitionId, relevance);
        }
        catch (CaseServiceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"markActivityRelevance", (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)e, CaseServiceUtil.getLocale(context, null));
            throw e;
        }
    }
}

