/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ejb;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJBException;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue")})
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class CaseEventMDB
implements MessageListener {
    private MessageDrivenContext messageDrivenContext;

    public void ejbCreate() {
    }

    public void ejbRemove() throws EJBException {
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.messageDrivenContext = mdc;
    }

    public void onMessage(Message message) {
        try {
            ObjectMessage objMsg = (ObjectMessage)message;
            String methodName = "onMessage";
            CaseEvent caseEvent = (CaseEvent)objMsg.getObject();
            this.logStartOfMethod(methodName, "Case Id: " + caseEvent.getCaseId() + "\n" + "Event Type: " + caseEvent.getEventType() + "\n" + "Activity Name: " + caseEvent.getActivityName() + "\n" + "Activity Event: " + caseEvent.getActivityEvent() + "\n" + "Lifecycle Event: " + caseEvent.getLifecycleEvent() + "\n" + "Lifecycle State: " + caseEvent.getLifecycleState() + "\n" + "Milestone Event: " + caseEvent.getMilestoneEvent() + "\n" + "Milestone: " + caseEvent.getMilestone() + "\n");
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_EVENT, (Severity)Severity.DEBUG, (String)("CaseEventMDB.onMessage(): Received CaseEvent: eventId = " + caseEvent.getEventId() + ", caseID = " + caseEvent.getCaseId()));
            ServicesLocator.getECAProcessor().processEvent(caseEvent);
            this.logEndOfMethod(methodName, "Case Id: " + caseEvent.getCaseId() + "\n" + "Event Type: " + caseEvent.getEventType() + "\n" + "Activity Name: " + caseEvent.getActivityName() + "\n" + "Activity Event: " + caseEvent.getActivityEvent() + "\n" + "Lifecycle Event: " + caseEvent.getLifecycleEvent() + "\n" + "Lifecycle State: " + caseEvent.getLifecycleState() + "\n" + "Milestone Event: " + caseEvent.getMilestoneEvent() + "\n" + "Milestone: " + caseEvent.getMilestone() + "\n");
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_EVENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"onMessage", (String)"Exception from process event", (Throwable)e);
        }
    }

    private void logStartOfMethod(String methodName, String string) {
        String msg = "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\nStart of " + methodName + "\n" + string + "\n" + "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" + "\n";
        this.debugLog(methodName, msg);
    }

    private void logEndOfMethod(String methodName, String string) {
        String msg = "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\nEnd of " + methodName + "\n" + string + "\n" + "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" + "\n";
        this.debugLog(methodName, msg);
    }

    private void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_EVENT, (Severity)Severity.DEBUG, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + message + "\n"));
    }
}

