/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ecm.database;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpel.services.workflow.ecm.api.DocumentObject;
import oracle.bpel.services.workflow.ecm.api.IContentObject;
import oracle.bpel.services.workflow.ecm.api.IDocumentObject;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.model.DatabaseDocument;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class DatabaseContentObject
implements IContentObject {
    public String[] listNames(String folder) {
        List<IDocumentObject> docObjects = this.listObjects(folder);
        String[] list = new String[docObjects.size()];
        for (int i = 0; i < docObjects.size(); ++i) {
            list[i] = docObjects.get(i).getDocName();
        }
        return list;
    }

    public List<IDocumentObject> listObjects(String folder) {
        ArrayList<IDocumentObject> docObjects = new ArrayList<IDocumentObject>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (folder == null || folder.equals("")) {
            folder = "/";
        }
        parameters.put("folder", folder);
        List dbDocs = null;
        try {
            dbDocs = ServicesLocator.getCasePersistence().findWithNamedQuery("DatabaseDocument.findByFolder", parameters);
        }
        catch (CasePersistenceException cpe) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_DOCUMENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"listObjects", (String)"Exception in listObjects", (Throwable)((Object)cpe));
        }
        for (Object dbDoc : dbDocs) {
            IDocumentObject documentObj = DatabaseContentObject.createDocumentObject((DatabaseDocument)dbDoc);
            docObjects.add(documentObj);
        }
        return docObjects;
    }

    public void createFolder(String folderName, String parentFolder) {
    }

    public void createFolder(String folder) {
    }

    public void deleteFolder(String folder) {
    }

    public void createDocument(String folder, String filePath, String docComment) {
        this.createDocument(folder, null, null, null, filePath, docComment, null);
    }

    public Object createDocument(String folder, String docName, String docType, String securityGroup, InputStream is, String docComment, Map<String, String> docMetadataMap) {
        if (folder == null || folder.equals("")) {
            folder = "/";
        }
        DatabaseDocument dbDocExisting = null;
        try {
            dbDocExisting = this.getDatabaseDocument(folder + "/" + docName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (dbDocExisting != null) {
            return dbDocExisting;
        }
        DatabaseDocument dbDoc = new DatabaseDocument();
        try {
            int nRead;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                baos.write(data, 0, nRead);
            }
            baos.flush();
            dbDoc.setFolder(folder);
            dbDoc.setObjectName(docName);
            String dbDocId = folder + "/" + docName;
            dbDoc.setId(dbDocId);
            byte[] docContent = baos.toByteArray();
            dbDoc.setDocContent(docContent);
            dbDoc.setDocSize(new Long(docContent.length));
            dbDoc.setDocVersion("1.0");
            dbDoc.setDocComment(docComment);
            Calendar currentTime = CaseServiceUtil.getCalendarInstance(null);
            dbDoc.setUpdatedDate(currentTime);
            dbDoc.setUpdatedBy(docMetadataMap.get("dDocLastModifier"));
            dbDoc.setCase(ServicesLocator.getInternalCaseService().getCase(docMetadataMap.get("caseId")));
            if (docMetadataMap != null) {
                String permisionTag = docMetadataMap.get(DocumentObject.getEMPermissionTagAttributeName());
                dbDoc.setPermissionTag(permisionTag);
            }
            ServicesLocator.getCasePersistence().persist(dbDoc);
        }
        catch (Exception e) {
            CaseServiceException cse = new CaseServiceException(73802, new Object[]{docName}, (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(null, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_DOCUMENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"CreateDocument", (String)"Exception from createDocument", (Throwable)e);
        }
        String docId = dbDoc != null ? dbDoc.getId() : null;
        return docId;
    }

    public void updateProperties(String folder, String docName, Map<String, String> docMetadataMap) throws Exception {
        try {
            String permisionTag;
            if (docMetadataMap != null && (permisionTag = docMetadataMap.get(DocumentObject.getEMPermissionTagAttributeName())) != null) {
                String dbDocId = folder + "/" + docName;
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("id", dbDocId);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_DOCUMENT, (Severity)Severity.DEBUG, (String)("Updating document " + dbDocId + " with " + docMetadataMap));
                List dbDocs = ServicesLocator.getCasePersistence().findWithNamedQuery("DatabaseDocument.findById", parameters);
                if (dbDocs.size() == 0) {
                    CaseServiceException cse = new CaseServiceException(73804, new Object[]{docName}, null);
                    new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(null, null));
                    throw cse;
                }
                DatabaseDocument dbDoc = (DatabaseDocument)dbDocs.get(0);
                dbDoc.setPermissionTag(permisionTag);
                ServicesLocator.getCasePersistence().update(dbDoc);
            }
        }
        catch (CaseServiceException cse) {
            throw cse;
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_DOCUMENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"setPermissionTag", (String)"Exception from updateProperties", (Throwable)e);
        }
    }

    public Object createDocument(String folder, String docName, String docType, String securityGroup, String filePath, String docComment, Map<String, String> docMetadataMap) {
        return null;
    }

    public InputStream getDocContentStream(String docPath) {
        DatabaseDocument dbDocument = null;
        try {
            dbDocument = this.getDatabaseDocument(docPath);
        }
        catch (CasePersistenceException cpe) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_DOCUMENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getDocContentStream", (String)"Exception in getDocContentStream", (Throwable)((Object)cpe));
        }
        byte[] docContent = dbDocument != null ? dbDocument.getDocContent() : null;
        ByteArrayInputStream bais = docContent != null ? new ByteArrayInputStream(docContent) : null;
        return bais;
    }

    public boolean deleteDocument(String docPath, boolean allVersions) {
        int nDeletedDocs = -1;
        boolean result = false;
        try {
            nDeletedDocs = ServicesLocator.getCasePersistence().executeUpdateWithNamedQuery("DatabaseDocument.deleteById", "id", docPath);
            result = nDeletedDocs > 0;
        }
        catch (CasePersistenceException cpe) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_DOCUMENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"deleteDocument", (String)"Exception in deleteDocument", (Throwable)((Object)cpe));
        }
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_DOCUMENT, (Severity)Severity.DEBUG, (String)("Deleted " + nDeletedDocs + " at " + docPath));
        return result;
    }

    public boolean deleteDocument(String doc, String dID, boolean allVersions) {
        return this.deleteDocument(doc, allVersions);
    }

    private static String getFullPath(String path) {
        return path;
    }

    private static IDocumentObject createDocumentObject(DatabaseDocument dbDoc) {
        DocumentObject documentObject = new DocumentObject();
        documentObject.setObjectType(ICaseConstants.CaseObjectType.DOCUMENT.name());
        documentObject.setDocId(dbDoc.getId());
        documentObject.setDocName(dbDoc.getObjectName());
        String docDisplayName = dbDoc.getObjectDisplayName() != null ? dbDoc.getObjectDisplayName() : dbDoc.getObjectName();
        documentObject.setDocDisplayName(docDisplayName);
        documentObject.setDocUpdatedBy(dbDoc.getUpdatedBy());
        documentObject.setDocUpdatedDate(dbDoc.getUpdatedDate());
        documentObject.setDocStoreType("ORACLE_DB");
        documentObject.setFolder(dbDoc.getFolder());
        documentObject.setDocVersion(dbDoc.getDocVersion());
        documentObject.setDocSize(dbDoc.getDocSize().longValue());
        documentObject.setDocComment(dbDoc.getDocComment());
        documentObject.setPermissionTag(dbDoc.getPermissionTag());
        return documentObject;
    }

    private DatabaseDocument getDatabaseDocument(String docPath) throws CasePersistenceException {
        Object dbDoc;
        int fileNameSeparatorIdx = docPath.lastIndexOf("/");
        String docName = docPath.substring(fileNameSeparatorIdx + 1);
        List dbDocs = null;
        dbDocs = ServicesLocator.getCasePersistence().findWithNamedQuery("DatabaseDocument.findById", "id", docPath);
        DatabaseDocument dbDocument = null;
        Iterator i$ = dbDocs.iterator();
        while (i$.hasNext() && !(dbDocument = (DatabaseDocument)(dbDoc = i$.next())).getObjectName().equals(docName)) {
        }
        return dbDocument;
    }
}

