/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.eca;

import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.caserule.model.TMilestoneAction;
import oracle.bpm.casemgmt.caserule.model.TMilestoneStatus;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.eca.ActionHandlerException;
import oracle.bpm.casemgmt.eca.IActionHandler;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.persistence.model.CaseMilestone;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;

public class MilestoneActionHandler
implements IActionHandler {
    @Override
    public boolean handle(String caseId, Object action) throws ActionHandlerException {
        TMilestoneAction milestoneAction = (TMilestoneAction)action;
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("milestone action:" + milestoneAction.getName()));
        String milestoneName = milestoneAction.getName();
        String comments = milestoneAction.getComments();
        Comment comment = null;
        if (comments != null && comments.trim().length() > 0 && !comments.equals("")) {
            comment = new Comment();
            comment.setCaseObjectComment(comments);
        }
        ICaseService service = ServicesLocator.getCaseService();
        IBPMContext context = null;
        try {
            context = InternalBPMContext.getInternalBPMContext();
            if (milestoneAction.getStatus().compareTo((Enum)TMilestoneStatus.REACH) == 0) {
                CaseMilestone milestone = new CaseMilestone();
                milestone.setCaseId(caseId);
                milestone.setObjectName(milestoneName);
                if (comment != null) {
                    milestone.setComment(comment);
                }
                return service.attainMilestone(context, milestone);
            }
            if (milestoneAction.getStatus().compareTo((Enum)TMilestoneStatus.REVOKE) == 0) {
                CaseMilestone milestone = new CaseMilestone();
                milestone.setCaseId(caseId);
                milestone.setObjectName(milestoneName);
                if (comment != null) {
                    milestone.setComment(comment);
                }
                return service.revokeMilestone(context, milestone);
            }
        }
        catch (Exception e) {
            throw new ActionHandlerException(74023, new Object[]{milestoneName, caseId}, e);
        }
        return false;
    }
}

