/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.eca;

import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.IInternalCaseService;
import oracle.bpm.casemgmt.caserule.IECARuleProcessor;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.eca.ActionHandlerException;
import oracle.bpm.casemgmt.eca.IActionHandler;
import oracle.bpm.casemgmt.eca.IECAProcessor;
import oracle.bpm.casemgmt.factory.ActionHandlerFactory;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.metadata.event.model.TEventType;
import oracle.bpm.casemgmt.metadata.event.model.TLifecycleEvent;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;

public class ECAProcessor
implements IECAProcessor {
    @Override
    public boolean processEvent(CaseEvent caseEvent) {
        IBPMContext ctx = null;
        String methodName = "processEvent";
        try {
            ctx = InternalBPMContext.getInternalBPMContext();
            this.logStartOfMethod(methodName, "Case Id: " + caseEvent.getCaseId() + "\n" + "Event Type: " + caseEvent.getEventType() + "\n" + "Activity Name: " + caseEvent.getActivityName() + "\n" + "Activity Event: " + caseEvent.getActivityEvent() + "\n" + "Lifecycle Event: " + caseEvent.getLifecycleEvent() + "\n" + "Lifecycle State: " + caseEvent.getLifecycleState() + "\n" + "Milestone Event: " + caseEvent.getMilestoneEvent() + "\n" + "Milestone: " + caseEvent.getMilestone() + "\n");
            String caseId = caseEvent.getCaseId();
            this.onStartCase(caseEvent);
            IECARuleProcessor ruleProcessor = ServicesLocator.getECARuleProcessor();
            List actionList = ruleProcessor.invokeRule(ctx, caseEvent);
            if (actionList != null) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.DEBUG, (String)("action list size:" + actionList.size()));
            }
            this.processAction(caseId, actionList);
            if (actionList != null) {
                this.logEndOfMethod(methodName, "Case Id: " + caseId + "actions size:" + actionList.size() + "\n" + "Case Id: " + caseEvent.getCaseId() + "\n" + "Event Type: " + caseEvent.getEventType() + "\n" + "Activity Name: " + caseEvent.getActivityName() + "\n" + "Activity Event: " + caseEvent.getActivityEvent() + "\n" + "Lifecycle Event: " + caseEvent.getLifecycleEvent() + "\n" + "Lifecycle State: " + caseEvent.getLifecycleState() + "\n" + "Milestone Event: " + caseEvent.getMilestoneEvent() + "\n" + "Milestone: " + caseEvent.getMilestone() + "\n");
            } else {
                this.logEndOfMethod(methodName, "Case Id: " + caseId + "actions size:" + actionList.size() + "\n" + "Case Id: " + caseEvent.getCaseId() + "\n" + "Event Type: " + caseEvent.getEventType() + "\n" + "Activity Name: " + caseEvent.getActivityName() + "\n" + "Activity Event: " + caseEvent.getActivityEvent() + "\n" + "Lifecycle Event: " + caseEvent.getLifecycleEvent() + "\n" + "Lifecycle State: " + caseEvent.getLifecycleState() + "\n" + "Milestone Event: " + caseEvent.getMilestoneEvent() + "\n" + "Milestone: " + caseEvent.getMilestone() + "\n" + "action list is empty");
            }
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"processEvent", (String)"Exception from ECAProcessor", (Throwable)e);
        }
        return true;
    }

    private void onStartCase(CaseEvent caseEvent) {
        if (caseEvent.getEventType().compareTo((Enum)TEventType.LIFECYCLE_EVENT) == 0 && caseEvent.getLifecycleEvent() != null && caseEvent.getLifecycleEvent().compareTo((Enum)TLifecycleEvent.STARTED) == 0) {
            this.debugLog("onStartCase", "Case start event found. Calling automatic activities...");
            try {
                IInternalCaseService service = ServicesLocator.getInternalCaseService();
                service.invokeCaseActivitiesOnCaseStart(caseEvent.getCaseId());
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.DEBUG, (String)"[CaseService] Automatic activities invoked");
            }
            catch (Exception e) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"Invoke case activities on case start failed", (Throwable)e);
            }
        }
    }

    private boolean processAction(String caseId, List actionList) {
        IActionHandler actionHandler = null;
        if (actionList != null && !actionList.isEmpty()) {
            for (int i = 0; i < actionList.size(); ++i) {
                actionHandler = ActionHandlerFactory.getActionHandler(actionList.get(i));
                try {
                    actionHandler.handle(caseId, actionList.get(i));
                    continue;
                }
                catch (ActionHandlerException e) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"processAction", (String)"Exception from ECAProcessor", (Throwable)((Object)e));
                }
            }
        }
        return false;
    }

    private void logStartOfMethod(String methodName, String string) {
        String msg = "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\nStart of " + methodName + "\n" + string + "\n" + "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" + "\n";
        this.debugLog(methodName, msg);
    }

    private void logEndOfMethod(String methodName, String string) {
        String msg = "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\nEnd of " + methodName + "\n" + string + "\n" + "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" + "\n";
        this.debugLog(methodName, msg);
    }

    private void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.DEBUG, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + message + "\n"));
    }
}

