/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.eca;

import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.IInternalCaseService;
import oracle.bpm.casemgmt.caserule.model.TCaseActivityAction;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.eca.ActionHandlerException;
import oracle.bpm.casemgmt.eca.IActionHandler;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;

public class ActivityActionHandler
implements IActionHandler {
    @Override
    public boolean handle(String caseId, Object action) throws ActionHandlerException {
        TCaseActivityAction activityAction = (TCaseActivityAction)action;
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("activity action:" + activityAction.getName()));
        String activityName = activityAction.getName();
        IInternalCaseService internalService = ServicesLocator.getInternalCaseService();
        String caseActivityMetadataId = null;
        try {
            caseActivityMetadataId = internalService.getCaseActivityDefinitionId(caseId, activityName);
            IBPMContext context = null;
            context = InternalBPMContext.getInternalBPMContext();
            switch (activityAction.getStatus()) {
                case ACTIVATE: {
                    internalService.invokeCaseActivity(context, caseId, caseActivityMetadataId);
                    return true;
                }
                case WITHDRAW: {
                    internalService.deleteCaseActivityInstance(caseId, caseActivityMetadataId);
                    return true;
                }
            }
        }
        catch (Exception e) {
            throw new ActionHandlerException(74022, new Object[]{activityName, caseId}, e);
        }
        return false;
    }
}

