/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.customactivity.simplewf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.caseactivity.CaseActivityException;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.metadata.activity.model.CaseActivity;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SimpleWFCallbackUtil {
    private static final String JAXB_CONTEXT = "oracle.bpm.casemgmt.metadata.activity.model";

    public static boolean registerActivity() throws CaseActivityException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)SimpleWFCallbackUtil.class.getName(), (String)"registerActivity", (String)"Register simple wf activity invoked");
        CaseActivity simpleWFActivity = null;
        try {
            IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
            if (!SimpleWFCallbackUtil.isActivityRegistered(ctx)) {
                simpleWFActivity = SimpleWFCallbackUtil.getSimpleWFActivity();
                if (simpleWFActivity != null) {
                    ICaseService caseActivityService = SimpleWFCallbackUtil.getCaseService();
                    caseActivityService.registerCaseActivity(ctx, simpleWFActivity);
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)SimpleWFCallbackUtil.class.getName(), (String)"registerActivity", (String)"Simple WF activity definition successfully registered..");
                    return true;
                }
                throw new CaseActivityException(74026, new Object[0]);
            }
        }
        catch (CaseActivityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CaseActivityException(74026, new Object[0], e);
        }
        return false;
    }

    public static CaseActivity unmarshal(InputStream inputStream) throws JAXBException, IOException {
        try {
            DOMParser p = new DOMParser();
            p.retainCDATASection(true);
            p.parse(inputStream);
            XMLDocument doc = p.getDocument();
            JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_CONTEXT);
            return (CaseActivity)jaxbContext.createUnmarshaller().unmarshal((Node)doc);
        }
        catch (XMLParseException e) {
            throw new JAXBException((Throwable)e);
        }
        catch (SAXException e) {
            throw new JAXBException((Throwable)e);
        }
    }

    private static ICaseService getCaseService() {
        return BPMServiceClientFactory.getInstance((String)"REMOTE", null, null).getCaseManagementServiceClient().getCaseService();
    }

    private static boolean isActivityRegistered(IBPMContext ctx) throws CaseServiceException {
        ArrayList<String> values = new ArrayList<String>();
        values.add("http://xmlns.oracle.com/bpm/case/activity/SimpleWFActivityDefinition");
        List activityDefnList = SimpleWFCallbackUtil.getCaseService().listCaseActivityDefinition(ctx, ICaseMetadataService.SEARCH_TYPE_ENUM.ACTIVITY_DEFINITION_ID, values);
        if (activityDefnList != null && activityDefnList.size() == 1) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)SimpleWFCallbackUtil.class.getName(), (String)"registerActivity", (String)"Simple WF activity definition already registered..");
            return true;
        }
        return false;
    }

    private static CaseActivity getSimpleWFActivity() throws Exception {
        CaseActivity caseActivity = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream("oracle/bpm/casemgmt/customactivity/simplewf/SimpleWFActivity.caseactivity");
        if (is == null) {
            return null;
        }
        caseActivity = SimpleWFCallbackUtil.unmarshal(is);
        return caseActivity;
    }
}

