/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.customactivity.simplewf;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpel.services.workflow.common.model.PrincipleRefType;
import oracle.bpel.services.workflow.metadata.routingslip.RoutingSlipUtil;
import oracle.bpel.services.workflow.metadata.routingslip.model.RoutingSlip;
import oracle.bpel.services.workflow.task.IInitiateTaskResponse;
import oracle.bpel.services.workflow.task.ITaskService;
import oracle.bpel.services.workflow.task.impl.SimpleApprovalTaskUtil;
import oracle.bpel.services.workflow.task.model.CommentType;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.caseactivity.ICaseActivityCallback;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.customactivity.simplewf.model.SimpleWorkflowPayload;
import oracle.bpm.casemgmt.customactivity.simplewf.model.TAssigneeType;
import oracle.bpm.casemgmt.customactivity.simplewf.model.TCompletionCriteriaType;
import oracle.bpm.casemgmt.customactivity.simplewf.model.TFyiAssignmentType;
import oracle.bpm.casemgmt.customactivity.simplewf.model.TOutcomeTypeEnum;
import oracle.bpm.casemgmt.customactivity.simplewf.model.TParallelAssignmentType;
import oracle.bpm.casemgmt.customactivity.simplewf.model.TParameterType;
import oracle.bpm.casemgmt.customactivity.simplewf.model.TPayloadType;
import oracle.bpm.casemgmt.customactivity.simplewf.model.TSequentialAssignmentType;
import oracle.bpm.casemgmt.customactivity.simplewf.model.TSimpleAssignmentType;
import oracle.bpm.casemgmt.customactivity.simplewf.model.TSimpleWorkflowPayload;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;

public class SimpleWFActivityCallback
implements ICaseActivityCallback {
    public String initiate(IBPMContext context, CaseIdentifier caseIdentifier, String activityMetadataId, Map<String, Object> payload) {
        String caseId = null;
        caseId = caseIdentifier.getCaseId();
        this.debugLog("initiate", "Simple WF activity initiated for case:" + caseId);
        String activityInstanceId = null;
        try {
            IInitiateTaskResponse initiateTaskResponse;
            if (payload != null && payload.size() > 0) {
                List params;
                TPayloadType taskPayload;
                SimpleWorkflowPayload simpleWFPayload = (SimpleWorkflowPayload)payload.get("SimpleWFActivityPayload");
                RoutingSlip routingSlip = null;
                if (((TSimpleWorkflowPayload)simpleWFPayload.getValue()).isSetSimpleAssignmentType()) {
                    routingSlip = this.createSimpleRoutingSlip(simpleWFPayload);
                } else if (((TSimpleWorkflowPayload)simpleWFPayload.getValue()).isSetSequentialAssignmentType()) {
                    routingSlip = this.createSequentialRoutingSlip(simpleWFPayload);
                } else if (((TSimpleWorkflowPayload)simpleWFPayload.getValue()).isSetParallelAssignmentType()) {
                    routingSlip = this.createParallelRoutingSlip(simpleWFPayload);
                } else if (((TSimpleWorkflowPayload)simpleWFPayload.getValue()).isSetFyiAssignmentType()) {
                    routingSlip = this.createFYIRoutingSlip(simpleWFPayload);
                }
                Task task = new ObjectFactory().createTask();
                task.setTaskDefinitionId("http://xmlns.oracle.com/SimpleApprovalApp/SimpleApproval/SimpleApprovalTask");
                String creator = context.getUser();
                task.setCreator(creator);
                if (((TSimpleWorkflowPayload)simpleWFPayload.getValue()).getTitle() != null) {
                    task.setTitle(((TSimpleWorkflowPayload)simpleWFPayload.getValue()).getTitle());
                }
                if (((TSimpleWorkflowPayload)simpleWFPayload.getValue()).getPriority() != null) {
                    task.setPriority(((TSimpleWorkflowPayload)simpleWFPayload.getValue()).getPriority().intValue());
                }
                if (((TSimpleWorkflowPayload)simpleWFPayload.getValue()).getDueDate() != null) {
                    task.setDueDate((Calendar)((TSimpleWorkflowPayload)simpleWFPayload.getValue()).getDueDate().toGregorianCalendar());
                }
                if (((TSimpleWorkflowPayload)simpleWFPayload.getValue()).getComment() != null) {
                    CommentType comment = this.getComment(context, simpleWFPayload);
                    task.addUserComment(comment);
                }
                if ((taskPayload = ((TSimpleWorkflowPayload)simpleWFPayload.getValue()).getPayloadType()) != null && (params = taskPayload.getParameter()) != null && !params.isEmpty()) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    for (TParameterType param : params) {
                        properties.put(param.getName(), param.getValue());
                    }
                    try {
                        this.debugLog("initiate", "Adding payload:" + properties + " to task");
                        SimpleApprovalTaskUtil.setTaskPayload((Task)task, properties);
                    }
                    catch (WorkflowException e) {
                        throw new CaseServiceException(74024, new Object[]{caseId}, (Throwable)e);
                    }
                }
                this.debugLog("initiate", "Initiating simple workflow approval task");
                try {
                    initiateTaskResponse = this.getTaskService().initiateTask(task, routingSlip);
                }
                catch (Exception e) {
                    throw new CaseServiceException(74024, new Object[]{caseId}, (Throwable)e);
                }
            }
            throw new CaseServiceException(74024, new Object[]{caseId});
            activityInstanceId = initiateTaskResponse.getTask().getSystemAttributes().getTaskId();
            this.debugLog("initiate", "Task initiated successfully for case:" + caseId);
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"initiate", (String)"Exception in initiating simple workflow approval task", (Throwable)e);
        }
        this.debugLog("initiate", "Returning simple wf activity instance id:" + activityInstanceId);
        return activityInstanceId;
    }

    private String getCaseId(CaseIdentifier caseIdentifier) throws BPMException, CaseServiceException {
        IBPMContext context = InternalBPMContext.getInternalBPMContext();
        Case caseInstance = ServicesLocator.getInternalCaseService().getCase(context, caseIdentifier, null);
        return caseInstance.getCaseId();
    }

    private CommentType getComment(IBPMContext context, SimpleWorkflowPayload simpleWFPayload) {
        this.debugLog("initiate", "Adding comment:" + ((TSimpleWorkflowPayload)simpleWFPayload.getValue()).getComment() + " in the context of user:" + context.getUser());
        CommentType comment = new ObjectFactory().createCommentType();
        comment.setComment(((TSimpleWorkflowPayload)simpleWFPayload.getValue()).getComment());
        IdentityType identity = new ObjectFactory().createIdentityType();
        identity.setType("USER");
        identity.setId(context.getUser());
        comment.setUpdatedBy(identity);
        return comment;
    }

    private RoutingSlip createSimpleRoutingSlip(SimpleWorkflowPayload simpleWFPayload) {
        oracle.bpel.services.workflow.common.model.ObjectFactory commonObjectFactory = new oracle.bpel.services.workflow.common.model.ObjectFactory();
        PrincipleRefType principle = commonObjectFactory.createPrincipleRefType();
        TSimpleAssignmentType simpleAssign = ((TSimpleWorkflowPayload)simpleWFPayload.getValue()).getSimpleAssignmentType();
        principle.setName(simpleAssign.getAssigneeType().getIdentityName());
        principle.setType(simpleAssign.getAssigneeType().getIdentityType().toString());
        RoutingSlip routingSlip = SimpleApprovalTaskUtil.createSimpleRoutingSlip((PrincipleRefType)principle);
        this.debugLog("createSimpleRoutingSlip", RoutingSlipUtil.getInstance().toString((Object)routingSlip));
        return routingSlip;
    }

    private RoutingSlip createSequentialRoutingSlip(SimpleWorkflowPayload simpleWFPayload) {
        oracle.bpel.services.workflow.common.model.ObjectFactory commonObjectFactory = new oracle.bpel.services.workflow.common.model.ObjectFactory();
        ArrayList<PrincipleRefType> principleList = new ArrayList<PrincipleRefType>();
        TSequentialAssignmentType sequentialAssign = ((TSimpleWorkflowPayload)simpleWFPayload.getValue()).getSequentialAssignmentType();
        List assigneeList = sequentialAssign.getAssigneeType();
        for (TAssigneeType assignee : assigneeList) {
            PrincipleRefType principle = commonObjectFactory.createPrincipleRefType();
            principle.setName(assignee.getIdentityName());
            principle.setType(assignee.getIdentityType().toString());
            principleList.add(principle);
        }
        RoutingSlip routingSlip = SimpleApprovalTaskUtil.createSequentialRoutingSlip(principleList);
        this.debugLog("createSequentialRoutingSlip", RoutingSlipUtil.getInstance().toString((Object)routingSlip));
        return routingSlip;
    }

    private RoutingSlip createParallelRoutingSlip(SimpleWorkflowPayload simpleWFPayload) {
        oracle.bpel.services.workflow.common.model.ObjectFactory commonObjectFactory = new oracle.bpel.services.workflow.common.model.ObjectFactory();
        RoutingSlip routingSlip = null;
        ArrayList<PrincipleRefType> principleList = new ArrayList<PrincipleRefType>();
        TParallelAssignmentType parallelAssign = ((TSimpleWorkflowPayload)simpleWFPayload.getValue()).getParallelAssignmentType();
        List assigneeList = parallelAssign.getAssigneeType();
        for (TAssigneeType assignee : assigneeList) {
            PrincipleRefType principle = commonObjectFactory.createPrincipleRefType();
            principle.setName(assignee.getIdentityName());
            principle.setType(assignee.getIdentityType().toString());
            principleList.add(principle);
        }
        SimpleApprovalTaskUtil.SimpleApprovalTaskOutcome defaultOutcome = this.getSimpleApprovalTaskOutcome(parallelAssign.getDefaultOutcome());
        List completionCriteriaList = parallelAssign.getCompletionCriteriaType();
        ArrayList<SimpleApprovalTaskUtil.SimpleApprovalParallelCompletionCriteria> criteriaList = new ArrayList<SimpleApprovalTaskUtil.SimpleApprovalParallelCompletionCriteria>();
        if (completionCriteriaList != null) {
            for (TCompletionCriteriaType completionCriteria : completionCriteriaList) {
                SimpleApprovalTaskUtil.SimpleApprovalTaskOutcome simpleApprovalTaskOutcome = this.getSimpleApprovalTaskOutcome(completionCriteria.getOutcome());
                int outcomePercentage = completionCriteria.getOutcomePercentage() != null ? completionCriteria.getOutcomePercentage().intValue() : 0;
                SimpleApprovalTaskUtil.SimpleApprovalParallelCompletionCriteria criteria = new SimpleApprovalTaskUtil.SimpleApprovalParallelCompletionCriteria(simpleApprovalTaskOutcome, outcomePercentage);
                criteriaList.add(criteria);
            }
            boolean waitForVotes = parallelAssign.isWaitForAllVotes();
            routingSlip = SimpleApprovalTaskUtil.createParallelRoutingSlip(principleList, (SimpleApprovalTaskUtil.SimpleApprovalTaskOutcome)defaultOutcome, criteriaList, (boolean)waitForVotes);
            this.debugLog("createParallelRoutingSlip", RoutingSlipUtil.getInstance().toString((Object)routingSlip));
        }
        return routingSlip;
    }

    private SimpleApprovalTaskUtil.SimpleApprovalTaskOutcome getSimpleApprovalTaskOutcome(TOutcomeTypeEnum outcome) {
        String defaultOutcomeStr = outcome != null ? outcome.toString() : null;
        SimpleApprovalTaskUtil.SimpleApprovalTaskOutcome simpleApprovalTaskOutcome = null;
        if (defaultOutcomeStr != null && defaultOutcomeStr.equals(SimpleApprovalTaskUtil.SimpleApprovalTaskOutcome.APPROVE.toString())) {
            simpleApprovalTaskOutcome = SimpleApprovalTaskUtil.SimpleApprovalTaskOutcome.APPROVE;
        } else if (defaultOutcomeStr != null && defaultOutcomeStr.equals(SimpleApprovalTaskUtil.SimpleApprovalTaskOutcome.REJECT.toString())) {
            simpleApprovalTaskOutcome = SimpleApprovalTaskUtil.SimpleApprovalTaskOutcome.REJECT;
        }
        return simpleApprovalTaskOutcome;
    }

    private RoutingSlip createFYIRoutingSlip(SimpleWorkflowPayload simpleWFPayload) {
        oracle.bpel.services.workflow.common.model.ObjectFactory commonObjectFactory = new oracle.bpel.services.workflow.common.model.ObjectFactory();
        ArrayList<PrincipleRefType> principleList = new ArrayList<PrincipleRefType>();
        TFyiAssignmentType fyiAssign = ((TSimpleWorkflowPayload)simpleWFPayload.getValue()).getFyiAssignmentType();
        List assigneeList = fyiAssign.getAssigneeType();
        for (TAssigneeType assignee : assigneeList) {
            PrincipleRefType principle = commonObjectFactory.createPrincipleRefType();
            principle.setName(assignee.getIdentityName());
            principle.setType(assignee.getIdentityType().toString());
            principleList.add(principle);
        }
        RoutingSlip routingSlip = SimpleApprovalTaskUtil.createSimpleFYIRoutingSlip(principleList);
        this.debugLog("createFyiRoutingSlip", RoutingSlipUtil.getInstance().toString((Object)routingSlip));
        return routingSlip;
    }

    private ITaskService getTaskService() {
        IWorkflowServiceClient client = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"REMOTE");
        return client.getTaskService();
    }

    private void debugLog(String method, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)method, (String)message);
    }
}

