/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.customactivity.notification;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.caseactivity.CaseActivityException;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.customactivity.simplewf.SimpleWFCallbackUtil;
import oracle.bpm.casemgmt.metadata.activity.model.CaseActivity;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class NotificationCallbackUtil {
    private static final String JAXB_CONTEXT = "oracle.bpm.casemgmt.metadata.activity.model";

    public static boolean registerEmailActivity() throws CaseActivityException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)NotificationCallbackUtil.class.getName(), (String)"register", (String)"Register email activity invoked");
        CaseActivity emailActivity = null;
        try {
            IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
            if (!NotificationCallbackUtil.isActivityRegistered(ctx)) {
                emailActivity = NotificationCallbackUtil.getEmailActivity();
                if (emailActivity != null) {
                    ICaseService caseActivityService = NotificationCallbackUtil.getCaseService();
                    caseActivityService.registerCaseActivity(ctx, emailActivity);
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)NotificationCallbackUtil.class.getName(), (String)"register", (String)"Email activity definition successfully registered..");
                    return true;
                }
                throw new CaseActivityException(74027, new Object[0]);
            }
        }
        catch (CaseActivityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CaseActivityException(74026, new Object[0], e);
        }
        return false;
    }

    public static CaseActivity unmarshal(InputStream inputStream) throws JAXBException, IOException {
        try {
            DOMParser p = new DOMParser();
            p.retainCDATASection(true);
            p.parse(inputStream);
            XMLDocument doc = p.getDocument();
            JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_CONTEXT);
            return (CaseActivity)jaxbContext.createUnmarshaller().unmarshal((Node)doc);
        }
        catch (XMLParseException e) {
            throw new JAXBException((Throwable)e);
        }
        catch (SAXException e) {
            throw new JAXBException((Throwable)e);
        }
    }

    private static CaseActivity getEmailActivity() throws Exception {
        CaseActivity caseActivity = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream("oracle/bpm/casemgmt/customactivity/notification/EmailActivity.caseactivity");
        if (is == null) {
            return null;
        }
        caseActivity = NotificationCallbackUtil.unmarshal(is);
        return caseActivity;
    }

    private static ICaseService getCaseService() {
        return BPMServiceClientFactory.getInstance((String)"REMOTE", null, null).getCaseManagementServiceClient().getCaseService();
    }

    private static boolean isActivityRegistered(IBPMContext ctx) throws CaseServiceException {
        ArrayList<String> values = new ArrayList<String>();
        values.add("http://xmlns.oracle.com/bpm/case/activity/EmailActivityDefinition");
        List activityDefnList = NotificationCallbackUtil.getCaseService().listCaseActivityDefinition(ctx, ICaseMetadataService.SEARCH_TYPE_ENUM.ACTIVITY_DEFINITION_ID, values);
        if (activityDefnList != null && activityDefnList.size() == 1) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)SimpleWFCallbackUtil.class.getName(), (String)"registerActivity", (String)"Simple WF activity definition already registered..");
            return true;
        }
        return false;
    }
}

