/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.customactivity.notification;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.notification.NotificationUtil;
import oracle.bpel.services.notification.ejb.INotificationBean;
import oracle.bpel.services.notification.payload.BodyPartType;
import oracle.bpel.services.notification.payload.BodyPartTypeFactory;
import oracle.bpel.services.notification.payload.ContentType;
import oracle.bpel.services.notification.payload.ContentTypeFactory;
import oracle.bpel.services.notification.payload.EmailPayloadType;
import oracle.bpel.services.notification.payload.EmailPayloadTypeFactory;
import oracle.bpel.services.notification.payload.IArrayOfResponseType;
import oracle.bpel.services.notification.payload.IBodyPartType;
import oracle.bpel.services.notification.payload.IContentType;
import oracle.bpel.services.notification.payload.IEmailPayloadType;
import oracle.bpel.services.notification.payload.MultiPartType;
import oracle.bpel.services.notification.payload.MultiPartTypeFactory;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseStreamService;
import oracle.bpm.casemgmt.caseactivity.ICaseActivityCallback;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.customactivity.notification.model.EmailPayload;
import oracle.bpm.casemgmt.customactivity.notification.model.TAttachment;
import oracle.bpm.casemgmt.customactivity.notification.model.TEmailPayload;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.soa.common.util.Base64Encoder;

public class EmailActivityCallback
implements ICaseActivityCallback {
    public String initiate(IBPMContext context, CaseIdentifier caseIdentifier, String activityMetadataId, Map<String, Object> payload) {
        block8: {
            String caseId = null;
            caseId = caseIdentifier.getCaseId();
            this.debugLog("initiate", "Email activity initiated for case:" + caseId);
            String activityInstanceId = null;
            try {
                if (payload != null) {
                    EmailPayload emailPayload = (EmailPayload)payload.get("EmailActivityPayload");
                    if (emailPayload == null) break block8;
                    String from = ((TEmailPayload)emailPayload.getValue()).getFrom();
                    String to = ((TEmailPayload)emailPayload.getValue()).getTo();
                    String cc = ((TEmailPayload)emailPayload.getValue()).getCc();
                    String bcc = ((TEmailPayload)emailPayload.getValue()).getBcc();
                    String replyTo = ((TEmailPayload)emailPayload.getValue()).getReplyTo();
                    String subject = ((TEmailPayload)emailPayload.getValue()).getSubject();
                    String message = ((TEmailPayload)emailPayload.getValue()).getMessage();
                    List attachments = ((TEmailPayload)emailPayload.getValue()).getAttachments();
                    EmailPayloadType emailContent = null;
                    MultiPartType multiPart = null;
                    ContentType content = null;
                    ContentType contentBody = null;
                    try {
                        emailContent = EmailPayloadTypeFactory.createFacade();
                        content = ContentTypeFactory.createFacade();
                        contentBody = ContentTypeFactory.createFacade();
                        multiPart = MultiPartTypeFactory.createFacade();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    BodyPartType messageBodyPart = null;
                    try {
                        messageBodyPart = EmailActivityCallback.createEmailBodyPart(message, null, "text/plain", "inline", null, true, false);
                    }
                    catch (Exception e) {
                        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"initiate", (String)"Error in creating email", (Throwable)e);
                        e.printStackTrace();
                    }
                    multiPart.addBodyPart((IBodyPartType)messageBodyPart);
                    if (attachments != null && attachments.size() > 0) {
                        this.addAttachmentsAsBodyParts(context, caseIdentifier, attachments, multiPart);
                    }
                    emailContent.setTo(to);
                    emailContent.setCc(cc);
                    emailContent.setBcc(bcc);
                    emailContent.setReplyToAddress(replyTo);
                    emailContent.setFromAccountName(from);
                    emailContent.setSubject(subject);
                    contentBody.setContentBody((Object)multiPart);
                    content.setContentBody((Object)contentBody);
                    content.setMimeType("multipart/mixed");
                    emailContent.setContent((IContentType)content);
                    activityInstanceId = this.sendEmailNotification(context, (IEmailPayloadType)emailContent);
                    this.debugLog("initiate", "sendEmailNotification returned successfully for case:" + caseId);
                    this.debugLog("initiate", "Returning email activity instance id:" + activityInstanceId);
                    return activityInstanceId;
                }
                throw new CaseServiceException(74025, new Object[]{caseId});
            }
            catch (Exception e) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"initiate", (String)"Exception in initiaiting email custom activity", (Throwable)e);
            }
        }
        return null;
    }

    private static BodyPartType createEmailBodyPart(String content, String name, String mimeType, String disposition, String contentId, boolean contentEnclosed, boolean encodedContent) throws Exception {
        BodyPartType bodyPart = BodyPartTypeFactory.createFacade();
        bodyPart.setMimeType(mimeType);
        if (encodedContent) {
            bodyPart.setContentEncoding("base64");
        }
        bodyPart.setContentBody((Object)content);
        if (name != null && !name.equals("")) {
            bodyPart.setBodyPartName(name);
        }
        if (disposition != null) {
            bodyPart.setDisposition(disposition);
        }
        if (contentId != null) {
            bodyPart.setContentId(contentId);
        }
        bodyPart.setAttachmentContentEnclosed(contentEnclosed);
        return bodyPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAttachmentsAsBodyParts(IBPMContext context, CaseIdentifier caseIdentifier, List<TAttachment> attachments, MultiPartType multiPart) {
        ICaseStreamService cmStreamServiceClient = BPMServiceClientFactory.getInstance((String)"REMOTE", null, null).getCaseManagementServiceClient().getCaseStreamServiceClient();
        for (TAttachment attachment : attachments) {
            InputStream inputStreamRead = null;
            try {
                inputStreamRead = cmStreamServiceClient.downloadDocument(context, caseIdentifier, attachment.getName());
            }
            catch (Exception e) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"addAttachmentsAsBodyParts", (String)("Exception while downloading case document " + attachment.getName() + " in email custom activity. For case : " + caseIdentifier), (Throwable)e);
            }
            if (inputStreamRead == null) continue;
            String contentBase64 = null;
            try {
                int len;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((len = inputStreamRead.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                byte[] contentBytes = outputStream.toByteArray();
                if (contentBytes.length <= 0) continue;
                contentBase64 = Base64Encoder.encode((byte[])contentBytes);
            }
            catch (Exception e) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"addAttachmentsAsBodyParts", (String)("Exception while reading case document " + attachment.getName() + " in email custom activity. For case : " + caseIdentifier), (Throwable)e);
            }
            finally {
                try {
                    inputStreamRead.close();
                }
                catch (Exception e) {}
                continue;
            }
            try {
                BodyPartType bodyPart = EmailActivityCallback.createEmailBodyPart(contentBase64, attachment.getName(), attachment.getMimeType(), "attachment", null, true, true);
                multiPart.addBodyPart((IBodyPartType)bodyPart);
            }
            catch (Exception e) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"addAttachmentsAsBodyParts", (String)("Exception while attaching case document " + attachment.getName() + " in email custom activity. For case : " + caseIdentifier), (Throwable)e);
            }
        }
    }

    private String getCaseId(CaseIdentifier caseIdentifier) throws BPMException {
        try {
            IBPMContext context = InternalBPMContext.getInternalBPMContext();
            Case caseInstance = ServicesLocator.getInternalCaseService().getCase(context, caseIdentifier, null);
            return caseInstance.getCaseId();
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"getCaseId", (String)"Exception in initiaiting email custom activity", (Throwable)e);
            return null;
        }
    }

    private String sendEmailNotification(IBPMContext ctx, IEmailPayloadType payload) {
        IArrayOfResponseType response = null;
        INotificationBean bean = null;
        try {
            bean = NotificationUtil.lookupRemoteBean();
            response = bean.sendEmailNotification(payload);
            String id = response.getResponse(0).getMessageId();
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_NOTIFICATION, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"sendEmailNotification", (String)("Email notification sent. Returning id:" + id));
            return id;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void debugLog(String method, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)method, (String)message);
    }
}

